# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import gtk
import gtk.glade
import pygtk
import gobject
import os

from aoiso.common.logic import AoisoLogic
from aoiso.gtk.aoisoGtkTreeView import AoisoGtkTreeView

class AoisoGtkMainWindow:

    """This is an Aoiso application"""

    TARGETS = [
        ('MY_TREE_MODEL_ROW', gtk.TARGET_SAME_WIDGET, 0),
        ('text/plain', 0, 1),
        ('TEXT', 0, 2),
        ('STRING', 0, 3),
        ]

    def make_mainTreeView(self, str1, str2, int1, int2):
        print "make_treeview"
        widget = AoisoGtkTreeView()
        return widget

    # for Custom Widgets
    def custom_handler(self,
        glade, function_name, widget_name,
        str1, str2, int1, int2):
        try:
            handler = getattr(self, function_name)
            return handler(str1, str2, int1, int2)
        except AttributeError:
            return None

    # Custom Initialized method
    # Call Manually
    def init(self, app):
        print "__init__"
        self.app = app

        #Create our dictionay and connect it
        dic = { 
                "on_button2_clicked"          : self.newDocument
                ,"on_mitemAppendNode_activate" : self.app.logic.appendNode
                ,"on_tbtnAppendNode_clicked"   : self.app.logic.appendNode
                ,"on_mitemAppendChildNode_activate" : self.app.logic.appendChildNode
                ,"on_tbtnAppendChildNode_clicked"   : self.app.logic.appendChildNode
                ,"on_tbtnSave_clicked" : self.saveDocument
                ,"on_tbtnOpen_clicked" : self.openDocument
                ,"on_tbtnNodeLeft_clicked" : self.moveNodeLeft
                ,"on_tbtnNodeRight_clicked" : self.moveNodeRight
                ,"on_tbtnNodeUp_clicked" : self.moveNodeUp
                ,"on_tbtnNodeDown_clicked" : self.moveNodeDown
                ,"on_tbtnTrashNode_clicked" : self.moveNodeTrash
                ,"on_btnTest1_clicked" : self.test1
                ,"on_btnTest2_clicked" : self.test2
                }
        self.wtree.signal_autoconnect(dic)
        self.editor.connect("event-after",self.on_editor_changed)
        self.titleEntry.connect("event-after",self.on_title_entry_changed)
        
        #self.treeView.set_cursor(0)

    def __init__(self):
        print "__init__"
        
        #for Custom Widget Handler
        gtk.glade.set_custom_handler(self.custom_handler)
        
        #Set the Glade file
        self.gladefile = "aoiso.glade" 
        self.wtree = gtk.glade.XML(self.gladefile)
        
        #Get the Main Window, and connect the "destroy" event
        self.window = self.wtree.get_widget("mainWindow")
        if (self.window):
            self.window.connect("destroy", gtk.main_quit)

        self.editor   = self.wtree.get_widget("mainTextView")
        self.titleEntry = self.wtree.get_widget("entryNodeTitle")
        
        #Get Glade widgets
        self.treeView = self.wtree.get_widget("mainTreeView")
        #self.treeView.set_init_props(self.editor,self.title_entry)
        self.treeView.show()

    def test1(self,widget):
        print "test1"
        self.app.logic.openWZText()
        self.treeView.set_cursor(0)
        
    def test2(self,widget):
        print "test2"
        self.app.logic.saveWZText()

    def on_editor_changed(self,widget,event):
        buffer = self.editor.get_buffer() 
        text = buffer.get_text(buffer.get_start_iter(),buffer.get_end_iter())
        self.app.model.storeNodeText(text)

    def on_title_entry_changed(self,widget,event):
        title = self.titleEntry.get_text()
        self.app.model.storeNodeTitle(title)
        
    def newDocument(self, widget):
        print "clicked!"
        self.app.logic.clearDocument()
        self.treeView.set_cursor(0)
        
    def saveDocument(self,widget):
        self.app.logic.saveDocument()
        
    def openDocument(self,weight):
        self.app.logic.openDocument()
        self.treeView.set_cursor(0)
        
    def moveNodeLeft(self,widget):
        print "moveNodeLeft"

    def moveNodeRight(self,widget):
        print "moveNodeRight"

    def moveNodeUp(self,widget):
        print "moveNodeUp"

    def moveNodeDown(self,widget):
        print "moveNodeDown"

    def moveNodeTrash(self,widget):
        print "moveNodeTrash"
        self.app.logic.deleteNode()

