<?php
/**
 * 
 * @package aowp.aspect.joinpoint
 */
/**
 * メソッド実行を表すジョインポイントです。
 * 
 * @author keiji
 * @package aowp.aspect.joinpoint
 *
 */
class AOWP_MethodExecutionJoinPoint extends AOWP_JoinPointWithArguments {
	
	private $_className;
	private $_invokedObject;
	private $_methodName;
	private $_modifierArray;
	private $_parameterCount;
	
	public function __construct(AOWP_PHPMethodElement $element = null, $fileName = null) {
		parent::__construct($element, $fileName);
		$this->setClassName($element->getClassName());
		$this->setMethodName($element->getMethodName());
		$this->_modifierArray = array();
		foreach ($element->getModifiers() as $modifier) {
			$this->addModifier($modifier);
		}
		$this->setParameterCount($element->getParameterCount());
	}
	
	public function setParameterCount($parameterCount) {
		$this->_parameterCount = $parameterCount;
	}
	public function getParameterCount() {
		return $this->_parameterCount;
	} 
	
	/**
	 * 
	 * @param string $className
	 * @return void
	 */
	public function setClassName($className) {
		$this->_className = $className;
	}
	/**
	 * 
	 * @return string
	 */
	public function getClassName() {
		return $this->_className;
	}
	
	/**
	 * 
	 * @param string $modifier
	 * @return void
	 */
	public function addModifier($modifier) {
		$this->_modifierArray[] = $modifier;
	}
	/**
	 * 
	 * @return array
	 */
	public function getModifierArray() {
		return $this->_modifierArray;
	}
	public function haveModifier($modifier) {
		return array_search($modifier, $this->_modifierArray) !== false;
	}
	
	public function setInvokedObject($invokedObject) {
		$this->_invokedObject = $invokedObject;
	}
	/**
	 * 呼び出されるオブジェクトを取得します。
	 * 
	 * @return mixed
	 */
	public function getInvokedObject() {
		return $this->_invokedObject;
	}
	
	public function setMethodName($methodName) {
		$this->_methodName = $methodName;
	}
	/**
	 * 呼び出すメソッド名を取得します。
	 * 
	 * @return string
	 */
	public function getMethodName() {
		return $this->_methodName;
	}	

	public function proceed(array $argumentArray = array()) {
		if ($this->_proceedFunctionName !== null) {
			return call_user_func_array(array($this->getInvokedObject(), $this->_proceedFunctionName), $argumentArray);
		}
	}
}
?>