<?php
/**
 * 長い説明文
 * 
 * @package aowp.aspect.pointcut.designators
 */
/**
 * 現在、サポートされていません (ver. 0.8)。
 * 次期リリース予定です。
 * コンストラクタの呼び出しを選択するポイントカットです。
 * 可変変数を用いたインスタンス生成には対応していません。
 * 例えば、
 * <code>
 * $className = 'SomeClass';
 * $someInstance = new $className();
 * </code>
 * を
 * <code>
 * new AOWP_ConstructorCallPointcut('someClass', 0);
 * </code>
 * で選択する事はできません。
 * 
 * @package aowp.aspect.pointcut.designators
 */
class AOWP_ConstructorCallPointcut extends AOWP_StaticPointcut {
	private $_className;
	private $_argumentScount;

	/**
	 * 
	 * @param string $className クラス名
	 * @param int $argumentsCount 引き数の数
	 */
	public function __construct ($className, $argumentsCount) {
		$this->_className      = $className;
		$this->_argumentsCount = $argumentsCount;
	}
	
	protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
		return $joinPoint instanceof AOWP_ConstructorCallJoinPoint &&
			AOWP_Pointcut::patternMatch($this->_className, $joinPoint->getClassName()) &&
			(($this->_argumentsCount === -1) || ($this->_argumentsCount === $joinPoint->getArgumentsCount()));
	}
}
?>
