<?php
/**
 * 長い説明文
 * 
 * @package aowp.aspect.pointcut.designators
 */
/**
 * 関数呼び出しを選択するポイントカット記述子です。
 * 可変変数を用いた関数呼び出しは選択できません。
 * 例えば、
 * <code>
 * $funcName = 'someFunc';
 * {$funcName}();
 *  
 * function someFunc() {
 * 	echo 'Call';
 * }
 * </code>
 * の2行目は、
 * <code>
 * new AOWP_FunctionClassPoint('someFunc', 0);
 * </code>
 * や、
 * <code>
 * new AOWP_FunctionClassPoint('{$funcName}', 0);
 * </code>
 * のポイントカットで選択する事はできません。
 * 
 * @package aowp.aspect.pointcut.designators
 */
class AOWP_FunctionCallPointcut extends AOWP_StaticPointcut {
	private $_functionName;
	private $_argumentsCount;

	/**
	 * 
	 * @param string $functionName 関数名
	 * @param int $argumentsCount 引き数の数
	 */
	public function __construct ($functionName, $argumentsCount = -1) {
		$this->_functionName   = $functionName;
		$this->_argumentsCount = $argumentsCount;
	}

	protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
		if ($joinPoint instanceof AOWP_FunctionCallJoinPoint) {
			return AOWP_Pointcut::patternMatch($this->_functionName, $joinPoint->getFunctionName()) &&
				(($this->_argumentsCount === -1) || ($this->_argumentsCount === $joinPoint->getStaticArgumentCount()));
		}
		else {
			return false;
		}
	}
	
}
?>
