<?php
/**
 * @package aowp.aspect.weaver.command.astutil
 */
/**
 * 
 * @author keiji
 * @package aowp.aspect.weaver.command.astutil
 */
class AOWP_WeavingASTHelper {
	
	private static $_RANDOM_INDEX = 0;
	
	/**
	 * 
	 * @param $joinPoint
	 * @return AOWP_PHPEqualExprElement
	 */
	public static function createJoinPointInstantiationAST(AOWP_JoinPoint $joinPoint) {
		$copiedJoinPoint = clone $joinPoint;
		$copiedJoinPoint->setAST(null);
		$unserializationFunctionElement = new AOWP_PHPFunctionCallElement('unserialize');
		$unserializationFunctionElement->addScalarArgument(serialize($copiedJoinPoint));
		return new AOWP_PHPEqualExprElement(AOWP_WeavingASTHelper::getRandomName('joinPoint', true), $unserializationFunctionElement);
	}
	
	/**
	 * 
	 * @return AOWP_PHPFileIncludeStatementElement
	 */
	public static function createIncludeStatemenetElement() {
		$requireOnceStatementElement = new AOWP_PHPFileIncludeStatementElement();
		$requireOnceStatementElement->type = AOWP_PHPFileIncludeStatementElement::TYPE_REQUIRE_ONCE;
		$requireOnceStatementElement->setScalarExpr(AOWP_ConfigurationManager::getRuntimeIncludePath());
		return new AOWP_PHPStatementElement($requireOnceStatementElement);
	}
	
	/**
	 * 
	 * @param string $aspectName
	 * @return AOWP_PHPEqualExprElement
	 */
	public static function createAspectInstantiationAST($aspectName) {
		$aspectInstantiationElement = new AOWP_PHPStaticMethodCallElement('AOWP_AspectInstanceManager', 'getInstance');
		AOWP_Logger::logging($aspectName);
		$aspectInstantiationElement->addScalarArgument($aspectName);
		return new AOWP_PHPEqualExprElement(AOWP_WeavingASTHelper::getRandomName('aspect', true), $aspectInstantiationElement);
	}
	
	/**
	 * 
	 * @param stirng $aspectVariableName
	 * @param int $adviceIndex
	 * @param string $contextVariableName
	 * @return {@link AOWP_PHPIfStatementElement}
	 */
	public static function createAdviceExecutionAST($aspectVariableName, $adviceIndex, $contextVariableName) {
		$adviceExecutionIfStatement = new AOWP_PHPIfStatementElement();
		$runtimeMatchMethodCall = new AOWP_PHPSimpleMethodCallElement($aspectVariableName, 'runtimeMatch');
		$runtimeMatchMethodCall->addArgument(AOWP_PHPArgumentElement::createStringArgument(0));
		$runtimeMatchMethodCall->addArgument(AOWP_PHPArgumentElement::createVariableArgument($contextVariableName));
		$adviceExecutionIfStatement->setCondition($runtimeMatchMethodCall);
		$adviceExecutionElement = new AOWP_PHPSimpleMethodCallElement($aspectVariableName, 'executeAdvice');
		$adviceExecutionElement->addArgument(AOWP_PHPArgumentElement::createStringArgument(0));
		$adviceExecutionElement->addArgument(AOWP_PHPArgumentElement::createVariableArgument($contextVariableName));
		$adviceExecutionIfStatement->addStatement(new AOWP_PHPStatementElement($adviceExecutionElement));
		return $adviceExecutionIfStatement;
	}
	
	/**
	 * 
	 * @param string $aspectVariableName
	 * @param int $adviceIndex
	 * @param string $contextVariableName
	 * @param $originalExecutionElement
	 * @return {@link AOWP_PHPIfStatementElement}
	 */
	public static function createAdviceExecutionASTForAround($aspectVariableName, $adviceIndex, $contextVariableName, AOWP_PHPElement $originalExecutionElement) {
		// アドバイスの実行時評価の為のAST。
		$adviceExecutionIfStatement = new AOWP_PHPIfStatementElement();
		$runtimeMatchMethodCall = new AOWP_PHPSimpleMethodCallElement($aspectVariableName, 'runtimeMatch');
		$runtimeMatchMethodCall->addArgument(AOWP_PHPArgumentElement::createStringArgument(0));
		$runtimeMatchMethodCall->addArgument(AOWP_PHPArgumentElement::createVariableArgument($contextVariableName));
		$adviceExecutionIfStatement->setCondition($runtimeMatchMethodCall);
		// アドバイス実行のAST。
		$adviceExecutionElement = new AOWP_PHPSimpleMethodCallElement($aspectVariableName, 'executeAdvice');
		$adviceExecutionElement->addArgument(AOWP_PHPArgumentElement::createStringArgument(0));
		$adviceExecutionElement->addArgument(AOWP_PHPArgumentElement::createVariableArgument($contextVariableName));
		$adviceExecutionReturnElement = new AOWP_PHPReturnStatementElement(null, $adviceExecutionElement);
		$adviceExecutionIfStatement->addStatement($adviceExecutionReturnElement);
		// 元のコードを実行する為のAST。
		$originalExecutionReturnElement = new AOWP_PHPReturnStatementElement(null, $originalExecutionElement);
		$adviceExecutionIfStatement->addElseStatement($originalExecutionReturnElement);	
		
		return $adviceExecutionIfStatement;
	}
	
	public static function getRandomName($prefix = 'name', $isVariableName = false) {
		return ($isVariableName ? '$' : '') . $prefix . AOWP_WeavingASTHelper::$_RANDOM_INDEX++;
	}
	
	/**
	 * {@link AOWP_IPHPContainerElement}を実装するAST要素を、
	 * 親から探します。
	 * 返り値は、0番目が{@link AOWP_IPHPContainerElement}を実装するAST要素、
	 * 1番目がその直前の子のAST要素です。
	 * 
	 * @param $element
	 * @return array
	 */
	public static function getContainerParent(AOWP_PHPElement $element, $checkError = false) {
		$parentElement = null;
		while (($parentElement = $element->getParent()) !== null) {
			if ($parentElement instanceof AOWP_IPHPContainerElement) {
				return array($parentElement, $element);
			}
			else {
				$element = $parentElement;
			}
		}
		if ($checkError) {
			echo "The weaver can not find a container element.\n";
			exit();
		}
		else {
			return null;
		}
	}
	


	/**
	 * このメソッドは、連続したメソッド呼び出し、フィールド参照を、
	 * 単純なメソッド呼び出し、フィールド参照からなる、複数の記述文に展開します。
	 * 例えば、
	 * <code>
	 * $a->b()->c()->d();
	 * </code>
	 * は、
	 * <code>
	 * $var1 = $a->b();
	 * $var2 = $var1->c();
	 * $var3 = $var2->d();
	 * </code>
	 * に展開します。 
	 * 
	 * @param $objectPropertyElement
	 * @return AOWP_PHPObjectPropertyElement
	 */
	public static function apartMethodCallElement(AOWP_PHPObjectPropertyElement $objectPropertyElement) {
		$objectOperatorElement = $objectPropertyElement->getParent();
		$newObjectPropertyElement = null;
		$objectPropertyIndex = $objectPropertyElement->getObjectPropertyIndex();
		
		// メソッド呼び出し (フィールド参照) を、分解する。
		$apartedMethodCallArray = array();
		$simpleMethodCallOrFieldAccess = null;
		$objectName = $objectOperatorElement->getLeftVariableName();
		$nowObjectPropertyIndex = 0;
		foreach ($objectOperatorElement->objectProperties as $objectProperty) {
			if ($simpleMethodCallOrFieldAccess !== null) {
				$equalExprElement = new AOWP_PHPEqualExprElement(AOWP_WeavingASTHelper::getRandomName('variable', true), $simpleMethodCallOrFieldAccess);
				$objectName = $equalExprElement->getLeftVarialeName();
				$apartedMethodCallArray[] = new AOWP_PHPStatementElement($equalExprElement);
			}
			if ($objectProperty->isMethodCall()) {
				$simpleMethodCallOrFieldAccess = new AOWP_PHPSimpleMethodCallElement($objectName, $objectProperty->getPropertyName());
				foreach ($objectProperty->arguments as $argumentElement) {
					$simpleMethodCallOrFieldAccess->addArgument($argumentElement);
				}
			}
			else {
				$simpleMethodCallOrFieldAccess = new AOWP_PHPSimpleFieldAccessElement($objectName, $objectProperty->getPropertyName());
			}
			if ($objectPropertyIndex === $nowObjectPropertyIndex++) {
				$newObjectPropertyElement = $simpleMethodCallOrFieldAccess->getFirstObjectProperty();
			}
		}
		$equalExprElement = new AOWP_PHPEqualExprElement(AOWP_WeavingASTHelper::getRandomName('variable', true), $simpleMethodCallOrFieldAccess);
		$lastStatementVaribaleName = $equalExprElement->getLeftVarialeName();
		$apartedMethodCallArray[] = new AOWP_PHPStatementElement($equalExprElement);
		
		// 分解した文を、元のコードに追加し、変換対象のメソッド呼び出し等を、分解した文の最後の変数に置き換える。
		$containerElementResult = AOWP_WeavingASTHelper::getContainerParent($objectOperatorElement, true);
		$containerElement = $containerElementResult[0];
		$parentElementNearContainer = $containerElementResult[1];
		$containerElement->insertElementArray($apartedMethodCallArray, $parentElementNearContainer);
		$parentElement = $objectOperatorElement->getParent();
		$parentElement->{$objectOperatorElement->getParentPropertyName()} = new AOWP_PHPVariableElement($lastStatementVaribaleName);
		$parentElement->{$objectOperatorElement->getParentPropertyName()}->setParent($parentElement);
		
		return $newObjectPropertyElement;
	}
	
	/**
	 * 
	 * @param $targetElement
	 * @param $insertedElement
	 * @return void
	 */
	public static function insertElement(AOWP_PHPElement &$targetElement, AOWP_PHPElement &$insertedElement) {
		// ラッピング関数を、元のコードに追加。
		$containerElementResult = AOWP_WeavingASTHelper::getContainerParent($targetElement->getParent(), true);
		$containerElement = $containerElementResult[0];
		$parentElementNearContainer = $containerElementResult[1];
		$containerElement->insertElement($insertedElement, $parentElementNearContainer);
	}
	
}
?>