<?php
class AOWP_PHPInnerStatementContainerElement extends AOWP_PHPElement implements AOWP_IPHPContainerElement {

	public $innerStatements;
	
	public function setElement(AOWP_PHPElement &$element, $index = null) {
		$element->setParent($this);
		if ($index === null) {
			$this->innerStatements[] = $element;
		}
		else {
			$this->innerStatements[$index] = $element;
		}
	}
	public function replaceElement(AOWP_PHPElement &$element, AOWP_PHPElement &$replacedElement) {
		$index = $this->searchElementInd($replacedElement);
		$replacedElement->setParent(null);
		$this->setElement($element, $index);
	}
	public function removeElement(AOWP_PHPElement &$removedElement) {
		$index = $this->searchElementIndex($removedElement);
		$removedElement->setParent(null);
		array_splice($this->innerStatements, $index, 1);
	}
	public function searchElementIndex(AOWP_PHPElement &$element) {
		return AOWP_PHPASTCommon::searchElementIndex($this->innerStatements, $element);
	}
	public function insertElement(AOWP_PHPElement &$element, $indexOrElement) {
		$indexOrElement = is_numeric($indexOrElement) ? $indexOrElement :
			$this->searchElementIndex($indexOrElement);
		$element->setParent($this);
		array_splice($this->innerStatements, $indexOrElement, 0, array($element));
	}
	public function insertElementArray(array &$elementArray, $indexOrElement) {
		$indexOrElement = is_numeric($indexOrElement) ? $indexOrElement :
			$this->searchElementIndex($indexOrElement);
		foreach ($elementArray as $element) {
			$element->setParent($this);
		}
		array_splice($this->innerStatements, $indexOrElement, 0, $elementArray);
	}
	
}
?>