<?php
ini_set('unserialize_callback_func', '__autoload');
function __autoload($className) {
	$classNameArray = explode('_', $className);
	if (count($classNameArray) == 2) {
//		echo 'Include class definition (' . $className . ').' . "\n";
		$autoloadClassLocation = dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR .
			'classes' . DIRECTORY_SEPARATOR . $classNameArray[1] . '.class.php';
		if (file_exists($autoloadClassLocation))
		require_once $autoloadClassLocation;
	}
	
	$classDefinitionLocation = ALP_ClassDefLocMap::getClassDefinitionLocation($className);
	if (file_exists($classDefinitionLocation)) {
		require_once $classDefinitionLocation;
	}
}
?>