<?php
/**
 * 長い説明文
 * 
 * @package aowp.aspect.pointcut.designators
 */
/**
 * 関数実行のイベントを選択するポイントカット記述子です。
 * 
 * @package aowp.aspect.pointcut.designators
 */
class AOWP_FunctionExecutionPointcut extends AOWP_StaticPointcut {
	private $_functionName;
	private $_argumentsCount;

	/**
	 * 
	 * @param string $functionName 関数名
	 * @param int $argumentsCount 選択対象の関数の引き数の数
	 */
	public function __construct ($functionName, $argumentsCount) {
		$this->_functionName   = $functionName;
		$this->_argumentsCount = $argumentsCount;
	}

	protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
//		AOWP_Logger::logging('Function name: ' . $this->_functionName . ', ' . $joinPoint->getFunctionName());
//		AOWP_Logger::logging('Argument count: ' . $this->_argumentsCount . ', ' . $joinPoint->getParameterCount());
		return $joinPoint instanceof AOWP_FunctionExecutionJoinPoint &&
			AOWP_Pointcut::patternMatch($this->_functionName, $joinPoint->getFunctionName()) &&
			(($this->_argumentsCount === -1) || ($this->_argumentsCount === $joinPoint->getParameterCount()));
	}
}
?>