<?php
/**
 * Driver template for the PHP_PHP_Parser_CorerGenerator parser generator. (PHP port of LEMON)
 * 
 * Driver template for the PHP_PHP_Parser_CorerGenerator parser generator. (PHP port of LEMON)
 * 
 * @package aowp.parser.Parser
 */

/**
 * PHP_Parser_CoreyToken
 *
 * This can be used to store both the string representation of
 * a token, and any useful meta-data associated with the token.
 * meta-data should be stored as an array
 * 
 * @package aowp.parser.Parser
 */
class PHP_Parser_CoreyyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof PHP_Parser_CoreyyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof PHP_Parser_CoreyyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof PHP_Parser_CoreyyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof PHP_Parser_CoreyyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

/** The following structure represents a single element of the
 * parser's stack.  Information stored includes:
 *
 *   +  The state number for the parser at this level of the stack.
 *
 *   +  The value of the token stored at this level of the stack.
 *      (In other words, the "major" token.)
 *
 *   +  The semantic value stored at this level of the stack.  This is
 *      the information used by the action routines in the grammar.
 *      It is sometimes called the "minor" token.
 * 
 * @package aowp.parser.Parser
 */
class PHP_Parser_CoreyyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

// code external to the class is included here

// declare_class is output here
#line 2 "Core.y"
/**
 * 短い説明
 * 
 * 長い説明
 *
 * @package aowp.parser.Parser
 */
class PHP_Parser_Core#line 102 "Core.php"
{
/* First off, code is included which follows the "include_class" declaration
** in the input file. */
#line 20 "Core.y"

    static public $transTable = array();
    public $lex;
    public $functions = array();
    public $classes = array();
    //public $interfaces = array();
    //public $includes = array();
    public $globals = array();
    public $root;
    

    function __construct($lex)
    {
        $this->lex = $lex;
        if (!count(self::$transTable)) {
            $start = 240; // start nice and low to be sure
            while (token_name($start) == 'UNKNOWN') {
                $start++;
            }
            $hash = array_flip(self::$yyTokenName);
            $map =
                array(
                    ord(',') => self::COMMA,
                    ord('=') => self::EQUALS,
                    ord('?') => self::QUESTION,
                    ord(':') => self::COLON,
                    ord('|') => self::BAR,
                    ord('^') => self::CARAT,
                    ord('&') => self::AMPERSAND,
                    ord('<') => self::LESSTHAN,
                    ord('>') => self::GREATERTHAN,
                    ord('+') => self::PLUS,
                    ord('-') => self::MINUS,
                    ord('.') => self::DOT,
                    ord('*') => self::TIMES,
                    ord('/') => self::DIVIDE,
                    ord('%') => self::PERCENT,
                    ord('!') => self::EXCLAM,
                    ord('~') => self::TILDE,
                    ord('@') => self::AT,
                    ord('[') => self::LBRACKET,
                    ord('(') => self::LPAREN,
                    ord(')') => self::RPAREN,
                    ord(';') => self::SEMI,
                    ord('{') => self::LCURLY,
                    ord('}') => self::RCURLY,
                    ord('`') => self::BACKQUOTE,
                    ord('$') => self::DOLLAR,
                    ord(']') => self::RBRACKET,
                    ord('"') => self::DOUBLEQUOTE,
                    ord("'") => self::SINGLEQUOTE,
                );
            for ($i = $start; $i < self::YYERRORSYMBOL + $start; $i++) {
                $lt = token_name($i);
                $lt = ($lt == 'T_DOUBLE_COLON') ?  'T_PAAMAYIM_NEKUDOTAYIM' : $lt;
//                echo "$lt has hash? ".$hash[$lt]."\n";
                if (!isset($hash[$lt])) {
                    continue;
                }
                
                //echo "compare $lt with {$tokens[$i]}\n";
                $map[$i] = $hash[$lt];
            }
            //print_r($map);
            // set the map to false if nothing in there.
            self::$transTable = $map;
        }
    }

    public $data;

    //何もしないセマンティックアクションがあると、実行時エラーになるらしい。。
    //何もしないセマンティックアクションではnop()を呼ぶ。
    public function nop(){}
    
        public function releaseInstance() {
    	foreach ($this->classes as $element) {
    		if (is_subclass_of($element, 'AOWP_PHPElement')) {
    			$element->releaseInstance();
    		}
       	}
    	foreach ($this->functions as $element) {
    		if (is_subclass_of($element, 'AOWP_PHPElement')) {
    			$element->releaseInstance();
    		}
       	}
    	foreach ($this->globals as $element) {
    		if (is_subclass_of($element, 'AOWP_PHPElement')) {
    			$element->releaseInstance();
    		}
       	}
       	$this->lex->releaseInstance();
    	if (is_subclass_of($this->root, 'AOWP_PHPElement')) {
    		$this->root->releaseInstance();
    	}
    }
#line 204 "Core.php"

/* Next is all token values, as class constants
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
    const T_INCLUDE                      =  1;
    const T_INCLUDE_ONCE                 =  2;
    const T_EVAL                         =  3;
    const T_REQUIRE                      =  4;
    const T_REQUIRE_ONCE                 =  5;
    const COMMA                          =  6;
    const T_LOGICAL_OR                   =  7;
    const T_LOGICAL_XOR                  =  8;
    const T_LOGICAL_AND                  =  9;
    const T_PRINT                        = 10;
    const EQUALS                         = 11;
    const T_PLUS_EQUAL                   = 12;
    const T_MINUS_EQUAL                  = 13;
    const T_MUL_EQUAL                    = 14;
    const T_DIV_EQUAL                    = 15;
    const T_CONCAT_EQUAL                 = 16;
    const T_MOD_EQUAL                    = 17;
    const T_AND_EQUAL                    = 18;
    const T_OR_EQUAL                     = 19;
    const T_XOR_EQUAL                    = 20;
    const T_SL_EQUAL                     = 21;
    const T_SR_EQUAL                     = 22;
    const QUESTION                       = 23;
    const COLON                          = 24;
    const T_BOOLEAN_OR                   = 25;
    const T_BOOLEAN_AND                  = 26;
    const BAR                            = 27;
    const CARAT                          = 28;
    const AMPERSAND                      = 29;
    const T_IS_EQUAL                     = 30;
    const T_IS_NOT_EQUAL                 = 31;
    const T_IS_IDENTICAL                 = 32;
    const T_IS_NOT_IDENTICAL             = 33;
    const LESSTHAN                       = 34;
    const T_IS_SMALLER_OR_EQUAL          = 35;
    const GREATERTHAN                    = 36;
    const T_IS_GREATER_OR_EQUAL          = 37;
    const T_SL                           = 38;
    const T_SR                           = 39;
    const PLUS                           = 40;
    const MINUS                          = 41;
    const DOT                            = 42;
    const TIMES                          = 43;
    const DIVIDE                         = 44;
    const PERCENT                        = 45;
    const EXCLAM                         = 46;
    const T_INSTANCEOF                   = 47;
    const TILDE                          = 48;
    const T_INC                          = 49;
    const T_DEC                          = 50;
    const T_INT_CAST                     = 51;
    const T_DOUBLE_CAST                  = 52;
    const T_STRING_CAST                  = 53;
    const T_UNICODE_CAST                 = 54;
    const T_BINARY_CAST                  = 55;
    const T_ARRAY_CAST                   = 56;
    const T_OBJECT_CAST                  = 57;
    const T_BOOL_CAST                    = 58;
    const T_UNSET_CAST                   = 59;
    const AT                             = 60;
    const LBRACKET                       = 61;
    const T_NEW                          = 62;
    const T_CLONE                        = 63;
    const T_ELSEIF                       = 64;
    const T_ELSE                         = 65;
    const T_ENDIF                        = 66;
    const T_STATIC                       = 67;
    const T_ABSTRACT                     = 68;
    const T_FINAL                        = 69;
    const T_PRIVATE                      = 70;
    const T_PROTECTED                    = 71;
    const T_PUBLIC                       = 72;
    const T_HALT_COMPILER                = 73;
    const LPAREN                         = 74;
    const RPAREN                         = 75;
    const SEMI                           = 76;
    const LCURLY                         = 77;
    const RCURLY                         = 78;
    const T_IF                           = 79;
    const T_WHILE                        = 80;
    const T_DO                           = 81;
    const T_FOR                          = 82;
    const T_SWITCH                       = 83;
    const T_BREAK                        = 84;
    const T_CONTINUE                     = 85;
    const T_RETURN                       = 86;
    const T_GLOBAL                       = 87;
    const T_ECHO                         = 88;
    const T_INLINE_HTML                  = 89;
    const T_USE                          = 90;
    const T_UNSET                        = 91;
    const T_FOREACH                      = 92;
    const T_AS                           = 93;
    const T_DECLARE                      = 94;
    const T_TRY                          = 95;
    const T_CATCH                        = 96;
    const T_VARIABLE                     = 97;
    const T_THROW                        = 98;
    const T_FUNCTION                     = 99;
    const T_STRING                       = 100;
    const T_CLASS                        = 101;
    const T_EXTENDS                      = 102;
    const T_INTERFACE                    = 103;
    const T_IMPLEMENTS                   = 104;
    const T_LIST                         = 105;
    const T_EXIT                         = 106;
    const BACKQUOTE                      = 107;
    const T_ARRAY                        = 108;
    const T_LNUMBER                      = 109;
    const T_DNUMBER                      = 110;
    const T_CONSTANT_ENCAPSED_STRING     = 111;
    const T_LINE                         = 112;
    const T_FILE                         = 113;
    const T_CLASS_C                      = 114;
    const T_METHOD_C                     = 115;
    const T_FUNC_C                       = 116;
    const T_DOUBLE_ARROW                 = 117;
    const T_PAAMAYIM_NEKUDOTAYIM         = 118;
    const T_ENDFOR                       = 119;
    const T_ENDFOREACH                   = 120;
    const T_ENDDECLARE                   = 121;
    const T_ENDSWITCH                    = 122;
    const T_CASE                         = 123;
    const T_DEFAULT                      = 124;
    const T_ENDWHILE                     = 125;
    const DOLLAR                         = 126;
    const T_VAR                          = 127;
    const T_CONST                        = 128;
    const T_OBJECT_OPERATOR              = 129;
    const RBRACKET                       = 130;
    const T_NUM_STRING                   = 131;
    const T_ENCAPSED_AND_WHITESPACE      = 132;
    const T_CHARACTER                    = 133;
    const T_BAD_CHARACTER                = 134;
    const T_DOLLAR_OPEN_CURLY_BRACES     = 135;
    const T_STRING_VARNAME               = 136;
    const T_CURLY_OPEN                   = 137;
    const T_ISSET                        = 138;
    const T_EMPTY                        = 139;
    const DOUBLEQUOTE                    = 140;
    const SINGLEQUOTE                    = 141;
    const T_START_HEREDOC                = 142;
    const T_END_HEREDOC                  = 143;
    const YY_NO_ACTION = 1121;
    const YY_ACCEPT_ACTION = 1120;
    const YY_ERROR_ACTION = 1119;

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < self::YYNSTATE                              Shift N.  That is,
**                                                        push the lookahead
**                                                        token onto the stack
**                                                        and goto state N.
**
**   self::YYNSTATE <= N < self::YYNSTATE+self::YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == self::YYNSTATE+self::YYNRULE                    A syntax error has occurred.
**
**   N == self::YYNSTATE+self::YYNRULE+1                  The parser accepts its
**                                                        input. (and concludes parsing)
**
**   N == self::YYNSTATE+self::YYNRULE+2                  No such action.  Denotes unused
**                                                        slots in the yy_action[] table.
**
** The action table is constructed as a single large static array $yy_action.
** Given state S and lookahead X, the action is computed as
**
**      self::$yy_action[self::$yy_shift_ofst[S] + X ]
**
** If the index value self::$yy_shift_ofst[S]+X is out of range or if the value
** self::$yy_lookahead[self::$yy_shift_ofst[S]+X] is not equal to X or if
** self::$yy_shift_ofst[S] is equal to self::YY_SHIFT_USE_DFLT, it means that
** the action is not in the table and that self::$yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the static $yy_reduce_ofst array is used in place of
** the static $yy_shift_ofst array and self::YY_REDUCE_USE_DFLT is used in place of
** self::YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  self::$yy_action        A single table containing all actions.
**  self::$yy_lookahead     A table containing the lookahead for each entry in
**                          yy_action.  Used to detect hash collisions.
**  self::$yy_shift_ofst    For each state, the offset into self::$yy_action for
**                          shifting terminals.
**  self::$yy_reduce_ofst   For each state, the offset into self::$yy_action for
**                          shifting non-terminals after a reduce.
**  self::$yy_default       Default action for each state.
*/
    const YY_SZ_ACTTAB = 14587;
static public $yy_action = array(
 /*     0 */   567,  566,  455,  583,  599,  563,  140,  358,   59,   92,
 /*    10 */   106,  111,  125,  102,  116,   98,   55,  122,  121,   56,
 /*    20 */    57,   58,   51,  105,  126,  110,  107,  109,  112,  114,
 /*    30 */   103,  209,  153,  341,  434,  719,  350,  187,  570,   67,
 /*    40 */    68,  570,  360,  718,   38,   63,  401,   53,  139,  137,
 /*    50 */    49,   50,   61,  195,   65,   64,   62,   66,   70,   54,
 /*    60 */    52,  608,  611,  451,  350,  187,  667,  433,  431,  570,
 /*    70 */   668,  581,  396,   69,  563,  694,  627,  459,  625,  705,
 /*    80 */   721,  736,  734,  742,  733,  724,  727,  653,  658,  661,
 /*    90 */   675,  692,  157,  696,  687,  405,  563,  677,  518,  364,
 /*   100 */   541,  143,  543,  462,  609,  231,  238,  578,  571,  571,
 /*   110 */   571,  571,  571,  571,  571,  571,  645,  567,  566,  455,
 /*   120 */   583,  599,  371,  403,  412,  462,   92,  110,  107,  109,
 /*   130 */   112,  114,  103,  394,  153,  598,  556,  456,  460,  239,
 /*   140 */   232,  242,   56,   57,   58,   51,  105,  126,  110,  107,
 /*   150 */   109,  112,  114,  103,  193,  153,   67,   68,  363,  184,
 /*   160 */   564,  474,   63,  570,   53,  139,  137,   49,   50,   61,
 /*   170 */   424,   65,   64,   62,   66,   70,   54,  711,  608,  611,
 /*   180 */   712,  350,  187,  667,  433,  431,  570,   16,  556,  396,
 /*   190 */    69,  729,  694,  627,  208,  625,  705,  721,  736,  734,
 /*   200 */   742,  733,  724,  727,  653,  658,  661,  675,  692,  399,
 /*   210 */   696,  687,  405,  563,  677,  518,  364,  541,  967,  543,
 /*   220 */   133,  609,  231,  238,  578,  571,  571,  571,  571,  571,
 /*   230 */   571,  571,  571,  218,  567,  566,  455,  583,  599,  499,
 /*   240 */    85,  202,  462,   92,  230,  665,  414,  377,  369,  671,
 /*   250 */   428,  226,  598,  527,  456,  460,  239,  232,  242,  229,
 /*   260 */   492,   85,  202,  719,  350,  187,  415,  350,  187,  570,
 /*   270 */   360,  718,  570,   67,   68,  363,  184,  564,  474,   63,
 /*   280 */   570,   53,  139,  137,   49,   50,   61,  967,   65,   64,
 /*   290 */    62,   66,   70,   54,  711,  608,  611,  224,   85,  202,
 /*   300 */   667,  433,  431,  483,   25,  398,  396,   69,  563,  694,
 /*   310 */   627,  441,  625,  705,  721,  736,  734,  742,  733,  724,
 /*   320 */   727,  653,  658,  661,  675,  692,  152,  696,  687,    4,
 /*   330 */   563,  677,  518,  364,  541,  484,  543,  462,  609,  231,
 /*   340 */   238,  578,  571,  571,  571,  571,  571,  571,  571,  571,
 /*   350 */   563,   28,  373,  459,  567,  566,  455,  583,  599,  462,
 /*   360 */   352,  563,  964,   92,  459,  570,  374,  345,   84,  598,
 /*   370 */   418,  456,  460,  239,  232,  242,  665,  522,  377,  462,
 /*   380 */   671,   28,  513,  513,  513,  513,  513,  513,  563,  563,
 /*   390 */   462,  459,  457,   67,   68,  379,  665,  515,  377,   63,
 /*   400 */   671,   53,  139,  137,   49,   50,   61,  659,   65,   64,
 /*   410 */    62,   66,   70,   54,  989,  608,  611,  462,  462,  131,
 /*   420 */   667,  433,  431,  359,  951, 1090,  396,   69,  570,  694,
 /*   430 */   627,  964,  625,  705,  721,  736,  734,  742,  733,  724,
 /*   440 */   727,  653,  658,  661,  675,  692,  397,  696,  687,  521,
 /*   450 */   563,  677,  518,  364,  541,  540,  543,  521,  609,  231,
 /*   460 */   238,  578,  571,  571,  571,  571,  571,  571,  571,  571,
 /*   470 */   530,  223,  452,  361,  468,  219,  699,  196,  523,  462,
 /*   480 */   447,  567,  566,  455,  583,  599,  534,  251,  500,  598,
 /*   490 */    92,  456,  460,  239,  232,  242,  111,  125,  102,  116,
 /*   500 */    98,   55,  122,  121,   56,   57,   58,   51,  105,  126,
 /*   510 */   110,  107,  109,  112,  114,  103,  577,  153,  386,  577,
 /*   520 */    67,   68,  563,  678,  540,  438,   63,  376,   53,  139,
 /*   530 */   137,   49,   50,   61,  201,   65,   64,   62,   66,   70,
 /*   540 */    54,  450,  608,  611,  612,  616,  686,  667,  433,  431,
 /*   550 */   577,  462,  118,  396,   69,  472,  694,  627,  501,  625,
 /*   560 */   705,  721,  736,  734,  742,  733,  724,  727,  653,  658,
 /*   570 */   661,  675,  692,  215,  696,  687,  563,  563,  677,  518,
 /*   580 */   364,  541,   15,  543,  700,  609,  231,  238,  578,  571,
 /*   590 */   571,  571,  571,  571,  571,  571,  571,  666,  567,  566,
 /*   600 */   455,  583,  599,  521,  731,  462,  462,   92,  665,  413,
 /*   610 */   377,  521,  671,  112,  114,  103,  598,  153,  456,  460,
 /*   620 */   239,  232,  242,  702,   17,  255,  623,  719,  350,  187,
 /*   630 */   400,  427,  217,  570,  360,  718,  509,   67,   68,  128,
 /*   640 */   665,  514,  377,   63,  671,   53,  139,  137,   49,   50,
 /*   650 */    61,   37,   65,   64,   62,   66,   70,   54,    1,  608,
 /*   660 */   611,  374,  345,  148,  667,  433,  431,   75, 1120,   12,
 /*   670 */   396,   69,  368,  694,  627,  680,  625,  705,  721,  736,
 /*   680 */   734,  742,  733,  724,  727,  653,  658,  661,  675,  692,
 /*   690 */   550,  696,  687,  405,  563,  677,  518,  364,  541,  381,
 /*   700 */   543,  715,  609,  231,  238,  578,  571,  571,  571,  571,
 /*   710 */   571,  571,  571,  571,  213,  567,  566,  455,  583,  599,
 /*   720 */     7,  488,  701,  462,   92,  210,  665,  656,  377,  192,
 /*   730 */   671,  470,  587,  598,  739,  456,  460,  239,  232,  242,
 /*   740 */   234,  131,  545,  120,  719,  350,  187,  639,  423,  235,
 /*   750 */   570,  360,  718,  254,   67,   68,  363,  184,  564,  474,
 /*   760 */    63,  570,   53,  139,  137,   49,   50,   61,  249,   65,
 /*   770 */    64,   62,   66,   70,   54,  711,  608,  611,  443,   85,
 /*   780 */   202,  667,  433,  431,  225,  506,   30,  396,   69,  485,
 /*   790 */   694,  627,  626,  625,  705,  721,  736,  734,  742,  733,
 /*   800 */   724,  727,  653,  658,  661,  675,  692,  227,  696,  687,
 /*   810 */   559,  563,  677,  518,  364,  541,  180,  543,  537,  609,
 /*   820 */   231,  238,  578,  571,  571,  571,  571,  571,  571,  571,
 /*   830 */   571,   83,  567,  566,  455,  583,  599,  384,  197,    8,
 /*   840 */   462,   92,  600,   73,  665,  670,  377,  538,  671,  183,
 /*   850 */   598,  159,  456,  460,  239,  232,  242, 1090,  665,  673,
 /*   860 */   377,  682,  671,  563,    9,  386,  717,  679,  404,  189,
 /*   870 */   558,   67,   68,  162,  665,  512,  377,   63,  671,   53,
 /*   880 */   139,  137,   49,   50,   61,  233,   65,   64,   62,   66,
 /*   890 */    70,   54,  462,  608,  611,   21,  175,   10,  667,  433,
 /*   900 */   431,  657,  182,  176,  396,   69,  446,  694,  627,  181,
 /*   910 */   625,  705,  721,  736,  734,  742,  733,  724,  727,  653,
 /*   920 */   658,  661,  675,  692,  211,  696,  687,  510,  563,  677,
 /*   930 */   518,  364,  541,  203,  543,  199,  609,  231,  238,  578,
 /*   940 */   571,  571,  571,  571,  571,  571,  571,  571,  115,  567,
 /*   950 */   566,  455,  583,  599,   36,  367,  722,  462,   92,  672,
 /*   960 */   665,  655,  377,  212,  671,  167,  372,  598,  123,  456,
 /*   970 */   460,  239,  232,  242,   38,  665,  544,  377,  113,  671,
 /*   980 */   665,  654,  377,  379,  671,   79,  236, 1019,   67,   68,
 /*   990 */    52,  665,  532,  377,   63,  671,   53,  139,  137,   49,
 /*  1000 */    50,   61,  173,   65,   64,   62,   66,   70,   54,  132,
 /*  1010 */   608,  611,  481,  516,  669,  667,  433,  431,  391,  370,
 /*  1020 */   158,  396,   69,  737,  694,  627,  553,  625,  705,  721,
 /*  1030 */   736,  734,  742,  733,  724,  727,  653,  658,  661,  675,
 /*  1040 */   692,   71,  696,  687,  463,  563,  677,  518,  364,  541,
 /*  1050 */   168,  543,  243,  609,  231,  238,  578,  571,  571,  571,
 /*  1060 */   571,  571,  571,  571,  571,  339,  567,  566,  455,  583,
 /*  1070 */   599,   42,  525,  628,  462,   92,  257,  665,  663,  377,
 /*  1080 */   127,  671,  632,  580,  598,   74,  456,  460,  239,  232,
 /*  1090 */   242,  665,  524,  377,   38,  671,  665,  557,  377,  252,
 /*  1100 */   671,  563,  194,   34,  459,   67,   68, 1018,   35,  609,
 /*  1110 */    52,   63,   31,   53,  139,  137,   49,   50,   61,  440,
 /*  1120 */    65,   64,   62,   66,   70,   54,  164,  608,  611,  383,
 /*  1130 */   462,  539,  667,  433,  431,   19,  156,  489,  396,   69,
 /*  1140 */   349,  694,  627,  130,  625,  705,  721,  736,  734,  742,
 /*  1150 */   733,  724,  727,  653,  658,  661,  675,  692,   32,  696,
 /*  1160 */   687,  387,  563,  677,  518,  364,  541,   80,  543,  613,
 /*  1170 */   609,  231,  238,  578,  571,  571,  571,  571,  571,  571,
 /*  1180 */   571,  571,  665,  504,  377,  479,  671,  520,   27,    2,
 /*  1190 */   351,  462,  416,  567,  566,  455,  583,  599,  674,  170,
 /*  1200 */   691,  598,   92,  456,  460,  239,  232,  242,  125,  102,
 /*  1210 */   116,   98,   55,  122,  121,   56,   57,   58,   51,  105,
 /*  1220 */   126,  110,  107,  109,  112,  114,  103,  496,  153,  154,
 /*  1230 */   174,  704,   67,   68,   33,   29,  709,  448,   63,   28,
 /*  1240 */    53,  139,  137,   49,   50,   61,  190,   65,   64,   62,
 /*  1250 */    66,   70,   54,  393,  608,  611,  207,   18,   81,  667,
 /*  1260 */   433,  431,  568,  607,  149,  396,   69,  375,  694,  627,
 /*  1270 */   426,  625,  705,  721,  736,  734,  742,  733,  724,  727,
 /*  1280 */   653,  658,  661,  675,  692,  552,  696,  687,  240,  563,
 /*  1290 */   677,  518,  364,  541,  551,  543,  475,  609,  231,  238,
 /*  1300 */   578,  571,  571,  571,  571,  571,  571,  571,  571,  338,
 /*  1310 */   567,  566,  455,  583,  599,  160,   91,  340,  462,   92,
 /*  1320 */   177,  256,  589,   11,    3,  588,  178,    5,  598,  155,
 /*  1330 */   456,  460,  239,  232,  242,  531,   13,  348,  591,   47,
 /*  1340 */   592,  214,  142,  535,  549,  417,  147,  421,   93,   67,
 /*  1350 */    68,  153,  546,  595,  357,   63,  342,   53,  139,  137,
 /*  1360 */    49,   50,   61,  738,   65,   64,   62,   66,   70,   54,
 /*  1370 */   602,  608,  611,  221,  172,  429,  667,  433,  431,  169,
 /*  1380 */   163,  253,  402,   69,   40,  694,  627,  555,  625,  705,
 /*  1390 */   721,  736,  734,  742,  733,  724,  727,  653,  658,  661,
 /*  1400 */   675,  692,   76,  696,  687,  410,  563,  677,  518,  364,
 /*  1410 */   541,  179,  543,  660,  609,  231,  238,  578,  571,  571,
 /*  1420 */   571,  571,  571,  571,  571,  571,  200,  594,    6,  618,
 /*  1430 */   730,  171,  395,   14,  392,  462,  425,  567,  566,  455,
 /*  1440 */   583,  599,  250,  161,  145,  598,   92,  456,  460,  239,
 /*  1450 */   232,  242,  188,  388,  389,  655,  655,  655,  655,  655,
 /*  1460 */   244,  655,   43,  108,   90,  101,   72,   97,   95,   96,
 /*  1470 */    87,   86,   77,   78,  655,  655,   67,   68,  655,  655,
 /*  1480 */   655,  655,   63,  655,   53,  139,  137,   49,   50,   61,
 /*  1490 */   655,   65,   64,   62,   66,   70,   54,  655,  608,  611,
 /*  1500 */  1010, 1010,  655,  667,  655,  655,  655,  655,  655,  655,
 /*  1510 */    69,  655,  694,  627,  655,  625,  705,  721,  736,  734,
 /*  1520 */   742,  733,  724,  727,  653,  658,  661,  675,  692,  655,
 /*  1530 */   696,  687,  655,  563,  677,  655,  364,  655,  655,  655,
 /*  1540 */   655,  609,  231,  238,  578,  571,  571,  571,  571,  571,
 /*  1550 */   571,  571,  571,  655,  655,  655,  655,  655,  655,  655,
 /*  1560 */   655,  655,  462,  655,  567,  566,  455,  583,  599,  655,
 /*  1570 */   655,  655,  598,   92,  456,  460,  239,  232,  242,  655,
 /*  1580 */   655,  655,  655,  655,  655,  655,  655,  246,  655,  655,
 /*  1590 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  1600 */   655,  655,  655,   67,   68,  655,  655,  655,  655,   63,
 /*  1610 */   655,   53,  139,  137,   49,   50,   61,  655,   65,   64,
 /*  1620 */    62,   66,   70,   54,  655,  608,  611,  655,  655,  655,
 /*  1630 */   667,  655,  655,  655,  655,  655,  689,   69,  655,  694,
 /*  1640 */   627,  655,  625,  705,  721,  736,  734,  742,  733,  724,
 /*  1650 */   727,  653,  658,  661,  675,  692,  454,  696,  687,  655,
 /*  1660 */   563,  677,  655,  364,  655,  655,  655,  655,  609,  231,
 /*  1670 */   238,  578,  571,  571,  571,  571,  571,  571,  571,  571,
 /*  1680 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  462,
 /*  1690 */   655,  567,  566,  455,  583,  599,  655,  655,  655,  598,
 /*  1700 */    92,  456,  460,  239,  232,  242,  655,  655,  655,  655,
 /*  1710 */   655,  560,  690,  453,  245,  655,  655,  655,  458,  343,
 /*  1720 */   186,  564,  561,  655,  570,  655,  655,  655,  655,  655,
 /*  1730 */    67,   68,  655,  655,  655,  655,   63,  655,   53,  139,
 /*  1740 */   137,   49,   50,   61,  655,   65,   64,   62,   66,   70,
 /*  1750 */    54,  655,  608,  611,  655,  655,  655,  667,  655,  655,
 /*  1760 */   655,  655,  655,  655,   69,  655,  694,  627,  655,  625,
 /*  1770 */   705,  721,  736,  734,  742,  733,  724,  727,  653,  658,
 /*  1780 */   661,  675,  692,  655,  696,  687,  655,  563,  677,  655,
 /*  1790 */   364,  655,  655,  655,  655,  609,  231,  238,  578,  571,
 /*  1800 */   571,  571,  571,  571,  571,  571,  571,  655,  655,  655,
 /*  1810 */   655,  655,  655,  655,  655,  655,  462,  655,  567,  566,
 /*  1820 */   455,  583,  599,  655,  655,  655,  598,   92,  456,  460,
 /*  1830 */   239,  232,  242,  655,  655,  655,  655,  655,  655,  655,
 /*  1840 */   655,  248,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  1850 */   655,  655,  655,  655,  655,  655,  655,   67,   68,  655,
 /*  1860 */   655,  655,  655,   63,  655,   53,  139,  137,   49,   50,
 /*  1870 */    61,  655,   65,   64,   62,   66,   70,   54,  655,  608,
 /*  1880 */   611,  655,  655,  655,  667,  655,  655,  655,  655,  655,
 /*  1890 */   655,   69,  655,  694,  627,  655,  625,  705,  721,  736,
 /*  1900 */   734,  742,  733,  724,  727,  653,  658,  661,  675,  692,
 /*  1910 */   655,  696,  687,  655,  563,  677,  655,  364,  655,  655,
 /*  1920 */   655,  655,  609,  231,  238,  578,  571,  571,  571,  571,
 /*  1930 */   571,  571,  571,  571,  655,  655,  655,  655,  655,  655,
 /*  1940 */   655,  655,  655,  462,  655,  567,  566,  455,  583,  599,
 /*  1950 */   655,  655,  655,  598,   92,  456,  460,  239,  232,  242,
 /*  1960 */   655,  655,  655,  655,  655,  655,  655,  655,  237,  655,
 /*  1970 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  1980 */   655,  655,  655,  655,   67,   68,  655,  655,  655,  655,
 /*  1990 */    63,  655,   53,  139,  137,   49,   50,   61,  655,   65,
 /*  2000 */    64,   62,   66,   70,   54,  655,  608,  611,  655,  655,
 /*  2010 */   655,  667,  655,  655,  655,  655,  655,  655,   69,  655,
 /*  2020 */   694,  627,  655,  625,  705,  721,  736,  734,  742,  733,
 /*  2030 */   724,  727,  653,  658,  661,  675,  692,  655,  696,  687,
 /*  2040 */   655,  563,  677,  655,  364,  655,  655,  655,  655,  609,
 /*  2050 */   231,  238,  578,  571,  571,  571,  571,  571,  571,  571,
 /*  2060 */   571,  655,  567,  566,  455,  583,  599,  655,  655,  655,
 /*  2070 */   462,   92,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  2080 */   598,  655,  456,  460,  239,  232,  242,  655,  655,  655,
 /*  2090 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  2100 */   655,   67,   68,  655,  655,  655,  655,   63,  655,   53,
 /*  2110 */   139,  137,   49,   50,   61,  655,   65,   64,   62,   66,
 /*  2120 */    70,   54,  655,  608,  611,  655,  655,  655,  667,  655,
 /*  2130 */   655,  655,  655,  655,  655,   69,  655,  694,  627,  655,
 /*  2140 */   469,  705,  721,  736,  734,  742,  733,  724,  727,  653,
 /*  2150 */   658,  661,  675,  692,  655,  696,  687,  655,  563,  677,
 /*  2160 */   655,  364,  655,  655,  655,  655,  609,  231,  238,  578,
 /*  2170 */   571,  571,  571,  571,  571,  571,  571,  571,  655,  567,
 /*  2180 */   566,  455,  583,  599,  655,  655,  655,  462,   92,  655,
 /*  2190 */   655,  655,  655,  655,  655,  655,  655,  598,  655,  456,
 /*  2200 */   460,  239,  232,  242,  655,  655,  655,  655,  655,  655,
 /*  2210 */   655,  655,  655,  655,  655,  655,  655,  655,   67,   68,
 /*  2220 */   655,  655,  655,  569,   63,  655,   53,  139,  137,   49,
 /*  2230 */    50,   61,  655,   65,   64,   62,   66,   70,   54,  655,
 /*  2240 */   608,  611,  655,  454,  655,  667,  655,  655,  655,  655,
 /*  2250 */   655,  655,   69,  655,  694,  627,  655,  625,  705,  721,
 /*  2260 */   736,  734,  742,  733,  724,  727,  653,  658,  661,  675,
 /*  2270 */   692,  655,  696,  687,  655,  563,  677,  655,  364,  655,
 /*  2280 */   655,  533,  655,  609,  231,  238,  578,  571,  571,  571,
 /*  2290 */   571,  571,  571,  571,  571,  655,  655,  655,  560,  655,
 /*  2300 */   453,  655,  655,  655,  462,  458,  343,  186,  564,  561,
 /*  2310 */   655,  570,  655,  655,  598,  655,  456,  460,  239,  232,
 /*  2320 */   242,  685,  684,  683,  624,  241,  655,  486,  262,  655,
 /*  2330 */   655,  205,  655,  495,  655,   26,  494,  655,  655,  490,
 /*  2340 */   655,   44,   45,   46,  610,  326,  185,  655,  216,  655,
 /*  2350 */    39,  655,  198,  655,  382,  655,  420,  655,  655,  655,
 /*  2360 */   406,  655,  655,  390,  655,  436,  655,   82,  655,  655,
 /*  2370 */   681,  743,  548,  206,  655,  655,  385,  655,  655,  655,
 /*  2380 */   497,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /*  2390 */   356,  642,  655,  634,  491,  655,  655,  596,  655,  106,
 /*  2400 */   111,  125,  102,  116,   98,   55,  122,  121,   56,   57,
 /*  2410 */    58,   51,  105,  126,  110,  107,  109,  112,  114,  103,
 /*  2420 */   560,  153,  453,  655,  655,  655,  655,  458,  343,  186,
 /*  2430 */   564,  561,  655,  570,  655,  655,  655,  655,  655,  655,
 /*  2440 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /*  2450 */   655,  655,  655,  685,  684,  683,  624,  241,  655,  486,
 /*  2460 */   262,  655,  655,  655,  655,  495,  655,   26,  494,  655,
 /*  2470 */   655,  490,  655,   44,   45,   46,  610,  326,  185,  655,
 /*  2480 */   216,  655,   39,  655,  198,  655,  382,  655,  420,  655,
 /*  2490 */   655,  655,  406,  655,  655,  390,  655,  436,  655,   82,
 /*  2500 */   655,  655,  681,  743,  548,  206,  655,  655,  385,  655,
 /*  2510 */   655,  655,  497,  655,  655,  617,  493,  655,  655,  655,
 /*  2520 */   151,  104,  356,  642,  655,  634,  491,  655,  655,  596,
 /*  2530 */   655,  102,  116,   98,   55,  122,  121,   56,   57,   58,
 /*  2540 */    51,  105,  126,  110,  107,  109,  112,  114,  103,  655,
 /*  2550 */   153,  655,  560,  655,  453,  655,  655,  655,  655,  458,
 /*  2560 */   343,  186,  564,  561,  655,  570,  655,  655,  655,  655,
 /*  2570 */   655,  655,  655,  655,   88,   89,   94,   99,  597,  622,
 /*  2580 */   621,  620,  619,  624,  241,  655,  486,  262,  655,  655,
 /*  2590 */   655,  655,  495,  655,   26,  494,  655,  655,  490,  655,
 /*  2600 */    44,   45,   46,  610,  326,  185,  655,  216,  655,   39,
 /*  2610 */   655,  198,  655,  382,  655,  420,  655,  655,  655,  406,
 /*  2620 */   655,  655,  390,  655,  436,  655,   82,  655,  655,  655,
 /*  2630 */   743,  548,  206,  655,  655,  385,  655,  655,  655,  497,
 /*  2640 */   655,  655,  617,  493,  655,  655,  655,  151,  104,  356,
 /*  2650 */   642,  655,  634,  491,  655,  655,  596,  655,  655,  655,
 /*  2660 */   116,   98,   55,  122,  121,   56,   57,   58,   51,  105,
 /*  2670 */   126,  110,  107,  109,  112,  114,  103,  655,  153,  560,
 /*  2680 */   655,  453,  655,  655,  655,  655,  458,  343,  186,  564,
 /*  2690 */   561,  655,  570,  166,  165,  655,  655,  655,  655,  655,
 /*  2700 */   655,   88,   89,   94,   99,  597,  655,  655,  519,  655,
 /*  2710 */   655,  624,  241,  655,  486,  262,  655,  655,  655,  655,
 /*  2720 */   495,  655,   26,  494,  655,  735,  490,  655,   44,   45,
 /*  2730 */    46,  610,  326,  185,  655,  216,  655,   39,  655,  198,
 /*  2740 */   655,  382,  655,  420,  655,  655,  655,  406,  655,  655,
 /*  2750 */   390,  655,  436,  380,   82,  655,  655,  655,  655,  655,
 /*  2760 */   655,  664,  571,  571,  571,  571,  571,  571,  571,  571,
 /*  2770 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /*  2780 */   634,  491,  655,  655,  596,   98,   55,  122,  121,   56,
 /*  2790 */    57,   58,   51,  105,  126,  110,  107,  109,  112,  114,
 /*  2800 */   103,  655,  153,  655,  655,  707,  655,  560,  655,  453,
 /*  2810 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /*  2820 */   570,  655,  655,  655,  655,  454,  655,  655,  655,   88,
 /*  2830 */    89,   94,   99,  597,  655,  536,  655,  655,  624,  241,
 /*  2840 */   655,  486,  262,  655,  498,  355,  655,  495,  720,   26,
 /*  2850 */   494,  655,  655,  490,  655,   44,   45,   46,  610,  326,
 /*  2860 */   185,  655,  216,  655,   39,  655,  198,  655,  382,  655,
 /*  2870 */   420,  655,  655,  655,  406,  655,  655,  390,  655,  436,
 /*  2880 */   560,   82,  453,  655,  655,  655,  655,  458,  343,  186,
 /*  2890 */   564,  561,  655,  570,  655,  655,  706,  617,  493,  655,
 /*  2900 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  655,
 /*  2910 */   965,  596,  655,  655,  655,   43,  108,   90,  101,   72,
 /*  2920 */    97,   95,   96,   87,   86,   77,   78,  655,  655,  655,
 /*  2930 */   655,  655,  655,  655,  560,  655,  453,  655,  655,  655,
 /*  2940 */   655,  458,  343,  186,  564,  561,  655,  570,  655,  655,
 /*  2950 */   655,  655,  655, 1010, 1010,  655,   88,   89,   94,   99,
 /*  2960 */   597,  655,  655,  526,  655,  655,  624,  241,  655,  486,
 /*  2970 */   262,  569,  655,  655,  655,  495,  655,   26,  494,  965,
 /*  2980 */   655,  490,  655,   44,   45,   46,  610,  326,  185,  655,
 /*  2990 */   216,  454,   39,  655,  198,  655,  382,  655,  420,  655,
 /*  3000 */   655,  529,  406,  655,  655,  390,  655,  436,  968,   82,
 /*  3010 */   655,  655,  655,   43,  108,   90,  101,   72,   97,   95,
 /*  3020 */    96,   87,   86,   77,   78,  617,  493,  655,  655,  593,
 /*  3030 */   151,  104,  356,  642,  655,  634,  491,  655,  655,  596,
 /*  3040 */   655,  655,  655,  655,  655,  655,  560,  655,  453,  655,
 /*  3050 */   655, 1010, 1010,  458,  343,  186,  564,  561,  655,  570,
 /*  3060 */   707,  655,  560,  655,  453,  655,  655,  655,  655,  458,
 /*  3070 */   343,  186,  564,  561,  655,  570,  655,  968,  655,  655,
 /*  3080 */   454,  655,  655,  655,   88,   89,   94,   99,  597,  655,
 /*  3090 */   508,  655,  655,  624,  241,  655,  486,  262,  655,  498,
 /*  3100 */   344,  655,  495,  655,   26,  494,  655,  655,  490,  655,
 /*  3110 */    44,   45,   46,  610,  326,  185,  655,  216,  655,   39,
 /*  3120 */   655,  198,  655,  382,  655,  420,  655,  655,  655,  406,
 /*  3130 */   655,  695,  390,  655,  436,  560,   82,  453,  655,  655,
 /*  3140 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /*  3150 */   655,  706,  617,  493,  655,  655,  655,  151,  104,  356,
 /*  3160 */   642,  655,  634,  491,  655,  655,  596,  655,  655,   43,
 /*  3170 */   108,   90,  101,   72,   97,   95,   96,   87,   86,   77,
 /*  3180 */    78,  655,  655,  655,  655,  655,  655,  655,  655,  560,
 /*  3190 */   655,  453,  655,  655,  655,  655,  458,  343,  186,  564,
 /*  3200 */   561,  655,  570,  655,  655,  655,  655, 1010, 1010,  655,
 /*  3210 */   655,   88,   89,   94,   99,  597,  655,  655,  526,  655,
 /*  3220 */   655,  624,  241,  655,  486,  262,  655,  655,  655,  655,
 /*  3230 */   495,  655,   26,  494,  726,  655,  490,  655,   44,   45,
 /*  3240 */    46,  610,  326,  185,  655,  216,  655,   39,  655,  198,
 /*  3250 */   655,  382,  655,  420,  655,  655,  693,  406,  655,  655,
 /*  3260 */   390,  655,  436,  655,   82,  655,  655,  655,   43,  108,
 /*  3270 */    90,  101,   72,   97,   95,   96,   87,   86,   77,   78,
 /*  3280 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /*  3290 */   634,  491,  655,  655,  596,  575,  655,  655,  655,  655,
 /*  3300 */   655,  655,  655,  655,  655,  655, 1010, 1010,  655,  655,
 /*  3310 */   655,  573,  572,  655,  655,  655,  655,  560,  655,  453,
 /*  3320 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /*  3330 */   570,  347,  655,  655,  638,  655,  655,  655,  655,   88,
 /*  3340 */    89,   94,   99,  597,  567,  566,  455,  583,  599,  655,
 /*  3350 */   129,  655,  655,   92,  655,  655,  655,  655,  166,  165,
 /*  3360 */   655,  655,  655,  576,  574,  637,  636,  606,  605,  100,
 /*  3370 */   655,  150,  141,  655,  655,  604,  655,  655,  655,  655,
 /*  3380 */   655,  655,  655,   67,   68,  655,  655,  655,  655,   63,
 /*  3390 */   655,   53,  139,  137,   49,   50,   61,  655,   65,   64,
 /*  3400 */    62,   66,   70,   54,  655,  608,  611,  655,  655,  655,
 /*  3410 */   655,  655,  655,  655,  655,  563,  655,   69,  366,  655,
 /*  3420 */   655,  655,  655,  655,  655,  655,  664,  571,  571,  571,
 /*  3430 */   571,  571,  571,  571,  571,  655,  655,  655,  655,  655,
 /*  3440 */   563,  655,  655,  364,  462,  655,  655,  655,  609,  231,
 /*  3450 */   238,  578,  571,  571,  571,  571,  571,  571,  571,  571,
 /*  3460 */   707,  567,  566,  455,  583,  599,  655,  655,  655,  462,
 /*  3470 */    92,  655,  655,  655,  655,  655,  655,  655,  655,  598,
 /*  3480 */   454,  456,  460,  239,  232,  242,  655,  655,  655,  138,
 /*  3490 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  498,
 /*  3500 */    67,   68,  655,  655,  655,  655,   63,  655,   53,  139,
 /*  3510 */   137,   49,   50,   61,  655,   65,   64,   62,   66,   70,
 /*  3520 */    54,  655,  608,  611,  655,  655,  655,  655,  513,  513,
 /*  3530 */   513,  513,  513,  513,   69,  560,  655,  453,  655,  554,
 /*  3540 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /*  3550 */   655,  708,  655,  655,  655,  655,  655,  563,  655,  655,
 /*  3560 */   364,  655,  655,  655,  655,  609,  231,  238,  578,  571,
 /*  3570 */   571,  571,  571,  571,  571,  571,  571,  655,  567,  566,
 /*  3580 */   455,  583,  599,  655,  655,  655,  462,   92,  502,  442,
 /*  3590 */   655,  655,  655,  655,  655,  655,  598,  655,  456,  460,
 /*  3600 */   239,  232,  242,  655,  655,  655,  144,  655,  655,  655,
 /*  3610 */   513,  513,  513,  513,  513,  513,  655,   67,   68,  655,
 /*  3620 */   655,  517,  655,   63,  655,   53,  139,  137,   49,   50,
 /*  3630 */    61,  655,   65,   64,   62,   66,   70,   54,  655,  608,
 /*  3640 */   611,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  3650 */   655,   69,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  3660 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  3670 */   502,  442,  655,  655,  563,  655,  655,  364,  655,  655,
 /*  3680 */   655,  655,  609,  231,  238,  578,  571,  571,  571,  571,
 /*  3690 */   571,  571,  571,  571,  655,  567,  566,  455,  583,  599,
 /*  3700 */   655,  655,  655,  462,   92,  655,  655,  655,  655,  655,
 /*  3710 */   655,  655,  655,  598,  655,  456,  460,  239,  232,  242,
 /*  3720 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  3730 */   655,  655,  655,  655,   67,   68,  655,  655,  655,  655,
 /*  3740 */    63,  655,   53,  139,  137,   49,   50,   61,  655,   65,
 /*  3750 */    64,   62,   66,   70,   54,  655,  608,  611,  655,  655,
 /*  3760 */   655,  655,  655,  655,  655,  655,  655,  655,   69,  714,
 /*  3770 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  3780 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  3790 */   655,  563,  655,  655,  364,  655,  655,  655,  655,  609,
 /*  3800 */   231,  238,  578,  571,  571,  571,  571,  571,  571,  571,
 /*  3810 */   571,  655,  567,  566,  455,  583,  599,  655,  655,  655,
 /*  3820 */   462,   92,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  3830 */   598,  655,  456,  460,  239,  232,  242,  655,  655,  655,
 /*  3840 */   135,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  3850 */   655,   67,   68,  655,  655,  655,  655,   63,  655,   53,
 /*  3860 */   139,  137,   49,   50,   61,  655,   65,   64,   62,   66,
 /*  3870 */    70,   54,  655,  608,  611,  655,  655,  655,  655,  655,
 /*  3880 */   655,  655,  655,  655,  655,   69,  655,  655,  655,  655,
 /*  3890 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  3900 */   655,  655,  655,  655,  655,  655,  655,  655,  563,  655,
 /*  3910 */   655,  364,  655,  655,  655,  655,  609,  231,  238,  578,
 /*  3920 */   571,  571,  571,  571,  571,  571,  571,  571,  655,  567,
 /*  3930 */   566,  455,  583,  599,  655,  655,  655,  462,   92,  655,
 /*  3940 */   655,  655,  655,  655,  655,  655,  655,  598,  655,  456,
 /*  3950 */   460,  239,  232,  242,  655,  655,  655,  655,  655,  655,
 /*  3960 */   655,  655,  655,  655,  655,  655,  655,  655,   67,   68,
 /*  3970 */   655,  655,  655,  655,   63,  655,   53,  139,  137,   49,
 /*  3980 */    50,   61,  655,   65,   64,   62,   66,   70,   54,  655,
 /*  3990 */   608,  611,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4000 */   655,  655,   69,  655,  732,  655,  655,  655,  655,  655,
 /*  4010 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4020 */   655,  655,  655,  655,  655,  563,  655,  655,  364,  655,
 /*  4030 */   655,  655,  655,  609,  231,  238,  578,  571,  571,  571,
 /*  4040 */   571,  571,  571,  571,  571,  655,  567,  566,  455,  583,
 /*  4050 */   599,  655,  655,  655,  462,   92,  655,  655,  655,  655,
 /*  4060 */   655,  655,  655,  655,  598,  655,  456,  460,  239,  232,
 /*  4070 */   242,  655,  655,  655,  136,  655,  655,  655,  655,  655,
 /*  4080 */   655,  655,  655,  655,  655,   67,   68,  655,  655,  655,
 /*  4090 */   655,   63,  655,   53,  139,  137,   49,   50,   61,  655,
 /*  4100 */    65,   64,   62,   66,   70,   54,  655,  608,  611,  655,
 /*  4110 */   655,  655,  655,  655,  655,  655,  655,  655,  655,   69,
 /*  4120 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4130 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4140 */   655,  655,  563,  655,  655,  364,  655,  655,  655,  655,
 /*  4150 */   609,  231,  238,  578,  571,  571,  571,  571,  571,  571,
 /*  4160 */   571,  571,  655,  567,  566,  455,  583,  599,  655,  655,
 /*  4170 */   655,  462,   92,  655,  655,  655,  655,  655,  655,  655,
 /*  4180 */   655,  598,  655,  456,  460,  239,  232,  242,  655,  655,
 /*  4190 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4200 */   655,  655,   67,   68,  655,  655,  655,  655,   63,  655,
 /*  4210 */    53,  139,  137,   49,   50,   61,  655,   65,   64,   62,
 /*  4220 */    66,   70,   54,  655,  608,  611,  655,  655,  655,  655,
 /*  4230 */   655,  655,  655,  655,  655,  655,   69,  655,  741,  655,
 /*  4240 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4250 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  563,
 /*  4260 */   655,  655,  364,  655,  655,  655,  655,  609,  231,  238,
 /*  4270 */   578,  571,  571,  571,  571,  571,  571,  571,  571,  655,
 /*  4280 */   567,  566,  455,  583,  599,  655,  655,  655,  462,   92,
 /*  4290 */   655,  655,  655,  655,  655,  655,  655,  655,  598,  655,
 /*  4300 */   456,  460,  239,  232,  242,  655,  655,  655,  146,  655,
 /*  4310 */   655,  655,  655,  655,  655,  655,  655,  655,  655,   67,
 /*  4320 */    68,  655,  655,  655,  655,   63,  655,   53,  139,  137,
 /*  4330 */    49,   50,   61,  655,   65,   64,   62,   66,   70,   54,
 /*  4340 */   655,  608,  611,  655,  655,  655,  655,  655,  655,  655,
 /*  4350 */   655,  655,  655,   69,  655,  655,  655,  655,  655,  655,
 /*  4360 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4370 */   655,  655,  655,  655,  655,  655,  563,  655,  655,  364,
 /*  4380 */   655,  655,  655,  655,  609,  231,  238,  578,  571,  571,
 /*  4390 */   571,  571,  571,  571,  571,  571,  655,  567,  566,  455,
 /*  4400 */   583,  599,  655,  655,  655,  462,   92,  655,  655,  655,
 /*  4410 */   655,  655,  655,  655,  655,  598,  655,  456,  460,  239,
 /*  4420 */   232,  242,  655,  655,  655,  134,  655,  655,  655,  655,
 /*  4430 */   655,  655,  655,  655,  655,  655,   67,   68,  655,  655,
 /*  4440 */   655,  655,   63,  655,   53,  139,  137,   49,   50,   61,
 /*  4450 */   655,   65,   64,   62,   66,   70,   54,  655,  608,  611,
 /*  4460 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4470 */    69,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4480 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4490 */   655,  655,  655,  563,  655,  655,  364,  655,  655,  655,
 /*  4500 */   655,  609,  231,  238,  578,  571,  571,  571,  571,  571,
 /*  4510 */   571,  571,  571,  655,  567,  566,  455,  583,  599,  655,
 /*  4520 */   655,  655,  462,   92,  655,  655,  655,  655,  655,  655,
 /*  4530 */   655,  655,  598,  655,  456,  460,  239,  232,  242,  655,
 /*  4540 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4550 */   655,  655,  655,   67,   68,  655,  655,  655,  569,   63,
 /*  4560 */   655,   53,  139,  137,   49,   50,   61,  655,   65,   64,
 /*  4570 */    62,   66,   70,   54,  655,  608,  611,  655,  454,  655,
 /*  4580 */   655,  655,  655,  655,  655,  655,  655,   69,  655,  723,
 /*  4590 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4600 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4610 */   563,  655,  655,  364,  655,  655,  565,  655,  609,  231,
 /*  4620 */   238,  578,  571,  571,  571,  571,  571,  571,  571,  571,
 /*  4630 */   655,  655,  655,  560,  655,  453,  655,  655,  655,  462,
 /*  4640 */   458,  343,  186,  564,  561,  655,  570,  655,  655,  598,
 /*  4650 */   655,  456,  460,  239,  232,  242,  511,  655,  655,  624,
 /*  4660 */   241,  655,  486,  262,  655,  655,  614,  655,  495,  655,
 /*  4670 */    26,  494,  655,  655,  490,  655,   44,   45,   46,  610,
 /*  4680 */   326,  185,  655,  216,  655,   39,  454,  198,  655,  382,
 /*  4690 */   655,  420,  655,  655,  655,  406,  655,  655,  390,  655,
 /*  4700 */   436,  655,   82,  655,  655,  655,  655,  655,  655,  655,
 /*  4710 */   655,  615,  655,  655,  655,  655,  655,  655,  617,  493,
 /*  4720 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /*  4730 */   655,  655,  596,  655,  655,  655,  655,  655,  655,  655,
 /*  4740 */   655,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /*  4750 */   186,  564,  561,  655,  570,  560,  655,  453,  655,  655,
 /*  4760 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /*  4770 */   655,  655,  655,  655,  655,  655,  655,   88,   89,   94,
 /*  4780 */    99,  597,  655,  655,  655,  655,  655,  655,  547,  655,
 /*  4790 */   655,  624,  241,  655,  486,  262,  569,  655,  655,  655,
 /*  4800 */   495,  655,   26,  494,  655,  655,  490,  655,   44,   45,
 /*  4810 */    46,  610,  326,  185,  655,  216,  454,   39,  655,  198,
 /*  4820 */   655,  382,  655,  420,  655,  655,  655,  406,  655,  655,
 /*  4830 */   390,  655,  436,  655,   82,  655,  655,  655,  655,  655,
 /*  4840 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4850 */   617,  493,  655,  655,  652,  151,  104,  356,  642,  655,
 /*  4860 */   634,  491,  655,  655,  596,  655,  655,  655,  655,  655,
 /*  4870 */   655,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /*  4880 */   186,  564,  561,  655,  570,  655,  655,  560,  655,  453,
 /*  4890 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /*  4900 */   570,  655,  655,  655,  655,  655,  655,  655,  655,   88,
 /*  4910 */    89,   94,   99,  597,  480,  655,  655,  624,  241,  655,
 /*  4920 */   486,  262,  569,  655,  655,  655,  495,  655,   26,  494,
 /*  4930 */   655,  655,  490,  655,   44,   45,   46,  610,  326,  185,
 /*  4940 */   655,  216,  454,   39,  655,  198,  655,  382,  655,  420,
 /*  4950 */   655,  655,  655,  406,  655,  655,  390,  655,  436,  655,
 /*  4960 */    82,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  4970 */   655,  655,  655,  655,  655,  655,  617,  493,  655,  655,
 /*  4980 */   584,  151,  104,  356,  642,  655,  634,  491,  655,  655,
 /*  4990 */   596,  655,  655,  655,  655,  655,  655,  560,  655,  453,
 /*  5000 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /*  5010 */   570,  655,  655,  560,  655,  453,  655,  655,  655,  655,
 /*  5020 */   458,  343,  186,  564,  561,  655,  570,  655,  655,  655,
 /*  5030 */   655,  655,  655,  655,  655,   88,   89,   94,   99,  597,
 /*  5040 */   655,  655,  655,  542,  655,  655,  624,  241,  655,  486,
 /*  5050 */   262,  655,  655,  697,  655,  495,  655,   26,  494,  655,
 /*  5060 */   655,  490,  655,   44,   45,   46,  610,  326,  185,  655,
 /*  5070 */   216,  655,   39,  454,  198,  655,  382,  655,  420,  655,
 /*  5080 */   655,  655,  406,  655,  655,  390,  655,  436,  655,   82,
 /*  5090 */   655,  728,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  5100 */   655,  655,  655,  655,  655,  617,  493,  655,  655,  655,
 /*  5110 */   151,  104,  356,  642,  655,  634,  491,  655,  655,  596,
 /*  5120 */   655,  655,  655,  655,  655,  655,  655,  655,  560,  655,
 /*  5130 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /*  5140 */   655,  570,  560,  655,  453,  655,  655,  655,  655,  458,
 /*  5150 */   343,  186,  564,  561,  655,  570,  655,  655,  655,  655,
 /*  5160 */   655,  655,  655,  655,   88,   89,   94,   99,  597,  247,
 /*  5170 */   655,  655,  624,  241,  655,  486,  262,  569,  655,  655,
 /*  5180 */   655,  495,  655,   26,  494,  655,  655,  490,  655,   44,
 /*  5190 */    45,   46,  610,  326,  185,  655,  216,  454,   39,  655,
 /*  5200 */   198,  655,  382,  655,  420,  655,  655,  655,  406,  655,
 /*  5210 */   655,  390,  655,  436,  655,   82,  655,  655,  655,  655,
 /*  5220 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  5230 */   655,  617,  493,  655,  655,  651,  151,  104,  356,  642,
 /*  5240 */   655,  634,  491,  655,  655,  596,  655,  655,  655,  655,
 /*  5250 */   655,  655,  560,  655,  453,  655,  655,  655,  655,  458,
 /*  5260 */   343,  186,  564,  561,  655,  570,  655,  655,  560,  655,
 /*  5270 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /*  5280 */   655,  570,  655,  655,  655,  655,  655,  117,  119,  124,
 /*  5290 */    88,   89,   94,   99,  597,  567,  566,  455,  583,  599,
 /*  5300 */   655,  655,  655,   59,   92,  106,  111,  125,  102,  116,
 /*  5310 */    98,   55,  122,  121,   56,   57,   58,   51,  105,  126,
 /*  5320 */   110,  107,  109,  112,  114,  103,  655,  153,  655,  655,
 /*  5330 */   655,  655,  655,  655,   67,   68,  655,  655,  655,  655,
 /*  5340 */    63,  655,   53,  139,  137,   49,   50,   61,  655,   65,
 /*  5350 */    64,   62,   66,   70,   54,   22,  608,  611,  655,  655,
 /*  5360 */   655,  655,  689,  655,  655,  655,  655,  655,   69,  655,
 /*  5370 */   655,  655,  365,  655,  655,  655,  655,  655,  655,  655,
 /*  5380 */   655,  655,  454,  655,  655,  655,  655,  655,  655,  655,
 /*  5390 */   655,  563,  655,  655,  364,  655,  655,  655,  655,  609,
 /*  5400 */   231,  238,  578,  571,  571,  571,  571,  571,  571,  571,
 /*  5410 */   571,  585,  567,  566,  455,  583,  599,  655,  655,  655,
 /*  5420 */   462,   92,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  5430 */   598,  454,  456,  460,  239,  232,  242,  560,  688,  453,
 /*  5440 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /*  5450 */   570,   67,   68,  655,  655,  655,  655,   63,  655,   53,
 /*  5460 */   139,  137,   49,   50,   61,  655,   65,   64,   62,   66,
 /*  5470 */    70,   54,  655,  608,  611,  655,  655,  655,  655,  655,
 /*  5480 */   655,  655,  655,  655,  655,   69,  560,  655,  453,  655,
 /*  5490 */   655,  655,  655,  458,  343,  186,  564,  561,  655,  570,
 /*  5500 */   655,  655,  655,  655,  655,  655,  655,  362,  563,  655,
 /*  5510 */   655,  364,  655,  655,  655,  655,  609,  231,  238,  578,
 /*  5520 */   571,  571,  571,  571,  571,  571,  571,  571,  575,  655,
 /*  5530 */   655,  655,  655,  655,  655,  655,  655,  462,  655,  655,
 /*  5540 */   655,  655,  655,  655,  573,  572,  655,  439,  655,  456,
 /*  5550 */   460,  239,  232,  242,  655,  288,  655,  655,  655,  655,
 /*  5560 */   655,  655,  655,  655,  347,  655,  655,  638,  655,  655,
 /*  5570 */   575,  353,  323,  655,  635,  655,  655,  655,  655,  655,
 /*  5580 */   655,  655,  655,  655,  655,  655,  573,  572,  655,  655,
 /*  5590 */   655,  655,  436,  655,  655,  655,  576,  574,  637,  636,
 /*  5600 */   606,  605,  100,  655,  150,  655,  347,  655,  655,  638,
 /*  5610 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /*  5620 */   634,  491,  655,  655,  596,  655,  655,  655,  655,  655,
 /*  5630 */   614,  655,  655,  655,  655,  466,  467,  655,  576,  574,
 /*  5640 */   637,  636,  606,  605,  100,  655,  150,  560,  655,  453,
 /*  5650 */   454,  655,  603,  655,  458,  343,  186,  564,  561,  655,
 /*  5660 */   570,  655,  117,  119,  124,  655,  655,  655,  655,   88,
 /*  5670 */    89,   94,   99,  597,  655,  629,  655,  655,   59,  556,
 /*  5680 */   106,  111,  125,  102,  116,   98,   55,  122,  121,   56,
 /*  5690 */    57,   58,   51,  105,  126,  110,  107,  109,  112,  114,
 /*  5700 */   103,  655,  153,  288,  655,  560,  655,  453,  655,  655,
 /*  5710 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  353,
 /*  5720 */   323,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  5730 */   655,  556,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  5740 */   436,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  5750 */   655,  655,  655,  655,  655,  655,  655,  655,  617,  493,
 /*  5760 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /*  5770 */   655,  655,  596,  288,  655,  655,  655,  655,  655,  655,
 /*  5780 */   655,  655,  655,  437,  467,  655,  655,  655,  655,  353,
 /*  5790 */   323,  655,  655,  655,  655,  560,  655,  453,  655,  655,
 /*  5800 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /*  5810 */   436,  655,  655,  655,  655,  655,  655,   88,   89,   94,
 /*  5820 */    99,  597,  655,  655,  655,  655,  655,  655,  617,  493,
 /*  5830 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /*  5840 */   288,  655,  596,  655,  655,  655,  655,  655,  655,  407,
 /*  5850 */   655,  655,  655,  473,  467,  655,  353,  323,  655,  655,
 /*  5860 */   655,  655,  655,  655,  655,  560,  655,  453,  655,  655,
 /*  5870 */   655,  655,  458,  343,  186,  564,  561,  436,  570,  655,
 /*  5880 */   655,  665,  507,  377,  655,  671,  655,   88,   89,   94,
 /*  5890 */    99,  597,  655,  655,  655,  617,  493,  655,  655,  655,
 /*  5900 */   151,  104,  356,  642,  528,  634,  491,  655,  655,  596,
 /*  5910 */   655,  458,  350,  187,  294,  655,  655,  570,  655,  655,
 /*  5920 */   464,  467,  655,  476,  655,  655,  655,  655,  655,  655,
 /*  5930 */   610,  326,  560,  655,  453,  655,  655,  655,  655,  458,
 /*  5940 */   343,  186,  564,  561,  655,  570,  655,  655,  655,  655,
 /*  5950 */   655,  436,  655,  655,   88,   89,   94,   99,  597,  655,
 /*  5960 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  617,
 /*  5970 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /*  5980 */   491,  655,  655,  596,  288,  655,  655,  655,  655,  655,
 /*  5990 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6000 */   353,  323,  655,  655,  655,  655,  560,  655,  453,  655,
 /*  6010 */   655,  655,  655,  458,  343,  186,  564,  561,  655,  570,
 /*  6020 */   655,  436,  655,  655,  655,  655,  655,  655,   88,   89,
 /*  6030 */    94,   99,  597,  655,  655,  655,  378,  655,  655,  617,
 /*  6040 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /*  6050 */   491,  294,  655,  596,  655,  655,  655,  655,  655,  655,
 /*  6060 */   478,  655,  655,  655,  445,  467,  655,  610,  326,  655,
 /*  6070 */   655,  655,  655,  655,  655,  655,  560,  655,  453,  655,
 /*  6080 */   655,  655,  655,  458,  343,  186,  564,  561,  436,  570,
 /*  6090 */   655,  655,  655,  655,  655,  655,  655,  655,   88,   89,
 /*  6100 */    94,   99,  597,  655,  655,  655,  617,  493,  655,  655,
 /*  6110 */   655,  151,  104,  356,  642,  655,  634,  491,  655,  655,
 /*  6120 */   596,  655,  655,  655,  655,  259,  655,  655,  655,  655,
 /*  6130 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6140 */   655,  610,  326,  560,  655,  453,  655,  655,  655,  655,
 /*  6150 */   458,  343,  186,  564,  561,  655,  570,  655,  655,  655,
 /*  6160 */   655,  655,  436,  655,  655,   88,   89,   94,   99,  597,
 /*  6170 */   655,  655,  655,  378,  655,  655,  655,  655,  655,  655,
 /*  6180 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /*  6190 */   634,  491,  430,  655,  596,  294,  655,  655,  655,  655,
 /*  6200 */   655,  655,  655,  655,  477,  655,  655,  655,  655,  655,
 /*  6210 */   655,  610,  326,  655,  655,  655,  655,  560,  655,  453,
 /*  6220 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /*  6230 */   570,  655,  436,  655,  220,  655,  655,  655,  655,   88,
 /*  6240 */    89,   94,   99,  597,  655,  655,  655,  655,  655,  655,
 /*  6250 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /*  6260 */   634,  491,  655,  655,  596,  655,  655,  288,  655,  655,
 /*  6270 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6280 */   655,  655,  655,  353,  323,  655,  655,  560,  655,  453,
 /*  6290 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /*  6300 */   570,  655,  655,  655,  436,  655,  655,  655,  655,   88,
 /*  6310 */    89,   94,   99,  597,  655,  655,  655,  378,  655,  655,
 /*  6320 */   655,  655,  617,  493,  655,  655,  655,  151,  104,  356,
 /*  6330 */   642,  655,  634,  491,  655,  655,  596,  655,  655,  655,
 /*  6340 */   655,  655,  228,  655,  655,  655,  655,  465,  467,  655,
 /*  6350 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  560,
 /*  6360 */   655,  453,  454,  655,  655,  655,  458,  343,  186,  564,
 /*  6370 */   561,  655,  570,  655,  117,  119,  124,  655,  655,  655,
 /*  6380 */   655,   88,   89,   94,   99,  597,  655,  655,  655,  655,
 /*  6390 */    59,  655,  106,  111,  125,  102,  116,   98,   55,  122,
 /*  6400 */   121,   56,   57,   58,   51,  105,  126,  110,  107,  109,
 /*  6410 */   112,  114,  103,  655,  153,  655,  655,  560,  655,  453,
 /*  6420 */   655,  655,  655,  575,  458,  343,  186,  564,  561,  461,
 /*  6430 */   570,  655,  655,  655,  655,  655,  655,  655,  655,  573,
 /*  6440 */   572,  655,  582,  655,  655,  655,  655,  655,  655,  454,
 /*  6450 */   117,  119,  124,  655,  655,  655,  655,  655,  655,  347,
 /*  6460 */   655,  655,  638,  655,  655,  655,   59,  655,  106,  111,
 /*  6470 */   125,  102,  116,   98,   55,  122,  121,   56,   57,   58,
 /*  6480 */    51,  105,  126,  110,  107,  109,  112,  114,  103,  655,
 /*  6490 */   153,  576,  574,  637,  636,  606,  605,  100,  655,  150,
 /*  6500 */   471,  655,  601,  655,  560,  655,  453,  655,  655,  655,
 /*  6510 */   655,  458,  343,  186,  564,  561,  655,  570,  655,  725,
 /*  6520 */   454,  655,  655,  655,  655,  655,  655,  117,  119,  124,
 /*  6530 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6540 */   655,  655,  655,   59,  655,  106,  111,  125,  102,  116,
 /*  6550 */    98,   55,  122,  121,   56,   57,   58,   51,  105,  126,
 /*  6560 */   110,  107,  109,  112,  114,  103,  655,  153,  655,  655,
 /*  6570 */   655,  655,  655,  586,  655,  560,  655,  453,  655,  655,
 /*  6580 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /*  6590 */   655,  655,  655,  454,  655,   24,  655,  655,  655,  655,
 /*  6600 */   655,  655,  655,  117,  119,  124,  655,  655,  655,  655,
 /*  6610 */   655,  655,  655,  655,  655,  655,  655,  655,  655,   59,
 /*  6620 */   655,  106,  111,  125,  102,  116,   98,   55,  122,  121,
 /*  6630 */    56,   57,   58,   51,  105,  126,  110,  107,  109,  112,
 /*  6640 */   114,  103,  655,  153,  117,  119,  124,  655,  560,  655,
 /*  6650 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /*  6660 */    59,  570,  106,  111,  125,  102,  116,   98,   55,  122,
 /*  6670 */   121,   56,   57,   58,   51,  105,  126,  110,  107,  109,
 /*  6680 */   112,  114,  103,  655,  153,  655,  703,  655,  655,  655,
 /*  6690 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6700 */   655,  655,  655,  655,  655,  655,  454,  655,  655,  655,
 /*  6710 */   655,  655,   20,  655,  655,  655,  655,  655,  655,  655,
 /*  6720 */   117,  119,  124,  655,  655,  655,  435,  655,  655,  655,
 /*  6730 */   655,  655,  655,  655,  655,  655,   59,  655,  106,  111,
 /*  6740 */   125,  102,  116,   98,   55,  122,  121,   56,   57,   58,
 /*  6750 */    51,  105,  126,  110,  107,  109,  112,  114,  103,  655,
 /*  6760 */   153,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /*  6770 */   186,  564,  561,  655,  570,  655,  655,  655,  655,  655,
 /*  6780 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6790 */   655,  710,  655,  655,  655,  655,  655,  655,  655,  117,
 /*  6800 */   119,  124,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6810 */   655,  655,  655,  655,  655,   59,  655,  106,  111,  125,
 /*  6820 */   102,  116,   98,   55,  122,  121,   56,   57,   58,   51,
 /*  6830 */   105,  126,  110,  107,  109,  112,  114,  103,  655,  153,
 /*  6840 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6850 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6860 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6870 */   562,  655,  655,  655,  655,  655,  655,  655,  117,  119,
 /*  6880 */   124,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6890 */   655,  655,  655,  655,   59,  655,  106,  111,  125,  102,
 /*  6900 */   116,   98,   55,  122,  121,   56,   57,   58,   51,  105,
 /*  6910 */   126,  110,  107,  109,  112,  114,  103,  655,  153,  117,
 /*  6920 */   119,  124,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6930 */   655,  655,  655,  655,  655,   59,  655,  106,  111,  125,
 /*  6940 */   102,  116,   98,   55,  122,  121,   56,   57,   58,   51,
 /*  6950 */   105,  126,  110,  107,  109,  112,  114,  103,  655,  153,
 /*  6960 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6970 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  6980 */   655,  655,  655,  655,  655,  655,  655,   23,   41,  655,
 /*  6990 */   655,  655,  655,  655,  655,  117,  119,  124,  655,  655,
 /*  7000 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7010 */   655,   59,  655,  106,  111,  125,  102,  116,   98,   55,
 /*  7020 */   122,  121,   56,   57,   58,   51,  105,  126,  110,  107,
 /*  7030 */   109,  112,  114,  103,  655,  153,  655,  655,  655,  655,
 /*  7040 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7050 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7060 */   655,  655,  655,  655,  662,  655,  655,  655,  655,  655,
 /*  7070 */   655,  655,  117,  119,  124,  655,  655,  655,  655,  655,
 /*  7080 */   655,  655,  655,  655,  655,  655,  655,  655,   59,  655,
 /*  7090 */   106,  111,  125,  102,  116,   98,   55,  122,  121,   56,
 /*  7100 */    57,   58,   51,  105,  126,  110,  107,  109,  112,  114,
 /*  7110 */   103,  655,  153,  655,  655,  655,  655,  655,  655,  655,
 /*  7120 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7130 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7140 */   655,  655,  655,  716,  655,  655,  655,  655,  655,  655,
 /*  7150 */   655,  117,  119,  124,  655,  655,  655,  655,  655,  655,
 /*  7160 */   655,  655,  655,  655,  655,  655,  655,   59,  655,  106,
 /*  7170 */   111,  125,  102,  116,   98,   55,  122,  121,   56,   57,
 /*  7180 */    58,   51,  105,  126,  110,  107,  109,  112,  114,  103,
 /*  7190 */   655,  153,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7200 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7210 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  643,
 /*  7220 */   655,  655,  655,  655,  655,  655,  655,  117,  119,  124,
 /*  7230 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7240 */   655,  655,  655,   59,  655,  106,  111,  125,  102,  116,
 /*  7250 */    98,   55,  122,  121,   56,   57,   58,   51,  105,  126,
 /*  7260 */   110,  107,  109,  112,  114,  103,  655,  153,  655,  655,
 /*  7270 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7280 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7290 */   655,  655,  655,  655,  655,  655,  655,  655,  579,  655,
 /*  7300 */   655,  655,  655,  655,  655,  655,  117,  119,  124,  655,
 /*  7310 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7320 */   655,  655,   59,  655,  106,  111,  125,  102,  116,   98,
 /*  7330 */    55,  122,  121,   56,   57,   58,   51,  105,  126,  110,
 /*  7340 */   107,  109,  112,  114,  103,  655,  153,  655,  655,  655,
 /*  7350 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7360 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7370 */   655,  655,  655,  655,  655,  655,  655,  713,  655,  655,
 /*  7380 */   655,  655,  655,  655,  655,  117,  119,  124,  655,  655,
 /*  7390 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7400 */   655,   59,  655,  106,  111,  125,  102,  116,   98,   55,
 /*  7410 */   122,  121,   56,   57,   58,   51,  105,  126,  110,  107,
 /*  7420 */   109,  112,  114,  103,  655,  153,  655,  655,  655,  655,
 /*  7430 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7440 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7450 */   655,  655,  655,  204,  655,  655,  655,  655,  655,  655,
 /*  7460 */   655,  117,  119,  124,  655,  655,  655,  655,  655,  655,
 /*  7470 */   655,  655,  655,  655,  655,  655,  655,   59,  655,  106,
 /*  7480 */   111,  125,  102,  116,   98,   55,  122,  121,   56,   57,
 /*  7490 */    58,   51,  105,  126,  110,  107,  109,  112,  114,  103,
 /*  7500 */   655,  153,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7510 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7520 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  482,
 /*  7530 */   655,  655,  655,  655,  655,  655,  655,  117,  119,  124,
 /*  7540 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7550 */   655,  655,  655,   59,  655,  106,  111,  125,  102,  116,
 /*  7560 */    98,   55,  122,  121,   56,   57,   58,   51,  105,  126,
 /*  7570 */   110,  107,  109,  112,  114,  103,  655,  153,  655,  655,
 /*  7580 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7590 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7600 */   655,  655,  655,  655,  655,  655,  740,  655,  655,  655,
 /*  7610 */   655,  655,  655,  655,  117,  119,  124,  655,  655,  655,
 /*  7620 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7630 */    59,   60,  106,  111,  125,  102,  116,   98,   55,  122,
 /*  7640 */   121,   56,   57,   58,   51,  105,  126,  110,  107,  109,
 /*  7650 */   112,  114,  103,  655,  153,  117,  119,  124,  655,  655,
 /*  7660 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7670 */   655,   59,  655,  106,  111,  125,  102,  116,   98,   55,
 /*  7680 */   122,  121,   56,   57,   58,   51,  105,  126,  110,  107,
 /*  7690 */   109,  112,  114,  103,  655,  153,  117,  119,  124,  655,
 /*  7700 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7710 */   655,  655,   59,  655,  106,  111,  125,  102,  116,   98,
 /*  7720 */    55,  122,  121,   56,   57,   58,   51,  105,  126,  110,
 /*  7730 */   107,  109,  112,  114,  103,  655,  153,  655,  655,  655,
 /*  7740 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7750 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7760 */   655,  655,  655,  655,  655,   48,  655,  698,  655,  655,
 /*  7770 */   655,  655,  655,  117,  119,  124,  655,  655,  655,  655,
 /*  7780 */   655,  655,  655,  655,  655,  655,  655,  655,  655,   59,
 /*  7790 */   655,  106,  111,  125,  102,  116,   98,   55,  122,  121,
 /*  7800 */    56,   57,   58,   51,  105,  126,  110,  107,  109,  112,
 /*  7810 */   114,  103,  655,  153,  655,  655,  655,  655,  655,  655,
 /*  7820 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7830 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7840 */   655,  422,  655,  655,  655,  655,  655,  655,  655,  117,
 /*  7850 */   119,  124,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7860 */   655,  655,  655,  655,  655,   59,  655,  106,  111,  125,
 /*  7870 */   102,  116,   98,   55,  122,  121,   56,   57,   58,   51,
 /*  7880 */   105,  126,  110,  107,  109,  112,  114,  103,  655,  153,
 /*  7890 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7900 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7910 */   655,  655,  655,  655,  655,  655,  655,  655,  676,  655,
 /*  7920 */   655,  655,  655,  655,  655,  655,  117,  119,  124,  655,
 /*  7930 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7940 */   655,  655,   59,  655,  106,  111,  125,  102,  116,   98,
 /*  7950 */    55,  122,  121,   56,   57,   58,   51,  105,  126,  110,
 /*  7960 */   107,  109,  112,  114,  103,  291,  153,  655,  655,  655,
 /*  7970 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  7980 */   655,  610,  326,  655,  655,  655,  655,  655,  346,  655,
 /*  7990 */   655,  655,  655,  655,  631,  655,  655,  655,  655,  655,
 /*  8000 */   655,  655,  436,  655,  655,  655,  655,  655,  655,  655,
 /*  8010 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8020 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /*  8030 */   634,  491,  289,  655,  596,  655,  655,  655,  655,  655,
 /*  8040 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /*  8050 */   655,  655,  655,  655,  655,  655,  655,  560,  655,  453,
 /*  8060 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  436,
 /*  8070 */   570,  655,  655,  655,  655,  655,  655,  655,  655,   88,
 /*  8080 */    89,   94,   99,  597,  655,  655,  655,  617,  493,  655,
 /*  8090 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  655,
 /*  8100 */   655,  596,  289,  655,  655,  655,  655,  655,  655,  655,
 /*  8110 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /*  8120 */   655,  655,  655,  655,  560,  655,  453,  655,  655,  655,
 /*  8130 */   655,  458,  343,  186,  564,  561,  449,  570,  655,  436,
 /*  8140 */   655,  655,  655,  655,  655,  655,   88,   89,   94,   99,
 /*  8150 */   597,  655,  655,  655,  655,  655,  655,  617,  493,  655,
 /*  8160 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  655,
 /*  8170 */   655,  596,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8180 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8190 */   655,  655,  655,  569,  560,  655,  453,  655,  655,  655,
 /*  8200 */   655,  458,  343,  186,  564,  561,  444,  570,  655,  117,
 /*  8210 */   119,  124,  655,  454,  655,  655,   88,   89,   94,   99,
 /*  8220 */   597,  655,  655,  655,  655,   59,  655,  106,  111,  125,
 /*  8230 */   102,  116,   98,   55,  122,  121,   56,   57,   58,   51,
 /*  8240 */   105,  126,  110,  107,  109,  112,  114,  103,  276,  153,
 /*  8250 */   655,  590,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8260 */   655,  655,  655,  655,  610,  326,  655,  655,  560,  655,
 /*  8270 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /*  8280 */   655,  570,  655,  655,  655,  436,  655,  655,  655,  655,
 /*  8290 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8300 */   655,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /*  8310 */   356,  642,  655,  634,  491,  655,  655,  596,  271,  655,
 /*  8320 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8330 */   655,  655,  655,  655,  610,  326,  655,  655,  655,  655,
 /*  8340 */   560,  655,  453,  655,  655,  655,  655,  458,  343,  186,
 /*  8350 */   564,  561,  655,  570,  655,  436,  655,  655,  655,  655,
 /*  8360 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /*  8370 */   655,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /*  8380 */   356,  642,  655,  634,  491,  312,  655,  596,  655,  655,
 /*  8390 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8400 */   655,  610,  326,  655,  655,  655,  655,  655,  655,  655,
 /*  8410 */   560,  655,  453,  655,  655,  655,  655,  458,  343,  186,
 /*  8420 */   564,  561,  436,  570,  655,  655,  655,  655,  655,  655,
 /*  8430 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /*  8440 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /*  8450 */   634,  491,  655,  655,  596,  655,  655,  655,  655,  320,
 /*  8460 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8470 */   655,  655,  655,  655,  655,  610,  326,  560,  655,  453,
 /*  8480 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /*  8490 */   570,  655,  655,  655,  655,  655,  436,  655,  655,   88,
 /*  8500 */    89,   94,   99,  597,  655,  655,  655,  655,  655,  655,
 /*  8510 */   655,  655,  655,  655,  617,  493,  655,  655,  655,  151,
 /*  8520 */   104,  356,  642,  655,  634,  491,  655,  655,  596,  649,
 /*  8530 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8540 */   655,  655,  655,  655,  655,  610,  326,  655,  655,  655,
 /*  8550 */   655,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /*  8560 */   186,  564,  561,  655,  570,  655,  436,  655,  655,  655,
 /*  8570 */   655,  655,  655,   88,   89,   94,   99,  597,  655,  655,
 /*  8580 */   655,  655,  655,  655,  617,  493,  655,  655,  655,  151,
 /*  8590 */   104,  356,  642,  655,  634,  491,  641,  655,  596,  655,
 /*  8600 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8610 */   655,  655,  610,  326,  655,  655,  655,  655,  655,  655,
 /*  8620 */   655,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /*  8630 */   186,  564,  561,  436,  570,  655,  655,  655,  655,  655,
 /*  8640 */   655,  655,  655,   88,   89,   94,   99,  597,  655,  655,
 /*  8650 */   655,  617,  493,  655,  655,  655,  151,  104,  356,  642,
 /*  8660 */   655,  634,  491,  655,  655,  596,  655,  655,  655,  655,
 /*  8670 */   279,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8680 */   655,  655,  655,  655,  655,  655,  610,  326,  560,  655,
 /*  8690 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /*  8700 */   655,  570,  655,  655,  655,  655,  655,  436,  655,  655,
 /*  8710 */    88,   89,   94,   99,  597,  655,  655,  655,  655,  655,
 /*  8720 */   655,  655,  655,  655,  655,  617,  493,  655,  655,  655,
 /*  8730 */   151,  104,  356,  642,  655,  634,  491,  655,  655,  596,
 /*  8740 */   640,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8750 */   655,  655,  655,  655,  655,  655,  610,  326,  655,  655,
 /*  8760 */   655,  655,  560,  655,  453,  655,  655,  655,  655,  458,
 /*  8770 */   343,  186,  564,  561,  655,  570,  655,  436,  655,  655,
 /*  8780 */   655,  655,  655,  655,   88,   89,   94,   99,  597,  655,
 /*  8790 */   655,  655,  655,  655,  655,  617,  493,  655,  655,  655,
 /*  8800 */   151,  104,  356,  642,  655,  634,  491,  321,  655,  596,
 /*  8810 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8820 */   655,  655,  655,  610,  326,  655,  655,  655,  655,  655,
 /*  8830 */   655,  655,  560,  655,  453,  655,  655,  655,  655,  458,
 /*  8840 */   343,  186,  564,  561,  436,  570,  655,  655,  655,  655,
 /*  8850 */   655,  655,  655,  655,   88,   89,   94,   99,  597,  655,
 /*  8860 */   655,  655,  617,  493,  655,  655,  655,  151,  104,  356,
 /*  8870 */   642,  655,  634,  491,  655,  655,  596,  655,  655,  655,
 /*  8880 */   655,  408,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8890 */   655,  655,  655,  655,  655,  655,  655,  610,  326,  560,
 /*  8900 */   655,  453,  655,  655,  655,  655,  458,  343,  186,  564,
 /*  8910 */   561,  655,  570,  655,  655,  655,  655,  655,  436,  655,
 /*  8920 */   655,   88,   89,   94,   99,  597,  655,  655,  655,  655,
 /*  8930 */   655,  655,  655,  655,  655,  655,  617,  493,  655,  655,
 /*  8940 */   655,  151,  104,  356,  642,  655,  634,  491,  655,  655,
 /*  8950 */   596,  650,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  8960 */   655,  655,  655,  655,  655,  655,  655,  610,  326,  655,
 /*  8970 */   655,  655,  655,  560,  655,  453,  655,  655,  655,  655,
 /*  8980 */   458,  343,  186,  564,  561,  655,  570,  655,  436,  655,
 /*  8990 */   655,  655,  655,  655,  655,   88,   89,   94,   99,  597,
 /*  9000 */   655,  655,  655,  655,  655,  655,  617,  493,  655,  655,
 /*  9010 */   655,  151,  104,  356,  642,  655,  634,  491,  315,  655,
 /*  9020 */   596,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  9030 */   655,  655,  655,  655,  610,  326,  655,  655,  655,  655,
 /*  9040 */   655,  655,  655,  560,  655,  453,  655,  655,  655,  655,
 /*  9050 */   458,  343,  186,  564,  561,  436,  570,  655,  655,  655,
 /*  9060 */   655,  655,  655,  655,  655,   88,   89,   94,   99,  597,
 /*  9070 */   655,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /*  9080 */   356,  642,  655,  634,  491,  655,  655,  596,  655,  655,
 /*  9090 */   655,  655,  301,  655,  655,  655,  655,  655,  655,  655,
 /*  9100 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /*  9110 */   560,  655,  453,  655,  655,  655,  655,  458,  343,  186,
 /*  9120 */   564,  561,  655,  570,  655,  655,  655,  655,  655,  436,
 /*  9130 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /*  9140 */   655,  655,  655,  655,  655,  655,  655,  617,  493,  655,
 /*  9150 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  655,
 /*  9160 */   655,  596,  648,  655,  655,  655,  655,  655,  655,  655,
 /*  9170 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /*  9180 */   655,  655,  655,  655,  560,  655,  453,  655,  655,  655,
 /*  9190 */   655,  458,  343,  186,  564,  561,  655,  570,  655,  436,
 /*  9200 */   655,  655,  655,  655,  655,  655,   88,   89,   94,   99,
 /*  9210 */   597,  655,  655,  655,  655,  655,  655,  617,  493,  655,
 /*  9220 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  278,
 /*  9230 */   655,  596,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  9240 */   655,  655,  655,  655,  655,  610,  326,  655,  655,  655,
 /*  9250 */   655,  655,  655,  655,  560,  655,  453,  655,  655,  655,
 /*  9260 */   655,  458,  343,  186,  564,  561,  436,  570,  655,  655,
 /*  9270 */   655,  655,  655,  655,  655,  655,   88,   89,   94,   99,
 /*  9280 */   597,  655,  655,  655,  617,  493,  655,  655,  655,  151,
 /*  9290 */   104,  356,  642,  655,  634,  491,  655,  655,  596,  655,
 /*  9300 */   655,  655,  655,  268,  655,  655,  655,  655,  655,  655,
 /*  9310 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  610,
 /*  9320 */   326,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /*  9330 */   186,  564,  561,  655,  570,  655,  655,  655,  655,  655,
 /*  9340 */   436,  655,  655,   88,   89,   94,   99,  597,  655,  655,
 /*  9350 */   655,  655,  655,  655,  655,  655,  655,  655,  617,  493,
 /*  9360 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /*  9370 */   655,  655,  596,  329,  655,  655,  655,  655,  655,  655,
 /*  9380 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  610,
 /*  9390 */   326,  655,  655,  655,  655,  560,  655,  453,  655,  655,
 /*  9400 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /*  9410 */   436,  655,  655,  655,  655,  655,  655,   88,   89,   94,
 /*  9420 */    99,  597,  655,  655,  655,  655,  655,  655,  617,  493,
 /*  9430 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /*  9440 */   647,  655,  596,  655,  655,  655,  655,  655,  655,  655,
 /*  9450 */   655,  655,  655,  655,  655,  655,  610,  326,  655,  655,
 /*  9460 */   655,  655,  655,  655,  655,  560,  655,  453,  655,  655,
 /*  9470 */   655,  655,  458,  343,  186,  564,  561,  436,  570,  655,
 /*  9480 */   655,  655,  655,  655,  655,  655,  655,   88,   89,   94,
 /*  9490 */    99,  597,  655,  655,  655,  617,  493,  655,  655,  655,
 /*  9500 */   151,  104,  356,  642,  655,  634,  491,  655,  655,  596,
 /*  9510 */   655,  655,  655,  655,  646,  655,  655,  655,  655,  655,
 /*  9520 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  9530 */   610,  326,  560,  655,  453,  655,  655,  655,  655,  458,
 /*  9540 */   343,  186,  564,  561,  655,  570,  655,  655,  655,  655,
 /*  9550 */   655,  436,  655,  655,   88,   89,   94,   99,  597,  655,
 /*  9560 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  617,
 /*  9570 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /*  9580 */   491,  655,  655,  596,  644,  655,  655,  655,  655,  655,
 /*  9590 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  9600 */   610,  326,  655,  655,  655,  655,  560,  655,  453,  655,
 /*  9610 */   655,  655,  655,  458,  343,  186,  564,  561,  655,  570,
 /*  9620 */   655,  436,  655,  655,  655,  655,  655,  655,   88,   89,
 /*  9630 */    94,   99,  597,  655,  655,  655,  655,  655,  655,  617,
 /*  9640 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /*  9650 */   491,  630,  655,  596,  655,  655,  655,  655,  655,  655,
 /*  9660 */   655,  655,  655,  655,  655,  655,  655,  610,  326,  655,
 /*  9670 */   655,  655,  655,  655,  655,  655,  560,  655,  453,  655,
 /*  9680 */   655,  655,  655,  458,  343,  186,  564,  561,  436,  570,
 /*  9690 */   655,  655,  655,  655,  655,  655,  655,  655,   88,   89,
 /*  9700 */    94,   99,  597,  655,  655,  655,  617,  493,  655,  655,
 /*  9710 */   655,  151,  104,  356,  642,  655,  634,  491,  655,  655,
 /*  9720 */   596,  655,  655,  655,  655,  328,  655,  655,  655,  655,
 /*  9730 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  9740 */   655,  610,  326,  560,  655,  453,  655,  655,  655,  655,
 /*  9750 */   458,  343,  186,  564,  561,  655,  570,  655,  655,  655,
 /*  9760 */   655,  655,  436,  655,  655,   88,   89,   94,   99,  597,
 /*  9770 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  9780 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /*  9790 */   634,  491,  655,  655,  596,  327,  655,  655,  655,  655,
 /*  9800 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  9810 */   655,  610,  326,  655,  655,  655,  655,  560,  655,  453,
 /*  9820 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /*  9830 */   570,  655,  436,  655,  655,  655,  655,  655,  655,   88,
 /*  9840 */    89,   94,   99,  597,  655,  655,  655,  655,  655,  655,
 /*  9850 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /*  9860 */   634,  491,  330,  655,  596,  655,  655,  655,  655,  655,
 /*  9870 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /*  9880 */   655,  655,  655,  655,  655,  655,  655,  560,  655,  453,
 /*  9890 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  436,
 /*  9900 */   570,  655,  655,  655,  655,  655,  655,  655,  655,   88,
 /*  9910 */    89,   94,   99,  597,  655,  655,  655,  617,  493,  655,
 /*  9920 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  655,
 /*  9930 */   655,  596,  655,  655,  655,  655,  317,  655,  655,  655,
 /*  9940 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  9950 */   655,  655,  610,  326,  560,  655,  453,  655,  655,  655,
 /*  9960 */   655,  458,  343,  186,  564,  561,  655,  570,  655,  655,
 /*  9970 */   655,  655,  655,  436,  655,  655,   88,   89,   94,   99,
 /*  9980 */   597,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /*  9990 */   655,  617,  493,  655,  655,  655,  151,  104,  356,  642,
 /* 10000 */   655,  634,  491,  655,  655,  596,  282,  655,  655,  655,
 /* 10010 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10020 */   655,  655,  610,  326,  655,  655,  655,  655,  560,  655,
 /* 10030 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /* 10040 */   655,  570,  655,  436,  655,  655,  655,  655,  655,  655,
 /* 10050 */    88,   89,   94,   99,  597,  655,  655,  655,  655,  655,
 /* 10060 */   655,  617,  493,  655,  655,  655,  151,  104,  356,  642,
 /* 10070 */   655,  634,  491,  270,  655,  596,  655,  655,  655,  655,
 /* 10080 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  610,
 /* 10090 */   326,  655,  655,  655,  655,  655,  655,  655,  560,  655,
 /* 10100 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /* 10110 */   436,  570,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10120 */    88,   89,   94,   99,  597,  655,  655,  655,  617,  493,
 /* 10130 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /* 10140 */   655,  655,  596,  655,  655,  655,  655,  288,  655,  655,
 /* 10150 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10160 */   655,  655,  655,  354,  322,  560,  655,  453,  655,  655,
 /* 10170 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /* 10180 */   655,  655,  655,  655,  436,  655,  655,   88,   89,   94,
 /* 10190 */    99,  597,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10200 */   655,  655,  617,  493,  655,  655,  655,  151,  104,  356,
 /* 10210 */   642,  655,  634,  491,  655,  655,  596,  296,  655,  655,
 /* 10220 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10230 */   655,  655,  655,  610,  326,  655,  655,  655,  655,  560,
 /* 10240 */   655,  453,  655,  655,  655,  655,  458,  343,  186,  564,
 /* 10250 */   561,  655,  570,  655,  436,  655,  655,  655,  655,  655,
 /* 10260 */   655,   88,   89,   94,   99,  597,  655,  655,  655,  655,
 /* 10270 */   655,  655,  617,  493,  655,  655,  655,  151,  104,  356,
 /* 10280 */   642,  655,  634,  491,  283,  655,  596,  655,  655,  655,
 /* 10290 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10300 */   610,  326,  655,  655,  655,  655,  655,  655,  655,  560,
 /* 10310 */   655,  453,  655,  655,  655,  655,  458,  343,  186,  564,
 /* 10320 */   561,  436,  570,  655,  655,  655,  655,  655,  655,  655,
 /* 10330 */   655,   88,   89,   94,   99,  597,  655,  655,  655,  617,
 /* 10340 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /* 10350 */   491,  655,  655,  596,  655,  655,  655,  655,  277,  655,
 /* 10360 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10370 */   655,  655,  655,  655,  610,  326,  560,  655,  453,  655,
 /* 10380 */   655,  655,  655,  458,  343,  186,  564,  561,  655,  570,
 /* 10390 */   655,  655,  655,  655,  655,  436,  655,  655,   88,   89,
 /* 10400 */    94,   99,  597,  655,  655,  655,  655,  655,  655,  655,
 /* 10410 */   655,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /* 10420 */   356,  642,  655,  634,  491,  655,  655,  596,  288,  655,
 /* 10430 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10440 */   655,  655,  655,  655,  487,  325,  655,  655,  655,  655,
 /* 10450 */   560,  655,  453,  655,  655,  655,  655,  458,  343,  186,
 /* 10460 */   564,  561,  655,  570,  655,  436,  655,  655,  655,  655,
 /* 10470 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /* 10480 */   655,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /* 10490 */   356,  642,  655,  634,  491,  280,  655,  596,  655,  655,
 /* 10500 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10510 */   655,  610,  326,  655,  655,  655,  655,  655,  655,  655,
 /* 10520 */   560,  655,  453,  655,  655,  655,  655,  458,  343,  186,
 /* 10530 */   564,  561,  436,  570,  655,  655,  655,  655,  655,  655,
 /* 10540 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /* 10550 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /* 10560 */   634,  491,  655,  655,  596,  655,  655,  655,  655,  274,
 /* 10570 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10580 */   655,  655,  655,  655,  655,  610,  326,  560,  655,  453,
 /* 10590 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /* 10600 */   570,  655,  655,  655,  655,  655,  436,  655,  655,   88,
 /* 10610 */    89,   94,   99,  597,  655,  655,  655,  655,  655,  655,
 /* 10620 */   655,  655,  655,  655,  617,  493,  655,  655,  655,  151,
 /* 10630 */   104,  356,  642,  655,  634,  491,  655,  655,  596,  300,
 /* 10640 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10650 */   655,  655,  655,  655,  655,  610,  326,  655,  655,  655,
 /* 10660 */   655,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /* 10670 */   186,  564,  561,  655,  570,  655,  436,  655,  655,  655,
 /* 10680 */   655,  655,  655,   88,   89,   94,   99,  597,  655,  655,
 /* 10690 */   655,  655,  655,  655,  617,  493,  655,  655,  655,  151,
 /* 10700 */   104,  356,  642,  655,  634,  491,  331,  655,  596,  655,
 /* 10710 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10720 */   655,  655,  610,  326,  655,  655,  655,  655,  655,  655,
 /* 10730 */   655,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /* 10740 */   186,  564,  561,  436,  570,  655,  655,  655,  655,  655,
 /* 10750 */   655,  655,  655,   88,   89,   94,   99,  597,  655,  655,
 /* 10760 */   655,  617,  493,  655,  655,  655,  151,  104,  356,  642,
 /* 10770 */   655,  634,  491,  655,  655,  596,  655,  655,  655,  655,
 /* 10780 */   287,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10790 */   655,  655,  655,  655,  655,  655,  610,  326,  560,  655,
 /* 10800 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /* 10810 */   655,  570,  655,  655,  655,  655,  655,  436,  655,  655,
 /* 10820 */    88,   89,   94,   99,  597,  655,  655,  655,  655,  655,
 /* 10830 */   655,  655,  655,  655,  655,  617,  493,  655,  655,  655,
 /* 10840 */   151,  104,  356,  642,  655,  634,  491,  655,  655,  596,
 /* 10850 */   316,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10860 */   655,  655,  655,  655,  655,  655,  610,  326,  655,  655,
 /* 10870 */   655,  655,  560,  655,  453,  655,  655,  655,  655,  458,
 /* 10880 */   343,  186,  564,  561,  655,  570,  655,  436,  655,  655,
 /* 10890 */   655,  655,  655,  655,   88,   89,   94,   99,  597,  655,
 /* 10900 */   655,  655,  655,  655,  655,  617,  493,  655,  655,  655,
 /* 10910 */   151,  104,  356,  642,  655,  634,  491,  419,  655,  596,
 /* 10920 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 10930 */   655,  655,  655,  610,  326,  655,  655,  655,  655,  655,
 /* 10940 */   655,  655,  560,  655,  453,  655,  655,  655,  655,  458,
 /* 10950 */   343,  186,  564,  561,  436,  570,  655,  655,  655,  655,
 /* 10960 */   655,  655,  655,  655,   88,   89,   94,   99,  597,  655,
 /* 10970 */   655,  655,  617,  493,  655,  655,  655,  151,  104,  356,
 /* 10980 */   642,  655,  634,  491,  655,  655,  596,  655,  655,  655,
 /* 10990 */   655,  275,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 11000 */   655,  655,  655,  655,  655,  655,  655,  610,  326,  560,
 /* 11010 */   655,  453,  655,  655,  655,  655,  458,  343,  186,  564,
 /* 11020 */   561,  655,  570,  655,  655,  655,  655,  655,  436,  655,
 /* 11030 */   655,   88,   89,   94,   99,  597,  655,  655,  655,  655,
 /* 11040 */   655,  655,  655,  655,  655,  655,  617,  493,  655,  655,
 /* 11050 */   655,  151,  104,  356,  642,  655,  634,  491,  655,  655,
 /* 11060 */   596,  292,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 11070 */   655,  655,  655,  655,  655,  655,  655,  610,  326,  655,
 /* 11080 */   655,  655,  655,  560,  655,  453,  655,  655,  655,  655,
 /* 11090 */   458,  343,  186,  564,  561,  655,  570,  655,  436,  655,
 /* 11100 */   655,  655,  655,  655,  655,   88,   89,   94,   99,  597,
 /* 11110 */   655,  655,  655,  655,  655,  655,  617,  493,  655,  655,
 /* 11120 */   655,  151,  104,  356,  642,  655,  634,  491,  281,  655,
 /* 11130 */   596,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 11140 */   655,  655,  655,  655,  610,  326,  655,  655,  655,  655,
 /* 11150 */   655,  655,  655,  560,  655,  453,  655,  655,  655,  655,
 /* 11160 */   458,  343,  186,  564,  561,  436,  570,  655,  655,  655,
 /* 11170 */   655,  655,  655,  655,  655,   88,   89,   94,   99,  597,
 /* 11180 */   655,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /* 11190 */   356,  642,  655,  634,  491,  655,  655,  596,  655,  655,
 /* 11200 */   655,  655,  308,  655,  655,  655,  655,  655,  655,  655,
 /* 11210 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /* 11220 */   560,  655,  453,  655,  655,  655,  655,  458,  343,  186,
 /* 11230 */   564,  561,  655,  570,  655,  655,  655,  655,  655,  436,
 /* 11240 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /* 11250 */   655,  655,  655,  655,  655,  655,  655,  617,  493,  655,
 /* 11260 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  655,
 /* 11270 */   655,  596,  293,  655,  655,  655,  655,  655,  655,  655,
 /* 11280 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /* 11290 */   655,  655,  655,  655,  560,  655,  453,  655,  655,  655,
 /* 11300 */   655,  458,  343,  186,  564,  561,  655,  570,  655,  436,
 /* 11310 */   655,  655,  655,  655,  655,  655,   88,   89,   94,   99,
 /* 11320 */   597,  655,  655,  655,  655,  655,  655,  617,  493,  655,
 /* 11330 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  305,
 /* 11340 */   655,  596,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 11350 */   655,  655,  655,  655,  655,  610,  326,  655,  655,  655,
 /* 11360 */   655,  655,  655,  655,  560,  655,  453,  655,  655,  655,
 /* 11370 */   655,  458,  343,  186,  564,  561,  436,  570,  655,  655,
 /* 11380 */   655,  655,  655,  655,  655,  655,   88,   89,   94,   99,
 /* 11390 */   597,  655,  655,  655,  617,  493,  655,  655,  655,  151,
 /* 11400 */   104,  356,  642,  655,  634,  491,  655,  655,  596,  655,
 /* 11410 */   655,  655,  655,  267,  655,  655,  655,  655,  655,  655,
 /* 11420 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  610,
 /* 11430 */   326,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /* 11440 */   186,  564,  561,  655,  570,  655,  655,  655,  655,  655,
 /* 11450 */   436,  655,  655,   88,   89,   94,   99,  597,  655,  655,
 /* 11460 */   655,  655,  655,  655,  655,  655,  655,  655,  617,  493,
 /* 11470 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /* 11480 */   655,  655,  596,  191,  655,  655,  655,  655,  655,  655,
 /* 11490 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  610,
 /* 11500 */   326,  655,  655,  655,  655,  560,  655,  453,  655,  655,
 /* 11510 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /* 11520 */   436,  655,  655,  655,  655,  655,  655,   88,   89,   94,
 /* 11530 */    99,  597,  655,  655,  655,  655,  655,  655,  617,  493,
 /* 11540 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /* 11550 */   288,  655,  596,  655,  655,  655,  655,  655,  655,  655,
 /* 11560 */   655,  655,  655,  655,  655,  655,  432,  324,  655,  655,
 /* 11570 */   655,  655,  655,  655,  655,  560,  655,  453,  655,  655,
 /* 11580 */   655,  655,  458,  343,  186,  564,  561,  436,  570,  655,
 /* 11590 */   655,  655,  655,  655,  655,  655,  655,   88,   89,   94,
 /* 11600 */    99,  597,  655,  655,  655,  617,  493,  655,  655,  655,
 /* 11610 */   151,  104,  356,  642,  655,  634,  491,  655,  655,  596,
 /* 11620 */   655,  655,  655,  655,  332,  655,  655,  655,  655,  655,
 /* 11630 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 11640 */   610,  326,  560,  655,  453,  655,  655,  655,  655,  458,
 /* 11650 */   343,  186,  564,  561,  655,  570,  655,  655,  655,  655,
 /* 11660 */   655,  436,  655,  655,   88,   89,   94,   99,  597,  655,
 /* 11670 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  617,
 /* 11680 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /* 11690 */   491,  655,  655,  596,  336,  655,  655,  655,  655,  655,
 /* 11700 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 11710 */   610,  326,  655,  655,  655,  655,  560,  655,  453,  655,
 /* 11720 */   655,  655,  655,  458,  343,  186,  564,  561,  655,  570,
 /* 11730 */   655,  436,  655,  655,  655,  655,  655,  655,   88,   89,
 /* 11740 */    94,   99,  597,  655,  655,  655,  655,  655,  655,  617,
 /* 11750 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /* 11760 */   491,  273,  655,  596,  655,  655,  655,  655,  655,  655,
 /* 11770 */   655,  655,  655,  655,  655,  655,  655,  610,  326,  655,
 /* 11780 */   655,  655,  655,  655,  655,  655,  560,  655,  453,  655,
 /* 11790 */   655,  655,  655,  458,  343,  186,  564,  561,  436,  570,
 /* 11800 */   655,  655,  655,  655,  655,  655,  655,  655,   88,   89,
 /* 11810 */    94,   99,  597,  655,  655,  655,  617,  493,  655,  655,
 /* 11820 */   655,  151,  104,  356,  642,  655,  634,  491,  655,  655,
 /* 11830 */   596,  655,  655,  655,  655,  311,  655,  655,  655,  655,
 /* 11840 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 11850 */   655,  610,  326,  560,  655,  453,  655,  655,  655,  655,
 /* 11860 */   458,  343,  186,  564,  561,  655,  570,  655,  655,  655,
 /* 11870 */   655,  655,  436,  655,  655,   88,   89,   94,   99,  597,
 /* 11880 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 11890 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /* 11900 */   634,  491,  655,  655,  596,  297,  655,  655,  655,  655,
 /* 11910 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 11920 */   655,  610,  326,  655,  655,  655,  655,  560,  655,  453,
 /* 11930 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /* 11940 */   570,  655,  436,  655,  655,  655,  655,  655,  655,   88,
 /* 11950 */    89,   94,   99,  597,  655,  655,  655,  655,  655,  655,
 /* 11960 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /* 11970 */   634,  491,  306,  655,  596,  655,  655,  655,  655,  655,
 /* 11980 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /* 11990 */   655,  655,  655,  655,  655,  655,  655,  560,  655,  453,
 /* 12000 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  436,
 /* 12010 */   570,  655,  655,  655,  655,  655,  655,  655,  655,   88,
 /* 12020 */    89,   94,   99,  597,  655,  655,  655,  617,  493,  655,
 /* 12030 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  655,
 /* 12040 */   655,  596,  655,  655,  655,  655,  335,  655,  655,  655,
 /* 12050 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12060 */   655,  655,  610,  326,  560,  655,  453,  655,  655,  655,
 /* 12070 */   655,  458,  343,  186,  564,  561,  655,  570,  655,  655,
 /* 12080 */   655,  655,  655,  436,  655,  655,   88,   89,   94,   99,
 /* 12090 */   597,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12100 */   655,  617,  493,  655,  655,  655,  151,  104,  356,  642,
 /* 12110 */   655,  634,  491,  655,  655,  596,  260,  655,  655,  655,
 /* 12120 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12130 */   655,  655,  610,  326,  655,  655,  655,  655,  560,  655,
 /* 12140 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /* 12150 */   655,  570,  655,  436,  655,  655,  655,  655,  655,  655,
 /* 12160 */    88,   89,   94,   99,  597,  655,  655,  655,  655,  655,
 /* 12170 */   655,  617,  493,  655,  655,  655,  151,  104,  356,  642,
 /* 12180 */   655,  634,  491,  337,  655,  596,  655,  655,  655,  655,
 /* 12190 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  610,
 /* 12200 */   326,  655,  655,  655,  655,  655,  655,  655,  560,  655,
 /* 12210 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /* 12220 */   436,  570,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12230 */    88,   89,   94,   99,  597,  655,  655,  655,  617,  493,
 /* 12240 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /* 12250 */   655,  655,  596,  655,  655,  655,  655,  272,  655,  655,
 /* 12260 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12270 */   655,  655,  655,  610,  326,  560,  655,  453,  655,  655,
 /* 12280 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /* 12290 */   655,  655,  655,  655,  436,  655,  655,   88,   89,   94,
 /* 12300 */    99,  597,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12310 */   655,  655,  617,  493,  655,  655,  655,  151,  104,  356,
 /* 12320 */   642,  655,  634,  491,  655,  655,  596,  313,  655,  655,
 /* 12330 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12340 */   655,  655,  655,  610,  326,  655,  655,  655,  655,  560,
 /* 12350 */   655,  453,  655,  655,  655,  655,  458,  343,  186,  564,
 /* 12360 */   561,  655,  570,  655,  436,  655,  655,  655,  655,  655,
 /* 12370 */   655,   88,   89,   94,   99,  597,  655,  655,  655,  655,
 /* 12380 */   655,  655,  617,  493,  655,  655,  655,  151,  104,  356,
 /* 12390 */   642,  655,  634,  491,  261,  655,  596,  655,  655,  655,
 /* 12400 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12410 */   610,  326,  655,  655,  655,  655,  655,  655,  655,  560,
 /* 12420 */   655,  453,  655,  655,  655,  655,  458,  343,  186,  564,
 /* 12430 */   561,  436,  570,  655,  655,  655,  655,  655,  655,  655,
 /* 12440 */   655,   88,   89,   94,   99,  597,  655,  655,  655,  617,
 /* 12450 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /* 12460 */   491,  655,  655,  596,  655,  655,  655,  655,  334,  655,
 /* 12470 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12480 */   655,  655,  655,  655,  610,  326,  560,  655,  453,  655,
 /* 12490 */   655,  655,  655,  458,  343,  186,  564,  561,  655,  570,
 /* 12500 */   655,  655,  655,  655,  655,  436,  655,  655,   88,   89,
 /* 12510 */    94,   99,  597,  655,  655,  655,  655,  655,  655,  655,
 /* 12520 */   655,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /* 12530 */   356,  642,  655,  634,  491,  655,  655,  596,  304,  655,
 /* 12540 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12550 */   655,  655,  655,  655,  610,  326,  655,  655,  655,  655,
 /* 12560 */   560,  655,  453,  655,  655,  655,  655,  458,  343,  186,
 /* 12570 */   564,  561,  655,  570,  655,  436,  655,  655,  655,  655,
 /* 12580 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /* 12590 */   655,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /* 12600 */   356,  642,  655,  634,  491,  286,  655,  596,  655,  655,
 /* 12610 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12620 */   655,  610,  326,  655,  655,  655,  655,  655,  655,  655,
 /* 12630 */   560,  655,  453,  655,  655,  655,  655,  458,  343,  186,
 /* 12640 */   564,  561,  436,  570,  655,  655,  655,  655,  655,  655,
 /* 12650 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /* 12660 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /* 12670 */   634,  491,  655,  655,  596,  655,  655,  655,  655,  269,
 /* 12680 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12690 */   655,  655,  655,  655,  655,  610,  326,  560,  655,  453,
 /* 12700 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /* 12710 */   570,  655,  655,  655,  655,  655,  436,  655,  655,   88,
 /* 12720 */    89,   94,   99,  597,  655,  655,  655,  655,  655,  655,
 /* 12730 */   655,  655,  655,  655,  617,  493,  655,  655,  655,  151,
 /* 12740 */   104,  356,  642,  655,  634,  491,  655,  655,  596,  409,
 /* 12750 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12760 */   655,  655,  655,  655,  655,  610,  326,  655,  655,  655,
 /* 12770 */   655,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /* 12780 */   186,  564,  561,  655,  570,  655,  436,  655,  655,  655,
 /* 12790 */   655,  655,  655,   88,   89,   94,   99,  597,  655,  655,
 /* 12800 */   655,  655,  655,  655,  617,  493,  655,  655,  655,  151,
 /* 12810 */   104,  356,  642,  655,  634,  491,  309,  655,  596,  655,
 /* 12820 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12830 */   655,  655,  610,  326,  655,  655,  655,  655,  655,  655,
 /* 12840 */   655,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /* 12850 */   186,  564,  561,  436,  570,  655,  655,  655,  655,  655,
 /* 12860 */   655,  655,  655,   88,   89,   94,   99,  597,  655,  655,
 /* 12870 */   655,  617,  493,  655,  655,  655,  151,  104,  356,  642,
 /* 12880 */   655,  634,  491,  655,  655,  596,  655,  655,  655,  655,
 /* 12890 */   264,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12900 */   655,  655,  655,  655,  655,  655,  610,  326,  560,  655,
 /* 12910 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /* 12920 */   655,  570,  655,  655,  655,  655,  655,  436,  655,  655,
 /* 12930 */    88,   89,   94,   99,  597,  655,  655,  655,  655,  655,
 /* 12940 */   655,  655,  655,  655,  655,  617,  493,  655,  655,  655,
 /* 12950 */   151,  104,  356,  642,  655,  634,  491,  655,  655,  596,
 /* 12960 */   633,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 12970 */   655,  655,  655,  655,  655,  655,  610,  326,  655,  655,
 /* 12980 */   655,  655,  560,  655,  453,  655,  655,  655,  655,  458,
 /* 12990 */   343,  186,  564,  561,  655,  570,  655,  436,  655,  655,
 /* 13000 */   655,  655,  655,  655,   88,   89,   94,   99,  597,  655,
 /* 13010 */   655,  655,  655,  655,  655,  617,  493,  655,  655,  655,
 /* 13020 */   151,  104,  356,  642,  655,  634,  491,  319,  655,  596,
 /* 13030 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 13040 */   655,  655,  655,  610,  326,  655,  655,  655,  655,  655,
 /* 13050 */   655,  655,  560,  655,  453,  655,  655,  655,  655,  458,
 /* 13060 */   343,  186,  564,  561,  436,  570,  655,  655,  655,  655,
 /* 13070 */   655,  655,  655,  655,   88,   89,   94,   99,  597,  655,
 /* 13080 */   655,  655,  617,  493,  655,  655,  655,  151,  104,  356,
 /* 13090 */   642,  655,  634,  491,  655,  655,  596,  655,  655,  655,
 /* 13100 */   655,  298,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 13110 */   655,  655,  655,  655,  655,  655,  655,  610,  326,  560,
 /* 13120 */   655,  453,  655,  655,  655,  655,  458,  343,  186,  564,
 /* 13130 */   561,  655,  570,  655,  655,  655,  655,  655,  436,  655,
 /* 13140 */   655,   88,   89,   94,   99,  597,  655,  655,  655,  655,
 /* 13150 */   655,  655,  655,  655,  655,  655,  617,  493,  655,  655,
 /* 13160 */   655,  151,  104,  356,  642,  655,  634,  491,  655,  655,
 /* 13170 */   596,  333,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 13180 */   655,  655,  655,  655,  655,  655,  655,  610,  326,  655,
 /* 13190 */   655,  655,  655,  560,  655,  453,  655,  655,  655,  655,
 /* 13200 */   458,  343,  186,  564,  561,  655,  570,  655,  436,  655,
 /* 13210 */   655,  655,  655,  655,  655,   88,   89,   94,   99,  597,
 /* 13220 */   655,  655,  655,  655,  655,  655,  617,  493,  655,  655,
 /* 13230 */   655,  151,  104,  356,  642,  655,  634,  491,  295,  655,
 /* 13240 */   596,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 13250 */   655,  655,  655,  655,  610,  326,  655,  655,  655,  655,
 /* 13260 */   655,  655,  655,  560,  655,  453,  655,  655,  655,  655,
 /* 13270 */   458,  343,  186,  564,  561,  436,  570,  655,  655,  655,
 /* 13280 */   655,  655,  655,  655,  655,   88,   89,   94,   99,  597,
 /* 13290 */   655,  655,  655,  617,  493,  655,  655,  655,  151,  104,
 /* 13300 */   356,  642,  655,  634,  491,  655,  655,  596,  655,  655,
 /* 13310 */   655,  655,  263,  655,  655,  655,  655,  655,  655,  655,
 /* 13320 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /* 13330 */   560,  655,  453,  655,  655,  655,  655,  458,  343,  186,
 /* 13340 */   564,  561,  655,  570,  655,  655,  655,  655,  655,  436,
 /* 13350 */   655,  655,   88,   89,   94,   99,  597,  655,  655,  655,
 /* 13360 */   655,  655,  655,  655,  655,  655,  655,  617,  493,  655,
 /* 13370 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  655,
 /* 13380 */   655,  596,  318,  655,  655,  655,  655,  655,  655,  655,
 /* 13390 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /* 13400 */   655,  655,  655,  655,  560,  655,  453,  655,  655,  655,
 /* 13410 */   655,  458,  343,  186,  564,  561,  655,  570,  655,  436,
 /* 13420 */   655,  655,  655,  655,  655,  655,   88,   89,   94,   99,
 /* 13430 */   597,  655,  655,  655,  655,  655,  655,  617,  493,  655,
 /* 13440 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  266,
 /* 13450 */   655,  596,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 13460 */   655,  655,  655,  655,  655,  610,  326,  655,  655,  655,
 /* 13470 */   655,  655,  655,  655,  560,  655,  453,  655,  655,  655,
 /* 13480 */   655,  458,  343,  186,  564,  561,  436,  570,  655,  655,
 /* 13490 */   655,  655,  655,  655,  655,  655,   88,   89,   94,   99,
 /* 13500 */   597,  655,  655,  655,  617,  493,  655,  655,  655,  151,
 /* 13510 */   104,  356,  642,  655,  634,  491,  655,  655,  596,  655,
 /* 13520 */   655,  655,  655,  307,  655,  655,  655,  655,  655,  655,
 /* 13530 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  610,
 /* 13540 */   326,  560,  655,  453,  655,  655,  655,  655,  458,  343,
 /* 13550 */   186,  564,  561,  655,  570,  655,  655,  655,  655,  655,
 /* 13560 */   436,  655,  655,   88,   89,   94,   99,  597,  655,  655,
 /* 13570 */   655,  655,  655,  655,  655,  655,  655,  655,  617,  493,
 /* 13580 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /* 13590 */   655,  655,  596,  258,  655,  655,  655,  655,  655,  655,
 /* 13600 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  610,
 /* 13610 */   326,  655,  655,  655,  655,  560,  655,  453,  655,  655,
 /* 13620 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /* 13630 */   436,  655,  655,  655,  655,  655,  655,   88,   89,   94,
 /* 13640 */    99,  597,  655,  655,  655,  655,  655,  655,  617,  493,
 /* 13650 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /* 13660 */   302,  655,  596,  655,  655,  655,  655,  655,  655,  655,
 /* 13670 */   655,  655,  655,  655,  655,  655,  610,  326,  655,  655,
 /* 13680 */   655,  655,  655,  655,  655,  560,  655,  453,  655,  655,
 /* 13690 */   655,  655,  458,  343,  186,  564,  561,  436,  570,  655,
 /* 13700 */   655,  655,  655,  655,  655,  655,  655,   88,   89,   94,
 /* 13710 */    99,  597,  655,  655,  655,  617,  493,  655,  655,  655,
 /* 13720 */   151,  104,  356,  642,  655,  634,  491,  655,  655,  596,
 /* 13730 */   655,  655,  655,  655,  303,  655,  655,  655,  655,  655,
 /* 13740 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 13750 */   610,  326,  560,  655,  453,  655,  655,  655,  655,  458,
 /* 13760 */   343,  186,  564,  561,  655,  570,  655,  655,  655,  655,
 /* 13770 */   655,  436,  655,  655,   88,   89,   94,   99,  597,  655,
 /* 13780 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  617,
 /* 13790 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /* 13800 */   491,  655,  655,  596,  284,  655,  655,  655,  655,  655,
 /* 13810 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 13820 */   610,  326,  655,  655,  655,  655,  560,  655,  453,  655,
 /* 13830 */   655,  655,  655,  458,  343,  186,  564,  561,  655,  570,
 /* 13840 */   655,  436,  655,  655,  655,  655,  655,  655,   88,   89,
 /* 13850 */    94,   99,  597,  655,  655,  655,  655,  655,  655,  617,
 /* 13860 */   493,  655,  655,  655,  151,  104,  356,  642,  655,  634,
 /* 13870 */   491,  411,  655,  596,  655,  655,  655,  655,  655,  655,
 /* 13880 */   655,  655,  655,  655,  655,  655,  655,  610,  326,  655,
 /* 13890 */   655,  655,  655,  655,  655,  655,  560,  655,  453,  655,
 /* 13900 */   655,  655,  655,  458,  343,  186,  564,  561,  436,  570,
 /* 13910 */   655,  655,  655,  655,  655,  655,  655,  655,   88,   89,
 /* 13920 */    94,   99,  597,  655,  655,  655,  617,  493,  655,  655,
 /* 13930 */   655,  151,  104,  356,  642,  655,  634,  491,  655,  655,
 /* 13940 */   596,  655,  655,  655,  655,  285,  655,  655,  655,  655,
 /* 13950 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 13960 */   655,  610,  326,  560,  655,  453,  655,  655,  655,  655,
 /* 13970 */   458,  343,  186,  564,  561,  655,  570,  655,  655,  655,
 /* 13980 */   655,  655,  436,  655,  655,   88,   89,   94,   99,  597,
 /* 13990 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14000 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /* 14010 */   634,  491,  655,  655,  596,  265,  655,  655,  655,  655,
 /* 14020 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14030 */   655,  610,  326,  655,  655,  655,  655,  560,  655,  453,
 /* 14040 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /* 14050 */   570,  655,  436,  655,  655,  655,  655,  655,  655,   88,
 /* 14060 */    89,   94,   99,  597,  655,  655,  655,  655,  655,  655,
 /* 14070 */   617,  493,  655,  655,  655,  151,  104,  356,  642,  655,
 /* 14080 */   634,  491,  299,  655,  596,  655,  655,  655,  655,  655,
 /* 14090 */   655,  655,  655,  655,  655,  655,  655,  655,  610,  326,
 /* 14100 */   655,  655,  655,  655,  655,  655,  655,  560,  655,  453,
 /* 14110 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  436,
 /* 14120 */   570,  655,  655,  655,  655,  655,  655,  655,  655,   88,
 /* 14130 */    89,   94,   99,  597,  655,  655,  655,  617,  493,  655,
 /* 14140 */   655,  655,  151,  104,  356,  642,  655,  634,  491,  655,
 /* 14150 */   655,  596,  655,  655,  655,  655,  314,  655,  655,  655,
 /* 14160 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14170 */   655,  655,  610,  326,  560,  655,  453,  655,  655,  655,
 /* 14180 */   655,  458,  343,  186,  564,  561,  655,  570,  655,  655,
 /* 14190 */   655,  655,  655,  436,  655,  655,   88,   89,   94,   99,
 /* 14200 */   597,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14210 */   655,  617,  493,  655,  655,  655,  151,  104,  356,  642,
 /* 14220 */   655,  634,  491,  655,  655,  596,  290,  655,  655,  655,
 /* 14230 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14240 */   655,  655,  610,  326,  655,  655,  655,  655,  560,  655,
 /* 14250 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /* 14260 */   655,  570,  655,  436,  655,  655,  655,  655,  655,  655,
 /* 14270 */    88,   89,   94,   99,  597,  655,  655,  655,  655,  655,
 /* 14280 */   655,  617,  493,  655,  655,  655,  151,  104,  356,  642,
 /* 14290 */   655,  634,  491,  310,  655,  596,  655,  655,  655,  655,
 /* 14300 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  610,
 /* 14310 */   326,  655,  655,  655,  655,  655,  655,  655,  560,  655,
 /* 14320 */   453,  655,  655,  655,  655,  458,  343,  186,  564,  561,
 /* 14330 */   436,  570,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14340 */    88,   89,   94,   99,  597,  655,  655,  655,  617,  493,
 /* 14350 */   655,  655,  655,  151,  104,  356,  642,  655,  634,  491,
 /* 14360 */   655,  655,  596,  655,  655,  655,  655,  655,  655,  655,
 /* 14370 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14380 */   655,  655,  655,  655,  655,  560,  655,  453,  655,  655,
 /* 14390 */   655,  655,  458,  343,  186,  564,  561,  655,  570,  655,
 /* 14400 */   655,  119,  124,  655,  655,  655,  655,   88,   89,   94,
 /* 14410 */    99,  597,  655,  655,  655,  655,   59,  655,  106,  111,
 /* 14420 */   125,  102,  116,   98,   55,  122,  121,   56,   57,   58,
 /* 14430 */    51,  105,  126,  110,  107,  109,  112,  114,  103,  124,
 /* 14440 */   153,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14450 */   655,  655,  655,   59,  655,  106,  111,  125,  102,  116,
 /* 14460 */    98,   55,  122,  121,   56,   57,   58,   51,  105,  126,
 /* 14470 */   110,  107,  109,  112,  114,  103,  655,  153,  655,  655,
 /* 14480 */   655,  655,  569,  655,  655,  655,  655,  655,  655,  655,
 /* 14490 */   655,  655,  655,  655,  222,  655,  655,  655,  569,  655,
 /* 14500 */   655,  655,  454,  655,  655,  655,  655,  655,  655,  655,
 /* 14510 */   505,  655,  655,  655,  655,  655,  655,  655,  454,  655,
 /* 14520 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14530 */   655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14540 */   503,  655,  655,  655,  655,  655,  655,  655,  655,  655,
 /* 14550 */   655,  655,  655,  655,  655,  655,  503,  560,  655,  453,
 /* 14560 */   655,  655,  655,  655,  458,  343,  186,  564,  561,  655,
 /* 14570 */   570,  655,  655,  560,  655,  453,  655,  655,  655,  655,
 /* 14580 */   458,  343,  186,  564,  561,  655,  570,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,    2,    3,    4,    5,   97,   29,  174,   23,   10,
 /*    10 */    25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
 /*    20 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*    30 */    45,  250,   47,  255,  126,  254,  255,  256,  260,   40,
 /*    40 */    41,  260,  261,  262,   61,   46,   75,   48,   49,   50,
 /*    50 */    51,   52,   53,  223,   55,   56,   57,   58,   59,   60,
 /*    60 */    77,   62,   63,  254,  255,  256,   67,   68,   69,  260,
 /*    70 */   237,  130,   73,   74,   97,   76,   77,  100,   79,   80,
 /*    80 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*    90 */    91,   92,  129,   94,   95,  192,   97,   98,   99,  100,
 /*   100 */   101,    6,  103,  126,  105,  106,  107,  108,  109,  110,
 /*   110 */   111,  112,  113,  114,  115,  116,  213,    1,    2,    3,
 /*   120 */     4,    5,   64,   65,  125,  126,   10,   40,   41,   42,
 /*   130 */    43,   44,   45,   97,   47,  136,   24,  138,  139,  140,
 /*   140 */   141,  142,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   150 */    42,   43,   44,   45,  223,   47,   40,   41,  255,  256,
 /*   160 */   257,  258,   46,  260,   48,   49,   50,   51,   52,   53,
 /*   170 */    75,   55,   56,   57,   58,   59,   60,  274,   62,   63,
 /*   180 */   254,  255,  256,   67,   68,   69,  260,  153,   76,   73,
 /*   190 */    74,   97,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   200 */    84,   85,   86,   87,   88,   89,   90,   91,   92,  100,
 /*   210 */    94,   95,  192,   97,   98,   99,  100,  101,    6,  103,
 /*   220 */   126,  105,  106,  107,  108,  109,  110,  111,  112,  113,
 /*   230 */   114,  115,  116,  213,    1,    2,    3,    4,    5,  122,
 /*   240 */   123,  124,  126,   10,   24,  224,  225,  226,  227,  228,
 /*   250 */   229,    6,  136,   78,  138,  139,  140,  141,  142,  250,
 /*   260 */   122,  123,  124,  254,  255,  256,  254,  255,  256,  260,
 /*   270 */   261,  262,  260,   40,   41,  255,  256,  257,  258,   46,
 /*   280 */   260,   48,   49,   50,   51,   52,   53,   75,   55,   56,
 /*   290 */    57,   58,   59,   60,  274,   62,   63,   77,  123,  124,
 /*   300 */    67,   68,   69,   64,   65,   75,   73,   74,   97,   76,
 /*   310 */    77,  100,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   320 */    87,   88,   89,   90,   91,   92,   62,   94,   95,  153,
 /*   330 */    97,   98,   99,  100,  101,  202,  103,  126,  105,  106,
 /*   340 */   107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*   350 */    97,   74,  119,  100,    1,    2,    3,    4,    5,  126,
 /*   360 */   255,   97,    6,   10,  100,  260,  233,  234,   77,  136,
 /*   370 */    74,  138,  139,  140,  141,  142,  224,  225,  226,  126,
 /*   380 */   228,   74,   67,   68,   69,   70,   71,   72,   97,   97,
 /*   390 */   126,  100,  100,   40,   41,  118,  224,  225,  226,   46,
 /*   400 */   228,   48,   49,   50,   51,   52,   53,  111,   55,   56,
 /*   410 */    57,   58,   59,   60,   99,   62,   63,  126,  126,    6,
 /*   420 */    67,   68,   69,  255,   75,  118,   73,   74,  260,   76,
 /*   430 */    77,   75,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   440 */    87,   88,   89,   90,   91,   92,   74,   94,   95,  100,
 /*   450 */    97,   98,   99,  100,  101,  192,  103,  108,  105,  106,
 /*   460 */   107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*   470 */   238,  239,  209,  241,  121,  243,   75,  245,  246,  126,
 /*   480 */   100,    1,    2,    3,    4,    5,   76,   77,   75,  136,
 /*   490 */    10,  138,  139,  140,  141,  142,   26,   27,   28,   29,
 /*   500 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*   510 */    40,   41,   42,   43,   44,   45,   97,   47,  191,  100,
 /*   520 */    40,   41,   97,  196,  192,  100,   46,    6,   48,   49,
 /*   530 */    50,   51,   52,   53,    6,   55,   56,   57,   58,   59,
 /*   540 */    60,  209,   62,   63,   49,   50,   96,   67,   68,   69,
 /*   550 */   131,  126,   11,   73,   74,    6,   76,   77,   78,   79,
 /*   560 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   570 */    90,   91,   92,  100,   94,   95,   97,   97,   98,   99,
 /*   580 */   100,  101,  153,  103,   75,  105,  106,  107,  108,  109,
 /*   590 */   110,  111,  112,  113,  114,  115,  116,   76,    1,    2,
 /*   600 */     3,    4,    5,  100,   76,  126,  126,   10,  224,  225,
 /*   610 */   226,  108,  228,   43,   44,   45,  136,   47,  138,  139,
 /*   620 */   140,  141,  142,  250,   75,   77,   76,  254,  255,  256,
 /*   630 */   202,   29,  275,  260,  261,  262,   76,   40,   41,   74,
 /*   640 */   224,  225,  226,   46,  228,   48,   49,   50,   51,   52,
 /*   650 */    53,   61,   55,   56,   57,   58,   59,   60,  153,   62,
 /*   660 */    63,  233,  234,    6,   67,   68,   69,   77,  145,  146,
 /*   670 */    73,   74,    6,   76,   77,   78,   79,   80,   81,   82,
 /*   680 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   690 */    76,   94,   95,  192,   97,   98,   99,  100,  101,   97,
 /*   700 */   103,  130,  105,  106,  107,  108,  109,  110,  111,  112,
 /*   710 */   113,  114,  115,  116,  213,    1,    2,    3,    4,    5,
 /*   720 */   153,   29,  130,  126,   10,   74,  224,  225,  226,  223,
 /*   730 */   228,  100,   75,  136,   78,  138,  139,  140,  141,  142,
 /*   740 */   250,    6,   76,   74,  254,  255,  256,  266,    6,   24,
 /*   750 */   260,  261,  262,   77,   40,   41,  255,  256,  257,  258,
 /*   760 */    46,  260,   48,   49,   50,   51,   52,   53,  232,   55,
 /*   770 */    56,   57,   58,   59,   60,  274,   62,   63,  267,  123,
 /*   780 */   124,   67,   68,   69,   74,   76,   74,   73,   74,   97,
 /*   790 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   800 */    86,   87,   88,   89,   90,   91,   92,  252,   94,   95,
 /*   810 */    75,   97,   98,   99,  100,  101,  118,  103,   76,  105,
 /*   820 */   106,  107,  108,  109,  110,  111,  112,  113,  114,  115,
 /*   830 */   116,    6,    1,    2,    3,    4,    5,   74,   61,  153,
 /*   840 */   126,   10,   78,   77,  224,  225,  226,  100,  228,   74,
 /*   850 */   136,  206,  138,  139,  140,  141,  142,  118,  224,  225,
 /*   860 */   226,   76,  228,   97,  153,  191,  100,  193,   75,  195,
 /*   870 */   196,   40,   41,   11,  224,  225,  226,   46,  228,   48,
 /*   880 */    49,   50,   51,   52,   53,   77,   55,   56,   57,   58,
 /*   890 */    59,   60,  126,   62,   63,   75,   11,  153,   67,   68,
 /*   900 */    69,   76,   74,   11,   73,   74,  129,   76,   77,   78,
 /*   910 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   920 */    89,   90,   91,   92,  100,   94,   95,   76,   97,   98,
 /*   930 */    99,  100,  101,    6,  103,   75,  105,  106,  107,  108,
 /*   940 */   109,  110,  111,  112,  113,  114,  115,  116,   74,    1,
 /*   950 */     2,    3,    4,    5,   76,  100,   76,  126,   10,   75,
 /*   960 */   224,  225,  226,   74,  228,   11,  100,  136,   74,  138,
 /*   970 */   139,  140,  141,  142,   61,  224,  225,  226,   74,  228,
 /*   980 */   224,  225,  226,  118,  228,   74,   77,   74,   40,   41,
 /*   990 */    77,  224,  225,  226,   46,  228,   48,   49,   50,   51,
 /*  1000 */    52,   53,   11,   55,   56,   57,   58,   59,   60,   74,
 /*  1010 */    62,   63,   80,   76,  100,   67,   68,   69,   75,   97,
 /*  1020 */    74,   73,   74,   76,   76,   77,   78,   79,   80,   81,
 /*  1030 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  1040 */    92,    6,   94,   95,  100,   97,   98,   99,  100,  101,
 /*  1050 */    11,  103,   77,  105,  106,  107,  108,  109,  110,  111,
 /*  1060 */   112,  113,  114,  115,  116,  231,    1,    2,    3,    4,
 /*  1070 */     5,   74,   76,  251,  126,   10,   76,  224,  225,  226,
 /*  1080 */    74,  228,  219,  100,  136,   74,  138,  139,  140,  141,
 /*  1090 */   142,  224,  225,  226,   61,  228,  224,  225,  226,   77,
 /*  1100 */   228,   97,  223,   76,  100,   40,   41,   74,   74,  105,
 /*  1110 */    77,   46,   74,   48,   49,   50,   51,   52,   53,  185,
 /*  1120 */    55,   56,   57,   58,   59,   60,   11,   62,   63,   75,
 /*  1130 */   126,  192,   67,   68,   69,   75,  129,   97,   73,   74,
 /*  1140 */   188,   76,   77,  117,   79,   80,   81,   82,   83,   84,
 /*  1150 */    85,   86,   87,   88,   89,   90,   91,   92,   74,   94,
 /*  1160 */    95,   97,   97,   98,   99,  100,  101,   74,  103,  253,
 /*  1170 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*  1180 */   115,  116,  224,  225,  226,  120,  228,  246,   74,  153,
 /*  1190 */   176,  126,   97,    1,    2,    3,    4,    5,   75,   11,
 /*  1200 */    76,  136,   10,  138,  139,  140,  141,  142,   27,   28,
 /*  1210 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  1220 */    39,   40,   41,   42,   43,   44,   45,  208,   47,  129,
 /*  1230 */     6,  214,   40,   41,   74,   74,  276,   97,   46,   74,
 /*  1240 */    48,   49,   50,   51,   52,   53,  102,   55,   56,   57,
 /*  1250 */    58,   59,   60,  192,   62,   63,  204,   75,   74,   67,
 /*  1260 */    68,   69,   75,  214,   74,   73,   74,  201,   76,   77,
 /*  1270 */    97,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1280 */    88,   89,   90,   91,   92,   29,   94,   95,   24,   97,
 /*  1290 */    98,   99,  100,  101,   99,  103,   66,  105,  106,  107,
 /*  1300 */   108,  109,  110,  111,  112,  113,  114,  115,  116,  231,
 /*  1310 */     1,    2,    3,    4,    5,  206,   77,  231,  126,   10,
 /*  1320 */   118,   76,   78,  153,  153,   75,  118,  153,  136,  129,
 /*  1330 */   138,  139,  140,  141,  142,  101,  153,  240,  265,    6,
 /*  1340 */    75,  242,   74,  101,  192,   97,   93,  185,   74,   40,
 /*  1350 */    41,   47,   76,   75,  234,   46,  231,   48,   49,   50,
 /*  1360 */    51,   52,   53,  167,   55,   56,   57,   58,   59,   60,
 /*  1370 */    75,   62,   63,  102,  117,  159,   67,   68,   69,  117,
 /*  1380 */    11,  232,   73,   74,    6,   76,   77,  244,   79,   80,
 /*  1390 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  1400 */    91,   92,   61,   94,   95,  180,   97,   98,   99,  100,
 /*  1410 */   101,  118,  103,   76,  105,  106,  107,  108,  109,  110,
 /*  1420 */   111,  112,  113,  114,  115,  116,  156,   75,  153,  157,
 /*  1430 */   237,   11,  201,  153,  191,  126,  111,    1,    2,    3,
 /*  1440 */     4,    5,  251,   11,   11,  136,   10,  138,  139,  140,
 /*  1450 */   141,  142,  104,  192,  205,  278,  278,  278,  278,  278,
 /*  1460 */    24,  278,   11,   12,   13,   14,   15,   16,   17,   18,
 /*  1470 */    19,   20,   21,   22,  278,  278,   40,   41,  278,  278,
 /*  1480 */   278,  278,   46,  278,   48,   49,   50,   51,   52,   53,
 /*  1490 */   278,   55,   56,   57,   58,   59,   60,  278,   62,   63,
 /*  1500 */    49,   50,  278,   67,  278,  278,  278,  278,  278,  278,
 /*  1510 */    74,  278,   76,   77,  278,   79,   80,   81,   82,   83,
 /*  1520 */    84,   85,   86,   87,   88,   89,   90,   91,   92,  278,
 /*  1530 */    94,   95,  278,   97,   98,  278,  100,  278,  278,  278,
 /*  1540 */   278,  105,  106,  107,  108,  109,  110,  111,  112,  113,
 /*  1550 */   114,  115,  116,  278,  278,  278,  278,  278,  278,  278,
 /*  1560 */   278,  278,  126,  278,    1,    2,    3,    4,    5,  278,
 /*  1570 */   278,  278,  136,   10,  138,  139,  140,  141,  142,  278,
 /*  1580 */   278,  278,  278,  278,  278,  278,  278,   24,  278,  278,
 /*  1590 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  1600 */   278,  278,  278,   40,   41,  278,  278,  278,  278,   46,
 /*  1610 */   278,   48,   49,   50,   51,   52,   53,  278,   55,   56,
 /*  1620 */    57,   58,   59,   60,  278,   62,   63,  278,  278,  278,
 /*  1630 */    67,  278,  278,  278,  278,  278,  172,   74,  278,   76,
 /*  1640 */    77,  278,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  1650 */    87,   88,   89,   90,   91,   92,  192,   94,   95,  278,
 /*  1660 */    97,   98,  278,  100,  278,  278,  278,  278,  105,  106,
 /*  1670 */   107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*  1680 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  126,
 /*  1690 */   278,    1,    2,    3,    4,    5,  278,  278,  278,  136,
 /*  1700 */    10,  138,  139,  140,  141,  142,  278,  278,  278,  278,
 /*  1710 */   278,  247,  248,  249,   24,  278,  278,  278,  254,  255,
 /*  1720 */   256,  257,  258,  278,  260,  278,  278,  278,  278,  278,
 /*  1730 */    40,   41,  278,  278,  278,  278,   46,  278,   48,   49,
 /*  1740 */    50,   51,   52,   53,  278,   55,   56,   57,   58,   59,
 /*  1750 */    60,  278,   62,   63,  278,  278,  278,   67,  278,  278,
 /*  1760 */   278,  278,  278,  278,   74,  278,   76,   77,  278,   79,
 /*  1770 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  1780 */    90,   91,   92,  278,   94,   95,  278,   97,   98,  278,
 /*  1790 */   100,  278,  278,  278,  278,  105,  106,  107,  108,  109,
 /*  1800 */   110,  111,  112,  113,  114,  115,  116,  278,  278,  278,
 /*  1810 */   278,  278,  278,  278,  278,  278,  126,  278,    1,    2,
 /*  1820 */     3,    4,    5,  278,  278,  278,  136,   10,  138,  139,
 /*  1830 */   140,  141,  142,  278,  278,  278,  278,  278,  278,  278,
 /*  1840 */   278,   24,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  1850 */   278,  278,  278,  278,  278,  278,  278,   40,   41,  278,
 /*  1860 */   278,  278,  278,   46,  278,   48,   49,   50,   51,   52,
 /*  1870 */    53,  278,   55,   56,   57,   58,   59,   60,  278,   62,
 /*  1880 */    63,  278,  278,  278,   67,  278,  278,  278,  278,  278,
 /*  1890 */   278,   74,  278,   76,   77,  278,   79,   80,   81,   82,
 /*  1900 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1910 */   278,   94,   95,  278,   97,   98,  278,  100,  278,  278,
 /*  1920 */   278,  278,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  1930 */   113,  114,  115,  116,  278,  278,  278,  278,  278,  278,
 /*  1940 */   278,  278,  278,  126,  278,    1,    2,    3,    4,    5,
 /*  1950 */   278,  278,  278,  136,   10,  138,  139,  140,  141,  142,
 /*  1960 */   278,  278,  278,  278,  278,  278,  278,  278,   24,  278,
 /*  1970 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  1980 */   278,  278,  278,  278,   40,   41,  278,  278,  278,  278,
 /*  1990 */    46,  278,   48,   49,   50,   51,   52,   53,  278,   55,
 /*  2000 */    56,   57,   58,   59,   60,  278,   62,   63,  278,  278,
 /*  2010 */   278,   67,  278,  278,  278,  278,  278,  278,   74,  278,
 /*  2020 */    76,   77,  278,   79,   80,   81,   82,   83,   84,   85,
 /*  2030 */    86,   87,   88,   89,   90,   91,   92,  278,   94,   95,
 /*  2040 */   278,   97,   98,  278,  100,  278,  278,  278,  278,  105,
 /*  2050 */   106,  107,  108,  109,  110,  111,  112,  113,  114,  115,
 /*  2060 */   116,  278,    1,    2,    3,    4,    5,  278,  278,  278,
 /*  2070 */   126,   10,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  2080 */   136,  278,  138,  139,  140,  141,  142,  278,  278,  278,
 /*  2090 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  2100 */   278,   40,   41,  278,  278,  278,  278,   46,  278,   48,
 /*  2110 */    49,   50,   51,   52,   53,  278,   55,   56,   57,   58,
 /*  2120 */    59,   60,  278,   62,   63,  278,  278,  278,   67,  278,
 /*  2130 */   278,  278,  278,  278,  278,   74,  278,   76,   77,  278,
 /*  2140 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  2150 */    89,   90,   91,   92,  278,   94,   95,  278,   97,   98,
 /*  2160 */   278,  100,  278,  278,  278,  278,  105,  106,  107,  108,
 /*  2170 */   109,  110,  111,  112,  113,  114,  115,  116,  278,    1,
 /*  2180 */     2,    3,    4,    5,  278,  278,  278,  126,   10,  278,
 /*  2190 */   278,  278,  278,  278,  278,  278,  278,  136,  278,  138,
 /*  2200 */   139,  140,  141,  142,  278,  278,  278,  278,  278,  278,
 /*  2210 */   278,  278,  278,  278,  278,  278,  278,  278,   40,   41,
 /*  2220 */   278,  278,  278,  172,   46,  278,   48,   49,   50,   51,
 /*  2230 */    52,   53,  278,   55,   56,   57,   58,   59,   60,  278,
 /*  2240 */    62,   63,  278,  192,  278,   67,  278,  278,  278,  278,
 /*  2250 */   278,  278,   74,  278,   76,   77,  278,   79,   80,   81,
 /*  2260 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  2270 */    92,  278,   94,   95,  278,   97,   98,  278,  100,  278,
 /*  2280 */   278,  230,  278,  105,  106,  107,  108,  109,  110,  111,
 /*  2290 */   112,  113,  114,  115,  116,  278,  278,  278,  247,  278,
 /*  2300 */   249,  278,  278,  278,  126,  254,  255,  256,  257,  258,
 /*  2310 */   278,  260,  278,  278,  136,  278,  138,  139,  140,  141,
 /*  2320 */   142,  148,  149,  150,  151,  152,  278,  154,  155,  278,
 /*  2330 */   278,  158,  278,  160,  278,  162,  163,  278,  278,  166,
 /*  2340 */   278,  168,  169,  170,  171,  172,  173,  278,  175,  278,
 /*  2350 */   177,  278,  179,  278,  181,  278,  183,  278,  278,  278,
 /*  2360 */   187,  278,  278,  190,  278,  192,  278,  194,  278,  278,
 /*  2370 */   197,  198,  199,  200,  278,  278,  203,  278,  278,  278,
 /*  2380 */   207,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /*  2390 */   217,  218,  278,  220,  221,  278,  278,  224,  278,   25,
 /*  2400 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  2410 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  2420 */   247,   47,  249,  278,  278,  278,  278,  254,  255,  256,
 /*  2430 */   257,  258,  278,  260,  278,  278,  278,  278,  278,  278,
 /*  2440 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /*  2450 */   278,  278,  278,  148,  149,  150,  151,  152,  278,  154,
 /*  2460 */   155,  278,  278,  278,  278,  160,  278,  162,  163,  278,
 /*  2470 */   278,  166,  278,  168,  169,  170,  171,  172,  173,  278,
 /*  2480 */   175,  278,  177,  278,  179,  278,  181,  278,  183,  278,
 /*  2490 */   278,  278,  187,  278,  278,  190,  278,  192,  278,  194,
 /*  2500 */   278,  278,  197,  198,  199,  200,  278,  278,  203,  278,
 /*  2510 */   278,  278,  207,  278,  278,  210,  211,  278,  278,  278,
 /*  2520 */   215,  216,  217,  218,  278,  220,  221,  278,  278,  224,
 /*  2530 */   278,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /*  2540 */    37,   38,   39,   40,   41,   42,   43,   44,   45,  278,
 /*  2550 */    47,  278,  247,  278,  249,  278,  278,  278,  278,  254,
 /*  2560 */   255,  256,  257,  258,  278,  260,  278,  278,  278,  278,
 /*  2570 */   278,  278,  278,  278,  269,  270,  271,  272,  273,  147,
 /*  2580 */   148,  149,  150,  151,  152,  278,  154,  155,  278,  278,
 /*  2590 */   278,  278,  160,  278,  162,  163,  278,  278,  166,  278,
 /*  2600 */   168,  169,  170,  171,  172,  173,  278,  175,  278,  177,
 /*  2610 */   278,  179,  278,  181,  278,  183,  278,  278,  278,  187,
 /*  2620 */   278,  278,  190,  278,  192,  278,  194,  278,  278,  278,
 /*  2630 */   198,  199,  200,  278,  278,  203,  278,  278,  278,  207,
 /*  2640 */   278,  278,  210,  211,  278,  278,  278,  215,  216,  217,
 /*  2650 */   218,  278,  220,  221,  278,  278,  224,  278,  278,  278,
 /*  2660 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  2670 */    39,   40,   41,   42,   43,   44,   45,  278,   47,  247,
 /*  2680 */   278,  249,  278,  278,  278,  278,  254,  255,  256,  257,
 /*  2690 */   258,  278,  260,   40,   41,  278,  278,  278,  278,  278,
 /*  2700 */   278,  269,  270,  271,  272,  273,  278,  278,  148,  278,
 /*  2710 */   278,  151,  152,  278,  154,  155,  278,  278,  278,  278,
 /*  2720 */   160,  278,  162,  163,  278,  165,  166,  278,  168,  169,
 /*  2730 */   170,  171,  172,  173,  278,  175,  278,  177,  278,  179,
 /*  2740 */   278,  181,  278,  183,  278,  278,  278,  187,  278,  278,
 /*  2750 */   190,  278,  192,  100,  194,  278,  278,  278,  278,  278,
 /*  2760 */   278,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*  2770 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /*  2780 */   220,  221,  278,  278,  224,   30,   31,   32,   33,   34,
 /*  2790 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  2800 */    45,  278,   47,  278,  278,  172,  278,  247,  278,  249,
 /*  2810 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /*  2820 */   260,  278,  278,  278,  278,  192,  278,  278,  278,  269,
 /*  2830 */   270,  271,  272,  273,  278,  148,  278,  278,  151,  152,
 /*  2840 */   278,  154,  155,  278,  211,  212,  278,  160,  161,  162,
 /*  2850 */   163,  278,  278,  166,  278,  168,  169,  170,  171,  172,
 /*  2860 */   173,  278,  175,  278,  177,  278,  179,  278,  181,  278,
 /*  2870 */   183,  278,  278,  278,  187,  278,  278,  190,  278,  192,
 /*  2880 */   247,  194,  249,  278,  278,  278,  278,  254,  255,  256,
 /*  2890 */   257,  258,  278,  260,  278,  278,  263,  210,  211,  278,
 /*  2900 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  278,
 /*  2910 */     6,  224,  278,  278,  278,   11,   12,   13,   14,   15,
 /*  2920 */    16,   17,   18,   19,   20,   21,   22,  278,  278,  278,
 /*  2930 */   278,  278,  278,  278,  247,  278,  249,  278,  278,  278,
 /*  2940 */   278,  254,  255,  256,  257,  258,  278,  260,  278,  278,
 /*  2950 */   278,  278,  278,   49,   50,  278,  269,  270,  271,  272,
 /*  2960 */   273,  278,  278,  148,  278,  278,  151,  152,  278,  154,
 /*  2970 */   155,  172,  278,  278,  278,  160,  278,  162,  163,   75,
 /*  2980 */   278,  166,  278,  168,  169,  170,  171,  172,  173,  278,
 /*  2990 */   175,  192,  177,  278,  179,  278,  181,  278,  183,  278,
 /*  3000 */   278,  186,  187,  278,  278,  190,  278,  192,    6,  194,
 /*  3010 */   278,  278,  278,   11,   12,   13,   14,   15,   16,   17,
 /*  3020 */    18,   19,   20,   21,   22,  210,  211,  278,  278,  230,
 /*  3030 */   215,  216,  217,  218,  278,  220,  221,  278,  278,  224,
 /*  3040 */   278,  278,  278,  278,  278,  278,  247,  278,  249,  278,
 /*  3050 */   278,   49,   50,  254,  255,  256,  257,  258,  278,  260,
 /*  3060 */   172,  278,  247,  278,  249,  278,  278,  278,  278,  254,
 /*  3070 */   255,  256,  257,  258,  278,  260,  278,   75,  278,  278,
 /*  3080 */   192,  278,  278,  278,  269,  270,  271,  272,  273,  278,
 /*  3090 */   148,  278,  278,  151,  152,  278,  154,  155,  278,  211,
 /*  3100 */   212,  278,  160,  278,  162,  163,  278,  278,  166,  278,
 /*  3110 */   168,  169,  170,  171,  172,  173,  278,  175,  278,  177,
 /*  3120 */   278,  179,  278,  181,  278,  183,  278,  278,  278,  187,
 /*  3130 */   278,  189,  190,  278,  192,  247,  194,  249,  278,  278,
 /*  3140 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /*  3150 */   278,  263,  210,  211,  278,  278,  278,  215,  216,  217,
 /*  3160 */   218,  278,  220,  221,  278,  278,  224,  278,  278,   11,
 /*  3170 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*  3180 */    22,  278,  278,  278,  278,  278,  278,  278,  278,  247,
 /*  3190 */   278,  249,  278,  278,  278,  278,  254,  255,  256,  257,
 /*  3200 */   258,  278,  260,  278,  278,  278,  278,   49,   50,  278,
 /*  3210 */   278,  269,  270,  271,  272,  273,  278,  278,  148,  278,
 /*  3220 */   278,  151,  152,  278,  154,  155,  278,  278,  278,  278,
 /*  3230 */   160,  278,  162,  163,   76,  278,  166,  278,  168,  169,
 /*  3240 */   170,  171,  172,  173,  278,  175,  278,  177,  278,  179,
 /*  3250 */   278,  181,  278,  183,  278,  278,  186,  187,  278,  278,
 /*  3260 */   190,  278,  192,  278,  194,  278,  278,  278,   11,   12,
 /*  3270 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*  3280 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /*  3290 */   220,  221,  278,  278,  224,   61,  278,  278,  278,  278,
 /*  3300 */   278,  278,  278,  278,  278,  278,   49,   50,  278,  278,
 /*  3310 */   278,   77,   78,  278,  278,  278,  278,  247,  278,  249,
 /*  3320 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /*  3330 */   260,   97,  278,  278,  100,  278,  278,  278,  278,  269,
 /*  3340 */   270,  271,  272,  273,    1,    2,    3,    4,    5,  278,
 /*  3350 */    93,  278,  278,   10,  278,  278,  278,  278,   40,   41,
 /*  3360 */   278,  278,  278,  129,  130,  131,  132,  133,  134,  135,
 /*  3370 */   278,  137,   29,  278,  278,  141,  278,  278,  278,  278,
 /*  3380 */   278,  278,  278,   40,   41,  278,  278,  278,  278,   46,
 /*  3390 */   278,   48,   49,   50,   51,   52,   53,  278,   55,   56,
 /*  3400 */    57,   58,   59,   60,  278,   62,   63,  278,  278,  278,
 /*  3410 */   278,  278,  278,  278,  278,   97,  278,   74,  100,  278,
 /*  3420 */   278,  278,  278,  278,  278,  278,  108,  109,  110,  111,
 /*  3430 */   112,  113,  114,  115,  116,  278,  278,  278,  278,  278,
 /*  3440 */    97,  278,  278,  100,  126,  278,  278,  278,  105,  106,
 /*  3450 */   107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*  3460 */   172,    1,    2,    3,    4,    5,  278,  278,  278,  126,
 /*  3470 */    10,  278,  278,  278,  278,  278,  278,  278,  278,  136,
 /*  3480 */   192,  138,  139,  140,  141,  142,  278,  278,  278,   29,
 /*  3490 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  211,
 /*  3500 */    40,   41,  278,  278,  278,  278,   46,  278,   48,   49,
 /*  3510 */    50,   51,   52,   53,  278,   55,   56,   57,   58,   59,
 /*  3520 */    60,  278,   62,   63,  278,  278,  278,  278,   67,   68,
 /*  3530 */    69,   70,   71,   72,   74,  247,  278,  249,  278,   78,
 /*  3540 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /*  3550 */   278,  263,  278,  278,  278,  278,  278,   97,  278,  278,
 /*  3560 */   100,  278,  278,  278,  278,  105,  106,  107,  108,  109,
 /*  3570 */   110,  111,  112,  113,  114,  115,  116,  278,    1,    2,
 /*  3580 */     3,    4,    5,  278,  278,  278,  126,   10,  127,  128,
 /*  3590 */   278,  278,  278,  278,  278,  278,  136,  278,  138,  139,
 /*  3600 */   140,  141,  142,  278,  278,  278,   29,  278,  278,  278,
 /*  3610 */    67,   68,   69,   70,   71,   72,  278,   40,   41,  278,
 /*  3620 */   278,   78,  278,   46,  278,   48,   49,   50,   51,   52,
 /*  3630 */    53,  278,   55,   56,   57,   58,   59,   60,  278,   62,
 /*  3640 */    63,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  3650 */   278,   74,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  3660 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  3670 */   127,  128,  278,  278,   97,  278,  278,  100,  278,  278,
 /*  3680 */   278,  278,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  3690 */   113,  114,  115,  116,  278,    1,    2,    3,    4,    5,
 /*  3700 */   278,  278,  278,  126,   10,  278,  278,  278,  278,  278,
 /*  3710 */   278,  278,  278,  136,  278,  138,  139,  140,  141,  142,
 /*  3720 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  3730 */   278,  278,  278,  278,   40,   41,  278,  278,  278,  278,
 /*  3740 */    46,  278,   48,   49,   50,   51,   52,   53,  278,   55,
 /*  3750 */    56,   57,   58,   59,   60,  278,   62,   63,  278,  278,
 /*  3760 */   278,  278,  278,  278,  278,  278,  278,  278,   74,   75,
 /*  3770 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  3780 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  3790 */   278,   97,  278,  278,  100,  278,  278,  278,  278,  105,
 /*  3800 */   106,  107,  108,  109,  110,  111,  112,  113,  114,  115,
 /*  3810 */   116,  278,    1,    2,    3,    4,    5,  278,  278,  278,
 /*  3820 */   126,   10,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  3830 */   136,  278,  138,  139,  140,  141,  142,  278,  278,  278,
 /*  3840 */    29,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  3850 */   278,   40,   41,  278,  278,  278,  278,   46,  278,   48,
 /*  3860 */    49,   50,   51,   52,   53,  278,   55,   56,   57,   58,
 /*  3870 */    59,   60,  278,   62,   63,  278,  278,  278,  278,  278,
 /*  3880 */   278,  278,  278,  278,  278,   74,  278,  278,  278,  278,
 /*  3890 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  3900 */   278,  278,  278,  278,  278,  278,  278,  278,   97,  278,
 /*  3910 */   278,  100,  278,  278,  278,  278,  105,  106,  107,  108,
 /*  3920 */   109,  110,  111,  112,  113,  114,  115,  116,  278,    1,
 /*  3930 */     2,    3,    4,    5,  278,  278,  278,  126,   10,  278,
 /*  3940 */   278,  278,  278,  278,  278,  278,  278,  136,  278,  138,
 /*  3950 */   139,  140,  141,  142,  278,  278,  278,  278,  278,  278,
 /*  3960 */   278,  278,  278,  278,  278,  278,  278,  278,   40,   41,
 /*  3970 */   278,  278,  278,  278,   46,  278,   48,   49,   50,   51,
 /*  3980 */    52,   53,  278,   55,   56,   57,   58,   59,   60,  278,
 /*  3990 */    62,   63,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4000 */   278,  278,   74,  278,   76,  278,  278,  278,  278,  278,
 /*  4010 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4020 */   278,  278,  278,  278,  278,   97,  278,  278,  100,  278,
 /*  4030 */   278,  278,  278,  105,  106,  107,  108,  109,  110,  111,
 /*  4040 */   112,  113,  114,  115,  116,  278,    1,    2,    3,    4,
 /*  4050 */     5,  278,  278,  278,  126,   10,  278,  278,  278,  278,
 /*  4060 */   278,  278,  278,  278,  136,  278,  138,  139,  140,  141,
 /*  4070 */   142,  278,  278,  278,   29,  278,  278,  278,  278,  278,
 /*  4080 */   278,  278,  278,  278,  278,   40,   41,  278,  278,  278,
 /*  4090 */   278,   46,  278,   48,   49,   50,   51,   52,   53,  278,
 /*  4100 */    55,   56,   57,   58,   59,   60,  278,   62,   63,  278,
 /*  4110 */   278,  278,  278,  278,  278,  278,  278,  278,  278,   74,
 /*  4120 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4130 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4140 */   278,  278,   97,  278,  278,  100,  278,  278,  278,  278,
 /*  4150 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*  4160 */   115,  116,  278,    1,    2,    3,    4,    5,  278,  278,
 /*  4170 */   278,  126,   10,  278,  278,  278,  278,  278,  278,  278,
 /*  4180 */   278,  136,  278,  138,  139,  140,  141,  142,  278,  278,
 /*  4190 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4200 */   278,  278,   40,   41,  278,  278,  278,  278,   46,  278,
 /*  4210 */    48,   49,   50,   51,   52,   53,  278,   55,   56,   57,
 /*  4220 */    58,   59,   60,  278,   62,   63,  278,  278,  278,  278,
 /*  4230 */   278,  278,  278,  278,  278,  278,   74,  278,   76,  278,
 /*  4240 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4250 */   278,  278,  278,  278,  278,  278,  278,  278,  278,   97,
 /*  4260 */   278,  278,  100,  278,  278,  278,  278,  105,  106,  107,
 /*  4270 */   108,  109,  110,  111,  112,  113,  114,  115,  116,  278,
 /*  4280 */     1,    2,    3,    4,    5,  278,  278,  278,  126,   10,
 /*  4290 */   278,  278,  278,  278,  278,  278,  278,  278,  136,  278,
 /*  4300 */   138,  139,  140,  141,  142,  278,  278,  278,   29,  278,
 /*  4310 */   278,  278,  278,  278,  278,  278,  278,  278,  278,   40,
 /*  4320 */    41,  278,  278,  278,  278,   46,  278,   48,   49,   50,
 /*  4330 */    51,   52,   53,  278,   55,   56,   57,   58,   59,   60,
 /*  4340 */   278,   62,   63,  278,  278,  278,  278,  278,  278,  278,
 /*  4350 */   278,  278,  278,   74,  278,  278,  278,  278,  278,  278,
 /*  4360 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4370 */   278,  278,  278,  278,  278,  278,   97,  278,  278,  100,
 /*  4380 */   278,  278,  278,  278,  105,  106,  107,  108,  109,  110,
 /*  4390 */   111,  112,  113,  114,  115,  116,  278,    1,    2,    3,
 /*  4400 */     4,    5,  278,  278,  278,  126,   10,  278,  278,  278,
 /*  4410 */   278,  278,  278,  278,  278,  136,  278,  138,  139,  140,
 /*  4420 */   141,  142,  278,  278,  278,   29,  278,  278,  278,  278,
 /*  4430 */   278,  278,  278,  278,  278,  278,   40,   41,  278,  278,
 /*  4440 */   278,  278,   46,  278,   48,   49,   50,   51,   52,   53,
 /*  4450 */   278,   55,   56,   57,   58,   59,   60,  278,   62,   63,
 /*  4460 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4470 */    74,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4480 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4490 */   278,  278,  278,   97,  278,  278,  100,  278,  278,  278,
 /*  4500 */   278,  105,  106,  107,  108,  109,  110,  111,  112,  113,
 /*  4510 */   114,  115,  116,  278,    1,    2,    3,    4,    5,  278,
 /*  4520 */   278,  278,  126,   10,  278,  278,  278,  278,  278,  278,
 /*  4530 */   278,  278,  136,  278,  138,  139,  140,  141,  142,  278,
 /*  4540 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4550 */   278,  278,  278,   40,   41,  278,  278,  278,  172,   46,
 /*  4560 */   278,   48,   49,   50,   51,   52,   53,  278,   55,   56,
 /*  4570 */    57,   58,   59,   60,  278,   62,   63,  278,  192,  278,
 /*  4580 */   278,  278,  278,  278,  278,  278,  278,   74,  278,   76,
 /*  4590 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4600 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4610 */    97,  278,  278,  100,  278,  278,  230,  278,  105,  106,
 /*  4620 */   107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*  4630 */   278,  278,  278,  247,  278,  249,  278,  278,  278,  126,
 /*  4640 */   254,  255,  256,  257,  258,  278,  260,  278,  278,  136,
 /*  4650 */   278,  138,  139,  140,  141,  142,  148,  278,  278,  151,
 /*  4660 */   152,  278,  154,  155,  278,  278,  172,  278,  160,  278,
 /*  4670 */   162,  163,  278,  278,  166,  278,  168,  169,  170,  171,
 /*  4680 */   172,  173,  278,  175,  278,  177,  192,  179,  278,  181,
 /*  4690 */   278,  183,  278,  278,  278,  187,  278,  278,  190,  278,
 /*  4700 */   192,  278,  194,  278,  278,  278,  278,  278,  278,  278,
 /*  4710 */   278,  217,  278,  278,  278,  278,  278,  278,  210,  211,
 /*  4720 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /*  4730 */   278,  278,  224,  278,  278,  278,  278,  278,  278,  278,
 /*  4740 */   278,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /*  4750 */   256,  257,  258,  278,  260,  247,  278,  249,  278,  278,
 /*  4760 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /*  4770 */   278,  278,  278,  278,  278,  278,  278,  269,  270,  271,
 /*  4780 */   272,  273,  278,  278,  278,  278,  278,  278,  148,  278,
 /*  4790 */   278,  151,  152,  278,  154,  155,  172,  278,  278,  278,
 /*  4800 */   160,  278,  162,  163,  278,  278,  166,  278,  168,  169,
 /*  4810 */   170,  171,  172,  173,  278,  175,  192,  177,  278,  179,
 /*  4820 */   278,  181,  278,  183,  278,  278,  278,  187,  278,  278,
 /*  4830 */   190,  278,  192,  278,  194,  278,  278,  278,  278,  278,
 /*  4840 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4850 */   210,  211,  278,  278,  230,  215,  216,  217,  218,  278,
 /*  4860 */   220,  221,  278,  278,  224,  278,  278,  278,  278,  278,
 /*  4870 */   278,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /*  4880 */   256,  257,  258,  278,  260,  278,  278,  247,  278,  249,
 /*  4890 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /*  4900 */   260,  278,  278,  278,  278,  278,  278,  278,  278,  269,
 /*  4910 */   270,  271,  272,  273,  148,  278,  278,  151,  152,  278,
 /*  4920 */   154,  155,  172,  278,  278,  278,  160,  278,  162,  163,
 /*  4930 */   278,  278,  166,  278,  168,  169,  170,  171,  172,  173,
 /*  4940 */   278,  175,  192,  177,  278,  179,  278,  181,  278,  183,
 /*  4950 */   278,  278,  278,  187,  278,  278,  190,  278,  192,  278,
 /*  4960 */   194,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  4970 */   278,  278,  278,  278,  278,  278,  210,  211,  278,  278,
 /*  4980 */   230,  215,  216,  217,  218,  278,  220,  221,  278,  278,
 /*  4990 */   224,  278,  278,  278,  278,  278,  278,  247,  278,  249,
 /*  5000 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /*  5010 */   260,  278,  278,  247,  278,  249,  278,  278,  278,  278,
 /*  5020 */   254,  255,  256,  257,  258,  278,  260,  278,  278,  278,
 /*  5030 */   278,  278,  278,  278,  278,  269,  270,  271,  272,  273,
 /*  5040 */   278,  278,  278,  148,  278,  278,  151,  152,  278,  154,
 /*  5050 */   155,  278,  278,  172,  278,  160,  278,  162,  163,  278,
 /*  5060 */   278,  166,  278,  168,  169,  170,  171,  172,  173,  278,
 /*  5070 */   175,  278,  177,  192,  179,  278,  181,  278,  183,  278,
 /*  5080 */   278,  278,  187,  278,  278,  190,  278,  192,  278,  194,
 /*  5090 */   278,  210,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  5100 */   278,  278,  278,  278,  278,  210,  211,  278,  278,  278,
 /*  5110 */   215,  216,  217,  218,  278,  220,  221,  278,  278,  224,
 /*  5120 */   278,  278,  278,  278,  278,  278,  278,  278,  247,  278,
 /*  5130 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /*  5140 */   278,  260,  247,  278,  249,  278,  278,  278,  278,  254,
 /*  5150 */   255,  256,  257,  258,  278,  260,  278,  278,  278,  278,
 /*  5160 */   278,  278,  278,  278,  269,  270,  271,  272,  273,  148,
 /*  5170 */   278,  278,  151,  152,  278,  154,  155,  172,  278,  278,
 /*  5180 */   278,  160,  278,  162,  163,  278,  278,  166,  278,  168,
 /*  5190 */   169,  170,  171,  172,  173,  278,  175,  192,  177,  278,
 /*  5200 */   179,  278,  181,  278,  183,  278,  278,  278,  187,  278,
 /*  5210 */   278,  190,  278,  192,  278,  194,  278,  278,  278,  278,
 /*  5220 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  5230 */   278,  210,  211,  278,  278,  230,  215,  216,  217,  218,
 /*  5240 */   278,  220,  221,  278,  278,  224,  278,  278,  278,  278,
 /*  5250 */   278,  278,  247,  278,  249,  278,  278,  278,  278,  254,
 /*  5260 */   255,  256,  257,  258,  278,  260,  278,  278,  247,  278,
 /*  5270 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /*  5280 */   278,  260,  278,  278,  278,  278,  278,    7,    8,    9,
 /*  5290 */   269,  270,  271,  272,  273,    1,    2,    3,    4,    5,
 /*  5300 */   278,  278,  278,   23,   10,   25,   26,   27,   28,   29,
 /*  5310 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*  5320 */    40,   41,   42,   43,   44,   45,  278,   47,  278,  278,
 /*  5330 */   278,  278,  278,  278,   40,   41,  278,  278,  278,  278,
 /*  5340 */    46,  278,   48,   49,   50,   51,   52,   53,  278,   55,
 /*  5350 */    56,   57,   58,   59,   60,   75,   62,   63,  278,  278,
 /*  5360 */   278,  278,  172,  278,  278,  278,  278,  278,   74,  278,
 /*  5370 */   278,  278,  182,  278,  278,  278,  278,  278,  278,  278,
 /*  5380 */   278,  278,  192,  278,  278,  278,  278,  278,  278,  278,
 /*  5390 */   278,   97,  278,  278,  100,  278,  278,  278,  278,  105,
 /*  5400 */   106,  107,  108,  109,  110,  111,  112,  113,  114,  115,
 /*  5410 */   116,  172,    1,    2,    3,    4,    5,  278,  278,  278,
 /*  5420 */   126,   10,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  5430 */   136,  192,  138,  139,  140,  141,  142,  247,  248,  249,
 /*  5440 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /*  5450 */   260,   40,   41,  278,  278,  278,  278,   46,  278,   48,
 /*  5460 */    49,   50,   51,   52,   53,  278,   55,   56,   57,   58,
 /*  5470 */    59,   60,  278,   62,   63,  278,  278,  278,  278,  278,
 /*  5480 */   278,  278,  278,  278,  278,   74,  247,  278,  249,  278,
 /*  5490 */   278,  278,  278,  254,  255,  256,  257,  258,  278,  260,
 /*  5500 */   278,  278,  278,  278,  278,  278,  278,  268,   97,  278,
 /*  5510 */   278,  100,  278,  278,  278,  278,  105,  106,  107,  108,
 /*  5520 */   109,  110,  111,  112,  113,  114,  115,  116,   61,  278,
 /*  5530 */   278,  278,  278,  278,  278,  278,  278,  126,  278,  278,
 /*  5540 */   278,  278,  278,  278,   77,   78,  278,  136,  278,  138,
 /*  5550 */   139,  140,  141,  142,  278,  155,  278,  278,  278,  278,
 /*  5560 */   278,  278,  278,  278,   97,  278,  278,  100,  278,  278,
 /*  5570 */    61,  171,  172,  278,  107,  278,  278,  278,  278,  278,
 /*  5580 */   278,  278,  278,  278,  278,  278,   77,   78,  278,  278,
 /*  5590 */   278,  278,  192,  278,  278,  278,  129,  130,  131,  132,
 /*  5600 */   133,  134,  135,  278,  137,  278,   97,  278,  278,  100,
 /*  5610 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /*  5620 */   220,  221,  278,  278,  224,  278,  278,  278,  278,  278,
 /*  5630 */   172,  278,  278,  278,  278,  235,  236,  278,  129,  130,
 /*  5640 */   131,  132,  133,  134,  135,  278,  137,  247,  278,  249,
 /*  5650 */   192,  278,  143,  278,  254,  255,  256,  257,  258,  278,
 /*  5660 */   260,  278,    7,    8,    9,  278,  278,  278,  278,  269,
 /*  5670 */   270,  271,  272,  273,  278,  217,  278,  278,   23,   24,
 /*  5680 */    25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
 /*  5690 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  5700 */    45,  278,   47,  155,  278,  247,  278,  249,  278,  278,
 /*  5710 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  171,
 /*  5720 */   172,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  5730 */   278,   76,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  5740 */   192,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  5750 */   278,  278,  278,  278,  278,  278,  278,  278,  210,  211,
 /*  5760 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /*  5770 */   278,  278,  224,  155,  278,  278,  278,  278,  278,  278,
 /*  5780 */   278,  278,  278,  235,  236,  278,  278,  278,  278,  171,
 /*  5790 */   172,  278,  278,  278,  278,  247,  278,  249,  278,  278,
 /*  5800 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /*  5810 */   192,  278,  278,  278,  278,  278,  278,  269,  270,  271,
 /*  5820 */   272,  273,  278,  278,  278,  278,  278,  278,  210,  211,
 /*  5830 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /*  5840 */   155,  278,  224,  278,  278,  278,  278,  278,  278,  192,
 /*  5850 */   278,  278,  278,  235,  236,  278,  171,  172,  278,  278,
 /*  5860 */   278,  278,  278,  278,  278,  247,  278,  249,  278,  278,
 /*  5870 */   278,  278,  254,  255,  256,  257,  258,  192,  260,  278,
 /*  5880 */   278,  224,  225,  226,  278,  228,  278,  269,  270,  271,
 /*  5890 */   272,  273,  278,  278,  278,  210,  211,  278,  278,  278,
 /*  5900 */   215,  216,  217,  218,  247,  220,  221,  278,  278,  224,
 /*  5910 */   278,  254,  255,  256,  155,  278,  278,  260,  278,  278,
 /*  5920 */   235,  236,  278,  164,  278,  278,  278,  278,  278,  278,
 /*  5930 */   171,  172,  247,  278,  249,  278,  278,  278,  278,  254,
 /*  5940 */   255,  256,  257,  258,  278,  260,  278,  278,  278,  278,
 /*  5950 */   278,  192,  278,  278,  269,  270,  271,  272,  273,  278,
 /*  5960 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  210,
 /*  5970 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /*  5980 */   221,  278,  278,  224,  155,  278,  278,  278,  278,  278,
 /*  5990 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6000 */   171,  172,  278,  278,  278,  278,  247,  278,  249,  278,
 /*  6010 */   278,  278,  278,  254,  255,  256,  257,  258,  278,  260,
 /*  6020 */   278,  192,  278,  278,  278,  278,  278,  278,  269,  270,
 /*  6030 */   271,  272,  273,  278,  278,  278,  277,  278,  278,  210,
 /*  6040 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /*  6050 */   221,  155,  278,  224,  278,  278,  278,  278,  278,  278,
 /*  6060 */   164,  278,  278,  278,  235,  236,  278,  171,  172,  278,
 /*  6070 */   278,  278,  278,  278,  278,  278,  247,  278,  249,  278,
 /*  6080 */   278,  278,  278,  254,  255,  256,  257,  258,  192,  260,
 /*  6090 */   278,  278,  278,  278,  278,  278,  278,  278,  269,  270,
 /*  6100 */   271,  272,  273,  278,  278,  278,  210,  211,  278,  278,
 /*  6110 */   278,  215,  216,  217,  218,  278,  220,  221,  278,  278,
 /*  6120 */   224,  278,  278,  278,  278,  155,  278,  278,  278,  278,
 /*  6130 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6140 */   278,  171,  172,  247,  278,  249,  278,  278,  278,  278,
 /*  6150 */   254,  255,  256,  257,  258,  278,  260,  278,  278,  278,
 /*  6160 */   278,  278,  192,  278,  278,  269,  270,  271,  272,  273,
 /*  6170 */   278,  278,  278,  277,  278,  278,  278,  278,  278,  278,
 /*  6180 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /*  6190 */   220,  221,  222,  278,  224,  155,  278,  278,  278,  278,
 /*  6200 */   278,  278,  278,  278,  164,  278,  278,  278,  278,  278,
 /*  6210 */   278,  171,  172,  278,  278,  278,  278,  247,  278,  249,
 /*  6220 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /*  6230 */   260,  278,  192,  278,  264,  278,  278,  278,  278,  269,
 /*  6240 */   270,  271,  272,  273,  278,  278,  278,  278,  278,  278,
 /*  6250 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /*  6260 */   220,  221,  278,  278,  224,  278,  278,  155,  278,  278,
 /*  6270 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6280 */   278,  278,  278,  171,  172,  278,  278,  247,  278,  249,
 /*  6290 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /*  6300 */   260,  278,  278,  278,  192,  278,  278,  278,  278,  269,
 /*  6310 */   270,  271,  272,  273,  278,  278,  278,  277,  278,  278,
 /*  6320 */   278,  278,  210,  211,  278,  278,  278,  215,  216,  217,
 /*  6330 */   218,  278,  220,  221,  278,  278,  224,  278,  278,  278,
 /*  6340 */   278,  278,  172,  278,  278,  278,  278,  235,  236,  278,
 /*  6350 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  247,
 /*  6360 */   278,  249,  192,  278,  278,  278,  254,  255,  256,  257,
 /*  6370 */   258,  278,  260,  278,    7,    8,    9,  278,  278,  278,
 /*  6380 */   278,  269,  270,  271,  272,  273,  278,  278,  278,  278,
 /*  6390 */    23,  278,   25,   26,   27,   28,   29,   30,   31,   32,
 /*  6400 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*  6410 */    43,   44,   45,  278,   47,  278,  278,  247,  278,  249,
 /*  6420 */   278,  278,  278,   61,  254,  255,  256,  257,  258,  172,
 /*  6430 */   260,  278,  278,  278,  278,  278,  278,  278,  278,   77,
 /*  6440 */    78,  278,   75,  278,  278,  278,  278,  278,  278,  192,
 /*  6450 */     7,    8,    9,  278,  278,  278,  278,  278,  278,   97,
 /*  6460 */   278,  278,  100,  278,  278,  278,   23,  278,   25,   26,
 /*  6470 */    27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /*  6480 */    37,   38,   39,   40,   41,   42,   43,   44,   45,  278,
 /*  6490 */    47,  129,  130,  131,  132,  133,  134,  135,  278,  137,
 /*  6500 */   172,  278,  140,  278,  247,  278,  249,  278,  278,  278,
 /*  6510 */   278,  254,  255,  256,  257,  258,  278,  260,  278,   76,
 /*  6520 */   192,  278,  278,  278,  278,  278,  278,    7,    8,    9,
 /*  6530 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6540 */   278,  278,  278,   23,  278,   25,   26,   27,   28,   29,
 /*  6550 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*  6560 */    40,   41,   42,   43,   44,   45,  278,   47,  278,  278,
 /*  6570 */   278,  278,  278,  172,  278,  247,  278,  249,  278,  278,
 /*  6580 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /*  6590 */   278,  278,  278,  192,  278,   75,  278,  278,  278,  278,
 /*  6600 */   278,  278,  278,    7,    8,    9,  278,  278,  278,  278,
 /*  6610 */   278,  278,  278,  278,  278,  278,  278,  278,  278,   23,
 /*  6620 */   278,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  6630 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  6640 */    44,   45,  278,   47,    7,    8,    9,  278,  247,  278,
 /*  6650 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /*  6660 */    23,  260,   25,   26,   27,   28,   29,   30,   31,   32,
 /*  6670 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*  6680 */    43,   44,   45,  278,   47,  278,  172,  278,  278,  278,
 /*  6690 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6700 */   278,  278,  278,  278,  278,  278,  192,  278,  278,  278,
 /*  6710 */   278,  278,   75,  278,  278,  278,  278,  278,  278,  278,
 /*  6720 */     7,    8,    9,  278,  278,  278,  130,  278,  278,  278,
 /*  6730 */   278,  278,  278,  278,  278,  278,   23,  278,   25,   26,
 /*  6740 */    27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /*  6750 */    37,   38,   39,   40,   41,   42,   43,   44,   45,  278,
 /*  6760 */    47,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /*  6770 */   256,  257,  258,  278,  260,  278,  278,  278,  278,  278,
 /*  6780 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6790 */   278,   78,  278,  278,  278,  278,  278,  278,  278,    7,
 /*  6800 */     8,    9,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6810 */   278,  278,  278,  278,  278,   23,  278,   25,   26,   27,
 /*  6820 */    28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
 /*  6830 */    38,   39,   40,   41,   42,   43,   44,   45,  278,   47,
 /*  6840 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6850 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6860 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6870 */    78,  278,  278,  278,  278,  278,  278,  278,    7,    8,
 /*  6880 */     9,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6890 */   278,  278,  278,  278,   23,  278,   25,   26,   27,   28,
 /*  6900 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  6910 */    39,   40,   41,   42,   43,   44,   45,  278,   47,    7,
 /*  6920 */     8,    9,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6930 */   278,  278,  278,  278,  278,   23,  278,   25,   26,   27,
 /*  6940 */    28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
 /*  6950 */    38,   39,   40,   41,   42,   43,   44,   45,  278,   47,
 /*  6960 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6970 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  6980 */   278,  278,  278,  278,  278,  278,  278,   75,  117,  278,
 /*  6990 */   278,  278,  278,  278,  278,    7,    8,    9,  278,  278,
 /*  7000 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7010 */   278,   23,  278,   25,   26,   27,   28,   29,   30,   31,
 /*  7020 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*  7030 */    42,   43,   44,   45,  278,   47,  278,  278,  278,  278,
 /*  7040 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7050 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7060 */   278,  278,  278,  278,   76,  278,  278,  278,  278,  278,
 /*  7070 */   278,  278,    7,    8,    9,  278,  278,  278,  278,  278,
 /*  7080 */   278,  278,  278,  278,  278,  278,  278,  278,   23,  278,
 /*  7090 */    25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
 /*  7100 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  7110 */    45,  278,   47,  278,  278,  278,  278,  278,  278,  278,
 /*  7120 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7130 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7140 */   278,  278,  278,   78,  278,  278,  278,  278,  278,  278,
 /*  7150 */   278,    7,    8,    9,  278,  278,  278,  278,  278,  278,
 /*  7160 */   278,  278,  278,  278,  278,  278,  278,   23,  278,   25,
 /*  7170 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  7180 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  7190 */   278,   47,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7200 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7210 */   278,  278,  278,  278,  278,  278,  278,  278,  278,   75,
 /*  7220 */   278,  278,  278,  278,  278,  278,  278,    7,    8,    9,
 /*  7230 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7240 */   278,  278,  278,   23,  278,   25,   26,   27,   28,   29,
 /*  7250 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*  7260 */    40,   41,   42,   43,   44,   45,  278,   47,  278,  278,
 /*  7270 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7280 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7290 */   278,  278,  278,  278,  278,  278,  278,  278,   78,  278,
 /*  7300 */   278,  278,  278,  278,  278,  278,    7,    8,    9,  278,
 /*  7310 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7320 */   278,  278,   23,  278,   25,   26,   27,   28,   29,   30,
 /*  7330 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  7340 */    41,   42,   43,   44,   45,  278,   47,  278,  278,  278,
 /*  7350 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7360 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7370 */   278,  278,  278,  278,  278,  278,  278,   78,  278,  278,
 /*  7380 */   278,  278,  278,  278,  278,    7,    8,    9,  278,  278,
 /*  7390 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7400 */   278,   23,  278,   25,   26,   27,   28,   29,   30,   31,
 /*  7410 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*  7420 */    42,   43,   44,   45,  278,   47,  278,  278,  278,  278,
 /*  7430 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7440 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7450 */   278,  278,  278,   75,  278,  278,  278,  278,  278,  278,
 /*  7460 */   278,    7,    8,    9,  278,  278,  278,  278,  278,  278,
 /*  7470 */   278,  278,  278,  278,  278,  278,  278,   23,  278,   25,
 /*  7480 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  7490 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  7500 */   278,   47,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7510 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7520 */   278,  278,  278,  278,  278,  278,  278,  278,  278,   75,
 /*  7530 */   278,  278,  278,  278,  278,  278,  278,    7,    8,    9,
 /*  7540 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7550 */   278,  278,  278,   23,  278,   25,   26,   27,   28,   29,
 /*  7560 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*  7570 */    40,   41,   42,   43,   44,   45,  278,   47,  278,  278,
 /*  7580 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7590 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7600 */   278,  278,  278,  278,  278,  278,   76,  278,  278,  278,
 /*  7610 */   278,  278,  278,  278,    7,    8,    9,  278,  278,  278,
 /*  7620 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7630 */    23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*  7640 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*  7650 */    43,   44,   45,  278,   47,    7,    8,    9,  278,  278,
 /*  7660 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7670 */   278,   23,  278,   25,   26,   27,   28,   29,   30,   31,
 /*  7680 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*  7690 */    42,   43,   44,   45,  278,   47,    7,    8,    9,  278,
 /*  7700 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7710 */   278,  278,   23,  278,   25,   26,   27,   28,   29,   30,
 /*  7720 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  7730 */    41,   42,   43,   44,   45,  278,   47,  278,  278,  278,
 /*  7740 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7750 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7760 */   278,  278,  278,  278,  278,  117,  278,   78,  278,  278,
 /*  7770 */   278,  278,  278,    7,    8,    9,  278,  278,  278,  278,
 /*  7780 */   278,  278,  278,  278,  278,  278,  278,  278,  278,   23,
 /*  7790 */   278,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  7800 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  7810 */    44,   45,  278,   47,  278,  278,  278,  278,  278,  278,
 /*  7820 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7830 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7840 */   278,   75,  278,  278,  278,  278,  278,  278,  278,    7,
 /*  7850 */     8,    9,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7860 */   278,  278,  278,  278,  278,   23,  278,   25,   26,   27,
 /*  7870 */    28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
 /*  7880 */    38,   39,   40,   41,   42,   43,   44,   45,  278,   47,
 /*  7890 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7900 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7910 */   278,  278,  278,  278,  278,  278,  278,  278,   76,  278,
 /*  7920 */   278,  278,  278,  278,  278,  278,    7,    8,    9,  278,
 /*  7930 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7940 */   278,  278,   23,  278,   25,   26,   27,   28,   29,   30,
 /*  7950 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  7960 */    41,   42,   43,   44,   45,  155,   47,  278,  278,  278,
 /*  7970 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  7980 */   278,  171,  172,  278,  278,  278,  278,  278,  178,  278,
 /*  7990 */   278,  278,  278,  278,   75,  278,  278,  278,  278,  278,
 /*  8000 */   278,  278,  192,  278,  278,  278,  278,  278,  278,  278,
 /*  8010 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8020 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /*  8030 */   220,  221,  155,  278,  224,  278,  278,  278,  278,  278,
 /*  8040 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /*  8050 */   278,  278,  278,  278,  278,  278,  278,  247,  278,  249,
 /*  8060 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  192,
 /*  8070 */   260,  278,  278,  278,  278,  278,  278,  278,  278,  269,
 /*  8080 */   270,  271,  272,  273,  278,  278,  278,  210,  211,  278,
 /*  8090 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  278,
 /*  8100 */   278,  224,  155,  278,  278,  278,  278,  278,  278,  278,
 /*  8110 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /*  8120 */   278,  278,  278,  278,  247,  278,  249,  278,  278,  278,
 /*  8130 */   278,  254,  255,  256,  257,  258,  259,  260,  278,  192,
 /*  8140 */   278,  278,  278,  278,  278,  278,  269,  270,  271,  272,
 /*  8150 */   273,  278,  278,  278,  278,  278,  278,  210,  211,  278,
 /*  8160 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  278,
 /*  8170 */   278,  224,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8180 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8190 */   278,  278,  278,  172,  247,  278,  249,  278,  278,  278,
 /*  8200 */   278,  254,  255,  256,  257,  258,  259,  260,  278,    7,
 /*  8210 */     8,    9,  278,  192,  278,  278,  269,  270,  271,  272,
 /*  8220 */   273,  278,  278,  278,  278,   23,  278,   25,   26,   27,
 /*  8230 */    28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
 /*  8240 */    38,   39,   40,   41,   42,   43,   44,   45,  155,   47,
 /*  8250 */   278,  230,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8260 */   278,  278,  278,  278,  171,  172,  278,  278,  247,  278,
 /*  8270 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /*  8280 */   278,  260,  278,  278,  278,  192,  278,  278,  278,  278,
 /*  8290 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8300 */   278,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /*  8310 */   217,  218,  278,  220,  221,  278,  278,  224,  155,  278,
 /*  8320 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8330 */   278,  278,  278,  278,  171,  172,  278,  278,  278,  278,
 /*  8340 */   247,  278,  249,  278,  278,  278,  278,  254,  255,  256,
 /*  8350 */   257,  258,  278,  260,  278,  192,  278,  278,  278,  278,
 /*  8360 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /*  8370 */   278,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /*  8380 */   217,  218,  278,  220,  221,  155,  278,  224,  278,  278,
 /*  8390 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8400 */   278,  171,  172,  278,  278,  278,  278,  278,  278,  278,
 /*  8410 */   247,  278,  249,  278,  278,  278,  278,  254,  255,  256,
 /*  8420 */   257,  258,  192,  260,  278,  278,  278,  278,  278,  278,
 /*  8430 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /*  8440 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /*  8450 */   220,  221,  278,  278,  224,  278,  278,  278,  278,  155,
 /*  8460 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8470 */   278,  278,  278,  278,  278,  171,  172,  247,  278,  249,
 /*  8480 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /*  8490 */   260,  278,  278,  278,  278,  278,  192,  278,  278,  269,
 /*  8500 */   270,  271,  272,  273,  278,  278,  278,  278,  278,  278,
 /*  8510 */   278,  278,  278,  278,  210,  211,  278,  278,  278,  215,
 /*  8520 */   216,  217,  218,  278,  220,  221,  278,  278,  224,  155,
 /*  8530 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8540 */   278,  278,  278,  278,  278,  171,  172,  278,  278,  278,
 /*  8550 */   278,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /*  8560 */   256,  257,  258,  278,  260,  278,  192,  278,  278,  278,
 /*  8570 */   278,  278,  278,  269,  270,  271,  272,  273,  278,  278,
 /*  8580 */   278,  278,  278,  278,  210,  211,  278,  278,  278,  215,
 /*  8590 */   216,  217,  218,  278,  220,  221,  155,  278,  224,  278,
 /*  8600 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8610 */   278,  278,  171,  172,  278,  278,  278,  278,  278,  278,
 /*  8620 */   278,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /*  8630 */   256,  257,  258,  192,  260,  278,  278,  278,  278,  278,
 /*  8640 */   278,  278,  278,  269,  270,  271,  272,  273,  278,  278,
 /*  8650 */   278,  210,  211,  278,  278,  278,  215,  216,  217,  218,
 /*  8660 */   278,  220,  221,  278,  278,  224,  278,  278,  278,  278,
 /*  8670 */   155,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8680 */   278,  278,  278,  278,  278,  278,  171,  172,  247,  278,
 /*  8690 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /*  8700 */   278,  260,  278,  278,  278,  278,  278,  192,  278,  278,
 /*  8710 */   269,  270,  271,  272,  273,  278,  278,  278,  278,  278,
 /*  8720 */   278,  278,  278,  278,  278,  210,  211,  278,  278,  278,
 /*  8730 */   215,  216,  217,  218,  278,  220,  221,  278,  278,  224,
 /*  8740 */   155,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8750 */   278,  278,  278,  278,  278,  278,  171,  172,  278,  278,
 /*  8760 */   278,  278,  247,  278,  249,  278,  278,  278,  278,  254,
 /*  8770 */   255,  256,  257,  258,  278,  260,  278,  192,  278,  278,
 /*  8780 */   278,  278,  278,  278,  269,  270,  271,  272,  273,  278,
 /*  8790 */   278,  278,  278,  278,  278,  210,  211,  278,  278,  278,
 /*  8800 */   215,  216,  217,  218,  278,  220,  221,  155,  278,  224,
 /*  8810 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8820 */   278,  278,  278,  171,  172,  278,  278,  278,  278,  278,
 /*  8830 */   278,  278,  247,  278,  249,  278,  278,  278,  278,  254,
 /*  8840 */   255,  256,  257,  258,  192,  260,  278,  278,  278,  278,
 /*  8850 */   278,  278,  278,  278,  269,  270,  271,  272,  273,  278,
 /*  8860 */   278,  278,  210,  211,  278,  278,  278,  215,  216,  217,
 /*  8870 */   218,  278,  220,  221,  278,  278,  224,  278,  278,  278,
 /*  8880 */   278,  155,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8890 */   278,  278,  278,  278,  278,  278,  278,  171,  172,  247,
 /*  8900 */   278,  249,  278,  278,  278,  278,  254,  255,  256,  257,
 /*  8910 */   258,  278,  260,  278,  278,  278,  278,  278,  192,  278,
 /*  8920 */   278,  269,  270,  271,  272,  273,  278,  278,  278,  278,
 /*  8930 */   278,  278,  278,  278,  278,  278,  210,  211,  278,  278,
 /*  8940 */   278,  215,  216,  217,  218,  278,  220,  221,  278,  278,
 /*  8950 */   224,  155,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  8960 */   278,  278,  278,  278,  278,  278,  278,  171,  172,  278,
 /*  8970 */   278,  278,  278,  247,  278,  249,  278,  278,  278,  278,
 /*  8980 */   254,  255,  256,  257,  258,  278,  260,  278,  192,  278,
 /*  8990 */   278,  278,  278,  278,  278,  269,  270,  271,  272,  273,
 /*  9000 */   278,  278,  278,  278,  278,  278,  210,  211,  278,  278,
 /*  9010 */   278,  215,  216,  217,  218,  278,  220,  221,  155,  278,
 /*  9020 */   224,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  9030 */   278,  278,  278,  278,  171,  172,  278,  278,  278,  278,
 /*  9040 */   278,  278,  278,  247,  278,  249,  278,  278,  278,  278,
 /*  9050 */   254,  255,  256,  257,  258,  192,  260,  278,  278,  278,
 /*  9060 */   278,  278,  278,  278,  278,  269,  270,  271,  272,  273,
 /*  9070 */   278,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /*  9080 */   217,  218,  278,  220,  221,  278,  278,  224,  278,  278,
 /*  9090 */   278,  278,  155,  278,  278,  278,  278,  278,  278,  278,
 /*  9100 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /*  9110 */   247,  278,  249,  278,  278,  278,  278,  254,  255,  256,
 /*  9120 */   257,  258,  278,  260,  278,  278,  278,  278,  278,  192,
 /*  9130 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /*  9140 */   278,  278,  278,  278,  278,  278,  278,  210,  211,  278,
 /*  9150 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  278,
 /*  9160 */   278,  224,  155,  278,  278,  278,  278,  278,  278,  278,
 /*  9170 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /*  9180 */   278,  278,  278,  278,  247,  278,  249,  278,  278,  278,
 /*  9190 */   278,  254,  255,  256,  257,  258,  278,  260,  278,  192,
 /*  9200 */   278,  278,  278,  278,  278,  278,  269,  270,  271,  272,
 /*  9210 */   273,  278,  278,  278,  278,  278,  278,  210,  211,  278,
 /*  9220 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  155,
 /*  9230 */   278,  224,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  9240 */   278,  278,  278,  278,  278,  171,  172,  278,  278,  278,
 /*  9250 */   278,  278,  278,  278,  247,  278,  249,  278,  278,  278,
 /*  9260 */   278,  254,  255,  256,  257,  258,  192,  260,  278,  278,
 /*  9270 */   278,  278,  278,  278,  278,  278,  269,  270,  271,  272,
 /*  9280 */   273,  278,  278,  278,  210,  211,  278,  278,  278,  215,
 /*  9290 */   216,  217,  218,  278,  220,  221,  278,  278,  224,  278,
 /*  9300 */   278,  278,  278,  155,  278,  278,  278,  278,  278,  278,
 /*  9310 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  171,
 /*  9320 */   172,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /*  9330 */   256,  257,  258,  278,  260,  278,  278,  278,  278,  278,
 /*  9340 */   192,  278,  278,  269,  270,  271,  272,  273,  278,  278,
 /*  9350 */   278,  278,  278,  278,  278,  278,  278,  278,  210,  211,
 /*  9360 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /*  9370 */   278,  278,  224,  155,  278,  278,  278,  278,  278,  278,
 /*  9380 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  171,
 /*  9390 */   172,  278,  278,  278,  278,  247,  278,  249,  278,  278,
 /*  9400 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /*  9410 */   192,  278,  278,  278,  278,  278,  278,  269,  270,  271,
 /*  9420 */   272,  273,  278,  278,  278,  278,  278,  278,  210,  211,
 /*  9430 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /*  9440 */   155,  278,  224,  278,  278,  278,  278,  278,  278,  278,
 /*  9450 */   278,  278,  278,  278,  278,  278,  171,  172,  278,  278,
 /*  9460 */   278,  278,  278,  278,  278,  247,  278,  249,  278,  278,
 /*  9470 */   278,  278,  254,  255,  256,  257,  258,  192,  260,  278,
 /*  9480 */   278,  278,  278,  278,  278,  278,  278,  269,  270,  271,
 /*  9490 */   272,  273,  278,  278,  278,  210,  211,  278,  278,  278,
 /*  9500 */   215,  216,  217,  218,  278,  220,  221,  278,  278,  224,
 /*  9510 */   278,  278,  278,  278,  155,  278,  278,  278,  278,  278,
 /*  9520 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  9530 */   171,  172,  247,  278,  249,  278,  278,  278,  278,  254,
 /*  9540 */   255,  256,  257,  258,  278,  260,  278,  278,  278,  278,
 /*  9550 */   278,  192,  278,  278,  269,  270,  271,  272,  273,  278,
 /*  9560 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  210,
 /*  9570 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /*  9580 */   221,  278,  278,  224,  155,  278,  278,  278,  278,  278,
 /*  9590 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  9600 */   171,  172,  278,  278,  278,  278,  247,  278,  249,  278,
 /*  9610 */   278,  278,  278,  254,  255,  256,  257,  258,  278,  260,
 /*  9620 */   278,  192,  278,  278,  278,  278,  278,  278,  269,  270,
 /*  9630 */   271,  272,  273,  278,  278,  278,  278,  278,  278,  210,
 /*  9640 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /*  9650 */   221,  155,  278,  224,  278,  278,  278,  278,  278,  278,
 /*  9660 */   278,  278,  278,  278,  278,  278,  278,  171,  172,  278,
 /*  9670 */   278,  278,  278,  278,  278,  278,  247,  278,  249,  278,
 /*  9680 */   278,  278,  278,  254,  255,  256,  257,  258,  192,  260,
 /*  9690 */   278,  278,  278,  278,  278,  278,  278,  278,  269,  270,
 /*  9700 */   271,  272,  273,  278,  278,  278,  210,  211,  278,  278,
 /*  9710 */   278,  215,  216,  217,  218,  278,  220,  221,  278,  278,
 /*  9720 */   224,  278,  278,  278,  278,  155,  278,  278,  278,  278,
 /*  9730 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  9740 */   278,  171,  172,  247,  278,  249,  278,  278,  278,  278,
 /*  9750 */   254,  255,  256,  257,  258,  278,  260,  278,  278,  278,
 /*  9760 */   278,  278,  192,  278,  278,  269,  270,  271,  272,  273,
 /*  9770 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  9780 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /*  9790 */   220,  221,  278,  278,  224,  155,  278,  278,  278,  278,
 /*  9800 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  9810 */   278,  171,  172,  278,  278,  278,  278,  247,  278,  249,
 /*  9820 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /*  9830 */   260,  278,  192,  278,  278,  278,  278,  278,  278,  269,
 /*  9840 */   270,  271,  272,  273,  278,  278,  278,  278,  278,  278,
 /*  9850 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /*  9860 */   220,  221,  155,  278,  224,  278,  278,  278,  278,  278,
 /*  9870 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /*  9880 */   278,  278,  278,  278,  278,  278,  278,  247,  278,  249,
 /*  9890 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  192,
 /*  9900 */   260,  278,  278,  278,  278,  278,  278,  278,  278,  269,
 /*  9910 */   270,  271,  272,  273,  278,  278,  278,  210,  211,  278,
 /*  9920 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  278,
 /*  9930 */   278,  224,  278,  278,  278,  278,  155,  278,  278,  278,
 /*  9940 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  9950 */   278,  278,  171,  172,  247,  278,  249,  278,  278,  278,
 /*  9960 */   278,  254,  255,  256,  257,  258,  278,  260,  278,  278,
 /*  9970 */   278,  278,  278,  192,  278,  278,  269,  270,  271,  272,
 /*  9980 */   273,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  9990 */   278,  210,  211,  278,  278,  278,  215,  216,  217,  218,
 /* 10000 */   278,  220,  221,  278,  278,  224,  155,  278,  278,  278,
 /* 10010 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10020 */   278,  278,  171,  172,  278,  278,  278,  278,  247,  278,
 /* 10030 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /* 10040 */   278,  260,  278,  192,  278,  278,  278,  278,  278,  278,
 /* 10050 */   269,  270,  271,  272,  273,  278,  278,  278,  278,  278,
 /* 10060 */   278,  210,  211,  278,  278,  278,  215,  216,  217,  218,
 /* 10070 */   278,  220,  221,  155,  278,  224,  278,  278,  278,  278,
 /* 10080 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  171,
 /* 10090 */   172,  278,  278,  278,  278,  278,  278,  278,  247,  278,
 /* 10100 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /* 10110 */   192,  260,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10120 */   269,  270,  271,  272,  273,  278,  278,  278,  210,  211,
 /* 10130 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /* 10140 */   278,  278,  224,  278,  278,  278,  278,  155,  278,  278,
 /* 10150 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10160 */   278,  278,  278,  171,  172,  247,  278,  249,  278,  278,
 /* 10170 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /* 10180 */   278,  278,  278,  278,  192,  278,  278,  269,  270,  271,
 /* 10190 */   272,  273,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10200 */   278,  278,  210,  211,  278,  278,  278,  215,  216,  217,
 /* 10210 */   218,  278,  220,  221,  278,  278,  224,  155,  278,  278,
 /* 10220 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10230 */   278,  278,  278,  171,  172,  278,  278,  278,  278,  247,
 /* 10240 */   278,  249,  278,  278,  278,  278,  254,  255,  256,  257,
 /* 10250 */   258,  278,  260,  278,  192,  278,  278,  278,  278,  278,
 /* 10260 */   278,  269,  270,  271,  272,  273,  278,  278,  278,  278,
 /* 10270 */   278,  278,  210,  211,  278,  278,  278,  215,  216,  217,
 /* 10280 */   218,  278,  220,  221,  155,  278,  224,  278,  278,  278,
 /* 10290 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10300 */   171,  172,  278,  278,  278,  278,  278,  278,  278,  247,
 /* 10310 */   278,  249,  278,  278,  278,  278,  254,  255,  256,  257,
 /* 10320 */   258,  192,  260,  278,  278,  278,  278,  278,  278,  278,
 /* 10330 */   278,  269,  270,  271,  272,  273,  278,  278,  278,  210,
 /* 10340 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /* 10350 */   221,  278,  278,  224,  278,  278,  278,  278,  155,  278,
 /* 10360 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10370 */   278,  278,  278,  278,  171,  172,  247,  278,  249,  278,
 /* 10380 */   278,  278,  278,  254,  255,  256,  257,  258,  278,  260,
 /* 10390 */   278,  278,  278,  278,  278,  192,  278,  278,  269,  270,
 /* 10400 */   271,  272,  273,  278,  278,  278,  278,  278,  278,  278,
 /* 10410 */   278,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /* 10420 */   217,  218,  278,  220,  221,  278,  278,  224,  155,  278,
 /* 10430 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10440 */   278,  278,  278,  278,  171,  172,  278,  278,  278,  278,
 /* 10450 */   247,  278,  249,  278,  278,  278,  278,  254,  255,  256,
 /* 10460 */   257,  258,  278,  260,  278,  192,  278,  278,  278,  278,
 /* 10470 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /* 10480 */   278,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /* 10490 */   217,  218,  278,  220,  221,  155,  278,  224,  278,  278,
 /* 10500 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10510 */   278,  171,  172,  278,  278,  278,  278,  278,  278,  278,
 /* 10520 */   247,  278,  249,  278,  278,  278,  278,  254,  255,  256,
 /* 10530 */   257,  258,  192,  260,  278,  278,  278,  278,  278,  278,
 /* 10540 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /* 10550 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /* 10560 */   220,  221,  278,  278,  224,  278,  278,  278,  278,  155,
 /* 10570 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10580 */   278,  278,  278,  278,  278,  171,  172,  247,  278,  249,
 /* 10590 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /* 10600 */   260,  278,  278,  278,  278,  278,  192,  278,  278,  269,
 /* 10610 */   270,  271,  272,  273,  278,  278,  278,  278,  278,  278,
 /* 10620 */   278,  278,  278,  278,  210,  211,  278,  278,  278,  215,
 /* 10630 */   216,  217,  218,  278,  220,  221,  278,  278,  224,  155,
 /* 10640 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10650 */   278,  278,  278,  278,  278,  171,  172,  278,  278,  278,
 /* 10660 */   278,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /* 10670 */   256,  257,  258,  278,  260,  278,  192,  278,  278,  278,
 /* 10680 */   278,  278,  278,  269,  270,  271,  272,  273,  278,  278,
 /* 10690 */   278,  278,  278,  278,  210,  211,  278,  278,  278,  215,
 /* 10700 */   216,  217,  218,  278,  220,  221,  155,  278,  224,  278,
 /* 10710 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10720 */   278,  278,  171,  172,  278,  278,  278,  278,  278,  278,
 /* 10730 */   278,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /* 10740 */   256,  257,  258,  192,  260,  278,  278,  278,  278,  278,
 /* 10750 */   278,  278,  278,  269,  270,  271,  272,  273,  278,  278,
 /* 10760 */   278,  210,  211,  278,  278,  278,  215,  216,  217,  218,
 /* 10770 */   278,  220,  221,  278,  278,  224,  278,  278,  278,  278,
 /* 10780 */   155,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10790 */   278,  278,  278,  278,  278,  278,  171,  172,  247,  278,
 /* 10800 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /* 10810 */   278,  260,  278,  278,  278,  278,  278,  192,  278,  278,
 /* 10820 */   269,  270,  271,  272,  273,  278,  278,  278,  278,  278,
 /* 10830 */   278,  278,  278,  278,  278,  210,  211,  278,  278,  278,
 /* 10840 */   215,  216,  217,  218,  278,  220,  221,  278,  278,  224,
 /* 10850 */   155,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10860 */   278,  278,  278,  278,  278,  278,  171,  172,  278,  278,
 /* 10870 */   278,  278,  247,  278,  249,  278,  278,  278,  278,  254,
 /* 10880 */   255,  256,  257,  258,  278,  260,  278,  192,  278,  278,
 /* 10890 */   278,  278,  278,  278,  269,  270,  271,  272,  273,  278,
 /* 10900 */   278,  278,  278,  278,  278,  210,  211,  278,  278,  278,
 /* 10910 */   215,  216,  217,  218,  278,  220,  221,  155,  278,  224,
 /* 10920 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 10930 */   278,  278,  278,  171,  172,  278,  278,  278,  278,  278,
 /* 10940 */   278,  278,  247,  278,  249,  278,  278,  278,  278,  254,
 /* 10950 */   255,  256,  257,  258,  192,  260,  278,  278,  278,  278,
 /* 10960 */   278,  278,  278,  278,  269,  270,  271,  272,  273,  278,
 /* 10970 */   278,  278,  210,  211,  278,  278,  278,  215,  216,  217,
 /* 10980 */   218,  278,  220,  221,  278,  278,  224,  278,  278,  278,
 /* 10990 */   278,  155,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 11000 */   278,  278,  278,  278,  278,  278,  278,  171,  172,  247,
 /* 11010 */   278,  249,  278,  278,  278,  278,  254,  255,  256,  257,
 /* 11020 */   258,  278,  260,  278,  278,  278,  278,  278,  192,  278,
 /* 11030 */   278,  269,  270,  271,  272,  273,  278,  278,  278,  278,
 /* 11040 */   278,  278,  278,  278,  278,  278,  210,  211,  278,  278,
 /* 11050 */   278,  215,  216,  217,  218,  278,  220,  221,  278,  278,
 /* 11060 */   224,  155,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 11070 */   278,  278,  278,  278,  278,  278,  278,  171,  172,  278,
 /* 11080 */   278,  278,  278,  247,  278,  249,  278,  278,  278,  278,
 /* 11090 */   254,  255,  256,  257,  258,  278,  260,  278,  192,  278,
 /* 11100 */   278,  278,  278,  278,  278,  269,  270,  271,  272,  273,
 /* 11110 */   278,  278,  278,  278,  278,  278,  210,  211,  278,  278,
 /* 11120 */   278,  215,  216,  217,  218,  278,  220,  221,  155,  278,
 /* 11130 */   224,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 11140 */   278,  278,  278,  278,  171,  172,  278,  278,  278,  278,
 /* 11150 */   278,  278,  278,  247,  278,  249,  278,  278,  278,  278,
 /* 11160 */   254,  255,  256,  257,  258,  192,  260,  278,  278,  278,
 /* 11170 */   278,  278,  278,  278,  278,  269,  270,  271,  272,  273,
 /* 11180 */   278,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /* 11190 */   217,  218,  278,  220,  221,  278,  278,  224,  278,  278,
 /* 11200 */   278,  278,  155,  278,  278,  278,  278,  278,  278,  278,
 /* 11210 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /* 11220 */   247,  278,  249,  278,  278,  278,  278,  254,  255,  256,
 /* 11230 */   257,  258,  278,  260,  278,  278,  278,  278,  278,  192,
 /* 11240 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /* 11250 */   278,  278,  278,  278,  278,  278,  278,  210,  211,  278,
 /* 11260 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  278,
 /* 11270 */   278,  224,  155,  278,  278,  278,  278,  278,  278,  278,
 /* 11280 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /* 11290 */   278,  278,  278,  278,  247,  278,  249,  278,  278,  278,
 /* 11300 */   278,  254,  255,  256,  257,  258,  278,  260,  278,  192,
 /* 11310 */   278,  278,  278,  278,  278,  278,  269,  270,  271,  272,
 /* 11320 */   273,  278,  278,  278,  278,  278,  278,  210,  211,  278,
 /* 11330 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  155,
 /* 11340 */   278,  224,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 11350 */   278,  278,  278,  278,  278,  171,  172,  278,  278,  278,
 /* 11360 */   278,  278,  278,  278,  247,  278,  249,  278,  278,  278,
 /* 11370 */   278,  254,  255,  256,  257,  258,  192,  260,  278,  278,
 /* 11380 */   278,  278,  278,  278,  278,  278,  269,  270,  271,  272,
 /* 11390 */   273,  278,  278,  278,  210,  211,  278,  278,  278,  215,
 /* 11400 */   216,  217,  218,  278,  220,  221,  278,  278,  224,  278,
 /* 11410 */   278,  278,  278,  155,  278,  278,  278,  278,  278,  278,
 /* 11420 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  171,
 /* 11430 */   172,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /* 11440 */   256,  257,  258,  278,  260,  278,  278,  278,  278,  278,
 /* 11450 */   192,  278,  278,  269,  270,  271,  272,  273,  278,  278,
 /* 11460 */   278,  278,  278,  278,  278,  278,  278,  278,  210,  211,
 /* 11470 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /* 11480 */   278,  278,  224,  155,  278,  278,  278,  278,  278,  278,
 /* 11490 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  171,
 /* 11500 */   172,  278,  278,  278,  278,  247,  278,  249,  278,  278,
 /* 11510 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /* 11520 */   192,  278,  278,  278,  278,  278,  278,  269,  270,  271,
 /* 11530 */   272,  273,  278,  278,  278,  278,  278,  278,  210,  211,
 /* 11540 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /* 11550 */   155,  278,  224,  278,  278,  278,  278,  278,  278,  278,
 /* 11560 */   278,  278,  278,  278,  278,  278,  171,  172,  278,  278,
 /* 11570 */   278,  278,  278,  278,  278,  247,  278,  249,  278,  278,
 /* 11580 */   278,  278,  254,  255,  256,  257,  258,  192,  260,  278,
 /* 11590 */   278,  278,  278,  278,  278,  278,  278,  269,  270,  271,
 /* 11600 */   272,  273,  278,  278,  278,  210,  211,  278,  278,  278,
 /* 11610 */   215,  216,  217,  218,  278,  220,  221,  278,  278,  224,
 /* 11620 */   278,  278,  278,  278,  155,  278,  278,  278,  278,  278,
 /* 11630 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 11640 */   171,  172,  247,  278,  249,  278,  278,  278,  278,  254,
 /* 11650 */   255,  256,  257,  258,  278,  260,  278,  278,  278,  278,
 /* 11660 */   278,  192,  278,  278,  269,  270,  271,  272,  273,  278,
 /* 11670 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  210,
 /* 11680 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /* 11690 */   221,  278,  278,  224,  155,  278,  278,  278,  278,  278,
 /* 11700 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 11710 */   171,  172,  278,  278,  278,  278,  247,  278,  249,  278,
 /* 11720 */   278,  278,  278,  254,  255,  256,  257,  258,  278,  260,
 /* 11730 */   278,  192,  278,  278,  278,  278,  278,  278,  269,  270,
 /* 11740 */   271,  272,  273,  278,  278,  278,  278,  278,  278,  210,
 /* 11750 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /* 11760 */   221,  155,  278,  224,  278,  278,  278,  278,  278,  278,
 /* 11770 */   278,  278,  278,  278,  278,  278,  278,  171,  172,  278,
 /* 11780 */   278,  278,  278,  278,  278,  278,  247,  278,  249,  278,
 /* 11790 */   278,  278,  278,  254,  255,  256,  257,  258,  192,  260,
 /* 11800 */   278,  278,  278,  278,  278,  278,  278,  278,  269,  270,
 /* 11810 */   271,  272,  273,  278,  278,  278,  210,  211,  278,  278,
 /* 11820 */   278,  215,  216,  217,  218,  278,  220,  221,  278,  278,
 /* 11830 */   224,  278,  278,  278,  278,  155,  278,  278,  278,  278,
 /* 11840 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 11850 */   278,  171,  172,  247,  278,  249,  278,  278,  278,  278,
 /* 11860 */   254,  255,  256,  257,  258,  278,  260,  278,  278,  278,
 /* 11870 */   278,  278,  192,  278,  278,  269,  270,  271,  272,  273,
 /* 11880 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 11890 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /* 11900 */   220,  221,  278,  278,  224,  155,  278,  278,  278,  278,
 /* 11910 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 11920 */   278,  171,  172,  278,  278,  278,  278,  247,  278,  249,
 /* 11930 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /* 11940 */   260,  278,  192,  278,  278,  278,  278,  278,  278,  269,
 /* 11950 */   270,  271,  272,  273,  278,  278,  278,  278,  278,  278,
 /* 11960 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /* 11970 */   220,  221,  155,  278,  224,  278,  278,  278,  278,  278,
 /* 11980 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /* 11990 */   278,  278,  278,  278,  278,  278,  278,  247,  278,  249,
 /* 12000 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  192,
 /* 12010 */   260,  278,  278,  278,  278,  278,  278,  278,  278,  269,
 /* 12020 */   270,  271,  272,  273,  278,  278,  278,  210,  211,  278,
 /* 12030 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  278,
 /* 12040 */   278,  224,  278,  278,  278,  278,  155,  278,  278,  278,
 /* 12050 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12060 */   278,  278,  171,  172,  247,  278,  249,  278,  278,  278,
 /* 12070 */   278,  254,  255,  256,  257,  258,  278,  260,  278,  278,
 /* 12080 */   278,  278,  278,  192,  278,  278,  269,  270,  271,  272,
 /* 12090 */   273,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12100 */   278,  210,  211,  278,  278,  278,  215,  216,  217,  218,
 /* 12110 */   278,  220,  221,  278,  278,  224,  155,  278,  278,  278,
 /* 12120 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12130 */   278,  278,  171,  172,  278,  278,  278,  278,  247,  278,
 /* 12140 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /* 12150 */   278,  260,  278,  192,  278,  278,  278,  278,  278,  278,
 /* 12160 */   269,  270,  271,  272,  273,  278,  278,  278,  278,  278,
 /* 12170 */   278,  210,  211,  278,  278,  278,  215,  216,  217,  218,
 /* 12180 */   278,  220,  221,  155,  278,  224,  278,  278,  278,  278,
 /* 12190 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  171,
 /* 12200 */   172,  278,  278,  278,  278,  278,  278,  278,  247,  278,
 /* 12210 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /* 12220 */   192,  260,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12230 */   269,  270,  271,  272,  273,  278,  278,  278,  210,  211,
 /* 12240 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /* 12250 */   278,  278,  224,  278,  278,  278,  278,  155,  278,  278,
 /* 12260 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12270 */   278,  278,  278,  171,  172,  247,  278,  249,  278,  278,
 /* 12280 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /* 12290 */   278,  278,  278,  278,  192,  278,  278,  269,  270,  271,
 /* 12300 */   272,  273,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12310 */   278,  278,  210,  211,  278,  278,  278,  215,  216,  217,
 /* 12320 */   218,  278,  220,  221,  278,  278,  224,  155,  278,  278,
 /* 12330 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12340 */   278,  278,  278,  171,  172,  278,  278,  278,  278,  247,
 /* 12350 */   278,  249,  278,  278,  278,  278,  254,  255,  256,  257,
 /* 12360 */   258,  278,  260,  278,  192,  278,  278,  278,  278,  278,
 /* 12370 */   278,  269,  270,  271,  272,  273,  278,  278,  278,  278,
 /* 12380 */   278,  278,  210,  211,  278,  278,  278,  215,  216,  217,
 /* 12390 */   218,  278,  220,  221,  155,  278,  224,  278,  278,  278,
 /* 12400 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12410 */   171,  172,  278,  278,  278,  278,  278,  278,  278,  247,
 /* 12420 */   278,  249,  278,  278,  278,  278,  254,  255,  256,  257,
 /* 12430 */   258,  192,  260,  278,  278,  278,  278,  278,  278,  278,
 /* 12440 */   278,  269,  270,  271,  272,  273,  278,  278,  278,  210,
 /* 12450 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /* 12460 */   221,  278,  278,  224,  278,  278,  278,  278,  155,  278,
 /* 12470 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12480 */   278,  278,  278,  278,  171,  172,  247,  278,  249,  278,
 /* 12490 */   278,  278,  278,  254,  255,  256,  257,  258,  278,  260,
 /* 12500 */   278,  278,  278,  278,  278,  192,  278,  278,  269,  270,
 /* 12510 */   271,  272,  273,  278,  278,  278,  278,  278,  278,  278,
 /* 12520 */   278,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /* 12530 */   217,  218,  278,  220,  221,  278,  278,  224,  155,  278,
 /* 12540 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12550 */   278,  278,  278,  278,  171,  172,  278,  278,  278,  278,
 /* 12560 */   247,  278,  249,  278,  278,  278,  278,  254,  255,  256,
 /* 12570 */   257,  258,  278,  260,  278,  192,  278,  278,  278,  278,
 /* 12580 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /* 12590 */   278,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /* 12600 */   217,  218,  278,  220,  221,  155,  278,  224,  278,  278,
 /* 12610 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12620 */   278,  171,  172,  278,  278,  278,  278,  278,  278,  278,
 /* 12630 */   247,  278,  249,  278,  278,  278,  278,  254,  255,  256,
 /* 12640 */   257,  258,  192,  260,  278,  278,  278,  278,  278,  278,
 /* 12650 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /* 12660 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /* 12670 */   220,  221,  278,  278,  224,  278,  278,  278,  278,  155,
 /* 12680 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12690 */   278,  278,  278,  278,  278,  171,  172,  247,  278,  249,
 /* 12700 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /* 12710 */   260,  278,  278,  278,  278,  278,  192,  278,  278,  269,
 /* 12720 */   270,  271,  272,  273,  278,  278,  278,  278,  278,  278,
 /* 12730 */   278,  278,  278,  278,  210,  211,  278,  278,  278,  215,
 /* 12740 */   216,  217,  218,  278,  220,  221,  278,  278,  224,  155,
 /* 12750 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12760 */   278,  278,  278,  278,  278,  171,  172,  278,  278,  278,
 /* 12770 */   278,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /* 12780 */   256,  257,  258,  278,  260,  278,  192,  278,  278,  278,
 /* 12790 */   278,  278,  278,  269,  270,  271,  272,  273,  278,  278,
 /* 12800 */   278,  278,  278,  278,  210,  211,  278,  278,  278,  215,
 /* 12810 */   216,  217,  218,  278,  220,  221,  155,  278,  224,  278,
 /* 12820 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12830 */   278,  278,  171,  172,  278,  278,  278,  278,  278,  278,
 /* 12840 */   278,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /* 12850 */   256,  257,  258,  192,  260,  278,  278,  278,  278,  278,
 /* 12860 */   278,  278,  278,  269,  270,  271,  272,  273,  278,  278,
 /* 12870 */   278,  210,  211,  278,  278,  278,  215,  216,  217,  218,
 /* 12880 */   278,  220,  221,  278,  278,  224,  278,  278,  278,  278,
 /* 12890 */   155,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12900 */   278,  278,  278,  278,  278,  278,  171,  172,  247,  278,
 /* 12910 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /* 12920 */   278,  260,  278,  278,  278,  278,  278,  192,  278,  278,
 /* 12930 */   269,  270,  271,  272,  273,  278,  278,  278,  278,  278,
 /* 12940 */   278,  278,  278,  278,  278,  210,  211,  278,  278,  278,
 /* 12950 */   215,  216,  217,  218,  278,  220,  221,  278,  278,  224,
 /* 12960 */   155,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 12970 */   278,  278,  278,  278,  278,  278,  171,  172,  278,  278,
 /* 12980 */   278,  278,  247,  278,  249,  278,  278,  278,  278,  254,
 /* 12990 */   255,  256,  257,  258,  278,  260,  278,  192,  278,  278,
 /* 13000 */   278,  278,  278,  278,  269,  270,  271,  272,  273,  278,
 /* 13010 */   278,  278,  278,  278,  278,  210,  211,  278,  278,  278,
 /* 13020 */   215,  216,  217,  218,  278,  220,  221,  155,  278,  224,
 /* 13030 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 13040 */   278,  278,  278,  171,  172,  278,  278,  278,  278,  278,
 /* 13050 */   278,  278,  247,  278,  249,  278,  278,  278,  278,  254,
 /* 13060 */   255,  256,  257,  258,  192,  260,  278,  278,  278,  278,
 /* 13070 */   278,  278,  278,  278,  269,  270,  271,  272,  273,  278,
 /* 13080 */   278,  278,  210,  211,  278,  278,  278,  215,  216,  217,
 /* 13090 */   218,  278,  220,  221,  278,  278,  224,  278,  278,  278,
 /* 13100 */   278,  155,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 13110 */   278,  278,  278,  278,  278,  278,  278,  171,  172,  247,
 /* 13120 */   278,  249,  278,  278,  278,  278,  254,  255,  256,  257,
 /* 13130 */   258,  278,  260,  278,  278,  278,  278,  278,  192,  278,
 /* 13140 */   278,  269,  270,  271,  272,  273,  278,  278,  278,  278,
 /* 13150 */   278,  278,  278,  278,  278,  278,  210,  211,  278,  278,
 /* 13160 */   278,  215,  216,  217,  218,  278,  220,  221,  278,  278,
 /* 13170 */   224,  155,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 13180 */   278,  278,  278,  278,  278,  278,  278,  171,  172,  278,
 /* 13190 */   278,  278,  278,  247,  278,  249,  278,  278,  278,  278,
 /* 13200 */   254,  255,  256,  257,  258,  278,  260,  278,  192,  278,
 /* 13210 */   278,  278,  278,  278,  278,  269,  270,  271,  272,  273,
 /* 13220 */   278,  278,  278,  278,  278,  278,  210,  211,  278,  278,
 /* 13230 */   278,  215,  216,  217,  218,  278,  220,  221,  155,  278,
 /* 13240 */   224,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 13250 */   278,  278,  278,  278,  171,  172,  278,  278,  278,  278,
 /* 13260 */   278,  278,  278,  247,  278,  249,  278,  278,  278,  278,
 /* 13270 */   254,  255,  256,  257,  258,  192,  260,  278,  278,  278,
 /* 13280 */   278,  278,  278,  278,  278,  269,  270,  271,  272,  273,
 /* 13290 */   278,  278,  278,  210,  211,  278,  278,  278,  215,  216,
 /* 13300 */   217,  218,  278,  220,  221,  278,  278,  224,  278,  278,
 /* 13310 */   278,  278,  155,  278,  278,  278,  278,  278,  278,  278,
 /* 13320 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /* 13330 */   247,  278,  249,  278,  278,  278,  278,  254,  255,  256,
 /* 13340 */   257,  258,  278,  260,  278,  278,  278,  278,  278,  192,
 /* 13350 */   278,  278,  269,  270,  271,  272,  273,  278,  278,  278,
 /* 13360 */   278,  278,  278,  278,  278,  278,  278,  210,  211,  278,
 /* 13370 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  278,
 /* 13380 */   278,  224,  155,  278,  278,  278,  278,  278,  278,  278,
 /* 13390 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /* 13400 */   278,  278,  278,  278,  247,  278,  249,  278,  278,  278,
 /* 13410 */   278,  254,  255,  256,  257,  258,  278,  260,  278,  192,
 /* 13420 */   278,  278,  278,  278,  278,  278,  269,  270,  271,  272,
 /* 13430 */   273,  278,  278,  278,  278,  278,  278,  210,  211,  278,
 /* 13440 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  155,
 /* 13450 */   278,  224,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 13460 */   278,  278,  278,  278,  278,  171,  172,  278,  278,  278,
 /* 13470 */   278,  278,  278,  278,  247,  278,  249,  278,  278,  278,
 /* 13480 */   278,  254,  255,  256,  257,  258,  192,  260,  278,  278,
 /* 13490 */   278,  278,  278,  278,  278,  278,  269,  270,  271,  272,
 /* 13500 */   273,  278,  278,  278,  210,  211,  278,  278,  278,  215,
 /* 13510 */   216,  217,  218,  278,  220,  221,  278,  278,  224,  278,
 /* 13520 */   278,  278,  278,  155,  278,  278,  278,  278,  278,  278,
 /* 13530 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  171,
 /* 13540 */   172,  247,  278,  249,  278,  278,  278,  278,  254,  255,
 /* 13550 */   256,  257,  258,  278,  260,  278,  278,  278,  278,  278,
 /* 13560 */   192,  278,  278,  269,  270,  271,  272,  273,  278,  278,
 /* 13570 */   278,  278,  278,  278,  278,  278,  278,  278,  210,  211,
 /* 13580 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /* 13590 */   278,  278,  224,  155,  278,  278,  278,  278,  278,  278,
 /* 13600 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  171,
 /* 13610 */   172,  278,  278,  278,  278,  247,  278,  249,  278,  278,
 /* 13620 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /* 13630 */   192,  278,  278,  278,  278,  278,  278,  269,  270,  271,
 /* 13640 */   272,  273,  278,  278,  278,  278,  278,  278,  210,  211,
 /* 13650 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /* 13660 */   155,  278,  224,  278,  278,  278,  278,  278,  278,  278,
 /* 13670 */   278,  278,  278,  278,  278,  278,  171,  172,  278,  278,
 /* 13680 */   278,  278,  278,  278,  278,  247,  278,  249,  278,  278,
 /* 13690 */   278,  278,  254,  255,  256,  257,  258,  192,  260,  278,
 /* 13700 */   278,  278,  278,  278,  278,  278,  278,  269,  270,  271,
 /* 13710 */   272,  273,  278,  278,  278,  210,  211,  278,  278,  278,
 /* 13720 */   215,  216,  217,  218,  278,  220,  221,  278,  278,  224,
 /* 13730 */   278,  278,  278,  278,  155,  278,  278,  278,  278,  278,
 /* 13740 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 13750 */   171,  172,  247,  278,  249,  278,  278,  278,  278,  254,
 /* 13760 */   255,  256,  257,  258,  278,  260,  278,  278,  278,  278,
 /* 13770 */   278,  192,  278,  278,  269,  270,  271,  272,  273,  278,
 /* 13780 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  210,
 /* 13790 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /* 13800 */   221,  278,  278,  224,  155,  278,  278,  278,  278,  278,
 /* 13810 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 13820 */   171,  172,  278,  278,  278,  278,  247,  278,  249,  278,
 /* 13830 */   278,  278,  278,  254,  255,  256,  257,  258,  278,  260,
 /* 13840 */   278,  192,  278,  278,  278,  278,  278,  278,  269,  270,
 /* 13850 */   271,  272,  273,  278,  278,  278,  278,  278,  278,  210,
 /* 13860 */   211,  278,  278,  278,  215,  216,  217,  218,  278,  220,
 /* 13870 */   221,  155,  278,  224,  278,  278,  278,  278,  278,  278,
 /* 13880 */   278,  278,  278,  278,  278,  278,  278,  171,  172,  278,
 /* 13890 */   278,  278,  278,  278,  278,  278,  247,  278,  249,  278,
 /* 13900 */   278,  278,  278,  254,  255,  256,  257,  258,  192,  260,
 /* 13910 */   278,  278,  278,  278,  278,  278,  278,  278,  269,  270,
 /* 13920 */   271,  272,  273,  278,  278,  278,  210,  211,  278,  278,
 /* 13930 */   278,  215,  216,  217,  218,  278,  220,  221,  278,  278,
 /* 13940 */   224,  278,  278,  278,  278,  155,  278,  278,  278,  278,
 /* 13950 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 13960 */   278,  171,  172,  247,  278,  249,  278,  278,  278,  278,
 /* 13970 */   254,  255,  256,  257,  258,  278,  260,  278,  278,  278,
 /* 13980 */   278,  278,  192,  278,  278,  269,  270,  271,  272,  273,
 /* 13990 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14000 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /* 14010 */   220,  221,  278,  278,  224,  155,  278,  278,  278,  278,
 /* 14020 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14030 */   278,  171,  172,  278,  278,  278,  278,  247,  278,  249,
 /* 14040 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /* 14050 */   260,  278,  192,  278,  278,  278,  278,  278,  278,  269,
 /* 14060 */   270,  271,  272,  273,  278,  278,  278,  278,  278,  278,
 /* 14070 */   210,  211,  278,  278,  278,  215,  216,  217,  218,  278,
 /* 14080 */   220,  221,  155,  278,  224,  278,  278,  278,  278,  278,
 /* 14090 */   278,  278,  278,  278,  278,  278,  278,  278,  171,  172,
 /* 14100 */   278,  278,  278,  278,  278,  278,  278,  247,  278,  249,
 /* 14110 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  192,
 /* 14120 */   260,  278,  278,  278,  278,  278,  278,  278,  278,  269,
 /* 14130 */   270,  271,  272,  273,  278,  278,  278,  210,  211,  278,
 /* 14140 */   278,  278,  215,  216,  217,  218,  278,  220,  221,  278,
 /* 14150 */   278,  224,  278,  278,  278,  278,  155,  278,  278,  278,
 /* 14160 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14170 */   278,  278,  171,  172,  247,  278,  249,  278,  278,  278,
 /* 14180 */   278,  254,  255,  256,  257,  258,  278,  260,  278,  278,
 /* 14190 */   278,  278,  278,  192,  278,  278,  269,  270,  271,  272,
 /* 14200 */   273,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14210 */   278,  210,  211,  278,  278,  278,  215,  216,  217,  218,
 /* 14220 */   278,  220,  221,  278,  278,  224,  155,  278,  278,  278,
 /* 14230 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14240 */   278,  278,  171,  172,  278,  278,  278,  278,  247,  278,
 /* 14250 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /* 14260 */   278,  260,  278,  192,  278,  278,  278,  278,  278,  278,
 /* 14270 */   269,  270,  271,  272,  273,  278,  278,  278,  278,  278,
 /* 14280 */   278,  210,  211,  278,  278,  278,  215,  216,  217,  218,
 /* 14290 */   278,  220,  221,  155,  278,  224,  278,  278,  278,  278,
 /* 14300 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  171,
 /* 14310 */   172,  278,  278,  278,  278,  278,  278,  278,  247,  278,
 /* 14320 */   249,  278,  278,  278,  278,  254,  255,  256,  257,  258,
 /* 14330 */   192,  260,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14340 */   269,  270,  271,  272,  273,  278,  278,  278,  210,  211,
 /* 14350 */   278,  278,  278,  215,  216,  217,  218,  278,  220,  221,
 /* 14360 */   278,  278,  224,  278,  278,  278,  278,  278,  278,  278,
 /* 14370 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14380 */   278,  278,  278,  278,  278,  247,  278,  249,  278,  278,
 /* 14390 */   278,  278,  254,  255,  256,  257,  258,  278,  260,  278,
 /* 14400 */   278,    8,    9,  278,  278,  278,  278,  269,  270,  271,
 /* 14410 */   272,  273,  278,  278,  278,  278,   23,  278,   25,   26,
 /* 14420 */    27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /* 14430 */    37,   38,   39,   40,   41,   42,   43,   44,   45,    9,
 /* 14440 */    47,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14450 */   278,  278,  278,   23,  278,   25,   26,   27,   28,   29,
 /* 14460 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /* 14470 */    40,   41,   42,   43,   44,   45,  278,   47,  278,  278,
 /* 14480 */   278,  278,  172,  278,  278,  278,  278,  278,  278,  278,
 /* 14490 */   278,  278,  278,  278,  184,  278,  278,  278,  172,  278,
 /* 14500 */   278,  278,  192,  278,  278,  278,  278,  278,  278,  278,
 /* 14510 */   184,  278,  278,  278,  278,  278,  278,  278,  192,  278,
 /* 14520 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14530 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14540 */   230,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /* 14550 */   278,  278,  278,  278,  278,  278,  230,  247,  278,  249,
 /* 14560 */   278,  278,  278,  278,  254,  255,  256,  257,  258,  278,
 /* 14570 */   260,  278,  278,  247,  278,  249,  278,  278,  278,  278,
 /* 14580 */   254,  255,  256,  257,  258,  278,  260,
);
    const YY_SHIFT_USE_DFLT = -93;
    const YY_SHIFT_MAX = 500;
    static public $yy_shift_ofst = array(
 /*     0 */   -93, 1192, 1065,  948,  714,  116,   -1,  831,  233,  353,
 /*    10 */   597,  480, 1309, 1192, 1192, 1192, 1192, 1436, 1563, 1690,
 /*    20 */  1817, 1563, 1944, 2178, 2178, 2061, 2178, 3577, 3577, 3577,
 /*    30 */  3577, 3577, 3811, 3577, 5294, 5294, 5294, 5294, 5294, 5294,
 /*    40 */  3460, 3343, 3694, 4279, 4162, 3928, 4513, 4045, 4396, 5294,
 /*    50 */  5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294,
 /*    60 */  5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294,
 /*    70 */  5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294,
 /*    80 */  5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294,
 /*    90 */  5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294,
 /*   100 */  5411, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294,
 /*   110 */  5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294, 5294,
 /*   120 */  5294, 5294, 5294, 5294, 5294, 5294, 5294, 1004, 1004,  -23,
 /*   130 */   -23, 1004,  253,  291,  253,  253,  253,  253,  253,  253,
 /*   140 */   253,  253,  253,  253,  253, 3318,  264,  253,  253,  253,
 /*   150 */   253,  211,  211,  211,  766,  766,  766,  766, 2653, 3461,
 /*   160 */  3543, 2653, 2653, 2653, 2653, 2653, 2653, 2653, 2653, 2653,
 /*   170 */  2653, 2653, 2653, 2653, 2653, 2653, 2653,  292,  425,  292,
 /*   180 */   479,  450,  349,  349,  -92,   94,  -92,  -92,  747,  450,
 /*   190 */   747, 5655, 5509, 5467, 3234, 6362,  315,  419,  296,  410,
 /*   200 */   239,   94,  112,  503,  220,   58, 1256, 1348,  450, 1038,
 /*   210 */   747, 1271,  747, 1160, 1256, 1144, 1095, 1100, 1160, 1195,
 /*   220 */  1333,  747, 1026, 1248, 1245,  944,  747, 1007, 1026, 1038,
 /*   230 */  1000,  997,  -93,  -93,  -93,  -93,  -93,  -93,  -93,  -93,
 /*   240 */   -93,  -93,  -93,  -93,  -93,  -93,  -93,  -93,  -93,  -93,
 /*   250 */   -93,  -93,  -93,  -93,  -93,  -93,  -93,  -93, 6792, 6871,
 /*   260 */  7065, 7454, 6988, 7144, 6912, 6637, 6713, 7220, 7299, 7766,
 /*   270 */  7648, 7607, 7378, 6596, 7530, 7842, 6367, 7919, 5280, 6520,
 /*   280 */  6443, 7689, 8202, 8202, 8202, 8202, 8202, 8202, 8202, 8202,
 /*   290 */  8202, 8202, 8202, 8202, 8202, 14393, 14430,  -15,  -15,  -15,
 /*   300 */   -15,  -15,  -15,  -15,  -15,  -15,  -15,  -15,  -15,  -15,
 /*   310 */   -15,  -15, 2374,  470, 1181, 2503, 2631, 2755, 2755, 2755,
 /*   320 */  2755, 2755, 3002, 2904, 3257, 3158, 1451,  108,  108,  108,
 /*   330 */   108,   87,   87,  570,  570,  570,  570,  570,  175,  117,
 /*   340 */   138,  913,  656, 1033,  735,  692,  825,  777,  742,  549,
 /*   350 */   -17,  521,  -17,  356,  212,  413,  495,  602,  528,  -17,
 /*   360 */   590,  666,  657,  -17,  307,   95,  277, 1039,  855,  884,
 /*   370 */   954,  874,  828,  851,  927,  866,  922,  946, 1035,  914,
 /*   380 */   865,  991,  935,  909,  943,  824,  889, 1054, 1064,  975,
 /*   390 */  1022,  550,  651,   36,  -29,  109,  372,  230,  785,  775,
 /*   400 */   793,  808,  763,  725,  676,  698,  710, 1293, 1304, 1304,
 /*   410 */  1337, 1304, 1276, 1262, 1257,  712, 1420, 1433, 1325, 1304,
 /*   420 */  1184, 1182, 1264, 1173, 1124, 1123, 1188, 1140, 1224, 1230,
 /*   430 */  1265, 1242, 1253, 1234, 1239, 1244, 1208, 1250, 1161, 1341,
 /*   440 */   820,  739,  380,  -59,  592,  509,  983, 1369,  885,  571,
 /*   450 */   245,  712,  245, 1200, 1202, 1274, 1268, 1161, 1114, 1165,
 /*   460 */  1190, 1187, 1239, 1432, 1295, 1278, 1352, 1378,  709,  669,
 /*   470 */   862,  764,  631,  401,  -37,  560, 1027, 1060,  878,  937,
 /*   480 */   932,  911,  947,  904,  860,  892,  894,  880, 1040, 1115,
 /*   490 */  1093, 1084,  996, 1006, 1034, 1011,  548,  473,  565,  614,
 /*   500 */   541,
);
    const YY_REDUCE_USE_DFLT = -223;
    const YY_REDUCE_MAX = 257;
    static public $yy_reduce_ofst = array(
 /*     0 */   523, 2173, 2305, 2305, 2305, 2305, 2305, 2305, 2305, 2305,
 /*    10 */  2305, 2305, 2432, 2305, 2305, 2305, 2305, 2942, 3070, 2560,
 /*    20 */  2687, 2815, 5021, 4895, 4508, 4640, 4766, 5685, 6112, 5400,
 /*    30 */  5548, 5829, 5970, 5618, 6040, 5896, 5759, 7877, 7947, 7810,
 /*    40 */  9992, 10129, 10203, 10484, 10414, 10340, 10273, 9918, 9851, 9359,
 /*    50 */  9285, 9218, 9148, 9429, 9496, 9781, 9707, 9640, 9570, 8163,
 /*    60 */  8230, 8796, 9007, 8726, 8374, 8441, 8585, 12028, 13016, 13157,
 /*    70 */  12805, 12450, 12661, 13294, 13860, 11961, 11606, 11680, 11817, 12239,
 /*    80 */  12102, 11395, 10836, 10625, 10973, 11328, 11184, 12383, 13790, 13649,
 /*    90 */  13505, 13438, 13927, 8093, 14071, 13368, 13579, 14138, 13227, 11117,
 /*   100 */  11258, 11047, 10695, 10762, 10906, 11469, 12172, 12313, 11750, 11539,
 /*   110 */  11891, 14001, 13716, 12735, 12594, 12524, 12872, 13083, 12946, 10062,
 /*   120 */  8515, 8304, 8652, 9074, 8937, 8863, 10551, 2633, 2888, 14310,
 /*   130 */  14326, 3288, 5190, 4881, 8021, 4624, 5005, 5458, 4750, 4494,
 /*   140 */  2051, 2799, 5239, 1464, 4386, 5657, 6514, 6170, 6401, 6257,
 /*   150 */  6328,  501,   20,  -97,  373, -219,    9,  490,   21,  232,
 /*   160 */   232,  867,  958,  872,  650,  634,  620,  736,  751,  853,
 /*   170 */   767,  756,  502,  416,  384,  172,  152, -191, -191,   12,
 /*   180 */   -74,  674,  133,  428,  168, -167, -222,  105,  263,  327,
 /*   190 */   332,  536,  481,  481,  481,  481,  941,  511, 1225, 1143,
 /*   200 */  1272, 1193, 1149, 1120, 1196, 1216, 1231, 1249, 1243, 1191,
 /*   210 */  1261, 1052, 1061, 1049, 1066, 1019, 1014,  960, 1017, 1099,
 /*   220 */  1073, 1152, 1162, 1097, 1125,  952,  939,  916,  934,  822,
 /*   230 */   834,  863,  879,  744,  357,  429,  567,  505,  -69, -170,
 /*   240 */    34,  176,  506,  645,  711,  686, 1036, 1270, 1275, 1280,
 /*   250 */   555, 1171, 1174, 1183, 1170, 1109, 1078, 1086,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(),
        /* 1 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 2 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 120, 126, 136, 138, 139, 140, 141, 142, ),
        /* 3 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 4 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 5 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 6 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 125, 126, 136, 138, 139, 140, 141, 142, ),
        /* 7 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 8 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 119, 126, 136, 138, 139, 140, 141, 142, ),
        /* 9 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 121, 126, 136, 138, 139, 140, 141, 142, ),
        /* 10 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 11 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 12 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 13 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 14 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 15 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 16 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 17 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 18 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 19 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 20 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 21 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 22 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 23 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 24 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 25 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 26 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 27 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 28 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 29 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 30 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 31 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 32 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 33 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 34 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 35 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 36 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 37 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 38 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 39 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 40 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 41 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 42 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 75, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 43 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 44 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 76, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 45 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 76, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 46 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 76, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 47 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 48 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 49 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 50 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 51 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 52 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 53 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 54 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 55 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 56 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 57 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 58 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 59 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 60 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 61 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 62 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 63 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 64 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 65 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 66 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 67 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 68 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 69 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 70 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 71 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 72 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 73 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 74 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 75 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 76 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 77 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 78 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 79 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 80 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 81 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 82 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 83 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 84 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 85 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 86 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 87 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 88 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 89 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 90 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 91 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 92 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 93 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 94 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 95 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 96 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 97 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 98 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 99 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 100 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 101 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 102 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 103 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 104 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 105 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 106 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 107 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 108 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 109 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 110 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 111 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 112 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 113 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 114 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 115 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 116 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 117 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 118 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 119 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 120 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 121 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 122 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 123 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 124 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 125 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 126 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 127 */ array(97, 100, 105, 126, ),
        /* 128 */ array(97, 100, 105, 126, ),
        /* 129 */ array(29, 97, 100, 126, ),
        /* 130 */ array(29, 97, 100, 126, ),
        /* 131 */ array(97, 100, 105, 126, ),
        /* 132 */ array(97, 100, 126, ),
        /* 133 */ array(77, 97, 100, 126, ),
        /* 134 */ array(97, 100, 126, ),
        /* 135 */ array(97, 100, 126, ),
        /* 136 */ array(97, 100, 126, ),
        /* 137 */ array(97, 100, 126, ),
        /* 138 */ array(97, 100, 126, ),
        /* 139 */ array(97, 100, 126, ),
        /* 140 */ array(97, 100, 126, ),
        /* 141 */ array(97, 100, 126, ),
        /* 142 */ array(97, 100, 126, ),
        /* 143 */ array(97, 100, 126, ),
        /* 144 */ array(97, 100, 126, ),
        /* 145 */ array(40, 41, 97, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, ),
        /* 146 */ array(62, 97, 100, 126, ),
        /* 147 */ array(97, 100, 126, ),
        /* 148 */ array(97, 100, 126, ),
        /* 149 */ array(97, 100, 126, ),
        /* 150 */ array(97, 100, 126, ),
        /* 151 */ array(97, 100, 126, ),
        /* 152 */ array(97, 100, 126, ),
        /* 153 */ array(97, 100, 126, ),
        /* 154 */ array(77, 97, 100, 126, ),
        /* 155 */ array(77, 97, 100, 126, ),
        /* 156 */ array(77, 97, 100, 126, ),
        /* 157 */ array(77, 97, 100, 126, ),
        /* 158 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 159 */ array(67, 68, 69, 70, 71, 72, 78, 127, 128, ),
        /* 160 */ array(67, 68, 69, 70, 71, 72, 78, 127, 128, ),
        /* 161 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 162 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 163 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 164 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 165 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 166 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 167 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 168 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 169 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 170 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 171 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 172 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 173 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 174 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 175 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 176 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 177 */ array(97, 100, 126, ),
        /* 178 */ array(97, 100, 126, ),
        /* 179 */ array(97, 100, 126, ),
        /* 180 */ array(97, 126, ),
        /* 181 */ array(96, ),
        /* 182 */ array(75, 100, 108, ),
        /* 183 */ array(75, 100, 108, ),
        /* 184 */ array(97, 126, ),
        /* 185 */ array(97, 126, ),
        /* 186 */ array(97, 126, ),
        /* 187 */ array(97, 126, ),
        /* 188 */ array(100, ),
        /* 189 */ array(96, ),
        /* 190 */ array(100, ),
        /* 191 */ array(7, 8, 9, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 192 */ array(61, 77, 78, 97, 100, 129, 130, 131, 132, 133, 134, 135, 137, 143, ),
        /* 193 */ array(61, 77, 78, 97, 100, 107, 129, 130, 131, 132, 133, 134, 135, 137, ),
        /* 194 */ array(61, 77, 78, 97, 100, 129, 130, 131, 132, 133, 134, 135, 137, 141, ),
        /* 195 */ array(61, 77, 78, 97, 100, 129, 130, 131, 132, 133, 134, 135, 137, 140, ),
        /* 196 */ array(67, 68, 69, 70, 71, 72, 99, ),
        /* 197 */ array(97, 100, 131, ),
        /* 198 */ array(74, 111, ),
        /* 199 */ array(76, 77, ),
        /* 200 */ array(64, 65, ),
        /* 201 */ array(97, 126, ),
        /* 202 */ array(24, 76, ),
        /* 203 */ array(100, 108, ),
        /* 204 */ array(24, 77, ),
        /* 205 */ array(64, 65, ),
        /* 206 */ array(29, ),
        /* 207 */ array(104, ),
        /* 208 */ array(96, ),
        /* 209 */ array(74, ),
        /* 210 */ array(100, ),
        /* 211 */ array(102, ),
        /* 212 */ array(100, ),
        /* 213 */ array(74, ),
        /* 214 */ array(29, ),
        /* 215 */ array(102, ),
        /* 216 */ array(97, ),
        /* 217 */ array(129, ),
        /* 218 */ array(74, ),
        /* 219 */ array(99, ),
        /* 220 */ array(6, ),
        /* 221 */ array(100, ),
        /* 222 */ array(117, ),
        /* 223 */ array(97, ),
        /* 224 */ array(76, ),
        /* 225 */ array(100, ),
        /* 226 */ array(100, ),
        /* 227 */ array(129, ),
        /* 228 */ array(117, ),
        /* 229 */ array(74, ),
        /* 230 */ array(76, ),
        /* 231 */ array(74, ),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 259 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 117, ),
        /* 260 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 261 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 262 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 263 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 264 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 265 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 266 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 267 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 268 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 269 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 270 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 117, ),
        /* 271 */ array(7, 8, 9, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 272 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 273 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 130, ),
        /* 274 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 275 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 276 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 277 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 278 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 279 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 280 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 281 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 282 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 283 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 284 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 285 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 286 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 287 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 288 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 289 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 290 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 291 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 292 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 293 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 294 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 295 */ array(8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 296 */ array(9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 297 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 298 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 299 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 300 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 301 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 302 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 303 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 304 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 305 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 306 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 307 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 308 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 309 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 310 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 311 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 312 */ array(25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 313 */ array(26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 314 */ array(27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 315 */ array(28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 316 */ array(29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 317 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 318 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 319 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 320 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 321 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 322 */ array(6, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 75, ),
        /* 323 */ array(6, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 75, ),
        /* 324 */ array(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 93, ),
        /* 325 */ array(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 76, ),
        /* 326 */ array(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, ),
        /* 327 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 328 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 329 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 330 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 331 */ array(40, 41, 42, 43, 44, 45, 47, ),
        /* 332 */ array(40, 41, 42, 43, 44, 45, 47, ),
        /* 333 */ array(43, 44, 45, 47, ),
        /* 334 */ array(43, 44, 45, 47, ),
        /* 335 */ array(43, 44, 45, 47, ),
        /* 336 */ array(43, 44, 45, 47, ),
        /* 337 */ array(43, 44, 45, 47, ),
        /* 338 */ array(78, 123, 124, ),
        /* 339 */ array(122, 123, 124, ),
        /* 340 */ array(122, 123, 124, ),
        /* 341 */ array(61, 74, 77, ),
        /* 342 */ array(78, 123, 124, ),
        /* 343 */ array(61, 74, 77, ),
        /* 344 */ array(6, 75, ),
        /* 345 */ array(29, 97, ),
        /* 346 */ array(6, 76, ),
        /* 347 */ array(61, 129, ),
        /* 348 */ array(6, 76, ),
        /* 349 */ array(6, 75, ),
        /* 350 */ array(61, 77, ),
        /* 351 */ array(6, 76, ),
        /* 352 */ array(61, 77, ),
        /* 353 */ array(6, 75, ),
        /* 354 */ array(6, 75, ),
        /* 355 */ array(6, 75, ),
        /* 356 */ array(49, 50, ),
        /* 357 */ array(29, 97, ),
        /* 358 */ array(6, 76, ),
        /* 359 */ array(61, 77, ),
        /* 360 */ array(61, 77, ),
        /* 361 */ array(6, 76, ),
        /* 362 */ array(6, 75, ),
        /* 363 */ array(61, 77, ),
        /* 364 */ array(74, 118, ),
        /* 365 */ array(6, 75, ),
        /* 366 */ array(74, 118, ),
        /* 367 */ array(11, ),
        /* 368 */ array(100, ),
        /* 369 */ array(75, ),
        /* 370 */ array(11, ),
        /* 371 */ array(74, ),
        /* 372 */ array(74, ),
        /* 373 */ array(76, ),
        /* 374 */ array(6, ),
        /* 375 */ array(100, ),
        /* 376 */ array(97, ),
        /* 377 */ array(74, ),
        /* 378 */ array(6, ),
        /* 379 */ array(100, ),
        /* 380 */ array(118, ),
        /* 381 */ array(11, ),
        /* 382 */ array(74, ),
        /* 383 */ array(77, ),
        /* 384 */ array(75, ),
        /* 385 */ array(100, ),
        /* 386 */ array(74, ),
        /* 387 */ array(75, ),
        /* 388 */ array(97, ),
        /* 389 */ array(77, ),
        /* 390 */ array(77, ),
        /* 391 */ array(76, ),
        /* 392 */ array(74, ),
        /* 393 */ array(97, ),
        /* 394 */ array(75, ),
        /* 395 */ array(100, ),
        /* 396 */ array(74, ),
        /* 397 */ array(75, ),
        /* 398 */ array(76, ),
        /* 399 */ array(74, ),
        /* 400 */ array(75, ),
        /* 401 */ array(77, ),
        /* 402 */ array(74, ),
        /* 403 */ array(24, ),
        /* 404 */ array(77, ),
        /* 405 */ array(118, ),
        /* 406 */ array(74, ),
        /* 407 */ array(118, ),
        /* 408 */ array(47, ),
        /* 409 */ array(47, ),
        /* 410 */ array(76, ),
        /* 411 */ array(47, ),
        /* 412 */ array(76, ),
        /* 413 */ array(117, ),
        /* 414 */ array(117, ),
        /* 415 */ array(74, ),
        /* 416 */ array(11, ),
        /* 417 */ array(11, ),
        /* 418 */ array(111, ),
        /* 419 */ array(47, ),
        /* 420 */ array(74, ),
        /* 421 */ array(75, ),
        /* 422 */ array(24, ),
        /* 423 */ array(97, ),
        /* 424 */ array(76, ),
        /* 425 */ array(75, ),
        /* 426 */ array(11, ),
        /* 427 */ array(97, ),
        /* 428 */ array(6, ),
        /* 429 */ array(66, ),
        /* 430 */ array(75, ),
        /* 431 */ array(101, ),
        /* 432 */ array(93, ),
        /* 433 */ array(101, ),
        /* 434 */ array(77, ),
        /* 435 */ array(78, ),
        /* 436 */ array(118, ),
        /* 437 */ array(75, ),
        /* 438 */ array(74, ),
        /* 439 */ array(61, ),
        /* 440 */ array(75, ),
        /* 441 */ array(118, ),
        /* 442 */ array(100, ),
        /* 443 */ array(130, ),
        /* 444 */ array(130, ),
        /* 445 */ array(75, ),
        /* 446 */ array(100, ),
        /* 447 */ array(11, ),
        /* 448 */ array(11, ),
        /* 449 */ array(130, ),
        /* 450 */ array(6, ),
        /* 451 */ array(74, ),
        /* 452 */ array(6, ),
        /* 453 */ array(129, ),
        /* 454 */ array(118, ),
        /* 455 */ array(74, ),
        /* 456 */ array(74, ),
        /* 457 */ array(74, ),
        /* 458 */ array(74, ),
        /* 459 */ array(74, ),
        /* 460 */ array(74, ),
        /* 461 */ array(75, ),
        /* 462 */ array(77, ),
        /* 463 */ array(11, ),
        /* 464 */ array(75, ),
        /* 465 */ array(75, ),
        /* 466 */ array(75, ),
        /* 467 */ array(6, ),
        /* 468 */ array(76, ),
        /* 469 */ array(74, ),
        /* 470 */ array(11, ),
        /* 471 */ array(78, ),
        /* 472 */ array(100, ),
        /* 473 */ array(75, ),
        /* 474 */ array(129, ),
        /* 475 */ array(76, ),
        /* 476 */ array(76, ),
        /* 477 */ array(75, ),
        /* 478 */ array(76, ),
        /* 479 */ array(76, ),
        /* 480 */ array(80, ),
        /* 481 */ array(74, ),
        /* 482 */ array(76, ),
        /* 483 */ array(74, ),
        /* 484 */ array(75, ),
        /* 485 */ array(11, ),
        /* 486 */ array(74, ),
        /* 487 */ array(76, ),
        /* 488 */ array(97, ),
        /* 489 */ array(11, ),
        /* 490 */ array(74, ),
        /* 491 */ array(74, ),
        /* 492 */ array(76, ),
        /* 493 */ array(74, ),
        /* 494 */ array(74, ),
        /* 495 */ array(74, ),
        /* 496 */ array(77, ),
        /* 497 */ array(100, ),
        /* 498 */ array(74, ),
        /* 499 */ array(76, ),
        /* 500 */ array(11, ),
        /* 501 */ array(),
        /* 502 */ array(),
        /* 503 */ array(),
        /* 504 */ array(),
        /* 505 */ array(),
        /* 506 */ array(),
        /* 507 */ array(),
        /* 508 */ array(),
        /* 509 */ array(),
        /* 510 */ array(),
        /* 511 */ array(),
        /* 512 */ array(),
        /* 513 */ array(),
        /* 514 */ array(),
        /* 515 */ array(),
        /* 516 */ array(),
        /* 517 */ array(),
        /* 518 */ array(),
        /* 519 */ array(),
        /* 520 */ array(),
        /* 521 */ array(),
        /* 522 */ array(),
        /* 523 */ array(),
        /* 524 */ array(),
        /* 525 */ array(),
        /* 526 */ array(),
        /* 527 */ array(),
        /* 528 */ array(),
        /* 529 */ array(),
        /* 530 */ array(),
        /* 531 */ array(),
        /* 532 */ array(),
        /* 533 */ array(),
        /* 534 */ array(),
        /* 535 */ array(),
        /* 536 */ array(),
        /* 537 */ array(),
        /* 538 */ array(),
        /* 539 */ array(),
        /* 540 */ array(),
        /* 541 */ array(),
        /* 542 */ array(),
        /* 543 */ array(),
        /* 544 */ array(),
        /* 545 */ array(),
        /* 546 */ array(),
        /* 547 */ array(),
        /* 548 */ array(),
        /* 549 */ array(),
        /* 550 */ array(),
        /* 551 */ array(),
        /* 552 */ array(),
        /* 553 */ array(),
        /* 554 */ array(),
        /* 555 */ array(),
        /* 556 */ array(),
        /* 557 */ array(),
        /* 558 */ array(),
        /* 559 */ array(),
        /* 560 */ array(),
        /* 561 */ array(),
        /* 562 */ array(),
        /* 563 */ array(),
        /* 564 */ array(),
        /* 565 */ array(),
        /* 566 */ array(),
        /* 567 */ array(),
        /* 568 */ array(),
        /* 569 */ array(),
        /* 570 */ array(),
        /* 571 */ array(),
        /* 572 */ array(),
        /* 573 */ array(),
        /* 574 */ array(),
        /* 575 */ array(),
        /* 576 */ array(),
        /* 577 */ array(),
        /* 578 */ array(),
        /* 579 */ array(),
        /* 580 */ array(),
        /* 581 */ array(),
        /* 582 */ array(),
        /* 583 */ array(),
        /* 584 */ array(),
        /* 585 */ array(),
        /* 586 */ array(),
        /* 587 */ array(),
        /* 588 */ array(),
        /* 589 */ array(),
        /* 590 */ array(),
        /* 591 */ array(),
        /* 592 */ array(),
        /* 593 */ array(),
        /* 594 */ array(),
        /* 595 */ array(),
        /* 596 */ array(),
        /* 597 */ array(),
        /* 598 */ array(),
        /* 599 */ array(),
        /* 600 */ array(),
        /* 601 */ array(),
        /* 602 */ array(),
        /* 603 */ array(),
        /* 604 */ array(),
        /* 605 */ array(),
        /* 606 */ array(),
        /* 607 */ array(),
        /* 608 */ array(),
        /* 609 */ array(),
        /* 610 */ array(),
        /* 611 */ array(),
        /* 612 */ array(),
        /* 613 */ array(),
        /* 614 */ array(),
        /* 615 */ array(),
        /* 616 */ array(),
        /* 617 */ array(),
        /* 618 */ array(),
        /* 619 */ array(),
        /* 620 */ array(),
        /* 621 */ array(),
        /* 622 */ array(),
        /* 623 */ array(),
        /* 624 */ array(),
        /* 625 */ array(),
        /* 626 */ array(),
        /* 627 */ array(),
        /* 628 */ array(),
        /* 629 */ array(),
        /* 630 */ array(),
        /* 631 */ array(),
        /* 632 */ array(),
        /* 633 */ array(),
        /* 634 */ array(),
        /* 635 */ array(),
        /* 636 */ array(),
        /* 637 */ array(),
        /* 638 */ array(),
        /* 639 */ array(),
        /* 640 */ array(),
        /* 641 */ array(),
        /* 642 */ array(),
        /* 643 */ array(),
        /* 644 */ array(),
        /* 645 */ array(),
        /* 646 */ array(),
        /* 647 */ array(),
        /* 648 */ array(),
        /* 649 */ array(),
        /* 650 */ array(),
        /* 651 */ array(),
        /* 652 */ array(),
        /* 653 */ array(),
        /* 654 */ array(),
        /* 655 */ array(),
        /* 656 */ array(),
        /* 657 */ array(),
        /* 658 */ array(),
        /* 659 */ array(),
        /* 660 */ array(),
        /* 661 */ array(),
        /* 662 */ array(),
        /* 663 */ array(),
        /* 664 */ array(),
        /* 665 */ array(),
        /* 666 */ array(),
        /* 667 */ array(),
        /* 668 */ array(),
        /* 669 */ array(),
        /* 670 */ array(),
        /* 671 */ array(),
        /* 672 */ array(),
        /* 673 */ array(),
        /* 674 */ array(),
        /* 675 */ array(),
        /* 676 */ array(),
        /* 677 */ array(),
        /* 678 */ array(),
        /* 679 */ array(),
        /* 680 */ array(),
        /* 681 */ array(),
        /* 682 */ array(),
        /* 683 */ array(),
        /* 684 */ array(),
        /* 685 */ array(),
        /* 686 */ array(),
        /* 687 */ array(),
        /* 688 */ array(),
        /* 689 */ array(),
        /* 690 */ array(),
        /* 691 */ array(),
        /* 692 */ array(),
        /* 693 */ array(),
        /* 694 */ array(),
        /* 695 */ array(),
        /* 696 */ array(),
        /* 697 */ array(),
        /* 698 */ array(),
        /* 699 */ array(),
        /* 700 */ array(),
        /* 701 */ array(),
        /* 702 */ array(),
        /* 703 */ array(),
        /* 704 */ array(),
        /* 705 */ array(),
        /* 706 */ array(),
        /* 707 */ array(),
        /* 708 */ array(),
        /* 709 */ array(),
        /* 710 */ array(),
        /* 711 */ array(),
        /* 712 */ array(),
        /* 713 */ array(),
        /* 714 */ array(),
        /* 715 */ array(),
        /* 716 */ array(),
        /* 717 */ array(),
        /* 718 */ array(),
        /* 719 */ array(),
        /* 720 */ array(),
        /* 721 */ array(),
        /* 722 */ array(),
        /* 723 */ array(),
        /* 724 */ array(),
        /* 725 */ array(),
        /* 726 */ array(),
        /* 727 */ array(),
        /* 728 */ array(),
        /* 729 */ array(),
        /* 730 */ array(),
        /* 731 */ array(),
        /* 732 */ array(),
        /* 733 */ array(),
        /* 734 */ array(),
        /* 735 */ array(),
        /* 736 */ array(),
        /* 737 */ array(),
        /* 738 */ array(),
        /* 739 */ array(),
        /* 740 */ array(),
        /* 741 */ array(),
        /* 742 */ array(),
        /* 743 */ array(),
);
    static public $yy_default = array(
 /*     0 */   746,  945, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*    10 */  1119, 1119,  744,  936,  935,  948,  944, 1119, 1119, 1119,
 /*    20 */  1119, 1119, 1119, 1119, 1119, 1119, 1119,  963,  963,  963,
 /*    30 */   963,  963, 1048,  963, 1114, 1114, 1114, 1032, 1032, 1119,
 /*    40 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1111, 1119, 1119,
 /*    50 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*    60 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*    70 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*    80 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*    90 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   100 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   110 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   120 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1046, 1046, 1119,
 /*   130 */  1119, 1046, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   140 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   150 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,  913,  990,
 /*   160 */   990, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   170 */  1119, 1119, 1119, 1119,  912, 1119, 1119, 1119, 1119, 1119,
 /*   180 */  1119,  799,  961,  961, 1119, 1119, 1119, 1119, 1119,  798,
 /*   190 */  1119, 1119, 1119, 1119, 1119, 1119,  987, 1119, 1119, 1119,
 /*   200 */   947, 1119, 1119,  961, 1119,  949, 1118,  823, 1119, 1017,
 /*   210 */  1119,  819, 1119, 1110, 1118,  822, 1119, 1104, 1110, 1119,
 /*   220 */  1112, 1119,  920, 1119,  937, 1119, 1119, 1011,  920, 1017,
 /*   230 */   937,  902, 1058,  804, 1107,  804,  804,  804, 1058, 1058,
 /*   240 */   804,  804, 1058,  980,  804,  804,  804,  943,  804,  804,
 /*   250 */  1014,  804,  804,  804,  804,  980,  937,  937, 1119, 1050,
 /*   260 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   270 */  1053, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   280 */  1119, 1119, 1052, 1054, 1081, 1079, 1115, 1001, 1119, 1031,
 /*   290 */  1084, 1002,  837, 1086, 1116,  855,  857,  838,  830,  898,
 /*   300 */   831,  856,  839,  844,  845,  846,  848,  843,  840,  841,
 /*   310 */   842,  847,  883,  853,  854,  858,  860,  876,  875,  859,
 /*   320 */   874,  873, 1008, 1008, 1008, 1008, 1008,  878,  879,  880,
 /*   330 */   877,  868,  867,  870,  863,  862,  861,  869, 1119, 1119,
 /*   340 */  1119, 1024, 1119, 1023, 1119, 1119, 1119, 1069, 1119, 1119,
 /*   350 */  1018, 1119, 1019,  828,  828, 1119, 1119, 1119, 1119, 1024,
 /*   360 */  1033, 1119, 1119, 1023, 1095, 1119,  905, 1119, 1119, 1119,
 /*   370 */   975, 1119, 1119, 1119,  950, 1119, 1119, 1119, 1113, 1119,
 /*   380 */   905,  956, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   390 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   400 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,  871,  865,
 /*   410 */  1119,  864, 1119,  915,  917, 1119,  977,  996, 1119,  866,
 /*   420 */  1119, 1119, 1119, 1119, 1119, 1119,  994, 1119,  911, 1119,
 /*   430 */  1119, 1119,  828, 1119, 1041, 1119, 1119, 1119, 1089, 1096,
 /*   440 */  1119, 1102, 1119, 1119, 1119, 1119, 1119, 1119,  957, 1119,
 /*   450 */   821, 1020,  824, 1012, 1119, 1119, 1119, 1119, 1119, 1090,
 /*   460 */  1119, 1119, 1040, 1119, 1119, 1119, 1119,  962, 1119, 1119,
 /*   470 */  1119, 1119, 1119, 1119, 1105, 1119, 1119, 1119, 1119, 1119,
 /*   480 */  1119, 1119, 1119, 1119, 1119,  952, 1119,  828, 1119,  953,
 /*   490 */  1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119,
 /*   500 */  1119,  812,  988,  921,  930,  919,  928,  997,  927,  756,
 /*   510 */   924,  942,  954,  993,  959,  958,  926,  814,  811,  923,
 /*   520 */   992,  960,  955,  991,  929,  934,  925,  932,  998,  789,
 /*   530 */   979,  816,  995,  922,  985,  817,  939,  981, 1090,  826,
 /*   540 */   825,  815,  941,  820,  999,  982,  940,  946,  810,  818,
 /*   550 */   933,  983, 1117,  986,  813,  984,  938, 1000,  800, 1045,
 /*   560 */  1022, 1021, 1030, 1029, 1025,  966, 1080, 1078, 1077, 1009,
 /*   570 */  1028,  903, 1067, 1066, 1065, 1064, 1068, 1070,  899, 1073,
 /*   580 */  1072, 1071, 1082, 1083,  969, 1087, 1088, 1076, 1093, 1074,
 /*   590 */  1055, 1047,  896, 1049, 1092, 1091, 1098, 1097, 1096, 1085,
 /*   600 */  1075, 1099, 1094, 1101, 1100, 1063, 1062,  835,  834,  829,
 /*   610 */   828,  836,  849, 1013, 1010,  850,  851,  827,  755,  749,
 /*   620 */   748,  747,  745,  750,  751,  754,  753,  752, 1015,  852,
 /*   630 */   894,  901,  893,  892,  895,  897, 1061, 1060, 1059, 1057,
 /*   640 */   891,  890,  884,  882,  872,  881,  885,  886,  889,  888,
 /*   650 */   887, 1056, 1051,  779,  978,  976,  916,  780,  781, 1006,
 /*   660 */   784,  783,  782,  914,  910,  904,  778,  777,  971,  918,
 /*   670 */   906,  909,  908,  907, 1007,  785,  797,  796,  801,  795,
 /*   680 */   802,  803,  808,  807,  806,  805,  794,  793, 1003, 1005,
 /*   690 */  1004,  786,  787,  788,  792,  791,  790, 1008,  974, 1109,
 /*   700 */  1016, 1026, 1108,  832,  833,  757, 1043, 1044, 1042, 1106,
 /*   710 */  1039, 1103, 1020, 1027,  900, 1035, 1036, 1038, 1037, 1034,
 /*   720 */   758,  759,  773,  772,  771,  770,  774,  775,  973,  972,
 /*   730 */   970,  776,  769,  768,  763,  762,  761,  760,  764,  931,
 /*   740 */   767,  766,  765,  809,
);
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    self::YYNOCODE      is a number which corresponds
**                        to no legal terminal or nonterminal number.  This
**                        number is used to fill in empty slots of the hash 
**                        table.
**    self::YYFALLBACK    If defined, this indicates that one or more tokens
**                        have fall-back values which should be used if the
**                        original value of the token will not parse.
**    self::YYSTACKDEPTH  is the maximum depth of the parser's stack.
**    self::YYNSTATE      the combined number of states.
**    self::YYNRULE       the number of rules in the grammar
**    self::YYERRORSYMBOL is the code number of the error symbol.  If not
**                        defined, then do no error processing.
*/
    const YYNOCODE = 279;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 744;
    const YYNRULE = 375;
    const YYERRORSYMBOL = 144;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    /** The next table maps tokens into fallback tokens.  If a construct
     * like the following:
     * 
     *      %fallback ID X Y Z.
     *
     * appears in the grammer, then ID becomes a fallback token for X, Y,
     * and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
     * but it does not parse, the type of the token is changed to ID and
     * the parse is retried before an error is thrown.
     */
    static public $yyFallback = array(
    );
    /**
     * Turn parser tracing on by giving a stream to which to write the trace
     * and a prompt to preface each trace message.  Tracing is turned off
     * by making either argument NULL 
     *
     * Inputs:
     * 
     * - A stream resource to which trace output should be written.
     *   If NULL, then tracing is turned off.
     * - A prefix string written at the beginning of every
     *   line of trace output.  If NULL, then tracing is
     *   turned off.
     *
     * Outputs:
     * 
     * - None.
     * @param resource
     * @param string
     */
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    /**
     * Output debug information to output (php://output stream)
     */
    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '';
    }

    /**
     * @var resource|0
     */
    static public $yyTraceFILE;
    /**
     * String to prepend to debug output
     * @var string|0
     */
    static public $yyTracePrompt;
    /**
     * @var int
     */
    public $yyidx;                    /* Index of top element in stack */
    /**
     * @var int
     */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    /**
     * @var array
     */
    public $yystack = array();  /* The parser's stack */

    /**
     * For tracing shifts, the names of all terminals and nonterminals
     * are required.  The following table supplies these names
     * @var array
     */
    static public $yyTokenName = array( 
  '$',             'T_INCLUDE',     'T_INCLUDE_ONCE',  'T_EVAL',      
  'T_REQUIRE',     'T_REQUIRE_ONCE',  'COMMA',         'T_LOGICAL_OR',
  'T_LOGICAL_XOR',  'T_LOGICAL_AND',  'T_PRINT',       'EQUALS',      
  'T_PLUS_EQUAL',  'T_MINUS_EQUAL',  'T_MUL_EQUAL',   'T_DIV_EQUAL', 
  'T_CONCAT_EQUAL',  'T_MOD_EQUAL',   'T_AND_EQUAL',   'T_OR_EQUAL',  
  'T_XOR_EQUAL',   'T_SL_EQUAL',    'T_SR_EQUAL',    'QUESTION',    
  'COLON',         'T_BOOLEAN_OR',  'T_BOOLEAN_AND',  'BAR',         
  'CARAT',         'AMPERSAND',     'T_IS_EQUAL',    'T_IS_NOT_EQUAL',
  'T_IS_IDENTICAL',  'T_IS_NOT_IDENTICAL',  'LESSTHAN',      'T_IS_SMALLER_OR_EQUAL',
  'GREATERTHAN',   'T_IS_GREATER_OR_EQUAL',  'T_SL',          'T_SR',        
  'PLUS',          'MINUS',         'DOT',           'TIMES',       
  'DIVIDE',        'PERCENT',       'EXCLAM',        'T_INSTANCEOF',
  'TILDE',         'T_INC',         'T_DEC',         'T_INT_CAST',  
  'T_DOUBLE_CAST',  'T_STRING_CAST',  'T_UNICODE_CAST',  'T_BINARY_CAST',
  'T_ARRAY_CAST',  'T_OBJECT_CAST',  'T_BOOL_CAST',   'T_UNSET_CAST',
  'AT',            'LBRACKET',      'T_NEW',         'T_CLONE',     
  'T_ELSEIF',      'T_ELSE',        'T_ENDIF',       'T_STATIC',    
  'T_ABSTRACT',    'T_FINAL',       'T_PRIVATE',     'T_PROTECTED', 
  'T_PUBLIC',      'T_HALT_COMPILER',  'LPAREN',        'RPAREN',      
  'SEMI',          'LCURLY',        'RCURLY',        'T_IF',        
  'T_WHILE',       'T_DO',          'T_FOR',         'T_SWITCH',    
  'T_BREAK',       'T_CONTINUE',    'T_RETURN',      'T_GLOBAL',    
  'T_ECHO',        'T_INLINE_HTML',  'T_USE',         'T_UNSET',     
  'T_FOREACH',     'T_AS',          'T_DECLARE',     'T_TRY',       
  'T_CATCH',       'T_VARIABLE',    'T_THROW',       'T_FUNCTION',  
  'T_STRING',      'T_CLASS',       'T_EXTENDS',     'T_INTERFACE', 
  'T_IMPLEMENTS',  'T_LIST',        'T_EXIT',        'BACKQUOTE',   
  'T_ARRAY',       'T_LNUMBER',     'T_DNUMBER',     'T_CONSTANT_ENCAPSED_STRING',
  'T_LINE',        'T_FILE',        'T_CLASS_C',     'T_METHOD_C',  
  'T_FUNC_C',      'T_DOUBLE_ARROW',  'T_PAAMAYIM_NEKUDOTAYIM',  'T_ENDFOR',    
  'T_ENDFOREACH',  'T_ENDDECLARE',  'T_ENDSWITCH',   'T_CASE',      
  'T_DEFAULT',     'T_ENDWHILE',    'DOLLAR',        'T_VAR',       
  'T_CONST',       'T_OBJECT_OPERATOR',  'RBRACKET',      'T_NUM_STRING',
  'T_ENCAPSED_AND_WHITESPACE',  'T_CHARACTER',   'T_BAD_CHARACTER',  'T_DOLLAR_OPEN_CURLY_BRACES',
  'T_STRING_VARNAME',  'T_CURLY_OPEN',  'T_ISSET',       'T_EMPTY',     
  'DOUBLEQUOTE',   'SINGLEQUOTE',   'T_START_HEREDOC',  'T_END_HEREDOC',
  'error',         'start',         'top_statement_list',  'top_statement',
  'statement',     'function_declaration_statement',  'class_declaration_statement',  'unticked_statement',
  'get_inner_statement_line',  'inner_statement_list',  'get_if_statement_line',  'expr',        
  'elseif_list',   'else_single',   'new_elseif_list',  'new_else_single',
  'get_while_statement_line',  'while_statement',  'get_do_statement_line',  'get_for_statement_line',
  'for_expr',      'for_statement',  'get_switch_statement_line',  'switch_case_list',
  'get_break_statement_line',  'get_continue_statement_line',  'get_return_statement_line',  'expr_without_variable',
  'variable',      'get_global_variable_statement_line',  'global_var_list',  'get_static_variable_statement_line',
  'static_var_list',  'get_echo_statement_line',  'echo_expr_list',  'get_use_statement_line',
  'use_filename',  'get_unset_statement_line',  'unset_variables',  'get_foreach_statement_line',
  'foreach_variable',  'foreach_optional_arg',  'foreach_statement',  'get_declare_statement_line',
  'declare_list',  'declare_statement',  'get_try_statement_line',  'get_catch_statement_line',
  'fully_qualified_class_name',  'additional_catches',  'get_throw_statement_line',  'non_empty_additional_catches',
  'additional_catch',  'inner_statement',  'unticked_function_declaration_statement',  'unticked_class_declaration_statement',
  'get_func_line',  'is_reference',  'parameter_list',  'class_entry_type',
  'extends_from',  'implements_list',  'class_statement_list',  'interface_entry',
  'interface_extends_list',  'interface_list',  'r_variable',    'get_list_line',
  'assignment_list',  'class_name_reference',  'ctor_arguments',  'get_new_expr_line',
  'get_clone_expr_line',  'rw_variable',   'internal_functions_in_yacc',  'exit_expr',   
  'scalar',        'expr_without_variable_t_array',  'array_pair_list',  'encaps_list', 
  'common_scalar',  'static_scalar',  'static_scalar_t_array',  'static_array_pair_list',
  'static_class_constant',  'non_empty_static_array_pair_list',  'w_variable',    'case_list',   
  'case_separator',  'non_empty_parameter_list',  'optional_class_type',  'function_call_parameter_list',
  'non_empty_function_call_parameter_list',  'global_var',    'class_statement',  'variable_modifiers',
  'class_variable_declaration',  'class_constant_declaration',  'get_method_line',  'method_modifiers',
  'method_body',   'non_empty_member_modifiers',  'member_modifier',  'function_call',
  'unset_variable',  'base_variable_with_function_calls',  'object_property',  'method_or_not',
  'variable_properties',  'variable_property',  'variable_without_objects',  'reference_variable',
  'simple_indirect_reference',  'static_member',  'base_variable',  'dim_offset',  
  'compound_variable',  'object_dim_list',  'variable_name',  'assignment_list_element',
  'non_empty_array_pair_list',  'possible_comma',  'encaps_var',    'encaps_var_bracket_index',
  'isset_variables',  'get_include_line',  'get_include_once_line',  'get_require_line',
  'get_require_once_line',  'class_constant',  'dynamic_class_name_reference',  'dynamic_class_name_variable_properties',
  'dynamic_class_name_variable_property',  'non_empty_for_expr',
    );

    /**
     * For tracing reduce actions, the names of all rules are required.
     * @var array
     */
    static public $yyRuleName = array(
 /*   0 */ "start ::= top_statement_list",
 /*   1 */ "top_statement_list ::= top_statement_list top_statement",
 /*   2 */ "top_statement_list ::=",
 /*   3 */ "top_statement ::= statement",
 /*   4 */ "top_statement ::= function_declaration_statement",
 /*   5 */ "top_statement ::= class_declaration_statement",
 /*   6 */ "top_statement ::= T_HALT_COMPILER LPAREN RPAREN SEMI",
 /*   7 */ "statement ::= unticked_statement",
 /*   8 */ "get_inner_statement_line ::= LCURLY",
 /*   9 */ "unticked_statement ::= get_inner_statement_line inner_statement_list RCURLY",
 /*  10 */ "get_if_statement_line ::= T_IF",
 /*  11 */ "unticked_statement ::= get_if_statement_line LPAREN expr RPAREN statement elseif_list else_single",
 /*  12 */ "unticked_statement ::= get_if_statement_line LPAREN expr RPAREN COLON inner_statement_list new_elseif_list new_else_single T_ENDIF SEMI",
 /*  13 */ "get_while_statement_line ::= T_WHILE",
 /*  14 */ "unticked_statement ::= get_while_statement_line LPAREN expr RPAREN while_statement",
 /*  15 */ "get_do_statement_line ::= T_DO",
 /*  16 */ "unticked_statement ::= get_do_statement_line statement T_WHILE LPAREN expr RPAREN SEMI",
 /*  17 */ "get_for_statement_line ::= T_FOR",
 /*  18 */ "unticked_statement ::= get_for_statement_line LPAREN for_expr SEMI for_expr SEMI for_expr RPAREN for_statement",
 /*  19 */ "get_switch_statement_line ::= T_SWITCH",
 /*  20 */ "unticked_statement ::= get_switch_statement_line LPAREN expr RPAREN switch_case_list",
 /*  21 */ "get_break_statement_line ::= T_BREAK",
 /*  22 */ "unticked_statement ::= get_break_statement_line SEMI",
 /*  23 */ "unticked_statement ::= get_break_statement_line expr SEMI",
 /*  24 */ "get_continue_statement_line ::= T_CONTINUE",
 /*  25 */ "unticked_statement ::= get_continue_statement_line SEMI",
 /*  26 */ "unticked_statement ::= get_continue_statement_line expr SEMI",
 /*  27 */ "get_return_statement_line ::= T_RETURN",
 /*  28 */ "unticked_statement ::= get_return_statement_line SEMI",
 /*  29 */ "unticked_statement ::= get_return_statement_line expr_without_variable SEMI",
 /*  30 */ "unticked_statement ::= get_return_statement_line variable SEMI",
 /*  31 */ "get_global_variable_statement_line ::= T_GLOBAL",
 /*  32 */ "unticked_statement ::= get_global_variable_statement_line global_var_list SEMI",
 /*  33 */ "get_static_variable_statement_line ::= T_STATIC",
 /*  34 */ "unticked_statement ::= get_static_variable_statement_line static_var_list SEMI",
 /*  35 */ "get_echo_statement_line ::= T_ECHO",
 /*  36 */ "unticked_statement ::= get_echo_statement_line echo_expr_list SEMI",
 /*  37 */ "unticked_statement ::= T_INLINE_HTML",
 /*  38 */ "unticked_statement ::= expr SEMI",
 /*  39 */ "get_use_statement_line ::= T_USE",
 /*  40 */ "unticked_statement ::= get_use_statement_line use_filename SEMI",
 /*  41 */ "get_unset_statement_line ::= T_UNSET",
 /*  42 */ "unticked_statement ::= get_unset_statement_line LPAREN unset_variables RPAREN SEMI",
 /*  43 */ "get_foreach_statement_line ::= T_FOREACH",
 /*  44 */ "unticked_statement ::= get_foreach_statement_line LPAREN variable T_AS foreach_variable foreach_optional_arg RPAREN foreach_statement",
 /*  45 */ "unticked_statement ::= get_foreach_statement_line LPAREN expr_without_variable T_AS variable foreach_optional_arg RPAREN foreach_statement",
 /*  46 */ "get_declare_statement_line ::= T_DECLARE",
 /*  47 */ "unticked_statement ::= get_declare_statement_line LPAREN declare_list RPAREN declare_statement",
 /*  48 */ "unticked_statement ::= SEMI",
 /*  49 */ "get_try_statement_line ::= T_TRY",
 /*  50 */ "get_catch_statement_line ::= T_CATCH",
 /*  51 */ "unticked_statement ::= get_try_statement_line LCURLY inner_statement_list RCURLY get_catch_statement_line LPAREN fully_qualified_class_name T_VARIABLE RPAREN LCURLY inner_statement_list RCURLY additional_catches",
 /*  52 */ "get_throw_statement_line ::= T_THROW",
 /*  53 */ "unticked_statement ::= get_throw_statement_line expr SEMI",
 /*  54 */ "additional_catches ::= non_empty_additional_catches",
 /*  55 */ "additional_catches ::=",
 /*  56 */ "non_empty_additional_catches ::= additional_catch",
 /*  57 */ "non_empty_additional_catches ::= non_empty_additional_catches additional_catch",
 /*  58 */ "additional_catch ::= get_catch_statement_line LPAREN fully_qualified_class_name T_VARIABLE RPAREN LCURLY inner_statement_list RCURLY",
 /*  59 */ "inner_statement_list ::= inner_statement_list inner_statement",
 /*  60 */ "inner_statement_list ::=",
 /*  61 */ "inner_statement ::= statement",
 /*  62 */ "inner_statement ::= function_declaration_statement",
 /*  63 */ "inner_statement ::= class_declaration_statement",
 /*  64 */ "inner_statement ::= T_HALT_COMPILER LPAREN RPAREN SEMI",
 /*  65 */ "function_declaration_statement ::= unticked_function_declaration_statement",
 /*  66 */ "class_declaration_statement ::= unticked_class_declaration_statement",
 /*  67 */ "get_func_line ::= T_FUNCTION",
 /*  68 */ "unticked_function_declaration_statement ::= get_func_line is_reference T_STRING LPAREN parameter_list RPAREN LCURLY inner_statement_list RCURLY",
 /*  69 */ "unticked_class_declaration_statement ::= class_entry_type T_STRING extends_from implements_list LCURLY class_statement_list RCURLY",
 /*  70 */ "unticked_class_declaration_statement ::= interface_entry T_STRING interface_extends_list LCURLY class_statement_list RCURLY",
 /*  71 */ "class_entry_type ::= T_CLASS",
 /*  72 */ "class_entry_type ::= T_ABSTRACT T_CLASS",
 /*  73 */ "class_entry_type ::= T_FINAL T_CLASS",
 /*  74 */ "extends_from ::= T_EXTENDS fully_qualified_class_name",
 /*  75 */ "extends_from ::=",
 /*  76 */ "interface_entry ::= T_INTERFACE",
 /*  77 */ "interface_extends_list ::= T_EXTENDS interface_list",
 /*  78 */ "interface_extends_list ::=",
 /*  79 */ "implements_list ::=",
 /*  80 */ "implements_list ::= T_IMPLEMENTS interface_list",
 /*  81 */ "interface_list ::= fully_qualified_class_name",
 /*  82 */ "interface_list ::= interface_list COMMA fully_qualified_class_name",
 /*  83 */ "expr ::= r_variable",
 /*  84 */ "expr ::= expr_without_variable",
 /*  85 */ "get_list_line ::= T_LIST",
 /*  86 */ "expr_without_variable ::= get_list_line LPAREN assignment_list RPAREN EQUALS expr",
 /*  87 */ "expr_without_variable ::= variable EQUALS expr",
 /*  88 */ "expr_without_variable ::= variable EQUALS AMPERSAND variable",
 /*  89 */ "expr_without_variable ::= variable EQUALS AMPERSAND T_NEW class_name_reference ctor_arguments",
 /*  90 */ "get_new_expr_line ::= T_NEW",
 /*  91 */ "expr_without_variable ::= get_new_expr_line class_name_reference ctor_arguments",
 /*  92 */ "get_clone_expr_line ::= T_CLONE",
 /*  93 */ "expr_without_variable ::= get_clone_expr_line expr",
 /*  94 */ "expr_without_variable ::= variable T_PLUS_EQUAL expr",
 /*  95 */ "expr_without_variable ::= variable T_MINUS_EQUAL expr",
 /*  96 */ "expr_without_variable ::= variable T_MUL_EQUAL expr",
 /*  97 */ "expr_without_variable ::= variable T_DIV_EQUAL expr",
 /*  98 */ "expr_without_variable ::= variable T_CONCAT_EQUAL expr",
 /*  99 */ "expr_without_variable ::= variable T_MOD_EQUAL expr",
 /* 100 */ "expr_without_variable ::= variable T_AND_EQUAL expr",
 /* 101 */ "expr_without_variable ::= variable T_OR_EQUAL expr",
 /* 102 */ "expr_without_variable ::= variable T_XOR_EQUAL expr",
 /* 103 */ "expr_without_variable ::= variable T_SL_EQUAL expr",
 /* 104 */ "expr_without_variable ::= variable T_SR_EQUAL expr",
 /* 105 */ "expr_without_variable ::= rw_variable T_INC",
 /* 106 */ "expr_without_variable ::= T_INC rw_variable",
 /* 107 */ "expr_without_variable ::= rw_variable T_DEC",
 /* 108 */ "expr_without_variable ::= T_DEC rw_variable",
 /* 109 */ "expr_without_variable ::= expr T_BOOLEAN_OR expr",
 /* 110 */ "expr_without_variable ::= expr T_BOOLEAN_AND expr",
 /* 111 */ "expr_without_variable ::= expr T_LOGICAL_OR expr",
 /* 112 */ "expr_without_variable ::= expr T_LOGICAL_AND expr",
 /* 113 */ "expr_without_variable ::= expr T_LOGICAL_XOR expr",
 /* 114 */ "expr_without_variable ::= expr BAR expr",
 /* 115 */ "expr_without_variable ::= expr AMPERSAND expr",
 /* 116 */ "expr_without_variable ::= expr CARAT expr",
 /* 117 */ "expr_without_variable ::= expr DOT expr",
 /* 118 */ "expr_without_variable ::= expr PLUS expr",
 /* 119 */ "expr_without_variable ::= expr MINUS expr",
 /* 120 */ "expr_without_variable ::= expr TIMES expr",
 /* 121 */ "expr_without_variable ::= expr DIVIDE expr",
 /* 122 */ "expr_without_variable ::= expr PERCENT expr",
 /* 123 */ "expr_without_variable ::= expr T_SL expr",
 /* 124 */ "expr_without_variable ::= expr T_SR expr",
 /* 125 */ "expr_without_variable ::= PLUS expr",
 /* 126 */ "expr_without_variable ::= MINUS expr",
 /* 127 */ "expr_without_variable ::= EXCLAM expr",
 /* 128 */ "expr_without_variable ::= TILDE expr",
 /* 129 */ "expr_without_variable ::= expr T_IS_IDENTICAL expr",
 /* 130 */ "expr_without_variable ::= expr T_IS_NOT_IDENTICAL expr",
 /* 131 */ "expr_without_variable ::= expr T_IS_EQUAL expr",
 /* 132 */ "expr_without_variable ::= expr T_IS_NOT_EQUAL expr",
 /* 133 */ "expr_without_variable ::= expr LESSTHAN expr",
 /* 134 */ "expr_without_variable ::= expr T_IS_SMALLER_OR_EQUAL expr",
 /* 135 */ "expr_without_variable ::= expr GREATERTHAN expr",
 /* 136 */ "expr_without_variable ::= expr T_IS_GREATER_OR_EQUAL expr",
 /* 137 */ "expr_without_variable ::= expr T_INSTANCEOF class_name_reference",
 /* 138 */ "expr_without_variable ::= LPAREN expr RPAREN",
 /* 139 */ "expr_without_variable ::= expr QUESTION expr COLON expr",
 /* 140 */ "expr_without_variable ::= internal_functions_in_yacc",
 /* 141 */ "expr_without_variable ::= T_INT_CAST expr",
 /* 142 */ "expr_without_variable ::= T_DOUBLE_CAST expr",
 /* 143 */ "expr_without_variable ::= T_STRING_CAST expr",
 /* 144 */ "expr_without_variable ::= T_ARRAY_CAST expr",
 /* 145 */ "expr_without_variable ::= T_OBJECT_CAST expr",
 /* 146 */ "expr_without_variable ::= T_BINARY_CAST expr",
 /* 147 */ "expr_without_variable ::= T_BOOL_CAST expr",
 /* 148 */ "expr_without_variable ::= T_UNSET_CAST expr",
 /* 149 */ "expr_without_variable ::= T_EXIT exit_expr",
 /* 150 */ "expr_without_variable ::= AT expr",
 /* 151 */ "expr_without_variable ::= scalar",
 /* 152 */ "expr_without_variable ::= expr_without_variable_t_array LPAREN array_pair_list RPAREN",
 /* 153 */ "expr_without_variable ::= BACKQUOTE encaps_list BACKQUOTE",
 /* 154 */ "expr_without_variable ::= T_PRINT expr",
 /* 155 */ "expr_without_variable_t_array ::= T_ARRAY",
 /* 156 */ "exit_expr ::= LPAREN RPAREN",
 /* 157 */ "exit_expr ::= LPAREN expr RPAREN",
 /* 158 */ "exit_expr ::=",
 /* 159 */ "common_scalar ::= T_LNUMBER|T_DNUMBER|T_CONSTANT_ENCAPSED_STRING|T_LINE|T_FILE|T_CLASS_C|T_METHOD_C|T_FUNC_C",
 /* 160 */ "static_scalar ::= common_scalar",
 /* 161 */ "static_scalar ::= T_STRING",
 /* 162 */ "static_scalar ::= PLUS static_scalar",
 /* 163 */ "static_scalar ::= MINUS static_scalar",
 /* 164 */ "static_scalar ::= static_scalar_t_array LPAREN static_array_pair_list RPAREN",
 /* 165 */ "static_scalar ::= static_class_constant",
 /* 166 */ "static_scalar_t_array ::= T_ARRAY",
 /* 167 */ "static_array_pair_list ::= non_empty_static_array_pair_list",
 /* 168 */ "static_array_pair_list ::= non_empty_static_array_pair_list COMMA",
 /* 169 */ "static_array_pair_list ::=",
 /* 170 */ "non_empty_static_array_pair_list ::= non_empty_static_array_pair_list COMMA static_scalar T_DOUBLE_ARROW static_scalar",
 /* 171 */ "non_empty_static_array_pair_list ::= non_empty_static_array_pair_list COMMA static_scalar",
 /* 172 */ "non_empty_static_array_pair_list ::= static_scalar T_DOUBLE_ARROW static_scalar",
 /* 173 */ "non_empty_static_array_pair_list ::= static_scalar",
 /* 174 */ "static_class_constant ::= T_STRING T_PAAMAYIM_NEKUDOTAYIM T_STRING",
 /* 175 */ "foreach_optional_arg ::= T_DOUBLE_ARROW foreach_variable",
 /* 176 */ "foreach_optional_arg ::=",
 /* 177 */ "foreach_variable ::= w_variable",
 /* 178 */ "foreach_variable ::= AMPERSAND w_variable",
 /* 179 */ "for_statement ::= statement",
 /* 180 */ "for_statement ::= COLON inner_statement_list T_ENDFOR SEMI",
 /* 181 */ "foreach_statement ::= statement",
 /* 182 */ "foreach_statement ::= COLON inner_statement_list T_ENDFOREACH SEMI",
 /* 183 */ "declare_statement ::= statement",
 /* 184 */ "declare_statement ::= COLON inner_statement_list T_ENDDECLARE SEMI",
 /* 185 */ "declare_list ::= T_STRING EQUALS static_scalar",
 /* 186 */ "declare_list ::= declare_list COMMA T_STRING EQUALS static_scalar",
 /* 187 */ "switch_case_list ::= LCURLY case_list RCURLY",
 /* 188 */ "switch_case_list ::= LCURLY SEMI case_list RCURLY",
 /* 189 */ "switch_case_list ::= COLON case_list T_ENDSWITCH SEMI",
 /* 190 */ "switch_case_list ::= COLON SEMI case_list T_ENDSWITCH SEMI",
 /* 191 */ "case_list ::= case_list T_CASE expr case_separator inner_statement_list",
 /* 192 */ "case_list ::= case_list T_DEFAULT case_separator inner_statement_list",
 /* 193 */ "case_list ::=",
 /* 194 */ "case_separator ::= COLON|SEMI",
 /* 195 */ "while_statement ::= statement",
 /* 196 */ "while_statement ::= COLON inner_statement_list T_ENDWHILE SEMI",
 /* 197 */ "elseif_list ::= elseif_list T_ELSEIF LPAREN expr RPAREN statement",
 /* 198 */ "elseif_list ::= elseif_list T_ELSE T_IF LPAREN expr RPAREN statement",
 /* 199 */ "elseif_list ::=",
 /* 200 */ "new_elseif_list ::= new_elseif_list T_ELSEIF LPAREN expr RPAREN COLON inner_statement_list",
 /* 201 */ "new_elseif_list ::=",
 /* 202 */ "else_single ::= T_ELSE statement",
 /* 203 */ "else_single ::=",
 /* 204 */ "new_else_single ::= T_ELSE COLON inner_statement_list",
 /* 205 */ "new_else_single ::=",
 /* 206 */ "parameter_list ::= non_empty_parameter_list",
 /* 207 */ "parameter_list ::=",
 /* 208 */ "non_empty_parameter_list ::= optional_class_type T_VARIABLE",
 /* 209 */ "non_empty_parameter_list ::= optional_class_type AMPERSAND T_VARIABLE",
 /* 210 */ "non_empty_parameter_list ::= optional_class_type AMPERSAND T_VARIABLE EQUALS static_scalar",
 /* 211 */ "non_empty_parameter_list ::= optional_class_type T_VARIABLE EQUALS static_scalar",
 /* 212 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type T_VARIABLE",
 /* 213 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type AMPERSAND T_VARIABLE",
 /* 214 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type AMPERSAND T_VARIABLE EQUALS static_scalar",
 /* 215 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type T_VARIABLE EQUALS static_scalar",
 /* 216 */ "optional_class_type ::= T_STRING|T_ARRAY",
 /* 217 */ "optional_class_type ::=",
 /* 218 */ "function_call_parameter_list ::= non_empty_function_call_parameter_list",
 /* 219 */ "function_call_parameter_list ::=",
 /* 220 */ "non_empty_function_call_parameter_list ::= expr_without_variable",
 /* 221 */ "non_empty_function_call_parameter_list ::= variable",
 /* 222 */ "non_empty_function_call_parameter_list ::= AMPERSAND w_variable",
 /* 223 */ "non_empty_function_call_parameter_list ::= non_empty_function_call_parameter_list COMMA expr_without_variable",
 /* 224 */ "non_empty_function_call_parameter_list ::= non_empty_function_call_parameter_list COMMA variable",
 /* 225 */ "non_empty_function_call_parameter_list ::= non_empty_function_call_parameter_list COMMA AMPERSAND w_variable",
 /* 226 */ "global_var_list ::= global_var_list COMMA global_var",
 /* 227 */ "global_var_list ::= global_var",
 /* 228 */ "global_var ::= T_VARIABLE",
 /* 229 */ "global_var ::= DOLLAR r_variable",
 /* 230 */ "global_var ::= DOLLAR LCURLY expr RCURLY",
 /* 231 */ "static_var_list ::= static_var_list COMMA T_VARIABLE",
 /* 232 */ "static_var_list ::= static_var_list COMMA T_VARIABLE EQUALS static_scalar",
 /* 233 */ "static_var_list ::= T_VARIABLE",
 /* 234 */ "static_var_list ::= T_VARIABLE EQUALS static_scalar",
 /* 235 */ "class_statement_list ::= class_statement_list class_statement",
 /* 236 */ "class_statement_list ::=",
 /* 237 */ "class_statement ::= variable_modifiers class_variable_declaration SEMI",
 /* 238 */ "class_statement ::= class_constant_declaration SEMI",
 /* 239 */ "get_method_line ::= T_FUNCTION",
 /* 240 */ "class_statement ::= method_modifiers get_method_line is_reference T_STRING LPAREN parameter_list RPAREN method_body",
 /* 241 */ "method_body ::= SEMI",
 /* 242 */ "method_body ::= LCURLY inner_statement_list RCURLY",
 /* 243 */ "variable_modifiers ::= non_empty_member_modifiers",
 /* 244 */ "variable_modifiers ::= T_VAR",
 /* 245 */ "method_modifiers ::= non_empty_member_modifiers",
 /* 246 */ "method_modifiers ::=",
 /* 247 */ "non_empty_member_modifiers ::= member_modifier",
 /* 248 */ "non_empty_member_modifiers ::= non_empty_member_modifiers member_modifier",
 /* 249 */ "member_modifier ::= T_PUBLIC|T_PROTECTED|T_PRIVATE|T_STATIC|T_ABSTRACT|T_FINAL",
 /* 250 */ "class_variable_declaration ::= class_variable_declaration COMMA T_VARIABLE",
 /* 251 */ "class_variable_declaration ::= class_variable_declaration COMMA T_VARIABLE EQUALS static_scalar",
 /* 252 */ "class_variable_declaration ::= T_VARIABLE",
 /* 253 */ "class_variable_declaration ::= T_VARIABLE EQUALS static_scalar",
 /* 254 */ "class_variable_declaration ::= T_VARIABLE EQUALS function_call",
 /* 255 */ "class_constant_declaration ::= class_constant_declaration COMMA T_STRING EQUALS static_scalar",
 /* 256 */ "class_constant_declaration ::= T_CONST T_STRING EQUALS static_scalar",
 /* 257 */ "echo_expr_list ::= echo_expr_list COMMA expr",
 /* 258 */ "echo_expr_list ::= expr",
 /* 259 */ "unset_variables ::= unset_variable",
 /* 260 */ "unset_variables ::= unset_variables COMMA unset_variable",
 /* 261 */ "unset_variable ::= variable",
 /* 262 */ "use_filename ::= T_CONSTANT_ENCAPSED_STRING",
 /* 263 */ "use_filename ::= LPAREN T_CONSTANT_ENCAPSED_STRING RPAREN",
 /* 264 */ "r_variable ::= variable",
 /* 265 */ "w_variable ::= variable",
 /* 266 */ "rw_variable ::= variable",
 /* 267 */ "variable ::= base_variable_with_function_calls T_OBJECT_OPERATOR object_property method_or_not variable_properties",
 /* 268 */ "variable ::= base_variable_with_function_calls",
 /* 269 */ "variable_properties ::= variable_properties variable_property",
 /* 270 */ "variable_properties ::=",
 /* 271 */ "variable_property ::= T_OBJECT_OPERATOR object_property method_or_not",
 /* 272 */ "method_or_not ::= LPAREN function_call_parameter_list RPAREN",
 /* 273 */ "method_or_not ::=",
 /* 274 */ "variable_without_objects ::= reference_variable",
 /* 275 */ "variable_without_objects ::= simple_indirect_reference reference_variable",
 /* 276 */ "static_member ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM variable_without_objects",
 /* 277 */ "base_variable_with_function_calls ::= base_variable",
 /* 278 */ "base_variable_with_function_calls ::= function_call",
 /* 279 */ "base_variable ::= reference_variable",
 /* 280 */ "base_variable ::= simple_indirect_reference reference_variable",
 /* 281 */ "base_variable ::= static_member",
 /* 282 */ "reference_variable ::= reference_variable LBRACKET dim_offset RBRACKET",
 /* 283 */ "reference_variable ::= reference_variable LCURLY expr RCURLY",
 /* 284 */ "reference_variable ::= compound_variable",
 /* 285 */ "compound_variable ::= T_VARIABLE",
 /* 286 */ "compound_variable ::= DOLLAR LCURLY expr RCURLY",
 /* 287 */ "dim_offset ::= expr",
 /* 288 */ "dim_offset ::=",
 /* 289 */ "object_property ::= object_dim_list",
 /* 290 */ "object_property ::= variable_without_objects",
 /* 291 */ "object_dim_list ::= object_dim_list LBRACKET dim_offset RBRACKET",
 /* 292 */ "object_dim_list ::= object_dim_list LCURLY expr RCURLY",
 /* 293 */ "object_dim_list ::= variable_name",
 /* 294 */ "variable_name ::= T_STRING",
 /* 295 */ "variable_name ::= LCURLY expr RCURLY",
 /* 296 */ "simple_indirect_reference ::= DOLLAR",
 /* 297 */ "simple_indirect_reference ::= simple_indirect_reference DOLLAR",
 /* 298 */ "assignment_list ::= assignment_list COMMA assignment_list_element",
 /* 299 */ "assignment_list ::= assignment_list_element",
 /* 300 */ "assignment_list_element ::= variable",
 /* 301 */ "assignment_list_element ::= get_list_line LPAREN assignment_list RPAREN",
 /* 302 */ "assignment_list_element ::=",
 /* 303 */ "array_pair_list ::= non_empty_array_pair_list possible_comma",
 /* 304 */ "array_pair_list ::=",
 /* 305 */ "non_empty_array_pair_list ::= expr T_DOUBLE_ARROW AMPERSAND w_variable",
 /* 306 */ "non_empty_array_pair_list ::= expr",
 /* 307 */ "non_empty_array_pair_list ::= AMPERSAND w_variable",
 /* 308 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA expr T_DOUBLE_ARROW expr",
 /* 309 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA expr",
 /* 310 */ "non_empty_array_pair_list ::= expr T_DOUBLE_ARROW expr",
 /* 311 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA expr T_DOUBLE_ARROW AMPERSAND w_variable",
 /* 312 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA AMPERSAND w_variable",
 /* 313 */ "encaps_list ::= encaps_list encaps_var",
 /* 314 */ "encaps_list ::=",
 /* 315 */ "encaps_var ::= T_STRING",
 /* 316 */ "encaps_var ::= T_NUM_STRING",
 /* 317 */ "encaps_var ::= T_ENCAPSED_AND_WHITESPACE",
 /* 318 */ "encaps_var ::= T_CHARACTER",
 /* 319 */ "encaps_var ::= T_BAD_CHARACTER",
 /* 320 */ "encaps_var ::= LBRACKET",
 /* 321 */ "encaps_var ::= RBRACKET",
 /* 322 */ "encaps_var ::= LCURLY",
 /* 323 */ "encaps_var ::= RCURLY",
 /* 324 */ "encaps_var ::= T_OBJECT_OPERATOR",
 /* 325 */ "encaps_var ::= T_VARIABLE",
 /* 326 */ "encaps_var_bracket_index ::= T_STRING|T_NUM_STRING|T_VARIABLE",
 /* 327 */ "encaps_var ::= T_VARIABLE LBRACKET encaps_var_bracket_index RBRACKET",
 /* 328 */ "encaps_var ::= T_VARIABLE T_OBJECT_OPERATOR T_STRING",
 /* 329 */ "encaps_var ::= T_DOLLAR_OPEN_CURLY_BRACES expr RCURLY",
 /* 330 */ "encaps_var ::= T_DOLLAR_OPEN_CURLY_BRACES T_STRING_VARNAME LBRACKET expr RBRACKET RCURLY",
 /* 331 */ "encaps_var ::= T_CURLY_OPEN variable RCURLY",
 /* 332 */ "internal_functions_in_yacc ::= T_ISSET LPAREN isset_variables RPAREN",
 /* 333 */ "internal_functions_in_yacc ::= T_EMPTY LPAREN variable RPAREN",
 /* 334 */ "get_include_line ::= T_INCLUDE",
 /* 335 */ "internal_functions_in_yacc ::= get_include_line expr",
 /* 336 */ "get_include_once_line ::= T_INCLUDE_ONCE",
 /* 337 */ "internal_functions_in_yacc ::= get_include_once_line expr",
 /* 338 */ "internal_functions_in_yacc ::= T_EVAL LPAREN expr RPAREN",
 /* 339 */ "get_require_line ::= T_REQUIRE",
 /* 340 */ "internal_functions_in_yacc ::= get_require_line expr",
 /* 341 */ "get_require_once_line ::= T_REQUIRE_ONCE",
 /* 342 */ "internal_functions_in_yacc ::= get_require_once_line expr",
 /* 343 */ "isset_variables ::= variable",
 /* 344 */ "isset_variables ::= isset_variables COMMA variable",
 /* 345 */ "class_constant ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM T_STRING",
 /* 346 */ "fully_qualified_class_name ::= T_STRING",
 /* 347 */ "function_call ::= T_STRING LPAREN function_call_parameter_list RPAREN",
 /* 348 */ "function_call ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM T_STRING LPAREN function_call_parameter_list RPAREN",
 /* 349 */ "function_call ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM variable_without_objects LPAREN function_call_parameter_list RPAREN",
 /* 350 */ "function_call ::= variable_without_objects LPAREN function_call_parameter_list RPAREN",
 /* 351 */ "scalar ::= T_STRING",
 /* 352 */ "scalar ::= T_STRING_VARNAME",
 /* 353 */ "scalar ::= class_constant",
 /* 354 */ "scalar ::= common_scalar",
 /* 355 */ "scalar ::= DOUBLEQUOTE encaps_list DOUBLEQUOTE",
 /* 356 */ "scalar ::= SINGLEQUOTE encaps_list SINGLEQUOTE",
 /* 357 */ "scalar ::= T_START_HEREDOC encaps_list T_END_HEREDOC",
 /* 358 */ "class_name_reference ::= T_STRING",
 /* 359 */ "class_name_reference ::= dynamic_class_name_reference",
 /* 360 */ "dynamic_class_name_reference ::= base_variable T_OBJECT_OPERATOR object_property dynamic_class_name_variable_properties",
 /* 361 */ "dynamic_class_name_reference ::= base_variable",
 /* 362 */ "dynamic_class_name_variable_properties ::= dynamic_class_name_variable_properties dynamic_class_name_variable_property",
 /* 363 */ "dynamic_class_name_variable_properties ::=",
 /* 364 */ "dynamic_class_name_variable_property ::= T_OBJECT_OPERATOR object_property",
 /* 365 */ "ctor_arguments ::= LPAREN function_call_parameter_list RPAREN",
 /* 366 */ "ctor_arguments ::=",
 /* 367 */ "possible_comma ::= COMMA",
 /* 368 */ "possible_comma ::=",
 /* 369 */ "for_expr ::= non_empty_for_expr",
 /* 370 */ "for_expr ::=",
 /* 371 */ "non_empty_for_expr ::= non_empty_for_expr COMMA expr",
 /* 372 */ "non_empty_for_expr ::= expr",
 /* 373 */ "is_reference ::= AMPERSAND",
 /* 374 */ "is_reference ::=",
    );

    /**
     * This function returns the symbolic name associated with a token
     * value.
     * @param int
     * @return string
     */
    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count(self::$yyTokenName)) {
            return self::$yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    /**
     * The following function deletes the value associated with a
     * symbol.  The symbol can be either a terminal or nonterminal.
     * @param int the symbol code
     * @param mixed the symbol's value
     */
    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is 
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    /**
     * Pop the parser's stack once.
     *
     * If there is a destructor routine associated with the token which
     * is popped from the stack, then call it.
     *
     * Return the major token number for the symbol popped.
     * @param PHP_Parser_CoreyyParser
     * @return int
     */
    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . self::$yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    /**
     * Deallocate and destroy a parser.  Destructors are all called for
     * all stack elements before shutting the parser down.
     */
    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    /**
     * Based on the current state and parser stack, get a list of all
     * possible lookahead tokens
     * @param int
     * @return array
     */
    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new PHP_Parser_CoreyyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    /**
     * Based on the parser state and current parser stack, determine whether
     * the lookahead token is possible.
     * 
     * The parser will convert the token value to an error token if not.  This
     * catches some unusual edge cases where the parser would fail.
     * @param int
     * @return bool
     */
    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new PHP_Parser_CoreyyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

    /**
     * Find the appropriate action for a parser given the terminal
     * look-ahead token iLookAhead.
     *
     * If the look-ahead token is YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return YY_NO_ACTION.
     * @param int The look-ahead token
     */
    function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        self::$yyTokenName[$iLookAhead] . " => " .
                        self::$yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Find the appropriate action for a parser given the non-terminal
     * look-ahead token $iLookAhead.
     *
     * If the look-ahead token is self::YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return self::YY_NO_ACTION.
     * @param int Current state number
     * @param int The look-ahead token
     */
    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Perform a shift action.
     * @param int The new state to shift in
     * @param int The major token to shift in
     * @param mixed the minor token to shift in
     */
    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            /* Here code is inserted which will execute if the parser
            ** stack ever overflows */
            return;
        }
        $yytos = new PHP_Parser_CoreyyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    self::$yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    /**
     * The following table contains information about every rule that
     * is used during the reduce.
     *
     * <pre>
     * array(
     *  array(
     *   int $lhs;         Symbol on the left-hand side of the rule
     *   int $nrhs;     Number of right-hand side symbols in the rule
     *  ),...
     * );
     * </pre>
     */
    static public $yyRuleInfo = array(
  array( 'lhs' => 145, 'rhs' => 1 ),
  array( 'lhs' => 146, 'rhs' => 2 ),
  array( 'lhs' => 146, 'rhs' => 0 ),
  array( 'lhs' => 147, 'rhs' => 1 ),
  array( 'lhs' => 147, 'rhs' => 1 ),
  array( 'lhs' => 147, 'rhs' => 1 ),
  array( 'lhs' => 147, 'rhs' => 4 ),
  array( 'lhs' => 148, 'rhs' => 1 ),
  array( 'lhs' => 152, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 154, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 7 ),
  array( 'lhs' => 151, 'rhs' => 10 ),
  array( 'lhs' => 160, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 5 ),
  array( 'lhs' => 162, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 7 ),
  array( 'lhs' => 163, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 9 ),
  array( 'lhs' => 166, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 5 ),
  array( 'lhs' => 168, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 2 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 169, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 2 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 170, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 2 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 173, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 175, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 177, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 2 ),
  array( 'lhs' => 179, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 181, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 5 ),
  array( 'lhs' => 183, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 8 ),
  array( 'lhs' => 151, 'rhs' => 8 ),
  array( 'lhs' => 187, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 5 ),
  array( 'lhs' => 151, 'rhs' => 1 ),
  array( 'lhs' => 190, 'rhs' => 1 ),
  array( 'lhs' => 191, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 13 ),
  array( 'lhs' => 194, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 193, 'rhs' => 1 ),
  array( 'lhs' => 193, 'rhs' => 0 ),
  array( 'lhs' => 195, 'rhs' => 1 ),
  array( 'lhs' => 195, 'rhs' => 2 ),
  array( 'lhs' => 196, 'rhs' => 8 ),
  array( 'lhs' => 153, 'rhs' => 2 ),
  array( 'lhs' => 153, 'rhs' => 0 ),
  array( 'lhs' => 197, 'rhs' => 1 ),
  array( 'lhs' => 197, 'rhs' => 1 ),
  array( 'lhs' => 197, 'rhs' => 1 ),
  array( 'lhs' => 197, 'rhs' => 4 ),
  array( 'lhs' => 149, 'rhs' => 1 ),
  array( 'lhs' => 150, 'rhs' => 1 ),
  array( 'lhs' => 200, 'rhs' => 1 ),
  array( 'lhs' => 198, 'rhs' => 9 ),
  array( 'lhs' => 199, 'rhs' => 7 ),
  array( 'lhs' => 199, 'rhs' => 6 ),
  array( 'lhs' => 203, 'rhs' => 1 ),
  array( 'lhs' => 203, 'rhs' => 2 ),
  array( 'lhs' => 203, 'rhs' => 2 ),
  array( 'lhs' => 204, 'rhs' => 2 ),
  array( 'lhs' => 204, 'rhs' => 0 ),
  array( 'lhs' => 207, 'rhs' => 1 ),
  array( 'lhs' => 208, 'rhs' => 2 ),
  array( 'lhs' => 208, 'rhs' => 0 ),
  array( 'lhs' => 205, 'rhs' => 0 ),
  array( 'lhs' => 205, 'rhs' => 2 ),
  array( 'lhs' => 209, 'rhs' => 1 ),
  array( 'lhs' => 209, 'rhs' => 3 ),
  array( 'lhs' => 155, 'rhs' => 1 ),
  array( 'lhs' => 155, 'rhs' => 1 ),
  array( 'lhs' => 211, 'rhs' => 1 ),
  array( 'lhs' => 171, 'rhs' => 6 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 4 ),
  array( 'lhs' => 171, 'rhs' => 6 ),
  array( 'lhs' => 215, 'rhs' => 1 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 216, 'rhs' => 1 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 5 ),
  array( 'lhs' => 171, 'rhs' => 1 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 171, 'rhs' => 1 ),
  array( 'lhs' => 171, 'rhs' => 4 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 2 ),
  array( 'lhs' => 221, 'rhs' => 1 ),
  array( 'lhs' => 219, 'rhs' => 2 ),
  array( 'lhs' => 219, 'rhs' => 3 ),
  array( 'lhs' => 219, 'rhs' => 0 ),
  array( 'lhs' => 224, 'rhs' => 1 ),
  array( 'lhs' => 225, 'rhs' => 1 ),
  array( 'lhs' => 225, 'rhs' => 1 ),
  array( 'lhs' => 225, 'rhs' => 2 ),
  array( 'lhs' => 225, 'rhs' => 2 ),
  array( 'lhs' => 225, 'rhs' => 4 ),
  array( 'lhs' => 225, 'rhs' => 1 ),
  array( 'lhs' => 226, 'rhs' => 1 ),
  array( 'lhs' => 227, 'rhs' => 1 ),
  array( 'lhs' => 227, 'rhs' => 2 ),
  array( 'lhs' => 227, 'rhs' => 0 ),
  array( 'lhs' => 229, 'rhs' => 5 ),
  array( 'lhs' => 229, 'rhs' => 3 ),
  array( 'lhs' => 229, 'rhs' => 3 ),
  array( 'lhs' => 229, 'rhs' => 1 ),
  array( 'lhs' => 228, 'rhs' => 3 ),
  array( 'lhs' => 185, 'rhs' => 2 ),
  array( 'lhs' => 185, 'rhs' => 0 ),
  array( 'lhs' => 184, 'rhs' => 1 ),
  array( 'lhs' => 184, 'rhs' => 2 ),
  array( 'lhs' => 165, 'rhs' => 1 ),
  array( 'lhs' => 165, 'rhs' => 4 ),
  array( 'lhs' => 186, 'rhs' => 1 ),
  array( 'lhs' => 186, 'rhs' => 4 ),
  array( 'lhs' => 189, 'rhs' => 1 ),
  array( 'lhs' => 189, 'rhs' => 4 ),
  array( 'lhs' => 188, 'rhs' => 3 ),
  array( 'lhs' => 188, 'rhs' => 5 ),
  array( 'lhs' => 167, 'rhs' => 3 ),
  array( 'lhs' => 167, 'rhs' => 4 ),
  array( 'lhs' => 167, 'rhs' => 4 ),
  array( 'lhs' => 167, 'rhs' => 5 ),
  array( 'lhs' => 231, 'rhs' => 5 ),
  array( 'lhs' => 231, 'rhs' => 4 ),
  array( 'lhs' => 231, 'rhs' => 0 ),
  array( 'lhs' => 232, 'rhs' => 1 ),
  array( 'lhs' => 161, 'rhs' => 1 ),
  array( 'lhs' => 161, 'rhs' => 4 ),
  array( 'lhs' => 156, 'rhs' => 6 ),
  array( 'lhs' => 156, 'rhs' => 7 ),
  array( 'lhs' => 156, 'rhs' => 0 ),
  array( 'lhs' => 158, 'rhs' => 7 ),
  array( 'lhs' => 158, 'rhs' => 0 ),
  array( 'lhs' => 157, 'rhs' => 2 ),
  array( 'lhs' => 157, 'rhs' => 0 ),
  array( 'lhs' => 159, 'rhs' => 3 ),
  array( 'lhs' => 159, 'rhs' => 0 ),
  array( 'lhs' => 202, 'rhs' => 1 ),
  array( 'lhs' => 202, 'rhs' => 0 ),
  array( 'lhs' => 233, 'rhs' => 2 ),
  array( 'lhs' => 233, 'rhs' => 3 ),
  array( 'lhs' => 233, 'rhs' => 5 ),
  array( 'lhs' => 233, 'rhs' => 4 ),
  array( 'lhs' => 233, 'rhs' => 4 ),
  array( 'lhs' => 233, 'rhs' => 5 ),
  array( 'lhs' => 233, 'rhs' => 7 ),
  array( 'lhs' => 233, 'rhs' => 6 ),
  array( 'lhs' => 234, 'rhs' => 1 ),
  array( 'lhs' => 234, 'rhs' => 0 ),
  array( 'lhs' => 235, 'rhs' => 1 ),
  array( 'lhs' => 235, 'rhs' => 0 ),
  array( 'lhs' => 236, 'rhs' => 1 ),
  array( 'lhs' => 236, 'rhs' => 1 ),
  array( 'lhs' => 236, 'rhs' => 2 ),
  array( 'lhs' => 236, 'rhs' => 3 ),
  array( 'lhs' => 236, 'rhs' => 3 ),
  array( 'lhs' => 236, 'rhs' => 4 ),
  array( 'lhs' => 174, 'rhs' => 3 ),
  array( 'lhs' => 174, 'rhs' => 1 ),
  array( 'lhs' => 237, 'rhs' => 1 ),
  array( 'lhs' => 237, 'rhs' => 2 ),
  array( 'lhs' => 237, 'rhs' => 4 ),
  array( 'lhs' => 176, 'rhs' => 3 ),
  array( 'lhs' => 176, 'rhs' => 5 ),
  array( 'lhs' => 176, 'rhs' => 1 ),
  array( 'lhs' => 176, 'rhs' => 3 ),
  array( 'lhs' => 206, 'rhs' => 2 ),
  array( 'lhs' => 206, 'rhs' => 0 ),
  array( 'lhs' => 238, 'rhs' => 3 ),
  array( 'lhs' => 238, 'rhs' => 2 ),
  array( 'lhs' => 242, 'rhs' => 1 ),
  array( 'lhs' => 238, 'rhs' => 8 ),
  array( 'lhs' => 244, 'rhs' => 1 ),
  array( 'lhs' => 244, 'rhs' => 3 ),
  array( 'lhs' => 239, 'rhs' => 1 ),
  array( 'lhs' => 239, 'rhs' => 1 ),
  array( 'lhs' => 243, 'rhs' => 1 ),
  array( 'lhs' => 243, 'rhs' => 0 ),
  array( 'lhs' => 245, 'rhs' => 1 ),
  array( 'lhs' => 245, 'rhs' => 2 ),
  array( 'lhs' => 246, 'rhs' => 1 ),
  array( 'lhs' => 240, 'rhs' => 3 ),
  array( 'lhs' => 240, 'rhs' => 5 ),
  array( 'lhs' => 240, 'rhs' => 1 ),
  array( 'lhs' => 240, 'rhs' => 3 ),
  array( 'lhs' => 240, 'rhs' => 3 ),
  array( 'lhs' => 241, 'rhs' => 5 ),
  array( 'lhs' => 241, 'rhs' => 4 ),
  array( 'lhs' => 178, 'rhs' => 3 ),
  array( 'lhs' => 178, 'rhs' => 1 ),
  array( 'lhs' => 182, 'rhs' => 1 ),
  array( 'lhs' => 182, 'rhs' => 3 ),
  array( 'lhs' => 248, 'rhs' => 1 ),
  array( 'lhs' => 180, 'rhs' => 1 ),
  array( 'lhs' => 180, 'rhs' => 3 ),
  array( 'lhs' => 210, 'rhs' => 1 ),
  array( 'lhs' => 230, 'rhs' => 1 ),
  array( 'lhs' => 217, 'rhs' => 1 ),
  array( 'lhs' => 172, 'rhs' => 5 ),
  array( 'lhs' => 172, 'rhs' => 1 ),
  array( 'lhs' => 252, 'rhs' => 2 ),
  array( 'lhs' => 252, 'rhs' => 0 ),
  array( 'lhs' => 253, 'rhs' => 3 ),
  array( 'lhs' => 251, 'rhs' => 3 ),
  array( 'lhs' => 251, 'rhs' => 0 ),
  array( 'lhs' => 254, 'rhs' => 1 ),
  array( 'lhs' => 254, 'rhs' => 2 ),
  array( 'lhs' => 257, 'rhs' => 3 ),
  array( 'lhs' => 249, 'rhs' => 1 ),
  array( 'lhs' => 249, 'rhs' => 1 ),
  array( 'lhs' => 258, 'rhs' => 1 ),
  array( 'lhs' => 258, 'rhs' => 2 ),
  array( 'lhs' => 258, 'rhs' => 1 ),
  array( 'lhs' => 255, 'rhs' => 4 ),
  array( 'lhs' => 255, 'rhs' => 4 ),
  array( 'lhs' => 255, 'rhs' => 1 ),
  array( 'lhs' => 260, 'rhs' => 1 ),
  array( 'lhs' => 260, 'rhs' => 4 ),
  array( 'lhs' => 259, 'rhs' => 1 ),
  array( 'lhs' => 259, 'rhs' => 0 ),
  array( 'lhs' => 250, 'rhs' => 1 ),
  array( 'lhs' => 250, 'rhs' => 1 ),
  array( 'lhs' => 261, 'rhs' => 4 ),
  array( 'lhs' => 261, 'rhs' => 4 ),
  array( 'lhs' => 261, 'rhs' => 1 ),
  array( 'lhs' => 262, 'rhs' => 1 ),
  array( 'lhs' => 262, 'rhs' => 3 ),
  array( 'lhs' => 256, 'rhs' => 1 ),
  array( 'lhs' => 256, 'rhs' => 2 ),
  array( 'lhs' => 212, 'rhs' => 3 ),
  array( 'lhs' => 212, 'rhs' => 1 ),
  array( 'lhs' => 263, 'rhs' => 1 ),
  array( 'lhs' => 263, 'rhs' => 4 ),
  array( 'lhs' => 263, 'rhs' => 0 ),
  array( 'lhs' => 222, 'rhs' => 2 ),
  array( 'lhs' => 222, 'rhs' => 0 ),
  array( 'lhs' => 264, 'rhs' => 4 ),
  array( 'lhs' => 264, 'rhs' => 1 ),
  array( 'lhs' => 264, 'rhs' => 2 ),
  array( 'lhs' => 264, 'rhs' => 5 ),
  array( 'lhs' => 264, 'rhs' => 3 ),
  array( 'lhs' => 264, 'rhs' => 3 ),
  array( 'lhs' => 264, 'rhs' => 6 ),
  array( 'lhs' => 264, 'rhs' => 4 ),
  array( 'lhs' => 223, 'rhs' => 2 ),
  array( 'lhs' => 223, 'rhs' => 0 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 1 ),
  array( 'lhs' => 267, 'rhs' => 1 ),
  array( 'lhs' => 266, 'rhs' => 4 ),
  array( 'lhs' => 266, 'rhs' => 3 ),
  array( 'lhs' => 266, 'rhs' => 3 ),
  array( 'lhs' => 266, 'rhs' => 6 ),
  array( 'lhs' => 266, 'rhs' => 3 ),
  array( 'lhs' => 218, 'rhs' => 4 ),
  array( 'lhs' => 218, 'rhs' => 4 ),
  array( 'lhs' => 269, 'rhs' => 1 ),
  array( 'lhs' => 218, 'rhs' => 2 ),
  array( 'lhs' => 270, 'rhs' => 1 ),
  array( 'lhs' => 218, 'rhs' => 2 ),
  array( 'lhs' => 218, 'rhs' => 4 ),
  array( 'lhs' => 271, 'rhs' => 1 ),
  array( 'lhs' => 218, 'rhs' => 2 ),
  array( 'lhs' => 272, 'rhs' => 1 ),
  array( 'lhs' => 218, 'rhs' => 2 ),
  array( 'lhs' => 268, 'rhs' => 1 ),
  array( 'lhs' => 268, 'rhs' => 3 ),
  array( 'lhs' => 273, 'rhs' => 3 ),
  array( 'lhs' => 192, 'rhs' => 1 ),
  array( 'lhs' => 247, 'rhs' => 4 ),
  array( 'lhs' => 247, 'rhs' => 6 ),
  array( 'lhs' => 247, 'rhs' => 6 ),
  array( 'lhs' => 247, 'rhs' => 4 ),
  array( 'lhs' => 220, 'rhs' => 1 ),
  array( 'lhs' => 220, 'rhs' => 1 ),
  array( 'lhs' => 220, 'rhs' => 1 ),
  array( 'lhs' => 220, 'rhs' => 1 ),
  array( 'lhs' => 220, 'rhs' => 3 ),
  array( 'lhs' => 220, 'rhs' => 3 ),
  array( 'lhs' => 220, 'rhs' => 3 ),
  array( 'lhs' => 213, 'rhs' => 1 ),
  array( 'lhs' => 213, 'rhs' => 1 ),
  array( 'lhs' => 274, 'rhs' => 4 ),
  array( 'lhs' => 274, 'rhs' => 1 ),
  array( 'lhs' => 275, 'rhs' => 2 ),
  array( 'lhs' => 275, 'rhs' => 0 ),
  array( 'lhs' => 276, 'rhs' => 2 ),
  array( 'lhs' => 214, 'rhs' => 3 ),
  array( 'lhs' => 214, 'rhs' => 0 ),
  array( 'lhs' => 265, 'rhs' => 1 ),
  array( 'lhs' => 265, 'rhs' => 0 ),
  array( 'lhs' => 164, 'rhs' => 1 ),
  array( 'lhs' => 164, 'rhs' => 0 ),
  array( 'lhs' => 277, 'rhs' => 3 ),
  array( 'lhs' => 277, 'rhs' => 1 ),
  array( 'lhs' => 201, 'rhs' => 1 ),
  array( 'lhs' => 201, 'rhs' => 0 ),
    );

    /**
     * The following table contains a mapping of reduce action to method name
     * that handles the reduction.
     * 
     * If a rule is not set, it has no handler.
     */
    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        57 => 1,
        59 => 1,
        235 => 1,
        248 => 1,
        269 => 1,
        313 => 1,
        362 => 1,
        2 => 2,
        78 => 2,
        79 => 2,
        169 => 2,
        207 => 2,
        219 => 2,
        246 => 2,
        304 => 2,
        366 => 2,
        370 => 2,
        3 => 3,
        4 => 4,
        5 => 5,
        6 => 6,
        64 => 6,
        7 => 7,
        74 => 7,
        77 => 7,
        80 => 7,
        83 => 7,
        84 => 7,
        160 => 7,
        161 => 7,
        165 => 7,
        167 => 7,
        175 => 7,
        177 => 7,
        206 => 7,
        216 => 7,
        218 => 7,
        243 => 7,
        245 => 7,
        249 => 7,
        261 => 7,
        262 => 7,
        264 => 7,
        265 => 7,
        266 => 7,
        268 => 7,
        274 => 7,
        277 => 7,
        278 => 7,
        279 => 7,
        281 => 7,
        284 => 7,
        287 => 7,
        289 => 7,
        290 => 7,
        293 => 7,
        294 => 7,
        326 => 7,
        346 => 7,
        351 => 7,
        352 => 7,
        353 => 7,
        354 => 7,
        358 => 7,
        359 => 7,
        361 => 7,
        369 => 7,
        8 => 8,
        10 => 8,
        13 => 8,
        15 => 8,
        17 => 8,
        19 => 8,
        21 => 8,
        24 => 8,
        27 => 8,
        31 => 8,
        33 => 8,
        35 => 8,
        39 => 8,
        41 => 8,
        43 => 8,
        46 => 8,
        49 => 8,
        50 => 8,
        52 => 8,
        67 => 8,
        76 => 8,
        85 => 8,
        90 => 8,
        92 => 8,
        155 => 8,
        166 => 8,
        194 => 8,
        239 => 8,
        334 => 8,
        336 => 8,
        339 => 8,
        341 => 8,
        9 => 9,
        11 => 11,
        12 => 12,
        14 => 14,
        16 => 16,
        18 => 18,
        20 => 20,
        22 => 22,
        23 => 23,
        25 => 25,
        26 => 26,
        28 => 28,
        29 => 29,
        30 => 29,
        32 => 32,
        34 => 34,
        36 => 36,
        37 => 37,
        38 => 38,
        40 => 40,
        42 => 42,
        44 => 44,
        45 => 44,
        47 => 47,
        51 => 51,
        53 => 53,
        54 => 54,
        61 => 54,
        62 => 54,
        63 => 54,
        65 => 54,
        66 => 54,
        140 => 54,
        159 => 54,
        300 => 54,
        315 => 54,
        316 => 54,
        317 => 54,
        318 => 54,
        319 => 54,
        325 => 54,
        55 => 55,
        60 => 55,
        193 => 55,
        199 => 55,
        201 => 55,
        203 => 55,
        236 => 55,
        270 => 55,
        302 => 55,
        314 => 55,
        363 => 55,
        56 => 56,
        202 => 56,
        299 => 56,
        58 => 58,
        68 => 68,
        69 => 69,
        70 => 70,
        71 => 71,
        72 => 72,
        73 => 73,
        75 => 75,
        156 => 75,
        158 => 75,
        176 => 75,
        217 => 75,
        241 => 75,
        273 => 75,
        288 => 75,
        81 => 81,
        82 => 82,
        86 => 86,
        87 => 87,
        88 => 88,
        89 => 89,
        91 => 91,
        93 => 93,
        94 => 94,
        95 => 95,
        96 => 96,
        97 => 97,
        98 => 98,
        99 => 99,
        100 => 100,
        101 => 101,
        102 => 102,
        103 => 103,
        104 => 104,
        105 => 105,
        106 => 106,
        107 => 107,
        108 => 108,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        114 => 114,
        115 => 115,
        116 => 116,
        117 => 117,
        118 => 118,
        119 => 119,
        120 => 120,
        121 => 121,
        122 => 122,
        123 => 123,
        124 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        139 => 139,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        152 => 152,
        164 => 152,
        153 => 153,
        154 => 154,
        157 => 157,
        168 => 157,
        187 => 157,
        188 => 157,
        242 => 157,
        263 => 157,
        272 => 157,
        303 => 157,
        365 => 157,
        162 => 162,
        163 => 163,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        345 => 174,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        195 => 181,
        182 => 182,
        183 => 183,
        184 => 184,
        185 => 185,
        186 => 186,
        189 => 189,
        190 => 189,
        191 => 191,
        192 => 192,
        196 => 196,
        197 => 197,
        198 => 198,
        200 => 200,
        204 => 204,
        205 => 205,
        208 => 208,
        209 => 209,
        210 => 210,
        211 => 211,
        212 => 212,
        213 => 213,
        214 => 214,
        215 => 215,
        220 => 220,
        221 => 220,
        222 => 222,
        223 => 223,
        224 => 223,
        225 => 225,
        226 => 226,
        231 => 226,
        257 => 226,
        260 => 226,
        298 => 226,
        344 => 226,
        371 => 226,
        227 => 227,
        247 => 227,
        258 => 227,
        259 => 227,
        372 => 227,
        228 => 228,
        285 => 228,
        229 => 229,
        230 => 230,
        286 => 230,
        232 => 232,
        233 => 233,
        252 => 233,
        234 => 234,
        237 => 237,
        238 => 238,
        240 => 240,
        244 => 244,
        250 => 250,
        251 => 251,
        253 => 253,
        254 => 254,
        255 => 255,
        256 => 256,
        267 => 267,
        271 => 271,
        275 => 275,
        280 => 275,
        276 => 276,
        282 => 282,
        283 => 282,
        291 => 282,
        292 => 282,
        295 => 295,
        296 => 296,
        297 => 297,
        301 => 301,
        305 => 305,
        306 => 306,
        307 => 307,
        308 => 308,
        309 => 309,
        310 => 310,
        311 => 311,
        312 => 312,
        320 => 320,
        321 => 321,
        322 => 322,
        323 => 323,
        324 => 324,
        327 => 327,
        328 => 328,
        329 => 329,
        330 => 330,
        331 => 331,
        332 => 332,
        333 => 333,
        335 => 335,
        337 => 337,
        338 => 338,
        340 => 340,
        342 => 342,
        343 => 343,
        347 => 347,
        348 => 348,
        349 => 349,
        350 => 350,
        355 => 355,
        356 => 356,
        357 => 357,
        360 => 360,
        364 => 364,
        367 => 367,
        373 => 367,
        368 => 368,
        374 => 368,
    );
    /* Beginning here are the reduction cases.  A typical example
    ** follows:
    **  #line <lineno> <grammarfile>
    **   function yy_r0($yymsp){ ... }           // User supplied code
    **  #line <lineno> <thisfile>
    */
#line 149 "Core.y"
    function yy_r0(){
	$this->root = new AOWP_PHPRootElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5931 "Core.php"
#line 153 "Core.y"
    function yy_r1(){
	$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
	$this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5937 "Core.php"
#line 157 "Core.y"
    function yy_r2(){ $this->_retvalue = array();     }
#line 5940 "Core.php"
#line 159 "Core.y"
    function yy_r3(){
	$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
	$this->globals[] = &$this->yystack[$this->yyidx + 0]->minor;
    }
#line 5946 "Core.php"
#line 163 "Core.y"
    function yy_r4(){
	$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
	$this->functions[] = &$this->yystack[$this->yyidx + 0]->minor;
    }
#line 5952 "Core.php"
#line 167 "Core.y"
    function yy_r5(){
	$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
	$this->classes[] = &$this->yystack[$this->yyidx + 0]->minor;
    }
#line 5958 "Core.php"
#line 171 "Core.y"
    function yy_r6(){
	$this->_retvalue = new AOWP_PHPHaltCompilerStatementElement($this->lex->line);
    }
#line 5963 "Core.php"
#line 175 "Core.y"
    function yy_r7(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 5966 "Core.php"
#line 177 "Core.y"
    function yy_r8(){ $this->_retvalue = $this->lex->line;     }
#line 5969 "Core.php"
#line 178 "Core.y"
    function yy_r9(){ 
	$this->_retvalue = new AOWP_PHPInnerStatementElement($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor); 
    }
#line 5974 "Core.php"
#line 183 "Core.y"
    function yy_r11(){
	$this->_retvalue = new AOWP_PHPIfStatementElement($this->yystack[$this->yyidx + -6]->minor, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5979 "Core.php"
#line 186 "Core.y"
    function yy_r12(){
	$this->_retvalue = new AOWP_PHPNewIfStatementElement($this->yystack[$this->yyidx + -9]->minor, $this->yystack[$this->yyidx + -7]->minor, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -2]->minor);
    }
#line 5984 "Core.php"
#line 191 "Core.y"
    function yy_r14(){
	list($isNewWhile, $val) = $this->yystack[$this->yyidx + 0]->minor;
	if( $isNewWhile ){
		$this->_retvalue = new AOWP_PHPNewWhileStatementElement($this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor, $val);
	}
	else{
		$this->_retvalue = new AOWP_PHPWhileStatementElement($this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor, $val);
	}
    }
#line 5995 "Core.php"
#line 202 "Core.y"
    function yy_r16(){
	$this->_retvalue = new AOWP_PHPDoWhileStatementElement($this->yystack[$this->yyidx + -6]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -5]->minor);
    }
#line 6000 "Core.php"
#line 215 "Core.y"
    function yy_r18(){
	list($isNewFor, $val) = $this->yystack[$this->yyidx + 0]->minor;
	if($isNewFor){
		$this->_retvalue = new AOWP_PHPNewForStatementElement($this->yystack[$this->yyidx + -8]->minor, $this->yystack[$this->yyidx + -6]->minor, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor, $val);
	}
	else{
		$this->_retvalue = new AOWP_PHPForStatementElement($this->yystack[$this->yyidx + -8]->minor, $this->yystack[$this->yyidx + -6]->minor, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor, $val);
	}
    }
#line 6011 "Core.php"
#line 226 "Core.y"
    function yy_r20(){
 $this->_retvalue = new AOWP_PHPSwitchStatementElement($this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6016 "Core.php"
#line 231 "Core.y"
    function yy_r22(){
	$this->_retvalue = new AOWP_PHPBreakStatementElement($this->yystack[$this->yyidx + -1]->minor, null);
    }
#line 6021 "Core.php"
#line 234 "Core.y"
    function yy_r23(){
	$this->_retvalue = new AOWP_PHPBreakStatementElement($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6026 "Core.php"
#line 239 "Core.y"
    function yy_r25(){
	$this->_retvalue = new AOWP_PHPContinueStatementElement($this->yystack[$this->yyidx + -1]->minor, null);
    }
#line 6031 "Core.php"
#line 242 "Core.y"
    function yy_r26(){
	$this->_retvalue = new AOWP_PHPContinueStatementElement($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6036 "Core.php"
#line 247 "Core.y"
    function yy_r28(){
	$this->_retvalue = new AOWP_PHPReturnStatementElement($this->yystack[$this->yyidx + -1]->minor, null); 
    }
#line 6041 "Core.php"
#line 250 "Core.y"
    function yy_r29(){
	$this->_retvalue = new AOWP_PHPReturnStatementElement($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6046 "Core.php"
#line 258 "Core.y"
    function yy_r32(){
	$this->_retvalue = new AOWP_PHPDefineVariableStatementElement($this->yystack[$this->yyidx + -2]->minor, 'global', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6051 "Core.php"
#line 263 "Core.y"
    function yy_r34(){
	$this->_retvalue = new AOWP_PHPDefineVariableStatementElement($this->yystack[$this->yyidx + -2]->minor, 'static', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6056 "Core.php"
#line 268 "Core.y"
    function yy_r36(){
	$this->_retvalue = new AOWP_PHPEchoStatementElement($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6061 "Core.php"
#line 272 "Core.y"
    function yy_r37(){
	$this->_retvalue = new AOWP_PHPInnerHTMLStatementElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6066 "Core.php"
#line 276 "Core.y"
    function yy_r38(){
	$this->_retvalue = new AOWP_PHPStatementElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6071 "Core.php"
#line 281 "Core.y"
    function yy_r40(){
	$this->_retvalue = new AOWP_PHPUseStatementElement($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6076 "Core.php"
#line 286 "Core.y"
    function yy_r42(){
	$this->_retvalue = new AOWP_PHPUnsetStatementElement($this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor);
    }
#line 6081 "Core.php"
#line 293 "Core.y"
    function yy_r44(){
	list($isNewForeach, $val) = $this->yystack[$this->yyidx + 0]->minor;
	if( $isNewForeach ){
		$this->_retvalue = new AOWP_PHPNewForeachStatementElement($this->yystack[$this->yyidx + -7]->minor, $this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -2]->minor, $val);
	}
	else{
		$this->_retvalue = new AOWP_PHPForeachStatementElement($this->yystack[$this->yyidx + -7]->minor, $this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -2]->minor, $val);
	}
    }
#line 6092 "Core.php"
#line 315 "Core.y"
    function yy_r47(){
	$this->_retvalue = new AOWP_PHPDeclareStatementElement($this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6097 "Core.php"
#line 328 "Core.y"
    function yy_r51(){
	$v = new AOWP_PHPVariableElement($this->yystack[$this->yyidx + -8]->minor, $this->yystack[$this->yyidx + -5]->minor);
	$catch = new AOWP_PHPCatchStatementElement($this->yystack[$this->yyidx + -8]->minor, $this->yystack[$this->yyidx + -6]->minor, $v, $this->yystack[$this->yyidx + -2]->minor);
	array_unshift($this->yystack[$this->yyidx + 0]->minor, $catch);
	$this->_retvalue = new AOWP_PHPTryCatchStatementElement($this->yystack[$this->yyidx + -12]->minor, $this->yystack[$this->yyidx + -10]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6105 "Core.php"
#line 336 "Core.y"
    function yy_r53(){
	$this->_retvalue = new AOWP_PHPThrowStatementElement($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6110 "Core.php"
#line 340 "Core.y"
    function yy_r54(){
	$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6115 "Core.php"
#line 343 "Core.y"
    function yy_r55(){
	$this->_retvalue = array();
    }
#line 6120 "Core.php"
#line 347 "Core.y"
    function yy_r56(){
	$this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 6125 "Core.php"
#line 355 "Core.y"
    function yy_r58(){
	$v = new AOWP_PHPVariableElement($this->yystack[$this->yyidx + -7]->minor, $this->yystack[$this->yyidx + -4]->minor);
	$this->_retvalue = new AOWP_PHPCatchStatementElement($this->yystack[$this->yyidx + -7]->minor, $this->yystack[$this->yyidx + -5]->minor, $v, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6131 "Core.php"
#line 392 "Core.y"
    function yy_r68(){
	$this->_retvalue = new AOWP_PHPFunctionElement($this->yystack[$this->yyidx + -8]->minor, $this->yystack[$this->yyidx + -7]->minor, $this->yystack[$this->yyidx + -6]->minor, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6136 "Core.php"
#line 401 "Core.y"
    function yy_r69(){
	list($line, $type) = $this->yystack[$this->yyidx + -6]->minor;
	$this->_retvalue = new AOWP_PHPClassElement($line, $type, $this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6142 "Core.php"
#line 410 "Core.y"
    function yy_r70(){
	$this->_retvalue = new AOWP_PHPInterfaceElement($this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6147 "Core.php"
#line 414 "Core.y"
    function yy_r71(){ $this->_retvalue = array($this->lex->line, "");     }
#line 6150 "Core.php"
#line 415 "Core.y"
    function yy_r72(){ $this->_retvalue = array($this->lex->line, "abstract");     }
#line 6153 "Core.php"
#line 416 "Core.y"
    function yy_r73(){ $this->_retvalue = array($this->lex->line, "final");     }
#line 6156 "Core.php"
#line 419 "Core.y"
    function yy_r75(){ $this->_retvalue = null;     }
#line 6159 "Core.php"
#line 429 "Core.y"
    function yy_r81(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);     }
#line 6162 "Core.php"
#line 430 "Core.y"
    function yy_r82(){ 
	$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
	$this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6168 "Core.php"
#line 439 "Core.y"
    function yy_r86(){
	$list_element = new AOWP_PHPListElement($this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -3]->minor);
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->yystack[$this->yyidx + -5]->minor, $list_element, '=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6174 "Core.php"
#line 443 "Core.y"
    function yy_r87(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6179 "Core.php"
#line 446 "Core.y"
    function yy_r88(){
	$amp = new AOWP_PHPAmpersandExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -3]->minor, '=', $amp);
    }
#line 6185 "Core.php"
#line 451 "Core.y"
    function yy_r89(){
	$newExpr = new AOWP_PHPNewExprElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);
	$ampExpr = new AOWP_PHPAmpersandExprElement($this->lex->line, $newExpr);
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -5]->minor, '=', $ampExpr);
    }
#line 6192 "Core.php"
#line 458 "Core.y"
    function yy_r91(){
	$this->_retvalue = new AOWP_PHPNewExprElement($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6197 "Core.php"
#line 463 "Core.y"
    function yy_r93(){
	$this->_retvalue = new AOWP_PHPCloneExprElement($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6202 "Core.php"
#line 466 "Core.y"
    function yy_r94(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '+=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6207 "Core.php"
#line 469 "Core.y"
    function yy_r95(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '-=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6212 "Core.php"
#line 473 "Core.y"
    function yy_r96(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '*=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6217 "Core.php"
#line 477 "Core.y"
    function yy_r97(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '/=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6222 "Core.php"
#line 481 "Core.y"
    function yy_r98(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '.=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6227 "Core.php"
#line 485 "Core.y"
    function yy_r99(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '%=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6232 "Core.php"
#line 489 "Core.y"
    function yy_r100(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '&=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6237 "Core.php"
#line 493 "Core.y"
    function yy_r101(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '|=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6242 "Core.php"
#line 497 "Core.y"
    function yy_r102(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '^=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6247 "Core.php"
#line 501 "Core.y"
    function yy_r103(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '<<=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6252 "Core.php"
#line 505 "Core.y"
    function yy_r104(){
	$this->_retvalue = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '>>=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6257 "Core.php"
#line 509 "Core.y"
    function yy_r105(){
	$this->_retvalue = new AOWP_PHPPostfixMonadicOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor, '++');
    }
#line 6262 "Core.php"
#line 512 "Core.y"
    function yy_r106(){
	$this->_retvalue = new AOWP_PHPPrefixMonadicOperatorExprElement($this->lex->line, '++', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6267 "Core.php"
#line 515 "Core.y"
    function yy_r107(){
	$this->_retvalue = new AOWP_PHPPostfixMonadicOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor, '--');
    }
#line 6272 "Core.php"
#line 518 "Core.y"
    function yy_r108(){
	$this->_retvalue = new AOWP_PHPPrefixMonadicOperatorExprElement($this->lex->line, '--', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6277 "Core.php"
#line 521 "Core.y"
    function yy_r109(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '||', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6282 "Core.php"
#line 524 "Core.y"
    function yy_r110(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '&&', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6287 "Core.php"
#line 527 "Core.y"
    function yy_r111(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, 'or', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6292 "Core.php"
#line 530 "Core.y"
    function yy_r112(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, 'and', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6297 "Core.php"
#line 533 "Core.y"
    function yy_r113(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, 'xor', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6302 "Core.php"
#line 536 "Core.y"
    function yy_r114(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '|', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6307 "Core.php"
#line 539 "Core.y"
    function yy_r115(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '&', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6312 "Core.php"
#line 542 "Core.y"
    function yy_r116(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '^', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6317 "Core.php"
#line 545 "Core.y"
    function yy_r117(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '.', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6322 "Core.php"
#line 548 "Core.y"
    function yy_r118(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '+', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6327 "Core.php"
#line 551 "Core.y"
    function yy_r119(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '-', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6332 "Core.php"
#line 554 "Core.y"
    function yy_r120(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '*', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6337 "Core.php"
#line 557 "Core.y"
    function yy_r121(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '/', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6342 "Core.php"
#line 560 "Core.y"
    function yy_r122(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '%', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6347 "Core.php"
#line 563 "Core.y"
    function yy_r123(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '<<', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6352 "Core.php"
#line 566 "Core.y"
    function yy_r124(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '>>', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6357 "Core.php"
#line 569 "Core.y"
    function yy_r125(){
	$this->_retvalue = new AOWP_PHPPrefixMonadicOperatorExprElement($this->lex->line, '+', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6362 "Core.php"
#line 572 "Core.y"
    function yy_r126(){
	$this->_retvalue = new AOWP_PHPPrefixMonadicOperatorExprElement($this->lex->line, '-', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6367 "Core.php"
#line 575 "Core.y"
    function yy_r127(){
	$this->_retvalue = new AOWP_PHPPrefixMonadicOperatorExprElement($this->lex->line, '!', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6372 "Core.php"
#line 578 "Core.y"
    function yy_r128(){
	$this->_retvalue = new AOWP_PHPPrefixMonadicOperatorExprElement($this->lex->line, '~', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6377 "Core.php"
#line 581 "Core.y"
    function yy_r129(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '===', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6382 "Core.php"
#line 584 "Core.y"
    function yy_r130(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '!==', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6387 "Core.php"
#line 587 "Core.y"
    function yy_r131(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '==', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6392 "Core.php"
#line 590 "Core.y"
    function yy_r132(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '!=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6397 "Core.php"
#line 593 "Core.y"
    function yy_r133(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '<', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6402 "Core.php"
#line 596 "Core.y"
    function yy_r134(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '<=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6407 "Core.php"
#line 599 "Core.y"
    function yy_r135(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '>', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6412 "Core.php"
#line 602 "Core.y"
    function yy_r136(){
	$this->_retvalue = new AOWP_PHPBinaryOperatorExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '>=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6417 "Core.php"
#line 605 "Core.y"
    function yy_r137(){
	$this->_retvalue = new AOWP_PHPInstanceofExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6422 "Core.php"
#line 608 "Core.y"
    function yy_r138(){
	$this->_retvalue = new AOWP_PHPBracketExprElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6427 "Core.php"
#line 613 "Core.y"
    function yy_r139(){
	$this->_retvalue = new AOWP_PHPQuestionExprElement($this->lex->line, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6432 "Core.php"
#line 619 "Core.y"
    function yy_r141(){
	$this->_retvalue = new AOWP_PHPCastExprElement($this->lex->line, 'int', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6437 "Core.php"
#line 622 "Core.y"
    function yy_r142(){
	$this->_retvalue = new AOWP_PHPCastExprElement($this->lex->line, 'double', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6442 "Core.php"
#line 625 "Core.y"
    function yy_r143(){
	$this->_retvalue = new AOWP_PHPCastExprElement($this->lex->line, 'string', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6447 "Core.php"
#line 628 "Core.y"
    function yy_r144(){
	$this->_retvalue = new AOWP_PHPCastExprElement($this->lex->line, 'array', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6452 "Core.php"
#line 631 "Core.y"
    function yy_r145(){
	$this->_retvalue = new AOWP_PHPCastExprElement($this->lex->line, 'object', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6457 "Core.php"
#line 634 "Core.y"
    function yy_r146(){
	$this->_retvalue = new AOWP_PHPCastExprElement($this->lex->line, 'binary', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6462 "Core.php"
#line 637 "Core.y"
    function yy_r147(){
	$this->_retvalue = new AOWP_PHPCastExprElement($this->lex->line, 'bool', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6467 "Core.php"
#line 640 "Core.y"
    function yy_r148(){
	$this->_retvalue = new AOWP_PHPCastExprElement($this->lex->line, 'unset', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6472 "Core.php"
#line 643 "Core.y"
    function yy_r149(){
	$this->_retvalue = new AOWP_PHPExitExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6477 "Core.php"
#line 646 "Core.y"
    function yy_r150(){
	$this->_retvalue = new AOWP_PHPPrefixMonadicOperatorExprElement($this->lex->line, '@', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6482 "Core.php"
#line 649 "Core.y"
    function yy_r151(){
	$this->_retvalue = new AOWP_PHPScalarExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6487 "Core.php"
#line 652 "Core.y"
    function yy_r152(){
	$this->_retvalue = new AOWP_PHPArrayElement($this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6492 "Core.php"
#line 655 "Core.y"
    function yy_r153(){
	$this->_retvalue = new AOWP_PHPQuoteExprElement($this->lex->line, 'backquote', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6497 "Core.php"
#line 658 "Core.y"
    function yy_r154(){
	$this->_retvalue = new AOWP_PHPPrintExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6502 "Core.php"
#line 665 "Core.y"
    function yy_r157(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 6505 "Core.php"
#line 683 "Core.y"
    function yy_r162(){ $this->_retvalue = '+' . $this->yystack[$this->yyidx + 0]->minor;     }
#line 6508 "Core.php"
#line 684 "Core.y"
    function yy_r163(){ $this->_retvalue = '-' . $this->yystack[$this->yyidx + 0]->minor;     }
#line 6511 "Core.php"
#line 696 "Core.y"
    function yy_r170(){
	$this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
	$e1 = new AOWP_PHPScalarExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$e2 = new AOWP_PHPScalarExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->lex->line, $e1, $e2);
    }
#line 6519 "Core.php"
#line 702 "Core.y"
    function yy_r171(){
	$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
	$e1 = new AOWP_PHPScalarExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->lex->line, null, $e1);
    }
#line 6526 "Core.php"
#line 707 "Core.y"
    function yy_r172(){
	$this->_retvalue = array();
	$e1 = new AOWP_PHPScalarExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$e2 = new AOWP_PHPScalarExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->lex->line, $e1, $e2);
    }
#line 6534 "Core.php"
#line 713 "Core.y"
    function yy_r173(){
	$this->_retvalue = array();
	$e1 = new AOWP_PHPScalarExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->lex->line, null, $e1);
    }
#line 6541 "Core.php"
#line 719 "Core.y"
    function yy_r174(){
	$this->_retvalue = new AOWP_PHPClassConstVariableRefElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6546 "Core.php"
#line 727 "Core.y"
    function yy_r178(){
	$this->_retvalue = new AOWP_PHPAmpersandExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6551 "Core.php"
#line 731 "Core.y"
    function yy_r179(){
	if( is_array($this->yystack[$this->yyidx + 0]->minor) ){
		$a = $this->yystack[$this->yyidx + 0]->minor;
	}
	else{
		$a = array();
		$a[] = $this->yystack[$this->yyidx + 0]->minor;
	}
	$this->_retvalue = array(false, $a); 
    }
#line 6563 "Core.php"
#line 741 "Core.y"
    function yy_r180(){
	$this->_retvalue = array(true, $this->yystack[$this->yyidx + -2]->minor); 
    }
#line 6568 "Core.php"
#line 745 "Core.y"
    function yy_r181(){
	if( is_array($this->yystack[$this->yyidx + 0]->minor) ){
		$a = $this->yystack[$this->yyidx + 0]->minor;
	}
	else{
		$a = array();
		$a[] = $this->yystack[$this->yyidx + 0]->minor;
	}
	$this->_retvalue = array(false, $a);
    }
#line 6580 "Core.php"
#line 755 "Core.y"
    function yy_r182(){
	$this->_retvalue = array(true, $this->yystack[$this->yyidx + -2]->minor);
    }
#line 6585 "Core.php"
#line 759 "Core.y"
    function yy_r183(){
	$this->_retvalue = array();
	$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6591 "Core.php"
#line 763 "Core.y"
    function yy_r184(){
	$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    }
#line 6596 "Core.php"
#line 767 "Core.y"
    function yy_r185(){
	$this->_retvalue = array();
	$this->_retvalue[] = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6602 "Core.php"
#line 771 "Core.y"
    function yy_r186(){
	$this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
	$this->_retvalue[] = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, '=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6608 "Core.php"
#line 778 "Core.y"
    function yy_r189(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;     }
#line 6611 "Core.php"
#line 781 "Core.y"
    function yy_r191(){
	$this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
	$this->_retvalue[] = new AOWP_PHPCaseStatementElement($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6617 "Core.php"
#line 785 "Core.y"
    function yy_r192(){
	$this->_retvalue = $this->yystack[$this->yyidx + -3]->minor;
	$this->_retvalue[] = new AOWP_PHPCaseStatementElement($this->yystack[$this->yyidx + -1]->minor, 'default', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6623 "Core.php"
#line 805 "Core.y"
    function yy_r196(){ 
	$this->_retvalue = array(true, $this->yystack[$this->yyidx + -2]->minor); 
    }
#line 6628 "Core.php"
#line 809 "Core.y"
    function yy_r197(){
	$this->_retvalue = $this->yystack[$this->yyidx + -5]->minor;
	$this->_retvalue[] = new AOWP_PHPElseIfStatementElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, array($this->yystack[$this->yyidx + 0]->minor));
    }
#line 6634 "Core.php"
#line 813 "Core.y"
    function yy_r198(){
	$this->_retvalue = $this->yystack[$this->yyidx + -6]->minor;
	$this->_retvalue[] = new AOWP_PHPElseIfStatementElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, array($this->yystack[$this->yyidx + 0]->minor));
    }
#line 6640 "Core.php"
#line 821 "Core.y"
    function yy_r200(){
	$this->_retvalue = $this->yystack[$this->yyidx + -6]->minor;
	$this->_retvalue[] = new AOWP_PHPNewElseIfStatementElement($this->lex->line, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6646 "Core.php"
#line 836 "Core.y"
    function yy_r204(){
	$this->_retvalue = new AOWP_PHPNewElseStatementElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6651 "Core.php"
#line 839 "Core.y"
    function yy_r205(){
	$this->_retvalue = null;
    }
#line 6656 "Core.php"
#line 846 "Core.y"
    function yy_r208(){
	$v = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue = array();
	$this->_retvalue[] = new AOWP_PHPParamaterElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor, $v, null);
    }
#line 6663 "Core.php"
#line 851 "Core.y"
    function yy_r209(){
	$this->_retvalue = array();
	$v1 = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$v = new AOWP_PHPAmpersandExprElement($this->lex->line, $v1);
	$this->_retvalue[] = new AOWP_PHPParamaterElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, $v, null);
    }
#line 6671 "Core.php"
#line 857 "Core.y"
    function yy_r210(){
	$this->_retvalue = array();
	$v1 = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$v = new AOWP_PHPAmpersandExprElement($this->lex->line, $v1);
	$this->_retvalue[] = new AOWP_PHPParamaterElement($this->lex->line, $this->yystack[$this->yyidx + -4]->minor, $v, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6679 "Core.php"
#line 863 "Core.y"
    function yy_r211(){
	$this->_retvalue = array();
	$v1 = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$this->_retvalue[] = new AOWP_PHPParamaterElement($this->lex->line, $this->yystack[$this->yyidx + -3]->minor, $v1, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6686 "Core.php"
#line 868 "Core.y"
    function yy_r212(){
	$this->_retvalue = $this->yystack[$this->yyidx + -3]->minor;
	$v1 = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPParamaterElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor, $v1, null);
    }
#line 6693 "Core.php"
#line 873 "Core.y"
    function yy_r213(){
	$this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
	$v1 = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$v = new AOWP_PHPAmpersandExprElement($this->lex->line, $v1);
	$this->_retvalue[] = new AOWP_PHPParamaterElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, $v, null);
    }
#line 6701 "Core.php"
#line 879 "Core.y"
    function yy_r214(){
	$this->_retvalue = $this->yystack[$this->yyidx + -6]->minor;
	$v1 = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$v = new AOWP_PHPAmpersandExprElement($this->lex->line, $v1);
	$this->_retvalue[] = new AOWP_PHPParamaterElement($this->lex->line, $this->yystack[$this->yyidx + -4]->minor, $v, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6709 "Core.php"
#line 885 "Core.y"
    function yy_r215(){
	$this->_retvalue = $this->yystack[$this->yyidx + -5]->minor;
	$v1 = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$this->_retvalue[] = new AOWP_PHPParamaterElement($this->lex->line, $this->yystack[$this->yyidx + -3]->minor, $v1, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6716 "Core.php"
#line 898 "Core.y"
    function yy_r220(){
	$this->_retvalue = array();
	$this->_retvalue[] = new AOWP_PHPArgumentElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6722 "Core.php"
#line 906 "Core.y"
    function yy_r222(){
	$this->_retvalue = array();
	$v = new AOWP_PHPAmpersandExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPArgumentElement($this->lex->line, $v);
    }
#line 6729 "Core.php"
#line 911 "Core.y"
    function yy_r223(){
	$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
	$this->_retvalue[] = new AOWP_PHPArgumentElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6735 "Core.php"
#line 919 "Core.y"
    function yy_r225(){
	$this->_retvalue = $this->yystack[$this->yyidx + -3]->minor;
	$v = new AOWP_PHPAmpersandExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPArgumentElement($this->lex->line, $v);
    }
#line 6742 "Core.php"
#line 925 "Core.y"
    function yy_r226(){
	$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
	$this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6748 "Core.php"
#line 929 "Core.y"
    function yy_r227(){
	$this->_retvalue = array();
	$this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6754 "Core.php"
#line 934 "Core.y"
    function yy_r228(){
	$this->_retvalue = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6759 "Core.php"
#line 937 "Core.y"
    function yy_r229(){
	$this->_retvalue = new AOWP_PHPIndirectVariableElement($this->lex->line, array('$'), $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6764 "Core.php"
#line 940 "Core.y"
    function yy_r230(){
	$this->_retvalue = new AOWP_PHPCompoundVariableElement($this->lex->line, '${', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6769 "Core.php"
#line 949 "Core.y"
    function yy_r232(){
	$this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
	$v1 = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$this->_retvalue[] = new AOWP_PHPEqualExprElement($this->lex->line, $v1, '=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6776 "Core.php"
#line 954 "Core.y"
    function yy_r233(){
	$this->_retvalue = array();
	$this->_retvalue[] = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6782 "Core.php"
#line 958 "Core.y"
    function yy_r234(){
	$this->_retvalue = array();
	$v1 = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$this->_retvalue[] = new AOWP_PHPEqualExprElement($this->lex->line, $v1, '=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6789 "Core.php"
#line 972 "Core.y"
    function yy_r237(){
	$this->_retvalue = new AOWP_PHPClassVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6794 "Core.php"
#line 975 "Core.y"
    function yy_r238(){
	$this->_retvalue = new AOWP_PHPDefineConstantVariableStatementElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6799 "Core.php"
#line 979 "Core.y"
    function yy_r240(){
	$this->_retvalue = new AOWP_PHPMethodElement($this->yystack[$this->yyidx + -6]->minor, $this->yystack[$this->yyidx + -7]->minor, $this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6804 "Core.php"
#line 987 "Core.y"
    function yy_r244(){
	$this->_retvalue = array();
	$this->_retvalue[] = 'var';
    }
#line 6810 "Core.php"
#line 1006 "Core.y"
    function yy_r250(){
	$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
	$this->_retvalue[] = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6816 "Core.php"
#line 1010 "Core.y"
    function yy_r251(){
	$this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
	$v = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$this->_retvalue[] = new AOWP_PHPEqualExprElement($this->lex->line, $v, '=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6823 "Core.php"
#line 1019 "Core.y"
    function yy_r253(){
	$this->_retvalue = array();
	$v = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor);
	$this->_retvalue[] = new AOWP_PHPEqualExprElement($this->lex->line, $v, '=', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6830 "Core.php"
#line 1024 "Core.y"
    function yy_r254(){
	$this->_retvalue = array();
	$this->_retvalue[] = new AOWP_PHPEqualExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor, '=', val);
    }
#line 6836 "Core.php"
#line 1029 "Core.y"
    function yy_r255(){
	$this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
	$this->_retvalue[] = new AOWP_PHPDefineConstantVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6842 "Core.php"
#line 1033 "Core.y"
    function yy_r256(){
	$this->_retvalue = array();
	$this->_retvalue[] = new AOWP_PHPDefineConstantVariableElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6848 "Core.php"
#line 1067 "Core.y"
    function yy_r267(){
	$p = new AOWP_PHPObjectPropertyElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor);
	array_unshift($this->yystack[$this->yyidx + 0]->minor, $p);
	$this->_retvalue = new AOWP_PHPObjectOperatorElement($this->lex->line, $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6855 "Core.php"
#line 1082 "Core.y"
    function yy_r271(){
	$this->_retvalue = new AOWP_PHPObjectPropertyElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6860 "Core.php"
#line 1090 "Core.y"
    function yy_r275(){
	$this->_retvalue = new AOWP_PHPIndirectVariableElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6865 "Core.php"
#line 1094 "Core.y"
    function yy_r276(){
	$this->_retvalue = new AOWP_PHPStaticMemberRefElement($this->lex->line, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6870 "Core.php"
#line 1107 "Core.y"
    function yy_r282(){
	$this->_retvalue = new AOWP_PHPReferenceVariableElement($this->lex->line, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6875 "Core.php"
#line 1137 "Core.y"
    function yy_r295(){
	$this->_retvalue = new AOWP_PHPCompoundVariableElement($this->lex->line, '{', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6880 "Core.php"
#line 1141 "Core.y"
    function yy_r296(){
	$this->_retvalue = array();
	$this->_retvalue[] = '$';
    }
#line 6886 "Core.php"
#line 1145 "Core.y"
    function yy_r297(){
	$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
	$this->_retvalue[] = '$';
    }
#line 6892 "Core.php"
#line 1161 "Core.y"
    function yy_r301(){
	$this->_retvalue = new AOWP_PHPListElement($this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6897 "Core.php"
#line 1171 "Core.y"
    function yy_r305(){
	$this->_retvalue = array();
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->lex->line, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6903 "Core.php"
#line 1175 "Core.y"
    function yy_r306(){
	$this->_retvalue = array();
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->line, null, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6909 "Core.php"
#line 1179 "Core.y"
    function yy_r307(){
	$this->_retvalue = array();
	$a = new AOWP_PHPAmpersandExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->line, null, $a);
    }
#line 6916 "Core.php"
#line 1184 "Core.y"
    function yy_r308(){
	$this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->line, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6922 "Core.php"
#line 1188 "Core.y"
    function yy_r309(){
	$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->line, null, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6928 "Core.php"
#line 1192 "Core.y"
    function yy_r310(){
	$this->_retvalue = array();
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->line, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6934 "Core.php"
#line 1196 "Core.y"
    function yy_r311(){
	$this->_retvalue = $this->yystack[$this->yyidx + -5]->minor;
	$a = new AOWP_PHPAmpersandExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->line, $this->yystack[$this->yyidx + -3]->minor, $a);
    }
#line 6941 "Core.php"
#line 1201 "Core.y"
    function yy_r312(){
	$this->_retvalue = $this->yystack[$this->yyidx + -3]->minor;
	$a = new AOWP_PHPAmpersandExprElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor);
	$this->_retvalue[] = new AOWP_PHPArrayPairElement($this->line, null, $a);
    }
#line 6948 "Core.php"
#line 1231 "Core.y"
    function yy_r320(){
	$this->_retvalue = '[';
    }
#line 6953 "Core.php"
#line 1234 "Core.y"
    function yy_r321(){
	$this->_retvalue = ']';
    }
#line 6958 "Core.php"
#line 1237 "Core.y"
    function yy_r322(){
	$this->_retvalue = '{';
    }
#line 6963 "Core.php"
#line 1240 "Core.y"
    function yy_r323(){
	$this->_retvalue = '}';
    }
#line 6968 "Core.php"
#line 1243 "Core.y"
    function yy_r324(){
	$this->_retvalue = '->';
    }
#line 6973 "Core.php"
#line 1250 "Core.y"
    function yy_r327(){
	$this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . '[' . $this->yystack[$this->yyidx + -1]->minor . ']';
    }
#line 6978 "Core.php"
#line 1253 "Core.y"
    function yy_r328(){
	$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . '->' . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6983 "Core.php"
#line 1256 "Core.y"
    function yy_r329(){
	$this->_retvalue = new AOWP_PHPComplexVariableElement($this->lex->line, '${', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6988 "Core.php"
#line 1259 "Core.y"
    function yy_r330(){
	$v = new AOWP_PHPVariableElement($this->lex->line, $this->yystack[$this->yyidx + -4]->minor);
	$r = new AOWP_PHPReferenceVariableElement($this->lex->line, $v, $this->yystack[$this->yyidx + -2]->minor);	
	$this->_retvalue = new AOWP_PHPComplexVariableElement($this->lex->line, '${', $r);
    }
#line 6995 "Core.php"
#line 1264 "Core.y"
    function yy_r331(){
	$this->_retvalue = new AOWP_PHPComplexVariableElement($this->lex->line, '{', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7000 "Core.php"
#line 1268 "Core.y"
    function yy_r332(){
	$this->_retvalue = new AOWP_PHPIssetStatementElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7005 "Core.php"
#line 1271 "Core.y"
    function yy_r333(){
	$this->_retvalue = new AOWP_PHPEmptyStatementElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7010 "Core.php"
#line 1275 "Core.y"
    function yy_r335(){
	$this->_retvalue = new AOWP_PHPFileIncludeStatementElement($this->yystack[$this->yyidx + -1]->minor, 'include', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 7015 "Core.php"
#line 1279 "Core.y"
    function yy_r337(){
	$this->_retvalue = new AOWP_PHPFileIncludeStatementElement($this->yystack[$this->yyidx + -1]->minor, 'include_once', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 7020 "Core.php"
#line 1282 "Core.y"
    function yy_r338(){
	$this->_retvalue = new AOWP_PHPEvalStatementElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7025 "Core.php"
#line 1286 "Core.y"
    function yy_r340(){
	$this->_retvalue = new AOWP_PHPFileIncludeStatementElement($this->yystack[$this->yyidx + -1]->minor, 'require', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 7030 "Core.php"
#line 1290 "Core.y"
    function yy_r342(){
	$this->_retvalue = new AOWP_PHPFileIncludeStatementElement($this->yystack[$this->yyidx + -1]->minor, 'require_once', $this->yystack[$this->yyidx + 0]->minor);
    }
#line 7035 "Core.php"
#line 1294 "Core.y"
    function yy_r343(){ 
	$this->_retvalue = array();
	$this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor; 
    }
#line 7041 "Core.php"
#line 1309 "Core.y"
    function yy_r347(){ 
	$this->_retvalue = new AOWP_PHPFunctionCallElement($this->lex->line, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7046 "Core.php"
#line 1312 "Core.y"
    function yy_r348(){
	$this->_retvalue = new AOWP_PHPStaticMethodCallElement($this->lex->line, $this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7051 "Core.php"
#line 1315 "Core.y"
    function yy_r349(){
	$this->_retvalue = new AOWP_PHPStaticMethodCallWithVariableElement($this->lex->line, $this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7056 "Core.php"
#line 1318 "Core.y"
    function yy_r350(){
	$this->_retvalue = new AOWP_PHPFunctionCallWithVariableElement($this->lex->line, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7061 "Core.php"
#line 1326 "Core.y"
    function yy_r355(){
	$this->_retvalue = new AOWP_PHPQuoteExprElement($this->lex->line, 'doublequote', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7066 "Core.php"
#line 1329 "Core.y"
    function yy_r356(){
	$this->_retvalue = new AOWP_PHPQuoteExprElement($this->lex->line, 'singlequote', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 7071 "Core.php"
#line 1332 "Core.y"
    function yy_r357(){
	$this->_retvalue = new AOWP_PHPHeredocExprElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 7076 "Core.php"
#line 1339 "Core.y"
    function yy_r360(){
	$p = new AOWP_PHPObjectPropertyElement($this->lex->line, $this->yystack[$this->yyidx + -1]->minor, null);
	$this->_retvalue = new AOWP_PHPObjectOperatorElement($this->lex->line, $this->yystack[$this->yyidx + -3]->minor, $p);
    }
#line 7082 "Core.php"
#line 1353 "Core.y"
    function yy_r364(){
	$this->_retvalue = new AOWP_PHPObjectPropertyElement($this->lex->line, $this->yystack[$this->yyidx + 0]->minor, null);
    }
#line 7087 "Core.php"
#line 1360 "Core.y"
    function yy_r367(){ $this->_retvalue = true;     }
#line 7090 "Core.php"
#line 1361 "Core.y"
    function yy_r368(){ $this->_retvalue = false;     }
#line 7093 "Core.php"

    /**
     * placeholder for the left hand side in a reduce operation.
     * 
     * For a parser with a rule like this:
     * <pre>
     * rule(A) ::= B. { A = 1; }
     * </pre>
     * 
     * The parser will translate to something like:
     * 
     * <code>
     * function yy_r0(){$this->_retvalue = 1;}
     * </code>
     */
    private $_retvalue;

    /**
     * Perform a reduce action and the shift that must immediately
     * follow the reduce.
     * 
     * For a rule such as:
     * 
     * <pre>
     * A ::= B blah C. { dosomething(); }
     * </pre>
     * 
     * This function will first call the action, if any, ("dosomething();" in our
     * example), and then it will pop three states from the stack,
     * one for each entry on the right-hand side of the expression
     * (B, blah, and C in our example rule), and then push the result of the action
     * back on to the stack with the resulting state reduced to (as described in the .out
     * file)
     * @param int Number of the rule by which to reduce
     */
    function yy_reduce($yyruleno)
    {
        //int $yygoto;                     /* The next state */
        //int $yyact;                      /* The next action */
        //mixed $yygotominor;        /* The LHS of the rule reduced */
        //PHP_Parser_CoreyyStackEntry $yymsp;            /* The top of the parser's stack */
        //int $yysize;                     /* Amount to pop the stack */
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            /* If we are not debugging and the reduce action popped at least
            ** one element off the stack, then we can push the new element back
            ** onto the stack here, and skip the stack overflow test in yy_shift().
            ** That gives a significant speed improvement. */
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new PHP_Parser_CoreyyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    /**
     * The following code executes when the parse fails
     * 
     * Code from %parse_fail is inserted here
     */
    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser fails */
    }

    /**
     * The following code executes when a syntax error first occurs.
     * 
     * %syntax_error code is inserted here
     * @param int The major type of the error token
     * @param mixed The minor type of the error token
     */
    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 4 "Core.y"

/* ?><?php */
    echo "Syntax Error on line " . $this->lex->line . ": token '" . 
        $this->lex->value . "' while parsing rule:";
    foreach ($this->yystack as $entry) {
        echo $this->tokenName($entry->major) . ' ';
    }
    foreach ($this->yy_get_expected_tokens($yymajor) as $token) {
        $expect[] = self::$yyTokenName[$token];
    }
    if (count($expect) > 5) {
        $expect = array_slice($expect, 0, 5);
        $expect[] = '...';
    }
    throw new Exception('Unexpected ' . $this->tokenName($yymajor) . '(' . $TOKEN
        . '), expected one of: ' . implode(',', $expect));
#line 7223 "Core.php"
    }

    /**
     * The following is executed when the parser accepts
     * 
     * %parse_accept code is inserted here
     */
    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser accepts */
#line 146 "Core.y"

#line 7244 "Core.php"
    }

    /**
     * The main parser program.
     * 
     * The first argument is the major token number.  The second is
     * the token value string as scanned from the input.
     *
     * @param int the token number
     * @param mixed the token value
     * @param mixed any extra arguments that should be passed to handlers
     */
    function doParse($yymajor, $yytokenvalue)
    {
//        $yyact;            /* The parser action. */
//        $yyendofinput;     /* True if we are at the end of input */
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        /* (re)initialize the parser, if necessary */
        if ($this->yyidx === null || $this->yyidx < 0) {
            /* if ($yymajor == 0) return; // not sure why this was here... */
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new PHP_Parser_CoreyyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, self::$yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    /* A syntax error has occurred.
                    ** The response to an error depends upon whether or not the
                    ** grammar defines an error token "ERROR".  
                    **
                    ** This is what we do if the grammar does define ERROR:
                    **
                    **  * Call the %syntax_error function.
                    **
                    **  * Begin popping the stack until we enter a state where
                    **    it is legal to shift the error symbol, then shift
                    **    the error symbol.
                    **
                    **  * Set the error count to three.
                    **
                    **  * Begin accepting and shifting new tokens.  No new error
                    **    processing will occur until three tokens have been
                    **    shifted successfully.
                    **
                    */
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, self::$yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    /* YYERRORSYMBOL is not defined */
                    /* This is what we do if the grammar does not define ERROR:
                    **
                    **  * Report an error message, and throw away the input token.
                    **
                    **  * If the input token is $, then fail the parse.
                    **
                    ** As before, subsequent error messages are suppressed until
                    ** three input tokens have been successfully shifted.
                    */
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}