<?php
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'TraceMonitor.class.php';

class TraceMonitorAspect extends AOWP_PerSessionAspect {

	const WARNING_PAGE_URL = 'http://localhost/~keiji/eccube/eccube/aowp/aspect/trace_monitor/warning.html';
	const MONITORED_TRACE_COUNT = 5;
	const MIN_INTERVAL = 3;
	
	private $_traceMonitor;
	
	public function __construct() {
		$this->_traceMonitor = new TraceMonitor();
		$allReqPC = new AOWP_RequestPointcut('.*');
//		$allReqPC = new AOWP_RequestPointcut('^html/.*');
		
		$monitorAdv = new AOWP_BeforeAdvice();
		$chkAccIfPC = new AOWP_IfPointcut('!$aspect->chkAcc()');
		$monitorAdv->setPointcut($allReqPC->opAnd($chkAccIfPC));
		$monitorAdv->setAdviceBody('_monitor');
		$this->addAdvice($monitorAdv);		
	}

	public function chkAcc() {
		return $this->_traceMonitor->checkAccessInterval();
	}	
	protected function _monitor(AOWP_JoinPoint $jp) {
		header('Location: ' . TraceMonitorAspect::WARNING_PAGE_URL);
		AOWP_AspectInstanceManager::releaseInstance($this);
		exit();
	}
}
?>