module CellGrid
  def initialize
    @cell_array = nil
  end
  def rows
    return @rows if @rows
    @rows = @cell_array.size
  end
  def cols
    return @cells if @cells
    @cells = @cell_array.collect {|row_array| row_array.size }.max
  end
  def row_array(row)
    @cell_array = [] unless @cell_array
    @cell_array[row] || @cell_array[row] = [] 
  end
  def [](row, col)
    row_array(row)[col]
  end
  def []=(row, col, item)
    @cells = @cols = nil
    row_array(row)[col] = item
  end
  def layout
    item_width  = self.width  / self.cols
    item_height = self.height / self.rows
    rows.times {|row|
      cols.times {|col|
        next unless item = self[row, col]
        item.width  = item_width
        item.height = item_height
        item.left   = item_width * col
        item.top    = item_height * row
      }
    }
  end
end

require "phi"

module CellItem
  attr :row,true
  attr :col,true
end

form = Phi::Form.new

panel = Phi::Panel.new form
panel.extend CellGrid
panel.align = Phi::AL_CLIENT

btn_click = proc {|sender| 
  form.caption = "#{sender.row} : #{sender.col} clicked"
  if sender.caption != "o"
    sender.caption = "o"
  else
    sender.caption = "x"
  end
}

require 'benchmark'
Benchmark.bm do |x|
  x.report do
    10.times {|r|
      20.times {|c|
        panel[r, c] = btn = Phi::SpeedButton.new(panel, "!")
        btn.extend CellItem
        btn.row = r
        btn.col = c
        btn.on_click = btn_click
      }
    }
  end
end

# 10.times {|r|
#   20.times {|c|
#     print panel[r, c].name, " "
#   }
#   print "\n"
# }

#form.on_resize = proc{ panel.layout }
#form.show
#Phi.mainloop
