unit uLineSeries;

interface

uses
  TeEngine,
  Chart,
  Series,
  Rubies;

var
  cLineSeries: Tvalue;

function ap_cLineSeries: Tvalue;
function ap_iLineSeries(real: TLineSeries; owner: Tvalue): Tvalue;
procedure Init_LineSeries;

implementation

uses
  uChartSeries,
  Classes,
  uDefUtils, 
  Pythia;

function ap_cLineSeries: Tvalue;
begin
  result := cLineSeries;
end;

procedure LineSeries_setup(obj: Tvalue; real: TLineSeries);
begin
//    AssignPropMethod(real, [Handle]);
end;

function LineSeries_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  //EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function LineSeries_alloc(This: Tvalue; real: TLineSeries): Tvalue;
begin
  result := ChildAlloc(This, real);
  LineSeries_setup(result, real);
end;

function ap_iLineSeries(real: TLineSeries; owner: Tvalue): Tvalue;
begin
  result := LineSeries_alloc(cLineSeries, real);
  ap_owner(result, owner);
end;

function ap_iLineSeries_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iLineSeries(TLineSeries(AControl), owner);
end;

function LineSeries_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TLineSeries;
begin
  real := TLineSeries.Create(nil);
  result := CompoAlloc(This, real);
  LineSeries_setup(result, real);
end;

procedure Init_LineSeries;
begin
  cLineSeries := DefinePersistentClass(ap_mPhi, TLineSeries, cChartSeries, ap_iLineSeries_v);
  rb_define_method(cLineSeries, 'event_handle', @LineSeries_event_handle, 1);
  rb_define_alloc_func(cLineSeries, @LineSeries_allocate);
end;

end.
