unit uFountainBracketItem;

interface

uses
  Rubies, heFountain;

var
  cFountainBracketItem: Tvalue;

function ap_iFountainBracketItem(real: TFountainBracketItem; owner: Tvalue): Tvalue;
procedure Init_FountainBracketItem;

implementation

uses
  Pythia, uFountain, uFountainColor;

procedure FountainBracketItem_setup(obj: Tvalue; real: TFountainBracketItem);
begin
  rb_iv_set(obj, '@item_color', ap_iFountainColor(real.ItemColor, obj));
  rb_iv_set(obj, '@left_bracket', ap_String(real.LeftBracket));
  rb_iv_set(obj, '@right_bracket', ap_String(real.RightBracket));
end;

function FountainBracketItem_alloc(This: Tvalue; real: TFountainBracketItem): Tvalue;
begin
  result := TmpAlloc(This, real);
  FountainBracketItem_setup(result, real);
end;

function ap_iFountainBracketItem(real: TFountainBracketItem; owner: Tvalue): Tvalue;
begin
  result := FountainBracketItem_alloc(cFountainBracketItem, real);
  ap_owner(result, owner);
end;

function ap_iFountainBracketItem_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iFountainBracketItem(TFountainBracketItem(obj), owner)
end;

procedure Init_FountainBracketItem;
begin
  cFountainBracketItem := DefinePersistentClass(cFountain, TFountainBracketItem, ap_cCollectionItem, ap_iFountainBracketItem_v);
  DefineProp(cFountainBracketItem, TFountainBracketItem);
end;

end.
