unit FTPHandle;

interface

uses
  Windows, Classes, Controls, Forms, contnrs, Rubies, NMFtp;

type
  TFTPHandle = class(TObject)
  public
    procedure doTransactionStart(Sender: TObject);
    procedure doTransactionStop(Sender: TObject);
  end;

var
  Handle: TFTPHandle;
  eFTPError, cFTP: Tvalue;

implementation

uses Pythia;

procedure TFTPHandle.doTransactionStart(Sender: TObject);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_transaction_start'));
  rb_ary_push(data, recv);
  PhiCallProtect(data);
end;

procedure TFTPHandle.doTransactionStop(Sender: TObject);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_transaction_stop'));
  rb_ary_push(data, recv);
  PhiCallProtect(data);
end;

initialization
  Handle := TFTPHandle.Create;
finalization
  Handle.Free;
end.
