unit uIdLogDebug;

interface

uses Classes, IdLogDebug, Rubies;

var
  cIdLogDebug: Tvalue;

function ap_cIdLogDebug: Tvalue;
function ap_iIdLogDebug(real: TIdLogDebug; owner: Tvalue): Tvalue;
procedure Init_IdLogDebug;

implementation

uses
  SysUtils, uDefUtils, Pythia, IdHandle, uIndy, uIdLogBase;

function ap_cIdLogDebug: Tvalue;
begin
  result := cIdLogDebug;
end;

procedure IdLogDebug_setup(obj: Tvalue; real: TIdLogDebug);
begin
end;

function IdLogDebug_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function IdLogDebug_alloc(This: Tvalue; real: TIdLogDebug): Tvalue;
begin
  result := ChildAlloc(This, real);
  IdLogDebug_setup(result, real);
end;

function ap_iIdLogDebug(real: TIdLogDebug; owner: Tvalue): Tvalue;
begin
  result := IdLogDebug_alloc(cIdLogDebug, real);
  ap_owner(result, owner);
end;

function ap_iIdLogDebug_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iIdLogDebug(TIdLogDebug(obj), owner);
end;

function IdLogDebug_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TIdLogDebug;
begin
  real := TIdLogDebug.Create(nil);
  result := CompoAlloc(This, real);
  IdLogDebug_setup(result, real);
end;

procedure Init_IdLogDebug;
begin
  cIdLogDebug := DefinePersistentClass(mIndy, TIdLogDebug, cIdLogBase, ap_iIdLogDebug_v);
  rb_define_alloc_func(cIdLogDebug, @IdLogDebug_allocate);
  rb_define_method(cIdLogDebug, 'event_handle', @IdLogDebug_event_handle, 1);
end;

end.
