unit uPropGrid;

interface

uses
  Rubies, HPropGrid;

function ap_iPropGrid(real: TPropGrid; owner: Tvalue): Tvalue;
function ap_cPropGrid: Tvalue;
procedure Init_PropGrid;

implementation

uses
  SysUtils, Pythia, uPropGridItems, uPropGridItem, uDefUtils, PGridHandle;

var
  cPropGrid: Tvalue;

function ap_cPropGrid: Tvalue;
begin
  result := cPropGrid;
end;

procedure PropGrid_setup(obj: Tvalue; real: TPropGrid);
begin
  rb_iv_set(obj, '@default_color_pick_list', ap_iStrings(real.DefaultColorPickList, obj));
  rb_iv_set(obj, '@yes_no_list', ap_iStrings(real.YesNoList, obj));
  rb_iv_set(obj, '@boolean_list', ap_iStrings(real.BooleanList, obj));
  rb_iv_set(obj, '@items', ap_iPropGridItems(real.Items, obj));
  rb_iv_set(obj, '@brush', ap_iBrush(real.Brush, obj));
//  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//  AssignPropMethod(real, [PhiGetHandle, PGridGetHandle]);
end;

function PropGrid_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PhiGetHandle, PGridGetHandle]);
  result := Qnil;
end;

function PropGrid_alloc(This: Tvalue; real: TPropGrid): Tvalue;
begin
  result := ChildAlloc(This, real);
  PropGrid_setup(result, real);
end;

function ap_iPropGrid(real: TPropGrid; owner: Tvalue): Tvalue;
begin
  result := PropGrid_alloc(cPropGrid, real);
  ap_owner(result, owner);
end;

function ap_iPropGrid_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPropGrid(TPropGrid(AControl), owner);
end;

function PropGrid_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := TPropGrid.Create(nil);
  result := CompoAlloc(This, real);
  PropGrid_setup(result, real);
end;

function PropGrid_get_current_index(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.CurrentIndex);
end;
   
function PropGrid_set_current_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  real.CurrentIndex := FIX2INT(v);
  result := v;
end;

function PropGrid_get_names(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_iPropGridItems(real.Items, This);
end;

function PropGrid_get_default_color_pick_list(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_iStrings(real.DefaultColorPickList, This);
end;

function PropGrid_get_boolean_list(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_iStrings(real.BooleanList, This);
end;

function PropGrid_get_yes_no_list(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_iStrings(real.YesNoList, This);
end;

function PropGrid_update_editor_text(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  real.UpdateEditorText;
  result := This;
end;

function PropGrid_expand(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  real.Expand(FIX2INT(v));
  result := This;
end;

function PropGrid_collapse(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  real.Collapse(FIX2INT(v));
  result := This;
end;

function PropGrid_expand_section(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  real.ExpandSection(dl_String(v));
  result := This;
end;

function PropGrid_collapse_section(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  real.CollapseSection(dl_String(v));
  result := This;
end;

function PropGrid_item_by_name(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_iPropGridItem(real.ItemByName(dl_String(v)), This);
end;

procedure Init_PropGrid;
begin
  DefineConstSetType(ap_mPhi, TypeInfo(TPropGridStyle));

  cPropGrid := DefinePersistentClass(ap_mPhi, TPropGrid, ap_cWinControl, ap_iPropGrid_v);
  rb_define_method(cPropGrid, 'event_handle', @PropGrid_event_handle, 1);
  rb_define_alloc_func(cPropGrid, @PropGrid_allocate);
  DefineAttrGet(cPropGrid, 'current_index', @PropGrid_get_current_index);
  DefineAttrSet(cPropGrid, 'current_index', @PropGrid_set_current_index);
  DefineAttrGet(cPropGrid, 'yes_no_list', @PropGrid_get_yes_no_list);
  DefineAttrGet(cPropGrid, 'boolean_list', @PropGrid_get_boolean_list);
  DefineAttrGet(cPropGrid, 'defaut_color_pick_list', @PropGrid_get_default_color_pick_list);

  rb_define_method(cPropGrid, 'update_editor_text', @PropGrid_update_editor_text, 0);
  rb_define_method(cPropGrid, 'expand', @PropGrid_expand, 1);
  rb_define_method(cPropGrid, 'collapse', @PropGrid_collapse, 1);
  rb_define_method(cPropGrid, 'expand_section', @PropGrid_expand_section, 1);
  rb_define_method(cPropGrid, 'collapse_section', @PropGrid_expand_section, 1);
  rb_define_method(cPropGrid, 'item_by_name', @PropGrid_item_by_name, 1);

  rb_define_attr(cPropGrid, 'items', 1, 0);
end;

end.
