unit uDBRichEdit;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBRichEdit = class(TDBRichEdit)
//  published
//    property Text;
  end;

var
  cDBRichEdit: Tvalue;

function ap_iDBRichEdit(real: TPhi_DBRichEdit; owner: Tvalue): Tvalue;
procedure Init_DBRichEdit;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBRichEdit_setup(obj: Tvalue; real: TPhi_DBRichEdit);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBRichEdit_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBRichEdit_alloc(This: Tvalue; real: TPhi_DBRichEdit): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBRichEdit_setup(result, real);
end;

function ap_iDBRichEdit(real: TPhi_DBRichEdit; owner: Tvalue): Tvalue;
begin
  result := DBRichEdit_alloc(cDBRichEdit, real);
  ap_owner(result, owner);
end;

function ap_iDBRichEdit_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBRichEdit(TPhi_DBRichEdit(AControl), owner)
end;

function DBRichEdit_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBRichEdit;
begin
  real := TPhi_DBRichEdit.Create(nil);
  result := CompoAlloc(This, real);
  DBRichEdit_setup(result, real);
end;

function DBRichEdit_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBRichEdit;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBRichEdit_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBRichEdit;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBRichEdit;
begin
  cDBRichEdit := DefinePersistentClass(mRDB, TPhi_DBRichEdit, ap_cWinControl, ap_iDBRichEdit_v);
  rb_define_method(cDBRichEdit, 'event_handle', @DBRichEdit_event_handle, 1);
  rb_define_alloc_func(cDBRichEdit, @DBRichEdit_allocate);
  DefineAttrSet(cDBRichEdit, 'data_source', DBRichEdit_set_data_source);
  DefineAttrSet(cDBRichEdit, 'data_field', DBRichEdit_set_data_field);
end;

end.
