unit uDBText;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBText = class(TDBText)
//  published
//    property Text;
  end;

var
  cDBText: Tvalue;

function ap_iDBText(real: TPhi_DBText; owner: Tvalue): Tvalue;
procedure Init_DBText;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBText_setup(obj: Tvalue; real: TPhi_DBText);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBText_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBText_alloc(This: Tvalue; real: TPhi_DBText): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBText_setup(result, real);
end;

function ap_iDBText(real: TPhi_DBText; owner: Tvalue): Tvalue;
begin
  result := DBText_alloc(cDBText, real);
  ap_owner(result, owner);
end;

function ap_iDBText_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBText(TPhi_DBText(AControl), owner)
end;

function DBText_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBText;
begin
  real := TPhi_DBText.Create(nil);
  result := CompoAlloc(This, real);
  DBText_setup(result, real);
end;

function DBText_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBText;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBText_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBText;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBText;
begin
  cDBText := DefinePersistentClass(mRDB, TPhi_DBText, ap_cWinControl, ap_iDBText_v);
  rb_define_method(cDBText, 'event_handle', @DBText_event_handle, 1);
  rb_define_alloc_func(cDBText, @DBText_allocate);
  DefineAttrSet(cDBText, 'data_source', DBText_set_data_source);
  DefineAttrSet(cDBText, 'data_field', DBText_set_data_field);
end;

end.
