unit uSCGrid;

interface

uses
  StrCGrid, Rubies;  

var
   cStrColGrid: Tvalue;

function ap_cStrColGrid: Tvalue;
function ap_iStrColGrid(real: TStrColGrid; owner: Tvalue): Tvalue;
procedure Init_SCGrid;

implementation

uses  SysUtils, StdCtrls, uDefUtils, uSCGCellParam, uSCGCellFont, Pythia, SCGHandle, Grids;

function ap_cStrColGrid: Tvalue;
begin
   result := cStrColGrid;
end;

procedure StrColGrid_setup(obj: Tvalue; real: TStrColGrid);
begin
   rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
   rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));

   rb_iv_set(obj, '@cell_params', ap_iSCGCellParams(real.CellParams, obj));
   rb_iv_set(obj, '@cell_fonts', ap_iSCGCellFonts(real.Fonts, obj));
end;

function StrColGrid_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PhiGetHandle, SCGGetHandle]);
  result := Qnil;
end;

function StrColGrid_alloc(This: Tvalue; real: TStrColGrid): Tvalue;
begin
   result := ChildAlloc(This, real);
   StrColGrid_setup(result, real);
end;

function ap_iStrColGrid(real: TStrColGrid; owner: Tvalue): Tvalue;
begin
   result := StrColGrid_alloc(cStrColGrid, real);
   ap_owner(result, owner);
end;

function ap_iStrColGrid_v(var AControl; owner: Tvalue): Tvalue;
begin
   result := ap_iStrColGrid(TStrColGrid(AControl), owner);
end;

function StrColGrid_allocate(This: Tvalue): Tvalue; cdecl;
var
   real: TStrColGrid;
begin
   real := TStrColGrid.Create(nil);
   result := CompoAlloc(This, real);
   StrColGrid_setup(result, real);
end;
  
function StrColGrid_get_cell_params(This: Tvalue): Tvalue; cdecl;
var
   real: TStrColGrid;
begin
   real := ap_data_get_struct(This);
   result := ap_iSCGCellParams(real.CellParams, This);
end;

function StrColGrid_set_cell_params(This, v: Tvalue): Tvalue; cdecl;
var
  real: TStrColGrid;
  CellParams: TSCGCellParams;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TSCGCellParams, CellParams);
  real.CellParams := CellParams;
  result := v;
end;

function StrColGrid_get_fonts(This, obj: Tvalue): Tvalue; cdecl;
var
   real: TStrColGrid;
begin
   real := ap_data_get_struct(This);
   result := ap_iSCGCellFonts(real.Fonts, This);
end;

function StrColGrid_set_fonts(This, obj: Tvalue): Tvalue; cdecl;
var
   real: TStrColGrid;
begin
   real := ap_data_get_struct(This);
   // ̃R[h₵ǁCgȂH
   real.Fonts := TSCGCellFonts(ap_data_get_struct(obj));
   result := obj;
end;

function StrColGrid_get_cells(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: array of Tvalue;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.Cells[FIX2INT(args[0]), FIX2INT(args[1])]));
end;

function StrColGrid_set_cells(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: array of Tvalue;
begin
  if argc < 3 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  real.Cells[FIX2INT(args[0]), FIX2INT(args[1])] := dl_String(args[2]);
  result := args[2];
end;

function StrColGrid_get_cell(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.Cells[FIX2INT(x), FIX2INT(y)]));
end;

function StrColGrid_set_cell(This, x, y, v: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
begin
  real := ap_data_get_struct(This);
  real.Cells[FIX2INT(x), FIX2INT(y)] := dl_String(v);
  result := v;
end;

function StrColGrid_get_cell_divide(This: Tvalue): Tvalue; cdecl;
var
  real: TStrColGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.CellDivide);
end;

function StrColGrid_set_cell_divide(This, v: Tvalue): Tvalue; cdecl;
var
  real: TStrColGrid;
begin
  real := ap_data_get_struct(This);
  real.CellDivide := RTEST(v);
  result := This;
end;

procedure Init_SCGrid;
begin
   DefineConstSetType(ap_mPhi, TypeInfo(TSCGCellCaptionType));

   cStrColGrid := DefinePersistentClass(ap_mPhi, TStrColGrid, ap_cStringGrid, ap_iStrColGrid_v);
  rb_define_method(cStrColGrid, 'event_handle', @StrColGrid_event_handle, 1);
   rb_define_alloc_func(cStrColGrid, @StrColGrid_allocate);
   DefineIndexer(cStrColGrid, 'cells', @StrColGrid_get_cells, @StrColGrid_set_cells);

//   rb_define_method(cStrColGrid, 'set_cell', @StrColGrid_set_cell, 3);
//   rb_define_method(cStrColGrid, 'get_cell', @StrColGrid_get_cell, 2);

   DefineAttrGet(cStrColGrid, 'cell_divide', StrColGrid_get_cell_divide);
   DefineAttrSet(cStrColGrid, 'cell_divide', StrColGrid_set_cell_divide);
end;

end.



