unit uCookieCollection;

interface

uses
  Rubies, HTTPApp;

var
  cCookieCollection: Tvalue;

function ap_iCookieCollection(real: TCookieCollection; owner: Tvalue): Tvalue;
procedure Init_CookieCollection;

implementation

uses
  uDefUtils, Pythia, uWeb, uCookie;

function CookieCollection_alloc(This: Tvalue; real: TCookieCollection): Tvalue;
begin
  result := TmpAlloc(This, real);
  Collection_setup(result, real);
end;

function ap_iCookieCollection(real: TCookieCollection; owner: Tvalue): Tvalue;
begin
  result := CookieCollection_alloc(cCookieCollection, real);
  ap_owner(result, owner);
end;

function ap_iCookieCollection_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iCookieCollection(TCookieCollection(obj), owner);
end;

procedure Init_CookieCollection;
begin
  cCookieCollection := DefinePersistentClass(ap_mPhi, TCookieCollection, ap_cCollection, ap_iCookieCollection_v);
  SetCollectionItemClass(cCookieCollection, 'TCookie');
end;

end.
