require "test/unit"
require "phi"
class TCMemo < Test::Unit::TestCase
  def test_ancestors
    assert_equal Phi::Edit, Phi::Memo.superclass
  end

  def setup
    @form = Phi::Form.new(:form)
  end

  def test_tag
    instance = Phi::Memo.new(@form, :memo)
    assert_raise(NoMethodError) { instance.tag }
  end

  def test_new_name_default
    instance = Phi::Memo.new(@form)
    assert_equal 'Memo1', instance.name
    assert_equal instance, @form.instance_eval { @Memo1 }
    assert_equal instance, @form.instance_eval { self.Memo1 }
  end

  def test_new_name
    instance = Phi::Memo.new(@form, :memo)
    assert_equal 'memo', instance.name
    assert_equal instance, @form.instance_eval { @memo }
    assert_equal instance, @form.instance_eval { self.memo }
  end

  def test_new_text_default
    instance = Phi::Memo.new(@form, :memo)
    assert_equal '', instance.text
  end

  def test_new_text
    instance = Phi::Memo.new(@form, :memo, 'hello')
    assert_equal 'hello', instance.text
  end

  def test_font
    instance = Phi::Memo.new(@form, :memo)
    assert_instance_of Phi::Font, instance.font
  end
end

class SubMemo < Phi::Memo
  def initialize(*args)
    @form = Phi::Form.new(:form)
    super(@form, :memo, *args)
  end
end

class TCSubMemo < Test::Unit::TestCase
  def test_new
    instance = nil
    assert_nothing_raised { instance = SubMemo.new('ab.cd') }
    assert_equal 'memo', instance.name
    assert_equal 'ab.cd', instance.text
  end
end
