unit uAnimate;

interface

uses
  ComCtrls,
  Rubies;

var
  cAnimate: Tvalue;

function ap_cAnimate: Tvalue;
function ap_iAnimate(real: TAnimate; owner: Tvalue): Tvalue;
procedure Init_Animate;

implementation

uses
  SysUtils, Classes,
  uConv, uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cAnimate: Tvalue;
begin
  result := cAnimate;
end;

procedure Animate_setup(obj: Tvalue; real: TAnimate);
begin
//    AssignPropMethod(real, [Handle]);
end;

function Animate_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Animate_alloc(This: Tvalue; real: TAnimate): Tvalue;
begin
  result := ChildAlloc(This, real);
  Animate_setup(result, real);
end;

function ap_iAnimate(real: TAnimate; owner: Tvalue): Tvalue;
begin
  result := Animate_alloc(cAnimate, real);
  ap_owner(result, owner);
end;

function ap_iAnimate_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iAnimate(TAnimate(AControl), owner);
end;

function Animate_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TAnimate;
begin
  real := TAnimate.Create(nil);
  result := CompoAlloc(This, real);
  Animate_setup(result, real);
end;

function Animate_play(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  real: TAnimate;
  fromFrame, toFrame: Integer;
begin
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);

  if argc = 0 then
    real.Play(1, real.FrameCount, 0)
  else
  if argc = 3 then
  begin
    fromFrame := NUM2INT(args[0]);
    toFrame := NUM2INT(args[1]);
    if (fromFrame < 1) or (fromFrame > real.FrameCount) then
      ap_raise(ap_eArgError, sOut_of_range);
    if (toFrame < 1) or (toFrame > real.FrameCount) then
      ap_raise(ap_eArgError, sOut_of_range);
    real.Play(fromFrame, toFrame, NUM2INT(args[2]));
  end
  else
    ap_raise(ap_eArgError, sWrong_num_of_args);
  result := This;
end;

function Animate_reset(This: Tvalue): Tvalue; cdecl;
var
  real: TAnimate;
begin
  real := ap_data_get_struct(This);
  real.Reset;
  result := This;
end;

function Animate_seek(This, tv: Tvalue): Tvalue; cdecl;
var
  real: TAnimate;
  toFrame: Integer;
begin
  real := ap_data_get_struct(This);
  toFrame := NUM2INT(tv);
  if (toFrame < 1) or (toFrame > real.FrameCount) then
    ap_raise(ap_eArgError, sOut_of_range);
  real.Seek(toFrame);
  result := This;
end;

function Animate_stop(This: Tvalue): Tvalue; cdecl;
var
  real: TAnimate;
begin
  real := ap_data_get_struct(This);
  real.Stop;
  result := This;
end;

(**** str_my_class made by ap_src_maker ****)
type
TMyAnimate = class(TAnimate)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function Animate_do_open(This : Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  real.DoOpen;
  result := This;
end;

function Animate_do_close(This : Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  real.DoClose;
  result := This;
end;

function Animate_do_start(This : Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  real.DoStart;
  result := This;
end;

function Animate_do_stop(This : Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  real.DoStop;
  result := This;
end;

function Animate_loaded(This : Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  real.Loaded;
  result := This;
end;

function Animate_get_frame_count(This: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.FrameCount);
end;

function Animate_get_frame_height(This: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.FrameHeight);
end;

function Animate_get_frame_width(This: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.FrameWidth);
end;

function Animate_get_open(This: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Open);
end;

function Animate_set_open(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  real.Open := dl_Boolean(v);
  result := v;
end;

function Animate_get_res_handle(This: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  result := ap_Handle(ord(real.ResHandle));
end;

function Animate_set_res_handle(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  real.ResHandle := THandle(dl_Handle(v));
  result := v;
end;

function Animate_get_res_id(This: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.ResId);
end;

function Animate_set_res_id(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  real.ResId := dl_Integer(v);
  result := v;
end;

function Animate_get_res_name(This: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.ResName);
end;

function Animate_set_res_name(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyAnimate;
begin
  real := ap_data_get_struct(This);
  real.ResName := dl_String(v);
  result := v;
end;

procedure Init_Animate;
begin
  OutputConstSetType(mPhi, TypeInfo(TCommonAVI));

  cAnimate := OutputPersistentClass(mPhi, TAnimate, cWinControl, ap_iAnimate_v);

  rb_define_method(cAnimate, 'event_handle', @Animate_event_handle, 1);
  rb_define_alloc_func(cAnimate, @Animate_allocate);

  rb_define_method(cAnimate, 'play', @Animate_play, -1);
  rb_define_method(cAnimate, 'reset', @Animate_reset, 0);
  rb_define_method(cAnimate, 'seek', @Animate_seek, 1);
  rb_define_method(cAnimate, 'stop', @Animate_stop, 0);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cAnimate, 'do_open', @Animate_do_open, 0);
  rb_define_method(cAnimate, 'do_close', @Animate_do_close, 0);
  rb_define_method(cAnimate, 'do_start', @Animate_do_start, 0);
  rb_define_method(cAnimate, 'do_stop', @Animate_do_stop, 0);
  rb_define_method(cAnimate, 'loaded', @Animate_loaded, 0);
  DefineAttrGet(cAnimate, 'frame_count', Animate_get_frame_count);
  DefineAttrGet(cAnimate, 'frame_height', Animate_get_frame_height);
  DefineAttrGet(cAnimate, 'frame_width', Animate_get_frame_width);
  DefineAttrGet(cAnimate, 'open', Animate_get_open);
  DefineAttrGet(cAnimate, 'open?', Animate_get_open);
  DefineAttrSet(cAnimate, 'open', Animate_set_open);
  DefineAttrGet(cAnimate, 'res_handle', Animate_get_res_handle);
  DefineAttrSet(cAnimate, 'res_handle', Animate_set_res_handle);
  DefineAttrGet(cAnimate, 'res_id', Animate_get_res_id);
  DefineAttrSet(cAnimate, 'res_id', Animate_set_res_id);
  DefineAttrGet(cAnimate, 'res_name', Animate_get_res_name);
  DefineAttrSet(cAnimate, 'res_name', Animate_set_res_name);
(**** made by ap_src_maker ****)
end;

end.
