unit uApplicationEvents;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  AppEvnts,
  Rubies;


var
  cApplicationEvents: Tvalue;

function ap_cApplicationEvents: Tvalue;
function ap_iApplicationEvents(real: TApplicationEvents; owner: Tvalue): Tvalue;
procedure Init_ApplicationEvents;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv,
  uIndexer,
  Graphics,
  uPersistent, uComponent, uControl;

function ap_cApplicationEvents: Tvalue;
begin
  result := cApplicationEvents;
end;

procedure ApplicationEvents_setup(obj: Tvalue; real: TApplicationEvents);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ApplicationEvents_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ApplicationEvents_alloc(This: Tvalue; real: TApplicationEvents): Tvalue;
begin
  result := ChildAlloc(This, real);
  ApplicationEvents_setup(result, real);
end;

function ap_iApplicationEvents(real: TApplicationEvents; owner: Tvalue): Tvalue;
begin
  result := ApplicationEvents_alloc(cApplicationEvents, real);
  ap_owner(result, owner);
end;

function ap_iApplicationEvents_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iApplicationEvents(TApplicationEvents(AControl), owner);
end;

function ApplicationEvents_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TApplicationEvents;
begin
  real := TApplicationEvents.Create(nil);
  result := CompoAlloc(This, real);
  ApplicationEvents_setup(result, real);
end;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_ApplicationEvents = class(TApplicationEvents)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function ApplicationEvents_activate(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ApplicationEvents;
begin
  real := ap_data_get_struct(This);
  real.Activate;
  result := This;
end;

function ApplicationEvents_cancel_dispatch(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ApplicationEvents;
begin
  real := ap_data_get_struct(This);
  real.CancelDispatch;
  result := This;
end;
(**** made by ap_src_maker ****)

procedure Init_ApplicationEvents;
begin
  cApplicationEvents := OutputPersistentClass(mPhi, TApplicationEvents, cWinControl, ap_iApplicationEvents_v);
  rb_define_method(cApplicationEvents, 'event_handle', @ApplicationEvents_event_handle, 1);
  rb_define_alloc_func(cApplicationEvents, @ApplicationEvents_allocate);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cApplicationEvents, 'activate', @ApplicationEvents_activate, 0);
  rb_define_method(cApplicationEvents, 'cancel_dispatch', @ApplicationEvents_cancel_dispatch, 0);
(**** made by ap_src_maker ****)

end;

end.
