unit uBoundLabel;

interface

uses
  ExtCtrls,
  Rubies;

var
  cBoundLabel: Tvalue;

function ap_cBoundLabel: Tvalue;
function ap_iBoundLabel(real: TBoundLabel; owner: Tvalue): Tvalue;
procedure Init_BoundLabel;

implementation

uses
  Classes,
  uLabel,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uCanvas, uFont,
  uPersistent, uComponent, uControl;

function ap_cBoundLabel: Tvalue;
begin
  result := cBoundLabel;
end;

procedure BoundLabel_setup(obj: Tvalue; real: TBoundLabel);
begin
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
end;

function BoundLabel_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function BoundLabel_alloc(This: Tvalue; real: TBoundLabel): Tvalue;
begin
  result := ChildAlloc(This, real);
  BoundLabel_setup(result, real);
end;

function ap_iBoundLabel(real: TBoundLabel; owner: Tvalue): Tvalue;
begin
  result := BoundLabel_alloc(cBoundLabel, real);
  ap_owner(result, owner);
end;

function ap_iBoundLabel_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iBoundLabel(TBoundLabel(AControl), owner);
end;

function BoundLabel_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TBoundLabel;
begin
  real := TBoundLabel.Create(nil);
  result := CompoAlloc(This, real);
  BoundLabel_setup(result, real);
end;

procedure Init_BoundLabel;
begin
  cBoundLabel := OutputPersistentClass(mPhi, TBoundLabel, cLabel, ap_iBoundLabel_v);
  rb_define_method(cBoundLabel, 'event_handle', @BoundLabel_event_handle, 1);
  rb_define_alloc_func(cBoundLabel, @BoundLabel_allocate);
//  rb_define_attr(cBoundLabel, 'canvas', 1, 0);
end;

end.
