unit uControlBar;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  ExtCtrls,
  Rubies;

var
  cControlBar: Tvalue;

function ap_cControlBar: Tvalue;
function ap_iControlBar(real: TControlBar; owner: Tvalue): Tvalue;
procedure Init_ControlBar;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cControlBar: Tvalue;
begin
  result := cControlBar;
end;

procedure ControlBar_setup(obj: Tvalue; real: TControlBar);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ControlBar_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ControlBar_alloc(This: Tvalue; real: TControlBar): Tvalue;
begin
  result := ChildAlloc(This, real);
  ControlBar_setup(result, real);
end;

function ap_iControlBar(real: TControlBar; owner: Tvalue): Tvalue;
begin
  result := ControlBar_alloc(cControlBar, real);
  ap_owner(result, owner);
end;

function ap_iControlBar_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iControlBar(TControlBar(AControl), owner);
end;

function ControlBar_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TControlBar;
begin
  real := TControlBar.Create(nil);
  result := CompoAlloc(This, real);
  ControlBar_setup(result, real);
end;

(**** str_my_class made by ap_src_maker ****)

type
TPhi_ControlBar = class(TControlBar)
end;

function ControlBar_stick_controls(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ControlBar;
begin
  real := ap_data_get_struct(This);
  real.StickControls;
  result := This;
end;

(**** made by ap_src_maker ****)

procedure Init_ControlBar;
begin
  cControlBar := OutputPersistentClass(mPhi, TControlBar, cWinControl, ap_iControlBar_v);
  rb_define_method(cControlBar, 'event_handle', @ControlBar_event_handle, 1);
  rb_define_alloc_func(cControlBar, @ControlBar_allocate);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cControlBar, 'stick_controls', @ControlBar_stick_controls, 0);
(**** made by ap_src_maker ****)

end;

end.
