unit uControlScrollBar;

interface

uses
{$IFDEF VCL}
  Forms, StdCtrls,
{$ELSE}
  QForms, QStdCtrls,
{$ENDIF}
  Rubies;

var
  cControlScrollBar: Tvalue;

function ap_cControlScrollBar: Tvalue;
function ap_iControlScrollBar(real: TControlScrollBar; owner: Tvalue): Tvalue;
procedure Init_ControlScrollBar;

implementation

uses
  Classes, SysUtils,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cControlScrollBar: Tvalue;
begin
  result := cControlScrollBar;
end;

procedure ControlScrollBar_setup(obj: Tvalue; real: TControlScrollBar);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ControlScrollBar_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ControlScrollBar_alloc(This: Tvalue; real: TControlScrollBar): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
  ControlScrollBar_setup(result, real);
end;

function ap_iControlScrollBar(real: TControlScrollBar; owner: Tvalue): Tvalue;
begin
  result := ControlScrollBar_alloc(cControlScrollBar, real);
  ap_owner(result, owner);
end;

function ControlScrollBar_new(This: Tvalue): Tvalue; cdecl;
var
  real: TControlScrollBar;
begin
  real := TControlScrollBar.Create;
  result := ObjAlloc(This, real);
  ControlScrollBar_setup(result, real);
  ap_obj_call_init(result, 0, nil);
end;

function ControlScrollBar_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControlScrollBar;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  try
    real.Assign(source);
  except
    on E: EConvertError do
      ap_raise(ap_eStandardError, E.message);
  end;
  result := v;
end;

function ControlScrollBar_scroll_bar_visible_p(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(TControlScrollBar(ap_data_get_struct(This)).IsScrollBarVisible);
end;

procedure Init_ControlScrollBar;
begin
  cControlScrollBar := rb_define_class_under(mPhi, 'ControlScrollBar', ap_cObject);
  OutputProp(cControlScrollBar, TControlScrollBar);

  rb_define_method(cControlScrollBar, 'event_handle', @ControlScrollBar_event_handle, 1);
  rb_define_singleton_method(cControlScrollBar, 'new', @ControlScrollBar_new, 0);
  rb_define_method(cControlScrollBar, 'assign', @ControlScrollBar_assign, 1);
  rb_define_method(cControlScrollBar, 'scroll_bar_visible?', @ControlScrollBar_scroll_bar_visible_p, 0);
end;

end.
