unit uHandle;

interface

uses Classes, contnrs, Rubies, PhiHandle;

var
  UOwner: TComponent;
  Handle: TPhiHandle;

function retnil(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
function retval(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
function PhiExtentList: TObjectList;
function PhiObjectList: TObjectList;
function PhiAllocFuncList: TStringList;
function GetAllocFunc(name: string): TAllocFunc;
function PhiEventFuncList: TStringList;
function PhiGetHandle: TPhiHandle;
function PhiGetUOwner: TComponent;

implementation

uses uAnyComponent;

function retnil(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

function retval(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
begin
  if argc > 0 then
    result := Pvalue(argv)^
  else
    result := Qnil
  ;
end;

function PhiExtentList: TObjectList;
begin
  result := Handle.ExtentList;
end;

function PhiObjectList: TObjectList;
begin
  result := Handle.ObjectList;
end;

function PhiAllocFuncList: TStringList;
begin
  result := Handle.AllocFuncList;
end;

function GetAllocFunc(name: string): TAllocFunc;
var
  i: Integer;
begin
  i := PhiAllocFuncList.IndexOf(name);
  if i < 0 then
    result := ap_iAnyComponent_v
  else
    result := TAllocFunc(PhiAllocFuncList.Objects[i])
  ;
end;

function PhiEventFuncList: TStringList;
begin
  result := Handle.EventFuncList;
end;

function PhiGetHandle: TPhiHandle;
begin
  result := Handle;
end;

function PhiGetUOwner: TComponent;
begin
  result := UOwner;
end;

end.
