unit uLabel;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cLabel: Tvalue;

function ap_cLabel: Tvalue;
function ap_iLabel(real: TLabel; owner: Tvalue): Tvalue;
procedure Init_Label;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uCanvas, uFont,
  uPersistent, uComponent, uControl;

function ap_cLabel: Tvalue;
begin
  result := cLabel;
end;

procedure Label_setup(obj: Tvalue; real: TLabel);
begin
{$IFDEF VCL}
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
{$ENDIF}
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
end;

function Label_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Label_alloc(This: Tvalue; real: TLabel): Tvalue;
begin
  result := ChildAlloc(This, real);
  Label_setup(result, real);
end;

function ap_iLabel(real: TLabel; owner: Tvalue): Tvalue;
begin
  result := Label_alloc(cLabel, real);
  ap_owner(result, owner);
end;

function ap_iLabel_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iLabel(TLabel(AControl), owner);
end;

function Label_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TLabel;
begin
  real := TLabel.Create(nil);
  result := CompoAlloc(This, real);
  Label_setup(result, real);
end;

procedure Init_Label;
begin
  OutputConstSetType(mPhi, TypeInfo(TTextLayout));
  cLabel := OutputPersistentClass(mPhi, TLabel, cControl, ap_iLabel_v);
  rb_define_method(cLabel, 'event_handle', @Label_event_handle, 1);
  rb_define_alloc_func(cLabel, @Label_allocate);
  rb_define_attr(cLabel, 'canvas', 1, 0);
//rb_define_attr(cLabel, 'font', 1, 0);
end;

end.
