unit uLabeledEdit;

interface

uses
{$IFDEF VCL}
  ExtCtrls,
{$ENDIF}
  Rubies;

var
  cLabeledEdit: Tvalue;

function ap_cLabeledEdit: Tvalue;
function ap_iLabeledEdit(real: TLabeledEdit; owner: Tvalue): Tvalue;
procedure Init_LabeledEdit;

implementation

uses
  Classes,
  uEdit,
  uBoundLabel,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uConv,
  uSizeConstraints, uFont,
  uPersistent, uComponent, uControl;

function ap_cLabeledEdit: Tvalue;
begin
  result := cLabeledEdit;
end;

procedure LabeledEdit_setup(obj: Tvalue; real: TLabeledEdit);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@edit_label', ap_iBoundLabel(real.EditLabel, obj));
end;

function LabeledEdit_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function LabeledEdit_alloc(klass: Tvalue; real: TLabeledEdit): Tvalue;
begin
  result := ChildAlloc(klass, real);
  LabeledEdit_setup(result, real);
end;

function ap_iLabeledEdit(real: TLabeledEdit; owner: Tvalue): Tvalue;
begin
  result := LabeledEdit_alloc(cLabeledEdit, real);
  ap_owner(result, owner);
end;

function ap_iLabeledEdit_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iLabeledEdit(TLabeledEdit(AControl), owner);
end;

function LabeledEdit_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TLabeledEdit;
begin
  real := TLabeledEdit.Create(nil);
  result := CompoAlloc(This, real);
  LabeledEdit_setup(result, real);
end;

procedure Init_LabeledEdit;
begin
  OutputConstSetType(mPhi, TypeInfo(TLabelPosition));
  cLabeledEdit := OutputPersistentClass(mPhi, TLabeledEdit, cEdit, ap_iLabeledEdit_v);
  rb_define_method(cLabeledEdit, 'event_handle', @LabeledEdit_event_handle, 1);
  rb_define_alloc_func(cLabeledEdit, @LabeledEdit_allocate);
end;

end.
