unit uListBox;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cListBox: Tvalue;

function ap_cListBox: Tvalue;
function ap_iListBox(real: TListBox; owner: Tvalue): Tvalue;
procedure Init_ListBox;

implementation

uses
{$IFDEF LINUX}
  Types,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  Classes, SysUtils,
  uConv,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uCanvas, uFont, uStrings, uRect,
  uPersistent, uComponent, uControl, uIndexer;

function ap_cListBox: Tvalue;
begin
  result := cListBox;
end;

procedure ListBox_setup(obj: Tvalue; real: TListBox);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@items', ap_iStrings(real.Items, obj));
//    AssignPropMethod(real, [Handle]);
end;

function ListBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ListBox_alloc(This: Tvalue; real: TListBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  ListBox_setup(result, real);
end;

function ap_iListBox(real: TListBox; owner: Tvalue): Tvalue;
begin
  result := ListBox_alloc(cListBox, real);
  ap_owner(result, owner);
end;

function ap_iListBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iListBox(TListBox(AControl), owner);
end;

function ListBox_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin
  real := TListBox.Create(nil);
  result := CompoAlloc(This, real);
  ListBox_setup(result, real);
end;

function ListBox_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin;
  real := ap_data_get_struct(This);
  real.Clear;
  result := This;
end;

function ListBox_get_sel_count(This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin;
  real := ap_data_get_struct(This);
  result := INT2FIX(real.SelCount);
end;

function ListBox_item_at_pos(This, pos, existing: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin;
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ItemAtPos(PPoint(ap_data_get_struct(pos))^, RTEST(existing)));
end;

function ListBox_item_rect(This, index: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin;
  real := ap_data_get_struct(This);
  result := This;
  try
    result := ap_iRect(real.ItemRect(FIX2INT(index)), This);
  except
    on E: Exception do;
  end;
end;

function ListBox_get_item_index(This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ItemIndex);
end;

function ListBox_set_item_index(This,v: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin
  real := ap_data_get_struct(This);
  real.ItemIndex := FIX2INT(v);
  result := v;
end;

function ListBox_selected_items(This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
  i, len: Integer;
begin
  real := ap_data_get_struct(This);
  len := real.items.Count;
  result := rb_ary_new;
  if real.MultiSelect then
    for i := 0 to len - 1 do
      if real.Selected[i] then
        rb_ary_push(result, INT2FIX(i));
end;

function ListBox_set_selected(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
  args: array of Tvalue;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  real.Selected[FIX2INT(args[0])] := RTEST(args[1]);
  result := args[1];
end;

function ListBox_get_selected(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
  args: array of Tvalue;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  result := ap_bool(real.Selected[FIX2INT(args[0])]);
end;

(**** str_my_class made by ap_src_maker ****)
type
TMyListBox = class(TListBox)
end;
{$IFDEF VCL}
function ListBox_add_item(This, Item, AObject : Tvalue): Tvalue; cdecl;
var
  real: TMyListBox;
  dlv_Item : String;
  dlv_AObject : TObject;
begin
  real := ap_data_get_struct(This);
  dlv_Item := dl_String(Item);
  dlv_AObject := ap_data_get_struct(AObject);
  real.AddItem( dlv_Item, dlv_AObject );
  result := This;
end;
{$ENDIF}
function ListBox_clear_selection(This : Tvalue): Tvalue; cdecl;
var
  real: TMyListBox;
begin
  real := ap_data_get_struct(This);
  real.ClearSelection;
  result := This;
end;
{$IFDEF VCL}
function ListBox_delete_selected(This : Tvalue): Tvalue; cdecl;
var
  real: TMyListBox;
begin
  real := ap_data_get_struct(This);
  real.DeleteSelected;
  result := This;
end;

function ListBox_select_all(This : Tvalue): Tvalue; cdecl;
var
  real: TMyListBox;
begin
  real := ap_data_get_struct(This);
  real.SelectAll;
  result := This;
end;

function ListBox_get_count(This: Tvalue): Tvalue; cdecl;
var
  real: TMyListBox;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.Count);
end;

function ListBox_set_count(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyListBox;
begin
  real := ap_data_get_struct(This);
  real.Count := dl_Integer(v);
  result := v;
end;
{$ENDIF}
function ListBox_get_top_index(This: Tvalue): Tvalue; cdecl;
var
  real: TMyListBox;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.TopIndex);
end;

function ListBox_set_top_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyListBox;
begin
  real := ap_data_get_struct(This);
  real.TopIndex := dl_Integer(v);
  result := v;
end;

procedure Init_ListBox;
begin
  OutputConstSetType(mPhi, TypeInfo(TListBoxStyle));
  cListBox := OutputPersistentClass(mPhi, TListBox, cWinControl, ap_iListBox_v);
  rb_define_method(cListBox, 'event_handle', @ListBox_event_handle, 1);
  rb_define_alloc_func(cListBox, @ListBox_allocate);
  DefineAttrGet(cListBox, 'sel_count', ListBox_get_sel_count);
  rb_define_method(cListBox, 'clear', @ListBox_clear, 0);
  rb_define_method(cListBox, 'item_at_pos', @ListBox_item_at_pos , 2);
  rb_define_method(cListBox, 'item_rect', @ListBox_item_rect ,1);
  rb_define_method(cListBox, 'selected_items', @ListBox_selected_items, 0);
  DefineIndexer(cListBox, 'selected', @ListBox_get_selected, @ListBox_set_selected);
  DefineAttrGet(cListBox, 'item_index', ListBox_get_item_index);
  DefineAttrSet(cListBox, 'item_index', ListBox_set_item_index);
  rb_define_attr(cListBox, 'canvas', 1, 0);
(**** str_init made by ap_src_maker ****)
{$IFDEF VCL}
  rb_define_method(cListBox, 'add_item', @ListBox_add_item, 2);
{$ENDIF}
  rb_define_method(cListBox, 'clear_selection', @ListBox_clear_selection, 0);
{$IFDEF VCL}
  rb_define_method(cListBox, 'delete_selected', @ListBox_delete_selected, 0);
  rb_define_method(cListBox, 'select_all', @ListBox_select_all, 0);
  DefineAttrGet(cListBox, 'count', ListBox_get_count);
  DefineAttrSet(cListBox, 'count', ListBox_set_count);
{$ENDIF}
  DefineAttrGet(cListBox, 'top_index', ListBox_get_top_index);
  DefineAttrSet(cListBox, 'top_index', ListBox_set_top_index);
end;

end.
