unit uSplitter;

interface

uses
{$IFDEF VCL}
  ExtCtrls,
{$ELSE}
  QExtCtrls,
{$ENDIF}
  Rubies;

var
  cSplitter: Tvalue;
  
function ap_cSplitter: Tvalue;
function ap_iSplitter(real: TSplitter; owner: Tvalue): Tvalue;
procedure Init_Splitter;

implementation

uses
  Classes,
  uDefUtils, uIntern, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cSplitter: Tvalue;
begin
  result := cSplitter;
end;

procedure Splitter_setup(obj: Tvalue; real: TSplitter);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
end;

function Splitter_alloc(This: Tvalue; real: TSplitter): Tvalue;
begin
  result := ChildAlloc(This, real);
  Splitter_setup(result, real);
end;

function ap_iSplitter(real: TSplitter; owner: Tvalue): Tvalue;
begin
  result := Splitter_alloc(cSplitter, real);
  ap_owner(result, owner);
end;

function ap_iSplitter_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iSplitter(TSplitter(AControl), owner);
end;

function Splitter_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TSplitter;
begin
  real := TSplitter.Create(nil);
  result := CompoAlloc(This, real);
  Splitter_setup(result, real);
end;

procedure Init_Splitter;
begin
  OutputConstSetType(mPhi, TypeInfo(TResizeStyle));
  cSplitter := OutputPersistentClass(mPhi, TSplitter, cControl, ap_iSplitter_v);
  rb_define_alloc_func(cSplitter, @Splitter_allocate);
end;

end.
