unit uTimer;

interface

uses
{$IFDEF VCL}
  ExtCtrls,
{$ELSE}
  QExtCtrls,
{$ENDIF}
  Rubies;

var
  cTimer: Tvalue;

function ap_cTimer: Tvalue;
function ap_iTimer(real: TTimer; owner: Tvalue): Tvalue;
procedure Init_Timer;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uPersistent, uComponent;

function ap_cTimer: Tvalue;
begin
  result := cTimer;
end;

procedure Timer_setup(obj: Tvalue; real: TTimer);
begin
//    AssignPropMethod(real, [Handle]);
end;

function Timer_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Timer_alloc(This: Tvalue; real: TTimer): Tvalue;
begin
  result := ChildAlloc(This, real);
  Timer_setup(result, real);
end;

function ap_iTimer(real: TTimer; owner: Tvalue): Tvalue;
begin
  result := Timer_alloc(cTimer, real);
  ap_owner(result, owner);
end;

function ap_iTimer_v(var AComponent; owner: Tvalue): Tvalue;
begin
  result := ap_iTimer(TTimer(AComponent), owner);
end;

function Timer_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TTimer;
begin
  real := TTimer.Create(nil);
  result := CompoAlloc(This, real);
  Timer_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_Timer;
begin
  cTimer := OutputPersistentClass(mPhi, TTimer, cComponent, ap_iTimer_v);
  rb_define_method(cTimer, 'event_handle', @Timer_event_handle, 1);
  DefineSingletonMethod(cTimer, 'new', Timer_new);
end;

end.
