unit uTreeNode;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cTreeNode, cTreeNodes: Tvalue;

function ap_cTreeNode: Tvalue;
function ap_iTreeNode(real: TTreeNode; owner: Tvalue): Tvalue;
function ap_cTreeNodes: Tvalue;
function ap_iTreeNodes(real: TTreeNodes; owner: Tvalue): Tvalue;
function dl_TreeNode(obj: Tvalue): TTreeNode;
function ap_TreeNode(node: TTreeNode): Tvalue;
procedure Init_TreeNode;

implementation

uses
  SysUtils, Classes,
  uRect,
  uConv, uDefUtils, uHandle, uIntern, uAlloc, uProp, uPhi, uError,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_TreeNode = class(TTreeNode);
TPhi_TreeNodes = class(TTreeNodes);
(**** made by ap_src_maker ****)

type
  PNode = ^TNode;
  TNode = record
    real: TTreeNode;
    dead: Boolean;
    data: Tvalue;
  end;

procedure TreeNode_free(p: PNode); cdecl;
begin
  dispose(p);
end;

procedure TreeNode_mark(p: PNode); cdecl;
begin
  rb_gc_mark(Pointer(p^.data));
end;

function TreeNode_alloc1(klass: Tvalue; real: TTreeNode): Tvalue;
var
  p: PNode;
  parent: Tvalue;
begin
  if real = nil then begin result := Qnil; exit; end;
  new(p);
  p^.real := real;
  p^.dead := False;
  p^.data := Qnil;
  result := rb_data_object_alloc(klass, p, @TreeNode_mark, @TreeNode_free);
  rb_iv_set(result, '@events', rb_hash_new);
  real.Data := Pointer(result);
  if real.Parent = nil then
    parent := Qnil
  else
    parent := Tvalue(real.Parent.Data);
  rb_iv_set(result, '@parent', parent);
end;

function GetP(obj: Tvalue): PNode;
begin
  if rb_obj_is_kind_of(obj, cTreeNode) = 0 then
    ap_raise(ap_eArgError, sWrong_arg_type);
  result := ap_data_get_struct(obj);
end;

function dl_TreeNode(obj: Tvalue): TTreeNode;
var
  p: PNode;
begin
  p := GetP(obj);
  if p^.dead then
    ap_raise(eDelphiError, 'dead node');
  result := TPhi_TreeNode(p^.real);
end;

function ap_TreeNode(node: TTreeNode): Tvalue;
begin
  if node = nil then
    result := Qnil
  else if node.data = nil then
    ap_raise(eDelphiError, 'invalid node')
  else
    result := Tvalue(node.data);
end;

function ap_cTreeNode: Tvalue;
begin
  result := cTreeNode;
end;

function TreeNode_alloc(This: Tvalue; real: TTreeNode): Tvalue; forward;

procedure TreeNode_setup(obj: Tvalue; real: TTreeNode);
var
  i: Integer;
begin
  rb_iv_set(obj, '@text', rb_str_new2(PChar(real.Text)));
  rb_iv_set(obj, '@index', INT2FIX(real.Index));
  rb_iv_set(obj, '@level', INT2FIX(real.Level));
  for i := 0 to real.Count-1 do
    TreeNode_alloc(cTreeNode, real[i]);
end;

function TreeNode_alloc;
begin
  result := TreeNode_alloc1(This, real);
  TreeNode_setup(result, real);
end;

function ap_iTreeNode(real: TTreeNode; owner: Tvalue): Tvalue;
begin
  result := Qnil ; if real = nil then exit;
  result := TreeNode_alloc(cTreeNode, real);
  ap_owner(result, owner);
end;

function TreeNode_aref(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  n: Integer;
begin
  real := dl_TreeNode(This);
  n := NUM2INT(v);
  if (n < 0) or (real.Count <= n) then
    ap_raise(ap_eIndexError, sOut_of_range);
  result := ap_TreeNode(real[n]);
end;

function TreeNode_get_data(This: Tvalue): Tvalue; cdecl;
var
  p: PNode;
begin
  p := GetP(This);
  result := p^.data;
end;

function TreeNode_set_data(This, v: Tvalue): Tvalue; cdecl;
var
  p: PNode;
begin
  p := GetP(This);
  p^.data := v;
  result := v;
end;

function TreeNode_get_count(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := INT2FIX(real.Count);
end;

function TreeNode_set_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  str: Tvalue;
begin
  real := dl_TreeNode(This);
  real.Text := dl_String(v);
  str := rb_iv_get(This, '@text');
  rb_str_resize(str, 0);
  rb_str_concat(str, v);
  result := v;
end;

{$IFDEF VCL}
function SortProc(a, b, This: Longint): Integer; stdcall;
var
  ret, anode, bnode: Tvalue;
begin
  anode := Tvalue(TTreeNode(a).Data);
  bnode := Tvalue(TTreeNode(b).Data);
  ret := rb_yield(rb_assoc_new(anode, bnode));
  if RTYPE(ret) = T_FIXNUM then
    result := FIX2INT(ret)
  else
    result := 0;
end;
{$ENDIF}

function TreeNode_sort(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
{$IFDEF VCL}
  if rb_block_given_p <> 0 then
    result := ap_bool(real.CustomSort(SortProc, This))
  else
    result := ap_bool(real.AlphaSort);
{$ELSE}
    result := ap_bool(real.AlphaSort(True));
{$ENDIF}
end;

function TreeNode_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  source: TPersistent;
begin
  real := dl_TreeNode(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := v;
end;

function TreeNode_expand(This, recurse: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.Expand(RTEST(recurse));
  result := This;
end;

function TreeNode_collapse(This, recurse: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.Collapse(RTEST(recurse));
  result := This;
end;

function TreeNode_get_expanded(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_bool(real.Expanded);
end;

function TreeNode_set_expanded(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.Expanded := RTEST(v);
  result := v;
end;

function TreeNode_get_first_child(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_TreeNode(dl_TreeNode(This).GetFirstChild);
end;

function TreeNode_get_last_child(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_TreeNode(dl_TreeNode(This).GetLastChild);
end;

function TreeNode_get_next(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_TreeNode(dl_TreeNode(This).GetNext);
end;

function TreeNode_get_next_child(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  child: TTreeNode;
begin
  real := dl_TreeNode(This);
  child := dl_TreeNode(v);

  if child = nil then
    result := Qnil
  else
    result := ap_TreeNode(real.GetNextChild(child));
end;

function TreeNode_get_next_sibling(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_TreeNode(dl_TreeNode(This).GetNextSibling);
end;

function TreeNode_get_next_visible(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_TreeNode(dl_TreeNode(This).GetNextVisible);
end;

function TreeNode_get_prev(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_TreeNode(dl_TreeNode(This).GetPrev);
end;

function TreeNode_get_prev_child(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  child: TTreeNode;
begin
  real := dl_TreeNode(This);
  child := dl_TreeNode(v);

  if child = nil then
    result := Qnil
  else
    result := ap_TreeNode(real.GetPrevChild(child));
end;

function TreeNode_get_prev_sibling(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_TreeNode(dl_TreeNode(This).GetPrevSibling);
end;

function TreeNode_get_prev_visible(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_TreeNode(dl_TreeNode(This).GetPrevVisible);
end;

function ap_cTreeNodes: Tvalue;
begin
  result := cTreeNodes;
end;

procedure TreeNodes_setup(obj: Tvalue; real: TTreeNodes);
var
  i: Integer;
begin
  rb_iv_set(obj, '@items', rb_ary_new);
  for i := 0 to real.Count-1 do
    TreeNode_alloc(cTreeNode, real[i]);
end;

function TreeNodes_alloc(This: Tvalue; real: TTreeNodes): Tvalue;
begin
  result := TmpAlloc(This, real);
  TreeNodes_setup(result, real);
end;

function ap_iTreeNodes(real: TTreeNodes; owner: Tvalue): Tvalue;
begin
  result := Qnil ; if real = nil then exit;
  result := TreeNodes_alloc(cTreeNodes, real);
  ap_owner(result, owner);
end;

function TreeNodes_aref(This, v: Tvalue): Tvalue; cdecl;
var
  n: Integer;
  real: TTreeNodes;
begin
  real := ap_data_get_struct(This);
  n := NUM2INT(v);
  if (n < 0) or (real.Count <= n) then
    ap_raise(ap_eIndexError, sOut_of_range);
  if real[n].Data = nil then
    result := Qnil
  else
  begin
    result := Tvalue(real[n].Data);
    dl_TreeNode(result);
  end;
end;

function TreeNodes_get_count(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Count);
end;

function TreeNodes_get_first_node(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
begin
  real := ap_data_get_struct(This);
  if real.GetFirstNode.Data = nil then
    result := Qnil
  else
    result := Tvalue(real.GetFirstNode.Data);
end;

function TreeNodes_get_owner(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
begin
  real := ap_data_get_struct(This);
  if real.Owner = nil then
    result := Qnil
  else
    result := real.Owner.tag
  ;
end;

function TreeNodes_add(This, vnode, str: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  node, ret: TTreeNode;
begin
  real := ap_data_get_struct(This);
  if vnode = Qnil then node := nil else node := dl_TreeNode(vnode);
  ret := real.Add(node, dl_String(str));
  result := ap_iTreeNode(ret, This);
  if rb_block_given_p <> 0 then rb_obj_instance_eval(0, nil, result);
  rb_ary_push(rb_iv_get(This, '@items'), result);
end;

function TreeNodes_add_first(This, vnode, str: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  node, ret: TTreeNode;
begin
  real := ap_data_get_struct(This);
  if vnode = Qnil then node := nil else node := dl_TreeNode(vnode);
  ret := real.Add(node, dl_String(str));
  result := ap_iTreeNode(ret, This);
  rb_ary_push(rb_iv_get(This, '@items'), result);
end;

function TreeNodes_add_child(This, vnode, str: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  node, ret: TTreeNode;
begin
  real := ap_data_get_struct(This);
  node := dl_TreeNode(vnode);
  ret := real.AddChild(node, dl_String(str));
  result := ap_iTreeNode(ret, This);
  rb_ary_push(rb_iv_get(This, '@items'), result);
end;

function TreeNodes_add_child_first(This, vnode, str: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  node, ret: TTreeNode;
begin
  real := ap_data_get_struct(This);
  node := dl_TreeNode(vnode);
  ret := real.AddChildFirst(node, dl_String(str));
  result := ap_iTreeNode(ret, This);
  rb_ary_push(rb_iv_get(This, '@items'), result);
end;

function TreeNodes_insert(This, vnode, str: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  node, ret: TTreeNode;
begin
  real := ap_data_get_struct(This);
  if vnode = Qnil then node := nil else node := dl_TreeNode(vnode);
  ret := real.Insert(node, dl_String(str));
  result := ap_iTreeNode(ret, This);
  rb_ary_push(rb_iv_get(This, '@items'), result);
end;

procedure Node_delete(This, vnode: Tvalue);
var
  p: PNode;
  node: TTreeNode;
  n: Integer;
begin
  rb_iv_set(vnode, '@owner', Qnil);
  rb_ary_delete(rb_iv_get(This, '@items'), vnode);
  p := GetP(vnode);
  p^.dead := True;
  node := p^.real;
  for n := 0 to node.Count-1 do
    Node_delete(This, Tvalue(node[n].Data));
end;

function TreeNodes_delete(This, vnode: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  p: PNode;
  node: TTreeNode;
begin
  Node_delete(This, vnode);

  p := GetP(vnode);
  p^.dead := True;
  node := p^.real;

  real := ap_data_get_struct(This);
  real.Delete(node);
  result := This;
end;

function TreeNodes_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  ary: Tvalue;
  ptr: Pvalue;
  len: Integer;
  vnode: Tvalue;
  p: PNode;
begin
  ary := rb_iv_get(This, '@items');
  ptr := ap_ary_ptr(ary);
  len := ap_ary_len(ary);
  while len > 0 do
  begin
    vnode := ptr^;
    p := GetP(vnode);
    p^.dead := True;
    Inc(ptr);
    Dec(len);
  end;
  rb_ary_clear(ary);
  real := ap_data_get_struct(This);
  real.Clear;
  result := This;
end;

function TreeNodes_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  source: TPersistent;
  ary, dup: Tvalue;
  ptr: Pvalue;
  len: Integer;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  ary := rb_iv_get(v, '@items');
  if RTYPE(ary) = T_ARRAY then
  begin
    ptr := ap_ary_ptr(ary);
    len := ap_ary_len(ary);
    dup := rb_iv_get(This, '@items');
    rb_ary_clear(dup);
    while len > 0 do
    begin
      rb_ary_push(dup, ptr^);
      Inc(ptr);
      Dec(len);
    end;
  end;
  result := v;
end;

function TreeNodes_update(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
begin
  real := ap_data_get_struct(This);
  real.BeginUpdate;
  try
    result := rb_yield(Qnil);
  finally
    real.EndUpdate;
  end;
end;

function TreeNode_get_image_index(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := INT2FIX(real.ImageIndex);
end;

function TreeNode_set_image_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.ImageIndex := FIX2INT(v);
  result := v;
end;

function TreeNode_get_selected_index(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := INT2FIX(real.SelectedIndex);
end;

function TreeNode_set_selected_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.SelectedIndex := dl_Integer(v);
  result := v;
end;

function TreeNode_get_absolute_index(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := INT2FIX(real.AbsoluteIndex);
end;

(**** str_method made by ap_src_maker ****)

//// must be replaced "real := ap_data_get_struct(This);" to "real := dl_TreeNode(This);" ####
//// must   replace in TreeNode_xxx
//// do not relpace in TreeNodes_xxx

function TreeNode_set_selected_bit(This, Value : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeNode;
  dlv_Value : Boolean;
begin
  real := TPhi_TreeNode(dl_TreeNode(This));
  dlv_Value := dl_Boolean(Value);
  real.SetSelectedBit( dlv_Value );
  result := Value;
end;

function TreeNode_alpha_sort(This, ARecurse : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  dlv_ARecurse : Boolean;
begin
  real := dl_TreeNode(This);
  dlv_ARecurse := dl_Boolean(ARecurse);
  result := ap_Bool(real.AlphaSort( dlv_ARecurse ));
end;

function TreeNode_delete(This : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.Delete;
  result := This;
end;

function TreeNode_delete_children(This : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.DeleteChildren;
  result := This;
end;

function TreeNode_display_rect(This, TextOnly : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  dlv_TextOnly : Boolean;
begin
  real := dl_TreeNode(This);
  dlv_TextOnly := dl_Boolean(TextOnly);
  result := ap_iRect(real.DisplayRect( dlv_TextOnly ),This);
end;

function TreeNode_edit_text(This : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Bool(real.EditText);
end;

function TreeNode_end_edit(This, Cancel : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  dlv_Cancel : Boolean;
begin
  real := dl_TreeNode(This);
  dlv_Cancel := dl_Boolean(Cancel);
  real.EndEdit( dlv_Cancel );
  result := This;
end;

function TreeNode_get_handle(This : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Handle(ord(real.GetHandle));
end;

function TreeNode_has_as_parent(This, Value : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  dlv_Value : TTreeNode;
begin
  real := dl_TreeNode(This);
  dlv_Value := dl_TreeNode(Value);
  result := ap_Bool(real.HasAsParent( dlv_Value ));
end;

function TreeNode_index_of(This, Value : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  dlv_Value : TTreeNode;
begin
  real := dl_TreeNode(This);
  dlv_Value := dl_TreeNode(Value);
  result := ap_Integer(real.IndexOf( dlv_Value ));
end;

function TreeNode_make_visible(This : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.MakeVisible;
  result := This;
end;

function TreeNode_is_first_node(This : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Bool(real.IsFirstNode);
end;

function TreeNode_get_cut(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Bool(real.Cut);
end;

function TreeNode_set_cut(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.Cut := dl_Boolean(v);
  result := v;
end;

function TreeNode_get_deleting(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Bool(real.Deleting);
end;

function TreeNode_get_focused(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Bool(real.Focused);
end;

function TreeNode_set_focused(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.Focused := dl_Boolean(v);
  result := v;
end;

function TreeNode_get_drop_target(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Bool(real.DropTarget);
end;

function TreeNode_set_drop_target(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.DropTarget := dl_Boolean(v);
  result := v;
end;

function TreeNode_get_selected(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Bool(real.Selected);
end;

function TreeNode_set_selected(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.Selected := dl_Boolean(v);
  result := v;
end;

function TreeNode_get_has_children(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Bool(real.HasChildren);
end;

function TreeNode_set_has_children(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.HasChildren := dl_Boolean(v);
  result := v;
end;

function TreeNode_get_is_visible(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Bool(real.IsVisible);
end;

// not used ..
function TreeNode_set_item(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  dlv_Index : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := dl_TreeNode(This);
  dlv_Index := dl_Integer(argv[0]);
  real.Item[dlv_Index] := ap_data_get_struct(argv[1]);
  result := argv[1];
end;

// not used ..
function TreeNode_get_item(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  dlv_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := dl_TreeNode(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_TreeNode(real.Item[dlv_Index]);
end;

function TreeNode_get_overlay_index(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Integer(real.OverlayIndex);
end;

function TreeNode_set_overlay_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.OverlayIndex := dl_Integer(v);
  result := v;
end;

function TreeNode_get_state_index(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Integer(real.StateIndex);
end;

function TreeNode_set_state_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  real.StateIndex := dl_Integer(v);
  result := v;
end;

function TreeNode_get_state(This, NodeState : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeNode;
  dlv_NodeState : TNodeState;
begin
  real := TPhi_TreeNode(dl_TreeNode(This));
  dlv_NodeState := TNodeState(dl_Integer(NodeState));
  result := ap_Bool(real.GetState( dlv_NodeState ));
end;

function TreeNode_set_state(This, NodeState, Value : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeNode;
  dlv_NodeState : TNodeState;
  dlv_Value : Boolean;
begin
  real := TPhi_TreeNode(dl_TreeNode(This));
  dlv_NodeState := TNodeState(dl_Integer(NodeState));
  dlv_Value := dl_Boolean(Value);
  real.SetState( dlv_NodeState, dlv_Value );
  result := Value;
end;

function TreeNode_move_to(This, Destination, Mode : Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
  dlv_Destination : TTreeNode;
  dlv_Mode : TNodeAttachMode;
begin
  real := dl_TreeNode(This);
  dlv_Destination := dl_TreeNode(Destination);
  dlv_Mode := TNodeAttachMode(dl_Integer(Mode));
  real.MoveTo( dlv_Destination, dlv_Mode );
  result := This;
end;

function TreeNode_get_index(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Integer(real.Index);
end;

function TreeNode_get_level(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_Integer(real.Level);
end;

function TreeNode_get_owner(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNode;
begin
  real := dl_TreeNode(This);
  result := ap_iTreeNodes(real.Owner,This); //????
end;

function TreeNode_get_parent(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_TreeNode(dl_TreeNode(This).Parent);
end;

(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function TreeNodes_add_child_object_first(This, Parent, S, Ptr : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  dlv_Parent : TTreeNode;
  dlv_S : string;
  dlv_Ptr : Pointer;
begin
  real := ap_data_get_struct(This);
  dlv_Parent := dl_TreeNode(Parent);
  dlv_S := dl_String(S);
  dlv_Ptr := ap_data_get_struct(Ptr);
  result := ap_iTreeNode(real.AddChildObjectFirst( dlv_Parent, dlv_S, dlv_Ptr ),This);
end;

function TreeNodes_add_child_object(This, Parent, S, Ptr : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  dlv_Parent : TTreeNode;
  dlv_S : string;
  dlv_Ptr : Pointer;
begin
  real := ap_data_get_struct(This);
  dlv_Parent := dl_TreeNode(Parent);
  dlv_S := dl_String(S);
  dlv_Ptr := ap_data_get_struct(Ptr);
  result := ap_iTreeNode(real.AddChildObject( dlv_Parent, dlv_S, dlv_Ptr ),This);
end;

function TreeNodes_add_object_first(This, Sibling, S, Ptr : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  dlv_Sibling : TTreeNode;
  dlv_S : string;
  dlv_Ptr : Pointer;
begin
  real := ap_data_get_struct(This);
  dlv_Sibling := dl_TreeNode(Sibling);
  dlv_S := dl_String(S);
  dlv_Ptr := ap_data_get_struct(Ptr);
  result := ap_iTreeNode(real.AddObjectFirst( dlv_Sibling, dlv_S, dlv_Ptr ),This);
end;

function TreeNodes_add_object(This, Sibling, S, Ptr : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  dlv_Sibling : TTreeNode;
  dlv_S : string;
  dlv_Ptr : Pointer;
begin
  real := ap_data_get_struct(This);
  dlv_Sibling := dl_TreeNode(Sibling);
  dlv_S := dl_String(S);
  dlv_Ptr := ap_data_get_struct(Ptr);
  result := ap_iTreeNode(real.AddObject( dlv_Sibling, dlv_S, dlv_Ptr ),This);
end;

function TreeNodes_add_node(This, Node, Relative, S, Ptr, Method : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  dlv_Node : TTreeNode;
  dlv_Relative : TTreeNode;
  dlv_S : string;
  dlv_Ptr : Pointer;
  dlv_Method : TNodeAttachMode;
begin
  real := ap_data_get_struct(This);
  dlv_Node := dl_TreeNode(Node);
  dlv_Relative := dl_TreeNode(Relative);
  dlv_S := dl_String(S);
  dlv_Ptr := ap_data_get_struct(Ptr);
  dlv_Method := TNodeAttachMode(dl_Integer(Method));
  result := ap_iTreeNode(real.AddNode( dlv_Node, dlv_Relative, dlv_S, dlv_Ptr, dlv_Method ),This);
end;

function TreeNodes_alpha_sort(This, ARecurse : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  dlv_ARecurse : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_ARecurse := dl_Boolean(ARecurse);
  result := ap_Bool(real.AlphaSort( dlv_ARecurse ));
end;

function TreeNodes_begin_update(This : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
begin
  real := ap_data_get_struct(This);
  real.BeginUpdate;
  result := This;
end;

function TreeNodes_end_update(This : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
begin
  real := ap_data_get_struct(This);
  real.EndUpdate;
  result := This;
end;

function TreeNodes_insert_object(This, Sibling, S, Ptr : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  dlv_Sibling : TTreeNode;
  dlv_S : string;
  dlv_Ptr : Pointer;
begin
  real := ap_data_get_struct(This);
  dlv_Sibling := dl_TreeNode(Sibling);
  dlv_S := dl_String(S);
  dlv_Ptr := ap_data_get_struct(Ptr);
  result := ap_iTreeNode(real.InsertObject( dlv_Sibling, dlv_S, dlv_Ptr ),This);
end;

function TreeNodes_insert_node(This, Node, Sibling, S, Ptr : Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  dlv_Node : TTreeNode;
  dlv_Sibling : TTreeNode;
  dlv_S : string;
  dlv_Ptr : Pointer;
begin
  real := ap_data_get_struct(This);
  dlv_Node := dl_TreeNode(Node);
  dlv_Sibling := dl_TreeNode(Sibling);
  dlv_S := dl_String(S);
  dlv_Ptr := ap_data_get_struct(Ptr);
  result := ap_iTreeNode(real.InsertNode( dlv_Node, dlv_Sibling, dlv_S, dlv_Ptr ),This);
end;

function TreeNodes_get_handle(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
begin
  real := ap_data_get_struct(This);
  result := ap_Handle(ord(real.Handle));
end;

// not used ..
function TreeNodes_get_item(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TTreeNodes;
  dlv_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_iTreeNode(real.Item[dlv_Index],This);
end;
(**** made by ap_src_maker ****)

procedure Init_TreeNode;
begin
  cTreeNode := rb_define_class_under(mPhi, 'TreeNode', cPersistent);
  OutputProp(cTreeNode, TTreeNode);

  rb_define_method(cTreeNode, '[]', @TreeNode_aref, 1);
  DefineAttrGet(cTreeNode, 'data', TreeNode_get_data);
  DefineAttrSet(cTreeNode, 'data', TreeNode_set_data);
  DefineAttrGet(cTreeNode, 'count', TreeNode_get_count);
  DefineAttrSet(cTreeNode, 'text', TreeNode_set_text);
  rb_define_method(cTreeNode, 'sort', @TreeNode_sort, 0);
  rb_define_method(cTreeNode, 'assign', @TreeNode_assign, 1);
  rb_define_method(cTreeNode, 'expand', @TreeNode_expand, 1);
  rb_define_method(cTreeNode, 'collapse', @TreeNode_collapse, 1);
  DefineAttrGet(cTreeNode, 'expanded', TreeNode_get_expanded);
  DefineAttrSet(cTreeNode, 'expanded', TreeNode_set_expanded);
  rb_define_alias(cTreeNode, 'expanded?', 'expanded');
  rb_define_method(cTreeNode, 'first_child', @TreeNode_get_first_child, 0);
  rb_define_method(cTreeNode, 'last_child', @TreeNode_get_last_child, 0);
  rb_define_method(cTreeNode, 'next', @TreeNode_get_next, 0);
  rb_define_method(cTreeNode, 'next_child', @TreeNode_get_next_child, 1);
  rb_define_method(cTreeNode, 'next_sibling', @TreeNode_get_next_sibling, 0);
  rb_define_method(cTreeNode, 'next_visible', @TreeNode_get_next_visible, 0);
  rb_define_method(cTreeNode, 'prev', @TreeNode_get_prev, 0);
  rb_define_method(cTreeNode, 'prev_child', @TreeNode_get_prev_child, 1);
  rb_define_method(cTreeNode, 'prev_sibling', @TreeNode_get_prev_sibling, 0);
  rb_define_method(cTreeNode, 'prev_visible', @TreeNode_get_prev_visible, 0);

  rb_define_attr(cTreeNode, 'text', 1, 0);
  rb_define_attr(cTreeNode, 'index', 1, 0);
  rb_define_attr(cTreeNode, 'level', 1, 0);
  rb_define_attr(cTreeNode, 'parent', 1, 0);
  rb_define_attr(cTreeNode, 'owner', 1, 0);

  cTreeNodes := rb_define_class_under(mPhi, 'TreeNodes', cPersistent);
  OutputProp(cTreeNodes, TTreeNodes);

  rb_define_method(cTreeNodes, '[]', @TreeNodes_aref, 1);
  DefineAttrGet(cTreeNodes, 'count', TreeNodes_get_count);
  DefineAttrGet(cTreeNodes, 'first_node', TreeNodes_get_first_node);
  rb_define_method(cTreeNodes, 'add', @TreeNodes_add, 2);
  rb_define_method(cTreeNodes, 'add_first', @TreeNodes_add_first, 2);
  rb_define_method(cTreeNodes, 'add_child', @TreeNodes_add_child, 2);
  rb_define_method(cTreeNodes, 'add_child_first', @TreeNodes_add_child_first, 2);
  rb_define_method(cTreeNodes, 'insert', @TreeNodes_insert, 2);
  rb_define_method(cTreeNodes, 'clear', @TreeNodes_clear, 0);
  rb_define_method(cTreeNodes, 'delete', @TreeNodes_delete, 1);
  rb_define_method(cTreeNodes, 'assign', @TreeNodes_assign, 1);
  rb_define_method(cTreeNodes, 'update', @TreeNodes_update, 0);
  DefineAttrGet(cTreeNodes, 'owner', TreeNodes_get_owner);

  DefineAttrGet(cTreeNode, 'image_index', TreeNode_get_image_index);
  DefineAttrSet(cTreeNode, 'image_index', TreeNode_set_image_index);
  DefineAttrGet(cTreeNode, 'selected_index', TreeNode_get_selected_index);
  DefineAttrSet(cTreeNode, 'selected_index', TreeNode_set_selected_index);
  DefineAttrGet(cTreeNode, 'absolute_index', TreeNode_get_absolute_index);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cTreeNode, 'set_selected_bit', @TreeNode_set_selected_bit, 1);
  rb_define_method(cTreeNode, 'alpha_sort', @TreeNode_alpha_sort, 1);
  rb_define_method(cTreeNode, 'delete', @TreeNode_delete, 0);
  rb_define_method(cTreeNode, 'delete_children', @TreeNode_delete_children, 0);
  rb_define_method(cTreeNode, 'display_rect', @TreeNode_display_rect, 1);
  rb_define_method(cTreeNode, 'edit_text', @TreeNode_edit_text, 0);
  rb_define_method(cTreeNode, 'end_edit', @TreeNode_end_edit, 1);
  rb_define_method(cTreeNode, 'handle', @TreeNode_get_handle, 0);
  rb_define_method(cTreeNode, 'has_as_parent', @TreeNode_has_as_parent, 1);
  rb_define_method(cTreeNode, 'index_of', @TreeNode_index_of, 1);
  rb_define_method(cTreeNode, 'make_visible', @TreeNode_make_visible, 0);
  rb_define_method(cTreeNode, 'move_to', @TreeNode_move_to, 2);
  rb_define_method(cTreeNode, 'is_first_node', @TreeNode_is_first_node, 0);
  rb_define_alias(cTreeNode , 'first_node?', 'is_first_node');
  DefineAttrGet(cTreeNode, 'cut', TreeNode_get_cut);
  rb_define_alias(cTreeNode , 'cut?', 'cut');
  DefineAttrSet(cTreeNode, 'cut', TreeNode_set_cut);
  DefineAttrGet(cTreeNode, 'deleting', TreeNode_get_deleting);
  rb_define_alias(cTreeNode , 'deleting?', 'deleting');
  DefineAttrGet(cTreeNode, 'focused', TreeNode_get_focused);
  rb_define_alias(cTreeNode , 'focused?', 'focused');
  DefineAttrSet(cTreeNode, 'focused', TreeNode_set_focused);
  DefineAttrGet(cTreeNode, 'drop_target', TreeNode_get_drop_target);
  rb_define_alias(cTreeNode , 'drop_target?', 'drop_target');
  DefineAttrSet(cTreeNode, 'drop_target', TreeNode_set_drop_target);
  DefineAttrGet(cTreeNode, 'selected', TreeNode_get_selected);
  rb_define_alias(cTreeNode , 'selected?', 'selected');
  DefineAttrSet(cTreeNode, 'selected', TreeNode_set_selected);
  DefineAttrGet(cTreeNode, 'handle', TreeNode_get_handle);
  DefineAttrGet(cTreeNode, 'has_children', TreeNode_get_has_children);
  rb_define_alias(cTreeNode , 'has_children?', 'has_children');
  DefineAttrSet(cTreeNode, 'has_children', TreeNode_set_has_children);
  DefineAttrGet(cTreeNode, 'is_visible', TreeNode_get_is_visible);
  rb_define_alias(cTreeNode , 'visible?', 'is_visible');
  DefineAttrGet(cTreeNode, 'overlay_index', TreeNode_get_overlay_index);
  DefineAttrSet(cTreeNode, 'overlay_index', TreeNode_set_overlay_index);
  DefineAttrGet(cTreeNode, 'state_index', TreeNode_get_state_index);
  DefineAttrSet(cTreeNode, 'state_index', TreeNode_set_state_index);
  rb_define_method(cTreeNode, 'get_state', @TreeNode_get_state, 1);
  rb_define_method(cTreeNode, 'set_state', @TreeNode_set_state, 2);
  rb_define_alias(cTreeNode , 'expanded?', 'expanded');
  DefineAttrGet(cTreeNode, 'index', TreeNode_get_index);
  DefineAttrGet(cTreeNode, 'level', TreeNode_get_level);
  DefineAttrGet(cTreeNode, 'owner', TreeNode_get_owner);
  DefineAttrGet(cTreeNode, 'parent', TreeNode_get_parent);
(**** made by ap_src_maker ****)
(**** str_init made by ap_src_maker ****)
  rb_define_method(cTreeNodes, 'add_child_object_first', @TreeNodes_add_child_object_first, 3);
  rb_define_method(cTreeNodes, 'add_child_object', @TreeNodes_add_child_object, 3);
  rb_define_method(cTreeNodes, 'add_object_first', @TreeNodes_add_object_first, 3);
  rb_define_method(cTreeNodes, 'add_object', @TreeNodes_add_object, 3);
  rb_define_method(cTreeNodes, 'add_node', @TreeNodes_add_node, 5);
  rb_define_method(cTreeNodes, 'alpha_sort', @TreeNodes_alpha_sort, 1);
  rb_define_method(cTreeNodes, 'begin_update', @TreeNodes_begin_update, 0);
  rb_define_method(cTreeNodes, 'end_update', @TreeNodes_end_update, 0);
  rb_define_method(cTreeNodes, 'insert_object', @TreeNodes_insert_object, 3);
  rb_define_method(cTreeNodes, 'insert_node', @TreeNodes_insert_node, 4);
  DefineAttrGet(cTreeNodes, 'handle', TreeNodes_get_handle);
(**** made by ap_src_maker ****)
  DefineConstSetType(mPhi, TypeInfo(TNodeState));
  DefineConstSetType(mPhi, TypeInfo(TNodeAttachMode));

end;

end.
