#! ruby -Ks
# Languages.rb .. for SimpleGetText.rb ȒP GetText
# Languages.pi
#
# This table was made from
# (1) windows_pas ( "C:/Progra~1/Borland/Delphi6/Source/Rtl/Win/Windows.pas" )
# (2) and iso639  ( http://ftp.ics.uci.edu/pub/ietf/http/related/iso639.txt )
#
# ̃f[^͌ÂȂEEB
# http://xml.coverpages.org/languageIdentifiers.html 2002N̏񂠂B
# http://www.rtt.org/ISO/TC37/SC2/WG1/639/ISO-FDIS-639-1.pdf ꂪŐVŁH

module Languages  # Phi ł悢H
module_function

# Languages::LANGS .. [lang_id , lang_name , ms_code_main ,  ms_code_sub , id_is_the_same_as ]
#
# ["aa", :afar, nil],               iso639 has the id, but ms has not.
# [nil, :belarusian, 35],           ms_code exist, but iso639 has not.
# ["ar", :algeria, 1, 5, :arabic],  the ID "ar" is the same as :arabic
#
# [nil, :neutral, 0, 0, :neutral],     neutral is a special function of Windows.
# [nil, :default, 0, 1, :neutral],
# [nil, :sys_default, 0, 2, :neutral],

LANGS = [["ab", :abkhazian, nil],
         ["aa", :afar, nil],
         ["af", :afrikaans, 54],
         ["sq", :albanian, 28],
         ["ar", :algeria, 1, 5, :arabic],
         ["am", :amharic, nil],
         ["ar", :arabic, 1],
         ["es", :argentina, 10, 11, :spanish],
         ["hy", :armenian, nil],
         ["as", :assamese, nil],
         ["en", :aus, 9, 3, :english],
         ["de", :austrian, 7, 3, :german],
         ["ay", :aymara, nil],
         ["az", :azerbaijani, nil],
         ["ar", :bahrain, 1, 15, :arabic],
         ["ba", :bashkir, nil],
         ["eu", :basque, 45],
         ##["be", :belarusian, 35],  # ISO-FDIS-639-1.pdf => byelorussian
         ##[nil, :belarusian, 35],
         ["nl", :belgian, 12, 2, :dutch],
         ["en", :belize, 9, 10, :english],
         ["bn", :bengali, nil],
         ["dz", :bhutani, nil],
         ["bh", :bihari, nil],
         ["bi", :bislama, nil],
         ["no", :bokmal, 20, 1, :norwegian],
         ["es", :bolivia, 10, 16, :spanish],
         ["pt", :brazilian, 22, 1, :portuguese],
         ["br", :breton, nil],
         ["bg", :bulgarian, 2],
         ["my", :burmese, nil],
         ["be", :byelorussian, nil],
         ["km", :cambodian, nil],
         ["en", :can, 9, 4, :english],
         ["fr", :canadian, 12, 3, :french],
         ["en", :caribbean, 9, 9, :english],
         ["ca", :catalan, 3],
         ["es", :chile, 10, 13, :spanish],
         ["zh", :chinese, 4],
         ["es", :colombia, 10, 9, :spanish],
         ["co", :corsican, nil],
         ["es", :costa_rica, 10, 5, :spanish],
         ["hr", :croatian, 26],
         ["sr", :cyrillic, 26, 3, :serbian],
         ["cs", :czech, 5],
         ["da", :danish, 6],
         [nil, :default, 0, 1, :neutral],
         ["es", :dominican_republic, 10, 7, :spanish],
         ["nl", :dutch, 19, 1],
         ["es", :ecuador, 10, 12, :spanish],
         ["ar", :egypt, 1, 3, :arabic],
         ["en", :eire, 9, 6, :english],
         ["es", :el_salvador, 10, 17, :spanish],
         ["en", :english, 9],
         ["eo", :esperanto, nil],
         ["et", :estonian, 37],
         ["fo", :faroese, 56],
         ##["fa", :farsi, 41],  # ISO-FDIS-639-1.pdf => persian
         ##[nil, :farsi, 41],
         ["fj", :fiji, nil],
         ["sv", :finland, 29, 2, :swedish],
         ["fi", :finnish, 11],
         ["fr", :french, 12, 1],
         ["fy", :frisian, nil],
         ["gl", :galician, nil],
         ["ka", :georgian, nil],
         ["de", :german, 7, 1],
         ["el", :greek, 8],
         ["kl", :greenlandic, nil],
         ["gn", :guarani, nil],
         ["es", :guatemala, 10, 4, :spanish],
         ["gu", :gujarati, nil],
         ["ha", :hausa, nil],
         ["he", :hebrew, 13],
         ["hi", :hindi, nil],
         ["es", :honduras, 10, 18, :spanish],
         ["zh", :hongkong, 4, 3, :chinese],
         ["hu", :hungarian, 14],
         ["is", :icelandic, 15],
         ["id", :indonesian, 33],
         ["ia", :interlingua, nil],
         ["ie", :interlingue, nil],
         ["iu", :inuktitut, nil],
         ["ik", :inupiak, nil],
         ["ar", :iraq, 1, 2, :arabic],
         ["ga", :irish, nil],
         ["it", :italian, 16, 1],
         ["en", :jamaica, 9, 8, :english],
         ["ja", :japanese, 17],
         ["jw", :javanese, nil],
         ["ko", :johab, 18, 2, :korean],
         ["ar", :jordan, 1, 11, :arabic],
         ["kn", :kannada, nil],
         ["ks", :kashmiri, nil],
         ["kk", :kazakh, nil],
         ["rw", :kinyarwanda, nil],
         ["ky", :kirghiz, nil],
         ["rn", :kirundi, nil],
         ["ko", :korean, 18, 1],
         ["ku", :kurdish, nil],
         ["ar", :kuwait, 1, 13, :arabic],
         ["lo", :laothian, nil],
         ["la", :latin, 26, 2],
         ["lv", :latvian, 38],
         ["ar", :lebanon, 1, 12, :arabic],
         ["ar", :libya, 1, 4, :arabic],
         ["de", :liechtenstein, 7, 5, :german],
         ["ln", :lingala, nil],
         ["lt", :lithuanian, 39],
         ["fr", :luxembourg, 7, 4, :french],
         ["mk", :macedonian, nil],
         ["mg", :malagasy, nil],
         ["ms", :malay, nil],
         ["ml", :malayalam, nil],
         ["mt", :maltese, nil],
         ["mi", :maori, nil],
         ["mr", :marathi, nil],
         ["es", :mexican, 10, 2, :spanish],
         ["es", :modern, 10, 3, :spanish],
         ["mo", :moldavian, nil],
         ["mn", :mongolian, nil],
         ["ar", :morocco, 1, 6, :arabic],
         ["na", :nauru, nil],
         ["ne", :nepali, nil],
         [nil, :neutral, 0, 0, :neutral],
         ["es", :nicaragua, 10, 19, :spanish],
         ["no", :norwegian, 20],
         ["no", :nynorsk, 20, 2, :norwegian],
         ["en", :nz, 9, 5, :english],
         ["oc", :occitan, nil],
         ["ar", :oman, 1, 8, :arabic],
         ["or", :oriya, nil],
         ["es", :panama, 10, 6, :spanish],
         ["es", :paraguay, 10, 15, :spanish],
         ["ps", :pashto, nil],
         ["fa", :persian, nil],
         ["es", :peru, 10, 10, :spanish],
         ["pl", :polish, 21],
         ["pt", :portuguese, 22, 2],
         ["es", :puerto_rico, 10, 20, :spanish],
         ["pa", :punjabi, nil],
         ["ar", :qatar, 1, 16, :arabic],
         ["qu", :quechua, nil],
         ["rm", :rhaeto, nil],
         ["ro", :romanian, 24],
         ["ru", :russian, 25],
         ["sm", :samoan, nil],
         ["sg", :sangho, nil],
         ["sa", :sanskrit, nil],
         ["ar", :saudi_arabia, 1, 1, :arabic],
         ["gd", :scots, nil],
         ["sr", :serbian, 26],
         ["sh", :serbo, nil],
         ["st", :sesotho, nil],
         ["tn", :setswana, nil],
         ["sn", :shona, nil],
         ["zh", :simplified, 4, 2, :chinese],
         ["sd", :sindhi, nil],
         ["zh", :singapore, 4, 4, :chinese],
         ["si", :sinhalese, nil],
         ["ss", :siswati, nil],
         ["sk", :slovak, 27],
         ["sl", :slovenian, 36],
         ["so", :somali, nil],
         ["en", :south_africa, 9, 7, :english],
         ["es", :spanish, 10, 1],
         ["su", :sundanese, nil],
         ["sw", :swahili, nil],
         ["sv", :swedish, 29, 1],
         ["fr", :swiss, 16, 2, :french],
         ["ar", :syria, 1, 10, :arabic],
         [nil, :sys_default, 0, 2, :neutral],
         ["tl", :tagalog, nil],
         ["tg", :tajik, nil],
         ["ta", :tamil, nil],
         ["tt", :tatar, nil],
         ["te", :telugu, nil],
         ["th", :thai, 30],
         ["bo", :tibetan, nil],
         ["ti", :tigrinya, nil],
         ["to", :tonga, nil],
         ["zh", :traditional, 4, 1, :chinese],
         ["en", :trinidad, 9, 11, :english],
         ["ts", :tsonga, nil],
         ["ar", :tunisia, 1, 7, :arabic],
         ["tr", :turkish, 31],
         ["tk", :turkmen, nil],
         ["tw", :twi, nil],
         ["ar", :uae, 1, 14, :arabic],
         ["ug", :uighur, nil],
         ["en", :uk, 9, 2, :english],
         ["uk", :ukrainian, 34],
         ["ur", :urdu, nil],
         ["es", :uruguay, 10, 14, :spanish],
         ["en", :us, 9, 1, :english],
         ["uz", :uzbek, nil],
         ["es", :venezuela, 10, 8, :spanish],
         ["vi", :vietnamese, 42],
         ["vo", :volapuk, nil],
         ["cy", :welsh, nil],
         ["wo", :wolof, nil],
         ["xh", :xhosa, nil],
         ["ar", :yemen, 1, 9, :arabic],
         ["yi", :yiddish, nil],
         ["yo", :yoruba, nil],
         ["za", :zhuang, nil],
         ["zu", :zulu, nil]]

        ##
        ##	̌ꖼiAAXjƎ擾łȂB
        ##
  def ms_code_to_data(main=0,sub=nil)
    if main == 0
      require "Win32API"
      main = Win32API.new('kernel32', "GetSystemDefaultLangID", "" , "L").call % 256
    end
    sel = LANGS.select{|d| d[2]==main && d[3]==sub}
    return sel[0] if sel.size == 1
    sel = LANGS.select{|d| d[2]==main}
    return sel[0] if sel.size == 1
    sel = sel.select{|d| d[4]==nil}
    return sel[0] if sel.size == 1
    return nil
  end
  
  def id_to_data(id)
      sel = LANGS.select{|d| d[0]==id}
      return sel[0] if sel.size == 1
      sel = sel.select{|d| d[4]==nil}
      return sel[0] if sel.size == 1
      return nil
  end

  def name_to_data(name)
    name = name.downcase.intern if name.is_a? String
    sel = LANGS.select{|d| d[1]==name}
    return sel[0] if sel.size == 1
    return nil
  end

end

if __FILE__ == $0

# usage..

p Languages.ms_code_to_data(0)            #=> ["ja", :japanese, 17] ( neutral => Win::LANG )

p Languages.ms_code_to_data(1)            #=> ["ar", :arabic, 1]
p Languages.ms_code_to_data(1,0)          #=> ["ar", :arabic, 1]
p Languages.ms_code_to_data(1,1)          #=> ["ar", :saudi_arabia, 1, 1, :arabic]
p Languages.ms_code_to_data(1,9)          #=> ["ar", :yemen, 1, 9, :arabic]

p Languages.ms_code_to_data(22)           #=> ["pt", :portuguese, 22, 2]
p Languages.ms_code_to_data(22,0)         #=> ["pt", :portuguese, 22, 2]
p Languages.ms_code_to_data(22,1)         #=> ["pt", :brazilian, 22, 1, :portuguese]
p Languages.ms_code_to_data(22,2)         #=> ["pt", :portuguese, 22, 2]
p Languages.ms_code_to_data(99)           #=> nil
                                          
p Languages.id_to_data("ja")              #=> ["ja", :japanese, 17]
p Languages.id_to_data("en")              #=> ["en", :english, 9]
p Languages.id_to_data("fr")              #=> ["fr", :french, 12, 1]
p Languages.id_to_data("ar")              #=> ["ar", :arabic, 1]
p Languages.id_to_data("al")              #=> nil

p Languages.name_to_data("Japanese")      #=> ["ja", :japanese, 17]
p Languages.name_to_data("portuguese")    #=> ["pt", :portuguese, 22, 2]
p Languages.name_to_data("spanish")       #=> ["es", :spanish, 10, 1]

p Languages.id_to_data("be")              #=> nil

##raise

p "making Languages::LANGS .. "

windows_pas = "C:/Progra~1/Borland/Delphi6/Source/Rtl/Win/Windows.pas"

#  from .. http://ftp.ics.uci.edu/pub/ietf/http/related/iso639.txt

iso639 = <<MMMM
aa Afar
ab Abkhazian
af Afrikaans
am Amharic
ar Arabic
as Assamese
ay Aymara
az Azerbaijani

ba Bashkir
be Byelorussian
bg Bulgarian
bh Bihari
bi Bislama
bn Bengali; Bangla
bo Tibetan
br Breton

ca Catalan
co Corsican
cs Czech
cy Welsh

da Danish
de German
dz Bhutani

el Greek
en English
eo Esperanto
es Spanish
et Estonian
eu Basque

fa Persian
fi Finnish
fj Fiji
fo Faroese
fr French
fy Frisian

ga Irish
gd Scots Gaelic
gl Galician
gn Guarani
gu Gujarati

ha Hausa
he Hebrew (formerly iw)
hi Hindi
hr Croatian
hu Hungarian
hy Armenian

ia Interlingua
id Indonesian (formerly in)
ie Interlingue
ik Inupiak
is Icelandic
it Italian
iu Inuktitut

ja Japanese
jw Javanese

ka Georgian
kk Kazakh
kl Greenlandic
km Cambodian
kn Kannada
ko Korean
ks Kashmiri
ku Kurdish
ky Kirghiz

la Latin
ln Lingala
lo Laothian
lt Lithuanian
lv Latvian, Lettish

mg Malagasy
mi Maori
mk Macedonian
ml Malayalam
mn Mongolian
mo Moldavian
mr Marathi
ms Malay
mt Maltese
my Burmese

na Nauru
ne Nepali
nl Dutch
no Norwegian

oc Occitan
om (Afan) Oromo
or Oriya

pa Punjabi
pl Polish
ps Pashto, Pushto
pt Portuguese

qu Quechua

rm Rhaeto-Romance
rn Kirundi
ro Romanian
ru Russian
rw Kinyarwanda

sa Sanskrit
sd Sindhi
sg Sangho
sh Serbo-Croatian
si Sinhalese
sk Slovak
sl Slovenian
sm Samoan
sn Shona
so Somali
sq Albanian
sr Serbian
ss Siswati
st Sesotho
su Sundanese
sv Swedish
sw Swahili

ta Tamil
te Telugu
tg Tajik
th Thai
ti Tigrinya
tk Turkmen
tl Tagalog
tn Setswana
to Tonga
tr Turkish
ts Tsonga
tt Tatar
tw Twi

ug Uighur
uk Ukrainian
ur Urdu
uz Uzbek

vi Vietnamese
vo Volapuk

wo Wolof

xh Xhosa

yi Yiddish (formerly ji)
yo Yoruba

za Zhuang
zh Chinese
zu Zulu
MMMM

sublangs = []
langs = {}

File.open( windows_pas ).each{|line|
  case line
  when /^\s*SUBLANG\_(\w+)\s*\=\s*\$([0-9a-f]+)/i
    sublangs.push [$1.downcase , $2.hex]
  when /^\s*LANG_(\w+)\s*=\s*\$([0-9a-f]+)/i
   name = $1.downcase.intern
      #   [nil, :faeroese, 56],
      #   ["fo", :faroese, nil],,
   name = :faroese if name == :faeroese
   langs[name] = [nil,$2.hex]
  end
}

iso639.each{|line|
  if /^(..)\s+(\w+)/ =~ line
    name = $2.downcase.intern
    id   = $1
    if langs.has_key? name
      langs[name][0] = id
    else
      langs[name] = [id,nil]
    end
  end
}

sublangs.each{|name,no|
  case name
  when "sys_default","default"
    main_name = :neutral
    sub_name = name.intern
  when /^(\w+?)_(\w+)/
    main_name = $1.intern
    sub_name = $2.intern
  else
    main_name = sub_name = name.intern
  end
  main_data = langs[main_name] || []
  sub_data  = langs[sub_name]  || []
  
  unless sub_data[0]
   sub_data[0] = main_data[0] 
   sub_data[3] = main_name
  end
  sub_data[1] = main_data[1]
  sub_data[2] = no
  langs[sub_name] = sub_data
}

langs = langs.collect{|k,v| [v[0],k,*v[1..-1]]}.sort{|l,r| l[1].to_s <=> r[1].to_s}
puts    "LANGS = " + langs.inspect.gsub('\],',"],\n        ")

p " ..  done."

raise

end
