#! ruby -Ks
# by KUMAGAI Hidetake (ggb03124@nifty.ne.jp)
# modified by YOSHIDA Kazuhiro (moriq@moriq.com)
#
#-- $(apollo)/lib/rdb/bde.rb
#-- bde.pi
#

require 'phi'
require 'rdb/rdb'
require 'rdb/bde.so'

unless $NO_PHI_EXTENSION
module Phi

class SessionList   ; include Phi::Enumerable ; end

######## class Database ########

#
# Database Extension for ruby
# Use Standard SQL (only), not for specific system.
# This class has contant query and table.
#
class Database
  STD_TABLE_CLASS = Table
  STD_QUERY_CLASS = Query
  include Connection_ex

  def new_query(sql=nil, params=nil)
    ret = STD_QUERY_CLASS.new
    ret.session_name = self.session_name
    ret.database_name = self.database_name
    if sql
      ret.open(sql,params)
    end
    ret
  rescue
    Phi.add_sql_to_error_message( sql , params ) ##++
    raise
  ensure
    GC.start unless $NO_GC_FOR_INTERBASE
  end
  alias query new_query    #  2003-07-02()

  def new_table(name=nil)
    ##ret = Table.new
    ret = STD_TABLE_CLASS.new
    ret.session_name = self.session_name
    ret.database_name = self.database_name
    if name
      ret.table_name = name
      ret.open
    end
    ret
  ensure
    GC.start unless $NO_GC_FOR_INTERBASE
  end
  alias table new_table    #  2003-07-02()

end # of class Database

class Database_ib < Database
  include InterBase
end
class Database_ora < Database
  include Oracle
end

class DBDataSet
  alias connection database

  alias _apply_updates apply_updates
  def apply_updates(ignore=nil) #++ 2002-11-07()
    _apply_updates
  end
  def apply_updates_ex(ignore=nil) #++ 2002-11-07()
    _apply_updates
  end
end

class Table # < DataSet
  include DataSet_ex
end

class Query # < DataSet
  include DataSet_ex
  include DotSqlDataSet

  def execute_ex(*args)
     execute(*args)
  rescue
    Phi.add_sql_to_error_message( *args )
    raise
  end
end

######## Session Level ########

class SessionList
  alias _open_session open_session
  def open_session(*args)
    session = _open_session(*args)
    yield session
  ensure
    session.active = false
  end
end

########

end # of module Phi
end # of if $NO_PHI_EXTENSION

if __FILE__ == $0
  #
  #  patch for Japanese data
  #
  class String
    def inspect
      '"'+to_s+'"'
    end
  end

##  db = Phi::Database.new('IBLocal','SYSDBA','masterkey')
##  query = db.new_query('select * from employee')
##  table = db.new_table('employee')
  db = Phi::Database.new('Apollo','apollo','apollo')
  p db.table_names
  query = db.new_query('select * from ap01den')
  table = db.new_table('ap01den')

  puts " -- puts query.struct --"
  puts query.struct         #=> field_name,field_type & field_size

  puts " -- puts query.fields --"
  puts query.fields         #=> string of field names with \t
  puts " -- puts query --"
  puts query                #=> big string of value with \t & \n
  puts " -- puts table --"
  puts table                #=> big string of value with \t & \n

  puts " -- p query --"
  p query                   #=>     #<Query:0xcb0c74>
  puts " -- p query.fields --"
  p query.fields            #=>     #<Fields:0x25785b8>
  puts " -- p query.fields.to_a --"
  p query.fields.to_a       #=> array of field

  puts " -- p table --"
  p table                   #=>     #<Table:0x25a3514>
  puts " -- p table.to_a --"
  p table.to_a              #=> array of array of value
end

#
# one liner sample
#
# ruby -r phi -r rdb -e "puts Phi::Database.new('IBLocal','SYSDBA','masterkey').table('employee').fields"
# ruby -r phi -r rdb -e "puts Phi::Database.new('IBLocal','SYSDBA','masterkey').table('employee')"
# ruby -r phi -r rdb -e "puts Phi::Database.new('IBLocal','SYSDBA','masterkey').query('select * from employee')"
# ruby -r rdb -e "puts Phi::Database.new('IBLocal').table('employee').struct"

#--------

