#!/usr/local/bin/ruby
# by YOSHIDA Kazuhiro (moriq@moriq.com)
# modified by KUMAGAI Hidetake (ggb03124@nifty.ne.jp)

module RGUI
  def initialize(*args)
    super(*args)
    @children = []
  end

  def add(*args)
    contents = args.flatten
    contents.each do |c|
      class << c
        attr :base_width  , true
        attr :base_height , true
      end
      c.base_width  = c.width
      c.base_height = c.height
    end
    @children = [] unless @children
    @children+= contents
    self
  end

  def homonize
    max_w = 1
    max_h = 1
    @children.each do |c|
      max_w = max max_w, c.base_width
      max_h = max max_h, c.base_height
    end
    @children.each do |c|
      c.base_width  = max_w
      c.base_height = max_h
    end
  end

  def repack
    @children.each do |c|
      c.base_width  = c.width
      c.base_height = c.height
    end
  end

  module_function

  def max(a,b) if a>b then a else b end end
  def min(a,b) if a<b then a else b end end

end  # of module RGUI

require 'rgui/widget.rb'
require 'rgui/form.rb'
require 'rgui/hbox.rb'
require 'rgui/vbox.rb'
require 'rgui/panel.rb'

