#! ruby -Ks
#-- $(lib)/win32/api/DeviceCaps.rb
#-- DeviceCaps.pi

## http://leed.issp.u-tokyo.ac.jp/~takeuchi/delphi/browse.cgi?index=016589

require "Win32API"

module Win32

  ##C:/PROGRA~1/Borland/Delphi6/Source/Rtl/Win/Windows.pas[HORZSIZE]
  ##{ Device Parameters for GetDeviceCaps() }
  DRIVERVERSION = 0;    ## { Device driver version                     }
  TECHNOLOGY    = 2;    ## { Device classification                     }
  HORZSIZE      = 4;    ## { Horizontal size in millimeters            }
  VERTSIZE      = 6;    ## { Vertical size in millimeters              }
  HORZRES       = 8;    ## { Horizontal width in pixels                }
  VERTRES       = 10;   ## { Vertical height in pixels                 }
  BITSPIXEL     = 12;   ## { Number of bits per pixel                  }
  PLANES        = 14;   ## { Number of planes                          }
  NUMBRUSHES    = $10;  ## { Number of brushes the device has          }
  NUMPENS       = 18;   ## { Number of pens the device has             }
  NUMMARKERS    = 20;   ## { Number of markers the device has          }
  NUMFONTS      = 22;   ## { Number of fonts the device has            }
  NUMCOLORS     = 24;   ## { Number of colors the device supports      }
  PDEVICESIZE   = 26;   ## { Size required for device descriptor       }
  CURVECAPS     = 28;   ## { Curve capabilities                        }
  LINECAPS      = 30;   ## { Line capabilities                         }
  POLYGONALCAPS = $20;  ## { Polygonal capabilities                    }
  TEXTCAPS      = 34;   ## { Text capabilities                         }
  CLIPCAPS      = 36;   ## { Clipping capabilities                     }
  RASTERCAPS    = 38;   ## { Bitblt capabilities                       }
  ASPECTX       = 40;   ## { Length of the X leg                       }
  ASPECTY       = 42;   ## { Length of the Y leg                       }
  ASPECTXY      = 44;   ## { Length of the hypotenuse                  }
  SHADEBLENDCAPS = 45;  ## { Shading and Blending caps                 }

  GetDeviceCaps = Win32API.new('gdi32','GetDeviceCaps','LL','L')
  def self.get_device_caps(handle,nindex)
    GetDeviceCaps.call(handle,nindex)
  end

end # of module Win32

if __FILE__ == $0
  require "phi"
  form = Phi::Form.new
  p form.pixels_per_inch
#p Phi::SCREEN.pixels_per_inch
  p Win32.get_device_caps form.canvas.handle, Win32::HORZSIZE
end

