require 'phi'
require 'rbeditor'
require 'string_class'
require 'completion'

autoload(:LS, 'ls-lib')

def p2(*args)
  STDOUT.p(*args) 
end

module Phi

  # IRB̓͂"\n"܂ޏꍇ΁A
  # ܂܂ȂꍇAA
  # Phi::Strings#addƂ͑łB
  # ̂Gtk::Text#insert̂悤ȓ
  # Phi::Strings#add_text܂B
  # A̎IRBpȂ̂ŁA
  # ad-hocȊ͔ۂ߂܂B

  # ܂IRBł͏o͂Ōɕt邾ł悢̂ŁA
  # Phi::Strings#add_textł͍Ō̍sւ̕tlĂ܂B
  
  # Phi::Strings#add_textł"\n"ɑ΂铮O
  # 邽߂IRB̓͂"\n"邩ׂ܂B
  # "\n"Ƃ͍Ō̍sɕǉāA
  # Phi::Strings#add''(̕)nĉs܂B
  # (񂪉Ƃ͈Ⴂ܂)
  # "\n"Ƃ͍Ō̍sɕǉ܂B

  # [U[̓͂IRBEditor̕ŏ܂B
  class Strings 

    def last_line
      if self.count == 0
	''
      else
	self[ self.count - 1 ]
      end
    end

    
    # Ō̕słȂ
    # fĕ̒ǉ@ς
    def add_text(string)
      # zɕȂ
      if self.count == 0
	if string.last_char_is_linefeed?
	  self.add(string.chomp)
	else
	  self.add(string)
	end
	return true
      end

      # zɕƂ
      if string.last_char_is_linefeed?
	self[self.count - 1] = 	last_line.concat(string.chomp)
	self.add('')
      else
	self[self.count - 1] = 	last_line.concat(string)
      end
    end


  end
end


module ApIRB

  # ŐV̗@history_arr̐擪ɂ
  class IRBHistory
    
    def initialize(strings)
      @history_arr = []
      @current_num = 0
      @max = 100
      @strings = strings
    end
    
    attr_reader :current_num

    def init_current
      @current_num = 0
    end

    def add_history(str)
      # Ō
      if @history_arr.size > @max
	@history_arr.pop
      end
      
      case str
      when  /^\s*$/
	# 󔒂s͖
      else
	# 擪ɒǉ
	@history_arr.unshift(str)
      end
    end
    
    def insert_history_str(string, last_point)
      @strings[@strings.count - 1] = @strings.last_line[0..(last_point - 1)].concat(string)
    end
    
    # Ōɑ}邱ƂOɂĂ
    def insert_previous_history(point)
      # O̗͂Ȃ
      if (@history_arr.size - 1 < @current_num) 
	#beep 
	return false
      end
      
      @current_num
      str = @history_arr[@current_num]
      @current_num += 1
      insert_history_str(str, point) 
    end
    
    # ꓖI(
    def insert_next_history(point)
      @current_num -= 1
      if @current_num < 0
	@current_num = 0
	return false
      elsif @current_num == 0 
	# x insert_previous_history sĂȂԂ 
	# insert_next_historyƁA󔒂ɂȂB
	insert_history_str('', point)
	return false
      end

      # ݂̗ԍ炵āA𓾂
      str = @history_arr[@current_num - 1]
      insert_history_str(str, point)
    end

    def get_history
      @history_arr
    end
    
    alias previous insert_previous_history
    alias next insert_next_history
  end


  # IRBEditor#buffer_getsŏIIIRBւ̏o͂
  # ߂܂BIRBEditor#buffer_gets̎GTKƓ
  # [U[Return̓͂܂
  # [vɓÅԍĕ`̖߂s܂B
  # [U[Return͂
  # ŌIRBEditor#buffer_writeœ͂ꂽ
  # Ōォ炻̍s܂ł[U[̓͂Ƃ݂Ȃ
  # IRBEditor#buffer_gets̏o͂Ƃ܂B
  class IRBEditor < RBEditor
    
    def initialize(form, com_name)
      super(form, com_name)
      @can_gets = false
      @phi_lines = self.lines
      @phi_lines.clear
      @last_char_point_of_buffer_write = 0
      @history = ApIRB::IRBHistory.new(@phi_lines)
      @completion = ApIRB::IRBCompletion.new(self)

      #
      # Cxgnh
      #
      
      # Return̉s̏?
      # ė~񂾂
      self.on_key_press = proc do |editor, key_code|
	if key_code == Phi::VK_RETURN
	  @phi_lines.add("")
	  @history.add_history(get_input_string_after_linefeed_is_inputed)
	  @history.init_current
	  @can_gets = true
	end
      end
      
      # EOFɈړ狭IɌɖ߂
      # buffer_writěEOFɓ̂ŁA̎sɓ
      self.on_caret_moved = proc do
	#p2 self.col, self.row
	#p2 k = self.list_count

	if (self.col == 0) and (self.row == self.list_count)
	  # Ō̍s̖̈ʒu擾
	  if @phi_lines.last_line.get_str_byte == 0
	    col_move_point = 0
	  else
	    col_move_point = @phi_lines.last_line.get_str_byte - 1
	  end

	  # Ōs̍s
	  row_move_point = self.row - 1
	  
	  if row_move_point >= 0 
	    self.set_row_col(row_move_point, col_move_point)
	  end
	end
      end

      self.on_resize = proc do 
	#col_countgׂ
	self.wrap_option.wrap_byte = (self.width / 9).to_i
      end

    end
    
    attr_reader :history, :last_char_point_of_buffer_write, :completion
    
    def buffer_write(str)
      begin
	@phi_lines.add_text(str)
	@last_char_point_of_buffer_write = @phi_lines.last_line.get_str_byte
	true
      rescue
	false
      end
    end
    
    alias buffer_putc buffer_write
    
    def buffer_gets(rs = $/)
      while true
	# Retun ͂܂Ń[v
	if @can_gets
	  break
	end
	
	# ĕ`
	Phi::APPLICATION.process_messages
	sleep 0.01
      end

      str = get_input_string_after_linefeed_is_inputed
      @can_gets = false
      "#{str}\n"
    end

    def get_prompt_str
      last_line = @phi_lines.last_line
      if last_line.size > 0 
	last_line[0..(@last_char_point_of_buffer_write - 1)]
      else
	''
      end
    end

    # [U[ɂē͂ꂽŏ̕
    # buffer_writeŏoꂽŌ̂̕ɂ̂ƂB
    def get_input_string(input_line_num)
      if input_line_num < 0
	input_line = ''
      else
	input_line = @phi_lines[input_line_num]
      end
      input_line[@last_char_point_of_buffer_write..-1]
    end

    # [U[^[O̒iKł̃[U[̓͂𓾂
    def get_input_string_before_linefeed_is_inputed
      get_input_string(@phi_lines.count - 1)
    end

    # ^[As͂̂ŁA
    # ͍s͍Ōォ2sڂɂȂB

    # łɓ͂Ă镶ҏW
    # buffer_get̏o͂͂Ȃ邪A
    # ܂Ŗʓ|Ȃ(
    # ݋֎~ or }𒀈폜 ?
    def get_input_string_after_linefeed_is_inputed
      get_input_string(@phi_lines.count - 2)
    end

    def complete
      org_col = self.col
      input = get_input_string_before_linefeed_is_inputed
      last_line = @phi_lines.last_line
      col_point = org_col - last_char_point_of_buffer_write
      input_word = @completion.get_input_word(input, col_point)
      list = @completion.get_completion_candidates(input_word)

      case list.size 
      when 0
      when 1
	# ̂܂܂?ƂłȂ
	completion_str = list[0].sub(/^#{Regexp.quote(input_word)}/, '')

	@phi_lines[@phi_lines.count - 1] = last_line[0..(org_col-1)].concat(completion_str)
	if org_col < last_line.get_str_byte - 1
	  @phi_lines[@phi_lines.count - 1] = @phi_lines[@phi_lines.count - 1].concat(last_line[(org_col)..-1])
	end
	self.set_row_col(@phi_lines.count - 1, org_col + completion_str.get_str_byte)
      else
	ls = LS.new(list.sort!, self.wrap_option.wrap_byte)
	@phi_lines.add(ls.get_result_string)
	@phi_lines.add_text(last_line)
	self.set_row_col(@phi_lines.count - 1, org_col)
      end
    end

  end
   
end






if $0 == __FILE__
  require 'rgui/ui'
# require 'inspect-my'
  
  w = RGUI::Form.new(:form1)
  w.height = 350
  w.width = 400
  
  btns = [
    btn1 = Phi::Button.new(w, :btn1_1),
    btn2 = Phi::Button.new(w, :btn2_1),
    btn3 = Phi::Button.new(w, :btn3_1),
  ]
  hbox = UI::Hbox.new([btns], 5)
  hbox.height = 35
  
  editor = ApIRB::IRBEditor.new(w, :editor1)
  vbox = UI::Vbox.new(editor, 5)
  vbox.height = w.width - hbox.height
  
  top_vbox = UI::Vbox.new([vbox, hbox])
  w.add(top_vbox)
  w.layout
  w.show
  
  btn1.on_click = proc do 
    buf = editor.lines
    p editor.buffer_gets
    #p buf.last_line
    #buf.methods.sort.each do |l|
    #  buf.add(l)
    #end
  end
  
  btn2.on_click = proc do 
    buf = editor.lines
    p buf.count
    if buf.count > 0
      print "last line: "
      p buf.last_line
      print "last char: "
      p buf.last_line.last_char
    end
  end
  
  btn3.on_click = proc do 
    buf = editor.lines
    case rand(3)
    when 0
      p 0
      editor.buffer_write("hogehoge\n")
      editor.buffer_write("mmmmm")
      editor.buffer_write("aaaaa\n")
    when 1
      p 1
      editor.buffer_write("イ")
      editor.buffer_write("悤")
      editor.buffer_write("")
    else
      p 2
      editor.buffer_write("1234\n")
      editor.buffer_write("2345\n")
      editor.buffer_write("3059\n")
    end
  end
  
  w.on_resize = proc { w.layout }
  Phi.mainloop
end
