require 'phi'
include Phi
require 'internet'

#form = Form.new
form = Component._load open('s.afm', 'rb').read

server = ServerSocket.new
server.port = 50
#server.server_type = ServerSocket::ST_NON_BLOCKING
server.active = true

refresh_clients = proc do
  form.lb_clients.clear
  server.socket.connections.each do |i|
    form.lb_clients.items.add "#{i.remote_addr} (#{i.remote_host})"
  end
end

ServerSocket.on_client_connect = proc do |sender, socket|
  form.lb_log.items.add "ڑ: #{socket.remote_host} (#{socket.remote_addr})"
  refresh_clients.call
end

ServerSocket.on_client_disconnect = proc do |sender, socket|
  form.lb_log.items.add "ؒf: #{socket.remote_host} (#{socket.remote_addr})"
  refresh_clients.call
end

ServerSocket.on_client_read = proc do |sender, socket|
  s = socket.recv 256
  form.lb_msg.items.add "#{socket.remote_host}:#{s.length}:#{s.inspect}"
end

form.show
Phi.mainloop
