#! ruby

# cf:
# Delphi4 vO~OoCu p.243
# 5.5. F ListBox

require 'phi'
include Phi
require 'dialogs'

form = Form.new
form.caption = $0
form.font.height=-32

ListBox.new(form, :list)
i = form.list
i.align = Phi::AL_CLIENT
i.style = Phi::LB_OWNER_DRAW_FIXED
i.item_height = -form.font.height+3

def i.add_colors(colors)
  colors.each do |c|
    items.add Phi.color_to_string(c), c
  end
  p items
end

colors = [Phi::CL_RED, Phi::CL_BLUE, 0x808040, 0x000000]
i.add_colors colors

def i.on_draw_item(index, rect, state)
  canvas.fill_rect(rect)
  canvas.font.color = items.object_at(index)
  canvas.text_out(rect.left, rect.top, items[index])
end

def i.on_dbl_click
  dlg = ColorDialog.new
  if dlg.execute
    add_colors [dlg.color]
  end
end

form.show

Phi.mainloop