require 'phi'
include Phi

form = Form.new
form.caption = $0
form.auto_scroll = false

i = Edit.new form, :edit
i.align = Phi::AL_CLIENT

i = UpDown.new form, :up_down
i.associate = form.edit
i.min = 30
i.max = 300
i.increment = 10
i.position = 100
i.wrap = false

class << form
  attr :scaled, true
end

i = Button.new form, :btn_scale
i.left = form.edit.left + form.edit.width + form.up_down.width
i.caption = '&do'
i.align = Phi::AL_BOTTOM

def i.on_click
  p = parent
  p.scaled = p.up_down.position
  p.scale_by p.scaled, 100
  p.up_down.height = p.edit.height
  self.enabled = false
  p.btn_restore.enabled = true
end

i = Button.new form, :btn_restore
i.left = form.edit.left + form.edit.width + form.up_down.width
i.top = form.btn_scale.top + form.btn_scale.height
i.caption = '&restore'
i.enabled = false
i.align = Phi::AL_RIGHT

def i.on_click
  p = parent
  p.scale_by 100, p.scaled
  p.up_down.height = p.edit.height
  self.enabled = false
  p.btn_scale.enabled = true
end

form.show

Phi.mainloop
