require 'phi'
include  Phi
require 'dialogs'

if !defined? DATA
  print <<EOT
Apollo.exe hasn't supported constant DATA.
Please use ruby_ap.exe instead of Apollo.exe.
EOT
  exit
end
form = Component._load DATA.read
form.panel1.speed_button_note.on_click = proc {
  Phi.beep
}
form.panel1.speed_button_left.on_click = proc {
  form.label1.alignment = TA_LEFT_JUSTIFY
}
form.panel1.speed_button_center.on_click = proc {
  form.label1.alignment = TA_CENTER
}
form.panel1.speed_button_right.on_click = proc {
  form.label1.alignment = TA_RIGHT_JUSTIFY
}
form.panel1.speed_button_bold.on_click = proc {|sender|
  form.label1.font.style = sender.down ? [FS_BOLD] : []
}
form.panel1.speed_button_italic.on_click = proc {|sender|
  form.label1.font.style = sender.down ? [FS_ITALIC] : []
}
form.panel1.speed_button_underline.on_click = proc {|sender|
  form.label1.font.style = sender.down ? [FS_UNDERLINE] : []
}
form.panel1.speed_button_big.on_click = proc {|sender|
  if sender.down
    form.label1.font.size = 24
    sender.hint = 'Shrink'
  else
    form.label1.font.size = 12
    sender.hint = 'Expand'
  end
}
form.menu.items.file1.exit1.on_click = proc {
  form.close
}
form.menu.items.toolbar1.visible1.on_click = proc {|sender|
  # hide or display the toolbar, setting the maneitem checkmark
    form.panel1.visible =
  ! form.panel1.visible
  sender.checked = ! sender.checked
}
form.menu.items.toolbar1.disable_sound1.on_click = proc {|sender|
  # disable or enable button and set menu check mark
    form.panel1.speed_button_note.enabled =
  ! form.panel1.speed_button_note.enabled
  sender.checked = ! sender.checked
}
form.menu.items.toolbar1.disable_size1.on_click = proc {|sender|
    form.panel1.speed_button_big.enabled =
  ! form.panel1.speed_button_big.enabled
  sender.checked = ! sender.checked
}
form.menu.items.toolbar1.hint_color1.on_click = proc {|sender|
  color_dialog1 = ColorDialog.new
  color_dialog1.color = APPLICATION.hint_color
  APPLICATION.hint_color = color_dialog1.color if color_dialog1.execute
}
form.menu.items.toolbar1.flat_style1.on_click = proc {|sender|
  sender.checked = ! sender.checked
  form.panel1.controls.each{|i|i.flat = sender.checked}
}
form.menu.items.toolbar1.disable_styles1.on_click = proc {|sender|
  # disable or enable buttons and set menu text properly
  if form.panel1.speed_button_bold.enabled
    form.panel1.speed_button_bold.enabled = false
    form.panel1.speed_button_italic.enabled = false
    form.panel1.speed_button_underline.enabled = false
    sender.checked = true
  else
    form.panel1.speed_button_bold.enabled = true
    form.panel1.speed_button_italic.enabled = true
    form.panel1.speed_button_underline.enabled = true
    sender.checked = false
  end
}
form.menu.items.help1.about_toolbar1.on_click = proc {|sender|
  Phi.message_dlg "Toolbar example for \"Mastering Delphi\"\rWritten by Marco Cantu", MT_INFORMATION, [MB_OK]
}

form.show
mainloop
__END__
object ToolbarForm: TForm
  Left = 305
  Top = 225
  Width = 366
  Height = 326
  ActiveControl = Panel1
  Caption = 'Toolbar'
  Color = clBtnFace
  Font.Charset = DEFAULT_CHARSET
  Font.Color = clWindowText
  Font.Height = -13
  Font.Name = 'System'
  Font.Style = []
  Menu = MainMenu1
  OldCreateOrder = True
  PixelsPerInch = 96
  TextHeight = 16
  object Label1: TLabel
    Left = 0
    Top = 33
    Width = 358
    Height = 247
    Align = alClient
    AutoSize = False
    Caption = 
      'A caption with some sample text to show the effect of the speed ' +
      'buttons of the toolbar. You can replace it with something more u' +
      'seful.'
    Font.Charset = DEFAULT_CHARSET
    Font.Color = clBlack
    Font.Height = -16
    Font.Name = 'Arial'
    Font.Style = []
    ParentFont = False
    WordWrap = True
  end
  object Panel1: TPanel
    Left = 0
    Top = 0
    Width = 358
    Height = 33
    Align = alTop
    BevelWidth = 2
    ParentShowHint = False
    ShowHint = True
    TabOrder = 0
    object SpeedButtonNote: TSpeedButton
      Left = 8
      Top = 4
      Width = 25
      Height = 25
      Hint = 'Play Note'
      Flat = True
      Glyph.Data = {
        42010000424D4201000000000000760000002800000012000000110000000100
        040000000000CC00000000000000000000001000000000000000000000000000
        80000080000000808000800000008000800080800000C0C0C000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00333333333333
        3333330000003330033333333333330000003300003330033333330000003300
        0003000033333300000033300003000003333300000033333303300003333300
        0000333333033333033333000000333333033333033333000000333333033333
        0333330000003333330333330333330000003333330333330333330000003333
        3300033303333300000033333303300003333300000033333300033303333300
        0000333333333000033333000000333333333333333333000000333333333333
        333333000000}
    end
    object SpeedButtonBig: TSpeedButton
      Left = 213
      Top = 4
      Width = 25
      Height = 25
      Hint = 'Expand'
      AllowAllUp = True
      GroupIndex = 3
      Flat = True
      Glyph.Data = {
        DA020000424DDA02000000000000760000002800000048000000110000000100
        0400000000006402000000000000000000001000000000000000000000000000
        80000080000000808000800000008000800080800000C0C0C000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00333333333333
        3333333333333333333333333333333333333333333333333333333333333333
        333333333333333333FFFFF33333333333333333333333333333333333333333
        3333333000003333333333333888883333333333333000000333333333333000
        0003333333333330333333333333333338F33333333333333330333333333333
        333330333333333333333330333333333333333338F333333333333333303333
        33333333333330333333333333333330333333333333333338FFFF3333333333
        3330333333333333333330333333333333333330000333333333333338888333
        3333333333303333333333333333303333333333333333303333333333333333
        38F3333333333333333000003333333333333000003333333333333033333033
        3333333338FFFFF8F33333333330333333333333333330333333333333333330
        0000330333333333388888338F3333F333303333333333333333303333333333
        3333333333333330333033333333333338F338F3333033333330333033333033
        3333300000333333333333330330333333333333338F38F33330333333330330
        3333303333333003333333333333333330303333333333333338F8F333300000
        0333303033333000000330303333333333333333330033333333333333FF88F3
        3333333333333300333333333333303303333333333333300000333333333333
        3888883333333333333000003333333333333033303333333333333333333333
        3333333333333333333333333333333333333333333333333303333333333333
        333333333333333333333333333333333333333333333333333333333333}
      NumGlyphs = 4
    end
    object SpeedButtonBold: TSpeedButton
      Left = 128
      Top = 4
      Width = 25
      Height = 25
      Hint = 'Bold'
      AllowAllUp = True
      GroupIndex = 2
      Flat = True
      Glyph.Data = {
        42010000424D4201000000000000760000002800000012000000110000000100
        040000000000CC00000000000000000000001000000000000000000000000000
        80000080000000808000800000008000800080800000C0C0C000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00333333333333
        3333330000003333333333333333330000003333333333333333330000003333
        0000000033333300000033330000000003333300000033333003333003333300
        0000333330033330033333000000333330033300033333000000333330000000
        3333330000003333300000000333330000003333300333300333330000003333
        3003333003333300000033330000000003333300000033330000000033333300
        0000333333333333333333000000333333333333333333000000333333333333
        333333000000}
    end
    object SpeedButtonItalic: TSpeedButton
      Left = 153
      Top = 4
      Width = 25
      Height = 25
      Hint = 'Italic'
      AllowAllUp = True
      GroupIndex = 2
      Flat = True
      Glyph.Data = {
        42010000424D4201000000000000760000002800000012000000110000000100
        040000000000CC00000000000000000000001000000000000000000000000000
        80000080000000808000800000008000800080800000C0C0C000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00333333333333
        3333330000003333333333333333330000003333333333333333330000003333
        3000000333333300000033333330033333333300000033333330033333333300
        0000333333300333333333000000333333330033333333000000333333330033
        3333330000003333333300333333330000003333333330033333330000003333
        3333300333333300000033333330000003333300000033333333333333333300
        0000333333333333333333000000333333333333333333000000333333333333
        333333000000}
    end
    object SpeedButtonUnderline: TSpeedButton
      Left = 178
      Top = 4
      Width = 25
      Height = 25
      Hint = 'Underlined'
      AllowAllUp = True
      GroupIndex = 2
      Flat = True
      Glyph.Data = {
        42010000424D4201000000000000760000002800000012000000110000000100
        040000000000CC00000000000000000000001000000000000000000000000000
        80000080000000808000800000008000800080800000C0C0C000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00333333333333
        3333330000003333333333333333330000003333333333333333330000003333
        3000000003333300000033333000000003333300000033333333333333333300
        0000333333300030033333000000333333000000033333000000333333003000
        3333330000003333330033003333330000003333330033003333330000003333
        3300330033333300000033333000300033333300000033333333333333333300
        0000333333333333333333000000333333333333333333000000333333333333
        333333000000}
    end
    object SpeedButtonLeft: TSpeedButton
      Left = 43
      Top = 4
      Width = 25
      Height = 25
      Hint = 'Left Align'
      GroupIndex = 1
      Down = True
      Flat = True
      Glyph.Data = {
        42010000424D4201000000000000760000002800000012000000110000000100
        040000000000CC00000000000000000000001000000000000000000000000000
        80000080000000808000800000008000800080800000C0C0C000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00333333333333
        333333000000330000000000000033000000330FFFFFFFFFFFF033000000330F
        0000000FFFF033000000330FFFFFFFFFFFF033000000330F000FFFFFFFF03300
        0000330FFFFFFFFFFFF033000000330F00000FFFFFF033000000330FFFFFFFFF
        FFF033000000330F000FFFFFFFF033000000330FFFFFFFFFFFF033000000330F
        00000000FFF033000000330FFFFFFFFFFFF033000000330F000000FFFFF03300
        0000330FFFFFFFFFFFF033000000330000000000000033000000333333333333
        333333000000}
    end
    object SpeedButtonCenter: TSpeedButton
      Left = 68
      Top = 4
      Width = 25
      Height = 25
      Hint = 'Center'
      GroupIndex = 1
      Flat = True
      Glyph.Data = {
        42010000424D4201000000000000760000002800000012000000110000000100
        040000000000CC00000000000000000000001000000000000000000000000000
        80000080000000808000800000008000800080800000C0C0C000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00333333333333
        333333000000330000000000000033000000330FFFFFFFFFFFF033000000330F
        FF000000FFF033000000330FFFFFFFFFFFF033000000330FFFF0000FFFF03300
        0000330FFFFFFFFFFFF033000000330FFF000000FFF033000000330FFFFFFFFF
        FFF033000000330FFFFF00FFFFF033000000330FFFFFFFFFFFF033000000330F
        F00000000FF033000000330FFFFFFFFFFFF033000000330FFF000000FFF03300
        0000330FFFFFFFFFFFF033000000330000000000000033000000333333333333
        333333000000}
    end
    object SpeedButtonRight: TSpeedButton
      Left = 93
      Top = 4
      Width = 25
      Height = 25
      Hint = 'Right Align'
      GroupIndex = 1
      Flat = True
      Glyph.Data = {
        42010000424D4201000000000000760000002800000012000000110000000100
        040000000000CC00000000000000000000001000000000000000000000000000
        80000080000000808000800000008000800080800000C0C0C000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00333333333333
        333333000000330000000000000033000000330FFFFFFFFFFFF033000000330F
        FFF0000000F033000000330FFFFFFFFFFFF033000000330FFFFFFFF000F03300
        0000330FFFFFFFFFFFF033000000330FFFFFF00000F033000000330FFFFFFFFF
        FFF033000000330FFFFFFFF000F033000000330FFFFFFFFFFFF033000000330F
        FF00000000F033000000330FFFFFFFFFFFF033000000330FFFFF000000F03300
        0000330FFFFFFFFFFFF033000000330000000000000033000000333333333333
        333333000000}
    end
  end
  object MainMenu1: TMainMenu
    Left = 32
    Top = 56
    object File1: TMenuItem
      Caption = '&File'
      object Exit1: TMenuItem
        Caption = 'E&xit'
      end
    end
    object Toolbar1: TMenuItem
      Caption = '&Toolbar'
      object Visible1: TMenuItem
        Caption = '&Visible'
        Checked = True
      end
      object DisableSound1: TMenuItem
        Caption = 'Disable &Sound'
      end
      object DisableStyles1: TMenuItem
        Caption = 'Disable S&tyles'
      end
      object DisableSize1: TMenuItem
        Caption = 'Disable Si&ze'
      end
      object N1: TMenuItem
        Caption = '-'
      end
      object HintColor1: TMenuItem
        Caption = '&Hint Color...'
      end
      object FlatStyle1: TMenuItem
        Caption = '&Flat Style'
        Checked = True
      end
    end
    object Help1: TMenuItem
      Caption = '&Help'
      object AboutToolbar1: TMenuItem
        Caption = '&About Toolbar...'
      end
    end
  end
  object ColorDialog1: TColorDialog
    Ctl3D = True
    Left = 32
    Top = 104
  end
end
