#!ruby
require 'phi'
require 'path'

form = Phi::Form.new(:form, $0)
form.client_width = 400
form.client_height = 400

pbox = Phi::PaintBox.new form
pbox.align = Phi::AL_CLIENT

module Phi
  class Path
    def initialize(cv, flatten=false, &block)
      self.class.open(cv, &block)
      self.class.flatten(cv) if flatten
      self.load(cv)
    end
  end
end

cv = pbox.canvas
def cv.ellipse_r(cx, cy, r)
  ellipse(cx-r, cy-r, cx+r, cy+r)
end

paths = [150, 130, 110, 90, 70].map do |r|
  Phi::Path.new(cv, true) do |cv|
    cv.ellipse_r(200, 200, r)
  end
end

pbox.on_paint = proc do
  paths[0].draw_path cv, :color => Phi::CL_RED   , :width => 8
  paths[1].draw_path cv, :color => Phi::CL_RED   , :width => 8, :pen_style => [1, 1]
  paths[2].draw_path cv, :color => Phi::CL_BLUE  , :width => 8, :pen_style => [2, 1, 1, 1]
  paths[3].draw_path cv, :color => Phi::CL_YELLOW, :width => 8, :pen_style => [2, 1, 1, 1, 1, 1]
  paths[4].draw_path cv, :color => Phi::CL_GREEN , :width => 8, :pen_style => [4, 1, 1, 1, 1, 1]
end

form.show
Phi.mainloop
