require 'phi'
include Phi
require 'rgui/ui'

form = RGUI::Form.new :form1
form.caption = 'NetMaster\'s FTP Component example'
form.height = RGUI.min form.height * 2, Phi::SCREEN.height - 64
form.width  = RGUI.min form.width  * 2, Phi::SCREEN.width  - 64

pc = PageControl.new form
pc.align = Phi::AL_CLIENT

ts1 = RGUI::TabSheet.new pc, :ts1, 'Hello'
ts2 = RGUI::TabSheet.new pc, :ts2, 'FTP Form'

labels = [
  Label.new(ts2, :lbl_host, 'host'),
  Label.new(ts2, :lbl_user, 'user'),
  Label.new(ts2, :lbl_passwd, 'passwd'),
]
def label_fixed(lbl)
  lbl.layout = Phi::TL_BOTTOM
end
labels.each { |i| label_fixed i }

edits = [
  ts2.lbl_host, Edit.new(ts2, :edit_host, 'ftp.netlab.co.jp'),
  ts2.lbl_user, Edit.new(ts2, :edit_user, 'ftp'),
  ts2.lbl_passwd, Edit.new(ts2, :edit_passwd, 'moriq@moriq.com'),
]

rgrp_mode = RadioGroup.new ts2 # Transfer Mode
rgrp_mode.height*=  60
rgrp_mode.height/= 100
buttons = [
  Button.new(ts2, :btn_connect, 'Connect'),
  Button.new(ts2, :btn_dirlist, 'Dir List'),
  Button.new(ts2, :btn_chdir, 'Chdir'),
  Button.new(ts2, :btn_download, 'Download'),
  Button.new(ts2, :btn_upload, 'Upload'),
  Button.new(ts2, :btn_upload_append, 'Upload Append'),
  Button.new(ts2, :btn_upload_unique, 'Upload Unique'),
  Button.new(ts2, :btn_upload_restore, 'Upload Restore'),
  Button.new(ts2, :btn_abort, 'Abort'),
]

memos = [
  Memo.new(ts2, :memo1), # Status Window
  Memo.new(ts2, :memo2), # Directory List display
]
def memo_fixed(memo)
  memo.scroll_bars = Phi::SS_VERTICAL
  memo.font.name = 'lr SVbN'
end
memos.each { |i| memo_fixed i }
ts2.memo1.height = 160

ts2.add (
  hbox1 = RGUI::Hbox.new.add(
    vbox4 = RGUI::Vbox.new(false,8).add(
      hbox2 = RGUI::Hbox.new(true,8).add(
        ts2.memo1,
        vbox2 = RGUI::Vbox.new.add(
          edits,
          rgrp_mode )),
      hbox3 = RGUI::Hbox.new(false,8).add(
        ts2.memo2 )),
    vbox1 = RGUI::Vbox.new(false,8).add(
      buttons )))

hbox3.height = 60
vbox2.height = form.client_height - ts2.memo2.height
hbox2.height = 80
vbox1.width = 160
vbox4.width = form.client_width - vbox1.width

form.on_resize = proc { ts2.layout }

ts2.layout
form.show
Phi.mainloop
