    ##
    ##  s_forms.rb
    ##
    ##  sample script for controlling other forms in Phi::SCREEN
    ##
    ##  created  by (tk) ggb03124@nifty.ne.jp 2000-06-23()
    ##	modified by ..
    ##
require 'phi'
include  Phi

    ##
    ##  a ̒̃R|[lg
    ##  b ̒̃NCAg̈
    ##  c ԖڂɔzuAŜƂĂ
    ##  d zuB
    ##
def adjust( a,b,c,d )
  raise "order error for adjust" if ( c < 1 ) or ( c > d )
  x = b - a * d
  raise "too many components for adjust" if ( x < 0 )
  x = x / (d+1)
  x = (c-1)*a + c * x
end

form1 = Form.new :form1
form2 = Form.new :form2
form1.caption = "form1"
form2.caption = "form2"
form1.left = adjust( form1.width , Phi::SCREEN.width ,  1 , 2)
form2.left = adjust( form2.width , Phi::SCREEN.width ,  2 , 2)

##p form1.parent

b11 = Button.new form1, :b11_show
b12 = Button.new form1, :b12_hide
b13 = Button.new form1, :b13_icon
b21 = Button.new form2, :b21_show
b22 = Button.new form2, :b22_hide
b23 = Button.new form2, :b23_icon

b11.top = adjust( b11.height , form1.client_height , 1 , 3)
b12.top = adjust( b12.height , form1.client_height , 2 , 3)
b13.top = adjust( b13.height , form1.client_height , 3 , 3)
b21.top = adjust( b21.height , form2.client_height , 1 , 3)
b22.top = adjust( b22.height , form2.client_height , 2 , 3)
b23.top = adjust( b23.height , form2.client_height , 3 , 3)

b11.left = adjust( b11.width , form1.client_width , 1 , 1)
b12.left = adjust( b12.width , form1.client_width , 1 , 1)
b13.left = adjust( b13.width , form1.client_width , 1 , 1)
b21.left = adjust( b21.width , form2.client_width , 1 , 1)
b22.left = adjust( b22.width , form2.client_width , 1 , 1)
b23.left = adjust( b23.width , form2.client_width , 1 , 1)

b11.caption = "show form 2"
b12.caption = "hide form 2"
b13.caption = "icon form 2"
b21.caption = "show form 1"
b22.caption = "hide form 1"
b23.caption = "icon form 1"

def form1.on_show
  Phi::SCREEN.form2.b21_show.enabled = false
  Phi::SCREEN.form2.b22_hide.enabled = true
  Phi::SCREEN.form2.b23_icon.enabled = true
end
def form1.on_hide
  Phi::SCREEN.form2.b21_show.enabled = true
  Phi::SCREEN.form2.b22_hide.enabled = false
  Phi::SCREEN.form2.b23_icon.enabled = false
end

def form2.on_show
  Phi::SCREEN.form1.b11_show.enabled = false
  Phi::SCREEN.form1.b12_hide.enabled = true
  Phi::SCREEN.form1.b13_icon.enabled = true
end
def form2.on_hide
  Phi::SCREEN.form1.b11_show.enabled = true
  Phi::SCREEN.form1.b12_hide.enabled = false
  Phi::SCREEN.form1.b13_icon.enabled = false
end
def form1.on_close(act)
  print "#{self.name} close #{act}\n"
end
def form2.on_close(act)
  print "#{self.name} close #{act}\n"
end
=begin
$closing=false
def form1.on_close(act)
  if not $closing
    $closing=true
    Phi::SCREEN.form2.close
    exit
  end;
end
def form2.on_close(act)
  if not $closing
    $closing=true
    Phi::SCREEN.form1.close
  end;
end
=end

def b12.on_click
  Phi::SCREEN.form2.hide
end
def b22.on_click
  Phi::SCREEN.form1.hide
end

require "Win32API"

def bx1_on_click form
  if form.window_state == WS_MINIMIZED
    Win32API.new("user32", "ShowWindow", ['I','I'], "I").
	  	call( form.handle,Phi::SW_RESTORE)
  end
  form.show
end
def b11.on_click
  bx1_on_click Phi::SCREEN.form2
end
def b21.on_click
  bx1_on_click Phi::SCREEN.form1
end

def bx3_on_click form
  if form.window_state == WS_MINIMIZED
    Win32API.new("user32", "ShowWindow", ['I','I'], "I").
	  	call( form.handle,Phi::SW_RESTORE)
  else
    form.window_state = WS_MINIMIZED
  end
end
def b13.on_click
  bx3_on_click Phi::SCREEN.form2
end
def b23.on_click
  bx3_on_click Phi::SCREEN.form1
end

Phi::SCREEN.form1.b11_show.enabled = true
Phi::SCREEN.form1.b12_hide.enabled = false
Phi::SCREEN.form1.b13_icon.enabled = false
form1.show

##Phi::SCREEN.forms.each{ |x| 
## p x
## p x.caption if x
##}

mainloop
