unit EditorHandle;

interface

uses
  Windows, Classes, Controls, Forms, contnrs, Rubies, HEditor;

type
  TEditorHandle = class(TObject)
  published
    procedure NotifyOnCaretMoved(Sender: TObject);
    procedure NotifyOnChange(Sender: TObject);
    procedure NotifyOnColorChange(Sender: TObject);
    procedure NotifyOnScrollBarsChange(Sender: TObject);
    procedure NotifyOnSelectionModeChange(Sender: TObject);
    procedure NotifyOnTopColChange(Sender: TObject);
    procedure NotifyOnTopRowChange(Sender: TObject);
    procedure NotifyOnWordWrapChange(Sender: TObject);
    procedure DrawLineOnDrawLine(Sender: TObject; LineStr: string; X, Y, Index: Integer; ARect: TRect; Selected: Boolean);
    procedure SelectionChangeOnSelectionChange(Sender: TObject; Selected: Boolean);
  end;

var
  rb_eEditorError, cEditor: Tvalue;

implementation

uses Pythia;

procedure TEditorHandle.NotifyOnCaretMoved(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_caret_moved');
end;

procedure TEditorHandle.NotifyOnChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_change');
end;

procedure TEditorHandle.NotifyOnColorChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_color_change');
end;

procedure TEditorHandle.NotifyOnScrollBarsChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_scroll_bars_change');
end;

procedure TEditorHandle.NotifyOnSelectionModeChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_selection_mode_change');
end;

procedure TEditorHandle.NotifyOnTopColChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_top_col_change');
end;

procedure TEditorHandle.NotifyOnTopRowChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_top_row_change');
end;

procedure TEditorHandle.NotifyOnWordWrapChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_word_wrap_change');
end;

procedure TEditorHandle.DrawLineOnDrawLine(Sender: TObject; LineStr: string; X, Y, Index: Integer; ARect: TRect; Selected: Boolean);
var
  recv, data: Tvalue;
  rectp: PRect;
  rectv: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_draw_line'));
  rb_ary_push(data, recv);
  rb_ary_push(data, rb_str_new2(PChar(LineStr)));
  rb_ary_push(data, INT2FIX(X));
  rb_ary_push(data, INT2FIX(Y));
  rb_ary_push(data, INT2FIX(Index));

  new(rectp);
  rectv := rb_data_object_alloc(ap_cRect, rectp, nil, @ap_dispose);
  rb_ary_push(data, rectv);
  rectp^.TopLeft := ARect.TopLeft;
  rectp^.BottomRight := ARect.BottomRight;

  rb_ary_push(data, ap_bool(Selected));
  PhiCallProtect(data);
end;

procedure TEditorHandle.SelectionChangeOnSelectionChange(Sender: TObject; Selected: Boolean);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_selection_change'));
  rb_ary_push(data, recv);
  rb_ary_push(data, ap_bool(Selected));
  PhiCallProtect(data);
end;

end.
