unit uEditorMark;

interface

uses
  Rubies, HEditor;

var
  cEditorMark, cEditorMarks: Tvalue;

function ap_cEditorMark: Tvalue;
function ap_iEditorMark(real: TEditorMark; owner: Tvalue): Tvalue;
function ap_cEditorMarks: Tvalue;
procedure EditorMarks_setup(obj: Tvalue; real: TEditorMarks);
function ap_iEditorMarks(real: TEditorMarks; owner: Tvalue): Tvalue;
procedure Init_EditorMark;

implementation

uses
  Pythia, uEditor, uNotifyPersistent;

function ap_cEditorMark: Tvalue;
begin
  result := cEditorMark;
end;

function EditorMark_alloc(This: Tvalue; real: TEditorMark): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function ap_iEditorMark(real: TEditorMark; owner: Tvalue): Tvalue;
begin
  result := EditorMark_alloc(cEditorMark, real);
  ap_owner(result, owner);
end;

function ap_iEditorMark_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iEditorMark(TEditorMark(AControl), owner)
end;

procedure EditorMarks_setup(obj: Tvalue; real: TEditorMarks);
begin
  rb_iv_set(obj, '@eof_mark', ap_iEditorMark(real.EofMark, obj));
  rb_iv_set(obj, '@ret_mark', ap_iEditorMark(real.RetMark, obj));
  rb_iv_set(obj, '@underline', ap_iEditorMark(real.Underline, obj));
end;

function ap_cEditorMarks: Tvalue;
begin
  result := cEditorMarks;
end;

function EditorMarks_alloc(This: Tvalue; real: TEditorMarks): Tvalue;
begin
  result := TmpAlloc(This, real);
  EditorMarks_setup(result, real);
end;

function ap_iEditorMarks(real: TEditorMarks; owner: Tvalue): Tvalue;
begin
  result := EditorMarks_alloc(cEditorMarks, real);
  ap_owner(result, owner);
end;

function ap_iEditorMarks_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iEditorMarks(TEditorMarks(AControl), owner)
end;

procedure Init_EditorMark;
begin
  cEditorMark := rb_define_class_under(cEditor, 'Mark', cNotifyPersistent);
  DefineProp(cEditorMark, TEditorMark);

  cEditorMarks := rb_define_class_under(cEditor, 'Marks', cNotifyPersistent);
  DefineProp(cEditorMarks, TEditorMarks);
end;

end.
