unit uFountain;

interface

uses
  Rubies, heFountain;

var
  cFountain: Tvalue;

procedure Fountain_setup(obj: Tvalue; real: TFountain);
function ap_iFountain(real: TFountain; owner: Tvalue): Tvalue;
procedure Init_Fountain;

implementation

uses
  Pythia,
  uEditor,
  uFountainColor,
  uFountainBracketCollection,
  uFountainBracketItem,
  uFountainParser,
  uDelphiFountain,
  uRubyFountain;

procedure Fountain_setup(obj: Tvalue; real: TFountain);
begin
  rb_iv_set(obj, '@brackets', ap_iFountainBracketCollection(real.Brackets, obj));
  rb_iv_set(obj, '@reserve', ap_iFountainColor(real.Reserve, obj));
  rb_iv_set(obj, '@reserve_word_list', ap_iStrings(real.ReserveWordList, obj));
end;

function Fountain_alloc(klass: Tvalue; real: TFountain): Tvalue;
begin
  result := TmpAlloc(klass, real);
  Fountain_setup(result, real);
end;

function ap_iFountain(real: TFountain; owner: Tvalue): Tvalue;
begin
  result := Fountain_alloc(cFountain, real);
  ap_owner(result, owner);
end;

function ap_iFountain_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iFountain(TFountain(AControl), owner)
end;

procedure Init_Fountain;
begin
  cFountain := DefinePersistentClass(ap_mPhi, TFountain, ap_cComponent, ap_iFountain_v);
  DefineProp(cFountain, TFountain);

  Init_FountainColor;
  Init_FountainBracketItem;
  Init_FountainBracketCollection;
  Init_FountainParser;

  Init_DelphiFountain;
  Init_RubyFountain;
end;

end.
