require 'phi'
require 'pgrid'

include Phi

form = Form.new :main_form

panel = Panel.new form
panel.align = Phi::AL_TOP

next_btn = Button.new panel, :next_btn, ">>(&F)"
prev_btn = Button.new panel, :prev_btn, "<<(&B)"
del_btn = Button.new panel, :prev_btn, "X(&D)"

panel.height = next_btn.height + 10
next_btn.top = 5
prev_btn.top = 5
del_btn.top = 5
next_btn.left = prev_btn.left + prev_btn.width + 1
del_btn.left = next_btn.left + next_btn.width + 1

memo = Memo.new form, :memo
memo.align = Phi::AL_BOTTOM
memo.height = 30

pgrid = PropGrid.new form, :pgrid
pgrid.align = Phi::AL_CLIENT

pgrid.auto_update = true
pgrid.break_by_section= true

selrow = proc do |sender, index, sectionname|
  if index != -1
    memo.text = sender.items[index].note
  end
end

def next_btn.on_click
  if Phi::SCREEN.main_form.pgrid.current_index < Phi::SCREEN.main_form.pgrid.items.count - 1
    Phi::SCREEN.main_form.pgrid.current_index = Phi::SCREEN.main_form.pgrid.current_index + 1  
  end
end

def prev_btn.on_click
  if Phi::SCREEN.main_form.pgrid.current_index > 0
    Phi::SCREEN.main_form.pgrid.current_index = Phi::SCREEN.main_form.pgrid.current_index - 1
  end
end

def del_btn.on_click
  if Phi::SCREEN.main_form.pgrid.current_index > 0
    Phi::SCREEN.main_form.pgrid.items.delete(Phi::SCREEN.main_form.pgrid.current_index)
  end
end

need_value = proc do |args|
  p args
end

value_change = proc do |args|
  p args
end

value_changing = proc do |args|
  p args
end

pgrid.on_select_row = selrow
p item = pgrid.items.add
item.key = ""
item.value = "Blue"
item.section = "낢"
item.note = "̂"
item.on_need_value = need_value
item.on_value_change = value_change
item.on_value_changing = value_changing
p item = pgrid.items.add
item.key = ""
item.value = "red"
item.section = "낢"
item.note = "ۂ̂"
p item = pgrid.items.add
item.key = "݂ǂ"
item.value = "green"
item.section = "낢"
item.note = "܂̂"
p item = pgrid.items.insert(1)
item.key = ""
item.value = "brown"
item.section = "낢"
item.note = "傱̂"


form.show

Phi.mainloop


