unit uPropGridItem;

interface

uses
  Rubies, HPropGrid;

procedure Init_PropGridItem;
function ap_cPropGridItem: Tvalue;
function ap_iPropGridItem(real: TPropGridItem; owner: Tvalue): Tvalue;
function dl_PropGridItem(obj: Tvalue): TPropGridItem;
function ap_PropGridItem(item: TPropGridItem): Tvalue;

implementation

uses
  SysUtils, Classes, Pythia, uDefUtils, PGridHandle, uProp;

var
  cPropGridItem: Tvalue;

type
  PItem = ^TItem;
  TItem = record
    real: TPropGridItem;
    dead: Boolean;
    data: Tvalue;
  end;

procedure PropGridItem_free(p: PItem); cdecl;
begin
  dispose(p);
end;

procedure PropGridItem_mark(p: PItem); cdecl;
begin
  rb_gc_mark(Pointer(p^.data));
end;

function PropGridItem_alloc1(klass: Tvalue; real: TPropGridItem): Tvalue;
var
  p: PItem;
begin
  if real = nil then begin result := Qnil; exit; end;
  new(p);
  p^.real := real;
  p^.dead := False;
  p^.data := Qnil;
  result := rb_data_object_alloc(klass, p, @PropGridItem_mark, @PropGridItem_free);
  rb_iv_set(result, '@events', rb_hash_new);
  real.Data := Pointer(result);
end;

function GetP(obj: Tvalue): PItem;
begin
  if rb_obj_is_kind_of(obj, cPropGridItem) = 0 then
    ap_raise(ap_eArgError, sWrong_arg_type);
  result := ap_data_get_struct(obj);
end;

function GetItem(obj: Tvalue): TPropGridItem;
var
  p: PItem;
begin
  p := GetP(obj);
  if p^.dead then
    ap_raise(ap_eArgError, 'dead item');
  result := p^.real;
end;

function dl_PropGridItem(obj: Tvalue): TPropGridItem;
begin
  result := GetItem(obj);
end;

function ap_PropGridItem(item: TPropGridItem): Tvalue;
begin
  result := Qnil ; if item = nil then exit;
  result := Tvalue(item.data);
end;

function ap_cPropGridItem: Tvalue;
begin
  result := cPropGridItem;
end;

procedure PropGridItem_setup(obj: Tvalue; real: TPropGridItem);
begin
//  AssignPropMethod(real, [PGridGetHandle]);
//  real.OnDrawCell := nil;
//  real.OnDrawItem := nil;
  rb_iv_set(obj, '@pick_list', ap_iStrings(real.PickList, obj));
//  rb_iv_set(obj, '@events', rb_hash_new);
  real.Data := Pointer(obj);
end;

function PropGridItem_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PGridGetHandle]);
  result := Qnil;
end;

function PropGridItem_alloc(This: Tvalue; real: TPropGridItem): Tvalue;
begin
  result := PropGridItem_alloc1(This, real);
  PropGridItem_setup(result, real);
end;

function ap_iPropGridItem(real: TPropGridItem; owner: Tvalue): Tvalue;
begin
  result := PropGridItem_alloc(cPropGridItem, real);
  ap_owner(result, owner);
end;

function ap_iPropGridItem_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPropGridItem(TPropGridItem(AControl), owner);
end;

function PropGridItem_get_index(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := GetItem(This);
  result := INT2FIX(real.Index);
end;

function PropGridItem_get_has_children(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := GetItem(This);
  result := ap_bool(real.HasChildren);
end;

function PropGridItem_get_data(This: Tvalue): Tvalue; cdecl;
var
  p: PItem;
begin
  p := GetP(This);
  result := p^.data;
end;

function PropGridItem_set_data(This, v: Tvalue): Tvalue; cdecl;
var
  p: PItem;
begin
  p := GetP(This);
  p^.data := v;
  result := v;
end;

function PropGridItem_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
  source: TPersistent;
begin
  real := GetItem(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := v;
end;

function PropGridItem_get_name_path(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := GetItem(This);
  result := ap_String(real.GetNamePath);
end;
(*
function PropGridItem_get_key(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := GetItem(This);
  result := ap_String(real.Key);
end;

function PropGridItem_set_key(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := GetItem(This);
  real.Key := dl_String(v);
  result := v;
end;

function PropGridItem_get_level(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := GetItem(This);
  result := ap_Integer(real.Level);
end;

function PropGridItem_set_level(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := GetItem(This);
  real.Level := dl_Integer(v);
  result := v;
end;
*)
procedure Init_PropGridItem;
begin
  cPropGridItem := DefinePersistentClass(ap_mPhi, TPropGridItem, ap_cCollectionItem, ap_iPropGridItem_v);
  rb_define_method(cPropGridItem, 'event_handle', @PropGridItem_event_handle, 1);

  DefineAttrGet(cPropGridItem, 'has_children', @PropGridItem_get_has_children);
  DefineAttrGet(cPropGridItem, 'index', @PropGridItem_get_index);
  DefineAttrGet(cPropGridItem, 'data', PropGridItem_get_data);
  DefineAttrSet(cPropGridItem, 'data', PropGridItem_set_data);
  rb_define_method(cPropGridItem, 'assign', @PropGridItem_assign, 1);
  rb_define_method(cPropGridItem, 'get_name_path', @PropGridItem_get_name_path, 0);
(*
  DefineAttrGet(cPropGridItem, 'key', PropGridItem_get_key);
  DefineAttrSet(cPropGridItem, 'key', PropGridItem_set_key);
  DefineAttrGet(cPropGridItem, 'level', PropGridItem_get_level);
  DefineAttrSet(cPropGridItem, 'level', PropGridItem_set_level);
*)
end;

end.
